/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.IntSequence;
import gnu.lists.ShortVector;
import gnu.math.UShort;

public class U16Vector
extends ShortVector<UShort> {
    public U16Vector() {
        this.data = empty;
    }

    public U16Vector(int size, short value) {
        short[] array = new short[size];
        this.data = array;
        if (value != 0) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public U16Vector(int size) {
        this(new short[size]);
    }

    public U16Vector(short[] data) {
        this.data = data;
    }

    public U16Vector(short[] data, IntSequence indexes) {
        this.data = data;
        this.indexes = indexes;
    }

    public U16Vector(short[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index] & 0xFFFF;
    }

    @Override
    public final UShort get(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return UShort.valueOf(this.data[index]);
    }

    @Override
    public final UShort getBuffer(int index) {
        return UShort.valueOf(this.data[index]);
    }

    @Override
    public final void setBuffer(int index, UShort value) {
        this.data[index] = value.shortValue();
    }

    protected U16Vector withIndexes(IntSequence ind) {
        return new U16Vector(this.data, ind);
    }

    @Override
    public U16Vector subList(int fromIx, int toIx) {
        return new U16Vector(this.data, this.indexesSubList(fromIx, toIx));
    }

    public int getElementKind() {
        return 19;
    }

    @Override
    public String getTag() {
        return "u16";
    }

    public int compareTo(Object obj) {
        return U16Vector.compareToInt(this, (U16Vector)obj);
    }
}

