/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.kawa.io.Path;
import gnu.kawa.servlet.HttpRequestContext;
import gnu.mapping.CallContext;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class KawaServlet
extends HttpServlet {
    public void run(CallContext ctx) throws Throwable {
        throw new AbstractMethodError();
    }

    public void run(HttpRequestContext hctx, CallContext ctx) throws Throwable {
        this.run(ctx);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context sctx;
        CallContext ctx = CallContext.getInstance();
        HttpRequestContext hctx = HttpRequestContext.instance.get();
        if (hctx instanceof Context) {
            sctx = (Context)hctx;
        } else {
            sctx = new Context();
            Context.setInstance(sctx);
        }
        sctx.init(this, request, response);
        ctx.consumer = sctx.getConsumer();
        Path.setCurrentPath(Path.valueOf(request.getRequestURL().toString()));
        ctx.values = Values.noArgs;
        try {
            ctx.consumer.startDocument();
            this.run(sctx, ctx);
            ctx.consumer.endDocument();
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            Throwable cause;
            response.reset();
            if (throwable instanceof WrappedException && (cause = ((WrappedException)throwable).getCause()) != null) {
                throwable = cause;
            }
            throw new ServletException(throwable);
        }
        finally {
            sctx.servlet = null;
            sctx.request = null;
            sctx.response = null;
        }
    }

    static {
        if (HttpRequestContext.importServletDefinitions < 2) {
            HttpRequestContext.importServletDefinitions = 2;
        }
    }

    public static class Context
    extends HttpRequestContext {
        HttpServletRequest request;
        HttpServletResponse response;
        HttpServlet servlet;
        ServletConfig config;
        ServletContext context;
        Map<String, Object> requestParameters;

        public void init(HttpServlet servlet, HttpServletRequest request, HttpServletResponse response) {
            if (response == null) {
                throw new Error("init with null response");
            }
            this.servlet = servlet;
            this.request = request;
            this.response = response;
            this.config = servlet.getServletConfig();
            this.context = this.config.getServletContext();
            this.statusCode = 200;
            this.statusReasonPhrase = null;
            this.requestParameters = null;
            this.consumer = null;
        }

        public static Context getInstance(String command) {
            HttpRequestContext hctx = (HttpRequestContext)instance.get();
            if (!(hctx instanceof Context)) {
                throw new UnsupportedOperationException(command + " can only be called within servlet-supporting http-server");
            }
            return (Context)hctx;
        }

        public static HttpServletRequest getCurrentRequest() {
            return Context.getInstance("request").getRequest();
        }

        public static HttpServletResponse getCurrentResponse() {
            return Context.getInstance("response").getResponse();
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public ServletConfig getServletConfig() {
            return this.config;
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        @Override
        public URI getRequestURI() {
            String path = this.getRequestPath();
            String query = this.getQueryString();
            try {
                return new URI(null, null, path, query, null);
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public String getContextPath() {
            return this.request.getContextPath() + "/";
        }

        @Override
        public String getQueryString() {
            return this.request.getQueryString();
        }

        @Override
        public String getRequestMethod() {
            return this.request.getMethod();
        }

        @Override
        public String getRequestPath() {
            return this.request.getRequestURI();
        }

        @Override
        public String getRequestScheme() {
            return this.request.getScheme();
        }

        @Override
        public InetAddress getLocalHost() {
            try {
                return InetAddress.getByName(this.request.getLocalName());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public String getLocalIPAddress() {
            return this.request.getLocalAddr();
        }

        @Override
        public int getLocalPort() {
            return this.request.getLocalPort();
        }

        @Override
        public String getRemoteIPAddress() {
            return this.request.getRemoteAddr();
        }

        @Override
        public InetAddress getRemoteHost() {
            try {
                return InetAddress.getByName(this.request.getRemoteHost());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public int getRemotePort() {
            return this.request.getRemotePort();
        }

        @Override
        public StringBuffer getRequestURLBuffer() {
            return this.request.getRequestURL();
        }

        public String getServletPath() {
            return this.request.getServletPath();
        }

        @Override
        public String getPathTranslated() {
            return this.request.getPathTranslated();
        }

        @Override
        public Map<String, List<String>> getRequestParameters() {
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            Enumeration e = this.request.getParameterNames();
            while (e != null && e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] values = this.request.getParameterValues(key);
                int nvalues = values.length;
                if (nvalues == 0) continue;
                ArrayList<String> list = new ArrayList<String>(nvalues);
                for (int i = 0; i < nvalues; ++i) {
                    list.add(values[i]);
                }
                map.put(key, list);
            }
            return map;
        }

        @Override
        public String getRequestHeader(String name) {
            return this.request.getHeader(name);
        }

        @Override
        public Map<String, List<String>> getRequestHeaders() {
            LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
            Enumeration e = this.request.getHeaderNames();
            while (e != null && e.hasMoreElements()) {
                String key = (String)e.nextElement();
                map.put(key, this.getRequestHeaders(key));
            }
            return map;
        }

        @Override
        public List<String> getRequestHeaders(String name) {
            Enumeration e = this.request.getHeaders(name);
            ArrayList<String> list = new ArrayList<String>();
            while (e.hasMoreElements()) {
                list.add((String)e.nextElement());
            }
            return list;
        }

        @Override
        public InputStream getRequestStream() {
            try {
                return this.request.getInputStream();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public OutputStream getResponseStream() {
            try {
                return this.response.getOutputStream();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void setResponseHeader(String name, String value) {
            this.response.setHeader(name, value);
        }

        @Override
        public void setContentType(String type) {
            this.response.setContentType(type);
        }

        @Override
        public boolean reset(boolean headersAlso) {
            if (this.statusCode == -999) {
                return false;
            }
            try {
                if (headersAlso) {
                    this.response.reset();
                } else {
                    this.response.resetBuffer();
                }
            }
            catch (IllegalStateException ex) {
                return false;
            }
            return true;
        }

        @Override
        public URL getResourceURL(String path) {
            if ((path = this.normalizeToContext(path)) == null) {
                return null;
            }
            try {
                return this.context.getResource("/" + path);
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public Object getAttribute(String name) {
            return this.context.getAttribute(name);
        }

        @Override
        public void setAttribute(String name, Object value) {
            this.context.setAttribute(name, value);
        }

        @Override
        public void sendResponseHeaders(int reasonCode, String reasonPhrase, long responseLength) throws IOException {
            if (this.response == null) {
                throw new Error("null response");
            }
            if (responseLength >= 0L && responseLength <= Integer.MAX_VALUE) {
                this.response.setContentLength((int)responseLength);
            }
            this.response.setStatus(reasonCode);
            this.statusCode = -999;
        }

        @Override
        public void log(String message) {
            this.context.log(message);
        }

        @Override
        public void log(String message, Throwable ex) {
            this.context.log(message, ex);
        }
    }
}

