/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.Orientation;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class CellArrayBuilder {
    public final Library theLibrary;
    private static HashMap<Map.Entry<NodeProto, String>, CellArray> cellArrayCache = new HashMap();

    public CellArrayBuilder(Library theLibrary) {
        this.theLibrary = theLibrary;
    }

    private String makeArrayName(int cols, int rows, FixpCoord colspace, FixpCoord rowspace) {
        return cols + "x" + rows + "sep" + TextUtils.formatDouble(colspace.getLambda()) + "x" + TextUtils.formatDouble(rowspace.getLambda());
    }

    private CellArray getCellArray(NodeProto proto, int cols, int rows, FixpCoord colspace, FixpCoord rowspace) {
        AbstractMap.SimpleEntry<NodeProto, String> key = new AbstractMap.SimpleEntry<NodeProto, String>(proto, this.makeArrayName(cols, rows, colspace, rowspace));
        CellArray ret = cellArrayCache.get(key);
        if (ret == null) {
            ret = new CellArray(proto, cols, rows, colspace, rowspace);
            cellArrayCache.put(key, ret);
        }
        return ret;
    }

    private boolean isPowerOfTwo(int x) {
        for (int i = 0; i < 32; ++i) {
            if (x != 1 << i) continue;
            return true;
        }
        return false;
    }

    public void buildArrayUsingSubcells(NodeProto proto, Cell parent, EPoint bottomLeftInstanceLocation, Orientation orient, int cols, int rows, FixpCoord colspace, FixpCoord rowspace, EditingPreferences ep) {
        if (this.isPowerOfTwo(cols) && this.isPowerOfTwo(rows)) {
            EPoint loc = bottomLeftInstanceLocation;
            Orientation corient = orient.canonic();
            Cell arrCell = switch (corient.getAngle()) {
                case 900, 2700 -> this.getCellArray(proto, rows, cols, rowspace, colspace).makeCell(ep);
                case 0, 1800 -> this.getCellArray(proto, cols, rows, colspace, rowspace).makeCell(ep);
                default -> throw new Error("got rotation of " + corient.getAngle());
            };
            switch (corient.getAngle()) {
                case 2700: {
                    loc = corient.isYMirrored() ? loc : EPoint.fromFixp(loc.getCoordX().getFixp(), rowspace.multiply(rows - 1).add(loc.getCoordY()).getFixp());
                    break;
                }
                case 1800: {
                    loc = EPoint.fromFixp(loc.getCoordX().add(colspace.multiply(cols - 1)).getFixp(), loc.getCoordY().getFixp());
                    loc = corient.isYMirrored() ? loc : EPoint.fromFixp(loc.getCoordX().getFixp(), rowspace.multiply(rows - 1).add(loc.getCoordY()).getFixp());
                    break;
                }
                case 900: {
                    loc = EPoint.fromFixp(loc.getCoordX().add(colspace.multiply(cols - 1)).getFixp(), loc.getCoordY().getFixp());
                    loc = !corient.isYMirrored() ? loc : EPoint.fromFixp(loc.getCoordX().getFixp(), rowspace.multiply(rows - 1).add(loc.getCoordY()).getFixp());
                    break;
                }
                case 0: {
                    loc = !corient.isYMirrored() ? loc : EPoint.fromFixp(loc.getCoordX().getFixp(), rowspace.multiply(rows - 1).add(loc.getCoordY()).getFixp());
                    break;
                }
                default: {
                    throw new Error("got rotation of " + corient.getAngle());
                }
            }
            NodeInst.makeInstance(arrCell, ep, loc, arrCell.getDefWidth(null), arrCell.getDefHeight(null), parent, orient, null);
        } else {
            this.buildArrayBisected(proto, parent, bottomLeftInstanceLocation, orient, cols, rows, colspace, rowspace, ep);
        }
    }

    public void buildArrayBisected(NodeProto proto, Cell parent, EPoint bottomLeftInstanceLocation, Orientation orient, int cols, int rows, FixpCoord colspace, FixpCoord rowspace, EditingPreferences ep) {
        int width;
        for (int x = 0; x < cols; x += width) {
            int height;
            width = 1;
            while ((width << 1) + x <= cols && width << 1 <= (cols >= rows ? cols / 2 : cols)) {
                width <<= 1;
            }
            for (int y = 0; y < rows; y += height) {
                height = 1;
                while ((height << 1) + y <= rows && height << 1 <= (rows >= cols ? rows / 2 : rows)) {
                    height <<= 1;
                }
                this.buildArrayUsingSubcells(proto, parent, EPoint.fromFixp(bottomLeftInstanceLocation.getCoordX().add(colspace.multiply(x)).getFixp(), bottomLeftInstanceLocation.getCoordY().add(rowspace.multiply(y)).getFixp()), orient, width, height, colspace, rowspace, ep);
            }
        }
    }

    public void buildFlatArray(NodeProto proto, Cell parent, EPoint bottomLeftInstanceLocation, Orientation orient, int cols, int rows, FixpCoord colspace, FixpCoord rowspace, EditingPreferences ep) {
        FixpCoord ptcX = bottomLeftInstanceLocation.getCoordX();
        ECoord ptcY = bottomLeftInstanceLocation.getCoordY();
        for (int ic = 0; ic < cols; ++ic) {
            ECoord ptX = ptcX;
            FixpCoord ptY = ptcY;
            for (int ir = 0; ir < rows; ++ir) {
                EPoint loc = EPoint.fromFixp(ptX.getFixp(), ptY.getFixp());
                NodeInst.makeInstance(proto, ep, loc, proto.getDefWidth(null), proto.getDefHeight(null), parent, orient, null);
                ptY = ptY.add(rowspace);
            }
            ptcX = ptcX.add(colspace);
        }
    }

    public void buildArray(NodeProto proto, Cell parent, EPoint startLoc, Orientation orient, int cols, int rows, FixpCoord colspace, FixpCoord rowspace, EditingPreferences ep) {
        if (cols < 1) {
            throw new Error();
        }
        if (rows < 1) {
            throw new Error();
        }
        if (colspace.signum() < 0) {
            colspace = colspace.multiply(-1.0);
            startLoc = EPoint.fromFixp(startLoc.getCoordX().add(colspace.multiply(-1 * (cols - 1))).getFixp(), startLoc.getCoordY().getFixp());
        }
        if (rowspace.signum() < 0) {
            rowspace = rowspace.multiply(-1.0);
            startLoc = EPoint.fromFixp(startLoc.getCoordX().getFixp(), startLoc.getCoordY().add(rowspace.multiply(-1 * (rows - 1))).getFixp());
        }
        if (rows < 4 && cols < 4) {
            this.buildFlatArray(proto, parent, startLoc, orient, cols, rows, colspace, rowspace, ep);
        } else {
            this.buildArrayUsingSubcells(proto, parent, startLoc, orient, cols, rows, colspace, rowspace, ep);
        }
    }

    public class CellArray {
        public final NodeProto proto;
        public final int cols;
        public final int rows;
        public final FixpCoord colspace;
        public final FixpCoord rowspace;
        private Cell cell = null;

        public CellArray(NodeProto proto, int cols, int rows, FixpCoord colspace, FixpCoord rowspace) {
            this.proto = proto;
            this.cols = cols;
            this.rows = rows;
            this.colspace = colspace;
            this.rowspace = rowspace;
        }

        public Cell makeCell(EditingPreferences ep) {
            if (this.cell != null) {
                return this.cell;
            }
            Object name = this.proto.getName();
            if (((String)name).indexOf(123) != -1) {
                name = ((String)name).substring(0, ((String)name).indexOf(123));
            }
            name = (String)name + "_" + CellArrayBuilder.this.makeArrayName(this.cols, this.rows, this.colspace, this.rowspace) + "{lay}";
            this.cell = Cell.newInst(CellArrayBuilder.this.theLibrary, (String)name);
            if (this.cell == null) {
                throw new RuntimeException("Cell.newInst(" + (String)name + ") returned null");
            }
            EPoint bottomLeftInstance = EPoint.ORIGIN;
            if (this.rows < 4 && this.cols < 4) {
                CellArrayBuilder.this.buildFlatArray(this.proto, this.cell, bottomLeftInstance, Orientation.fromAngle(0), this.cols, this.rows, this.colspace, this.rowspace, ep);
            } else {
                CellArrayBuilder.this.buildArrayBisected(this.proto, this.cell, bottomLeftInstance, Orientation.fromAngle(0), this.cols, this.rows, this.colspace, this.rowspace, ep);
            }
            return this.cell;
        }
    }
}

