/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PreferencesFrame;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DisplayControlTab
extends PreferencePanel {
    private boolean resetAllOpacity = false;
    private JLabel alphaBlendingLimitLabel;
    private JTextField alphaBlendingOvercolorLimit;
    private JCheckBox dimUpperWhenDownInPlace;
    private ButtonGroup displayAlgorithm;
    private JComboBox displayStyle;
    private JCheckBox dockMessages;
    private JPanel general;
    private JTextField generalGreekCellLimit;
    private JTextField generalGreekLimit;
    private JComboBox generalPanningDistance;
    private JCheckBox generalShowCursorCoordinates;
    private JCheckBox generalUseGreekImages;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JCheckBox keepModelessDialogsOnTop;
    private JRadioButton layerDisplay;
    private JCheckBox makeErrorHighlightingPulsate;
    private JCheckBox measurementCadence;
    private JTextField patternScaleLimit;
    private JRadioButton pixelDisplay;
    private JButton resetOpacity;
    private JCheckBox shiftWindowToErrors;
    private JCheckBox showCellsInNewWindow;
    private JCheckBox sideBarOnRight;
    private JCheckBox useNewBlending;
    private JRadioButton vectorDisplay;

    public DisplayControlTab(PreferencesFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.generalGreekLimit);
        EDialog.makeTextFieldSelectAllOnTab(this.generalGreekCellLimit);
        EDialog.makeTextFieldSelectAllOnTab(this.patternScaleLimit);
        EDialog.makeTextFieldSelectAllOnTab(this.alphaBlendingOvercolorLimit);
    }

    @Override
    public JPanel getUserPreferencesPanel() {
        return this.general;
    }

    @Override
    public String getName() {
        return "Display Control";
    }

    @Override
    public void init() {
        this.generalShowCursorCoordinates.setSelected(User.isShowHierarchicalCursorCoordinates());
        this.sideBarOnRight.setSelected(User.isSideBarOnRight());
        this.dimUpperWhenDownInPlace.setSelected(User.isDimUpperLevelWhenDownInPlace());
        this.showCellsInNewWindow.setSelected(User.isShowCellsInNewWindow());
        this.makeErrorHighlightingPulsate.setSelected(User.isErrorHighlightingPulsate());
        this.shiftWindowToErrors.setSelected(User.isShiftWindowToErrors());
        this.keepModelessDialogsOnTop.setSelected(User.isKeepModelessDialogsOnTop());
        this.measurementCadence.setSelected(User.isCadenceMeasurementStyle());
        this.dockMessages.setSelected(User.isDockMessagesWindow());
        this.generalPanningDistance.addItem("Small");
        this.generalPanningDistance.addItem("Medium");
        this.generalPanningDistance.addItem("Large");
        this.generalPanningDistance.setSelectedIndex(User.getPanningDistance());
        this.displayStyle.addItem("Operating-System default");
        this.displayStyle.addItem("Multiple Document (MDI)");
        this.displayStyle.addItem("Single Document (SDI)");
        this.displayStyle.setSelectedIndex(User.getDisplayStyle());
        int da = User.getDisplayAlgorithm();
        switch (da) {
            case 0: {
                this.pixelDisplay.setSelected(true);
                break;
            }
            case 1: {
                this.vectorDisplay.setSelected(true);
                break;
            }
            case 2: {
                this.layerDisplay.setSelected(true);
            }
        }
        this.generalUseGreekImages.setSelected(User.isUseCellGreekingImages());
        this.generalGreekLimit.setText(Double.toString(User.getGreekSizeLimit()));
        this.generalGreekCellLimit.setText(Double.toString(User.getGreekCellSizeLimit() * 100.0));
        this.patternScaleLimit.setText(Double.toString(User.getPatternedScaleLimit()));
        this.useNewBlending.setSelected(!User.isLegacyComposite());
        this.alphaBlendingOvercolorLimit.setText(Double.toString(User.getAlphaBlendingOvercolorLimit()));
    }

    @Override
    public void term() {
        double currDouble;
        int currInt;
        boolean currBoolean = this.generalShowCursorCoordinates.isSelected();
        if (currBoolean != User.isShowHierarchicalCursorCoordinates()) {
            User.setShowHierarchicalCursorCoordinates(currBoolean);
        }
        if ((currBoolean = this.sideBarOnRight.isSelected()) != User.isSideBarOnRight()) {
            User.setSideBarOnRight(currBoolean);
        }
        if ((currBoolean = this.dimUpperWhenDownInPlace.isSelected()) != User.isDimUpperLevelWhenDownInPlace()) {
            User.setDimUpperLevelWhenDownInPlace(currBoolean);
        }
        if ((currBoolean = this.showCellsInNewWindow.isSelected()) != User.isShowCellsInNewWindow()) {
            User.setShowCellsInNewWindow(currBoolean);
        }
        if ((currBoolean = this.makeErrorHighlightingPulsate.isSelected()) != User.isErrorHighlightingPulsate()) {
            User.setErrorHighlightingPulsate(currBoolean);
        }
        if ((currBoolean = this.shiftWindowToErrors.isSelected()) != User.isShiftWindowToErrors()) {
            User.setShiftWindowToErrors(currBoolean);
        }
        if ((currBoolean = this.keepModelessDialogsOnTop.isSelected()) != User.isKeepModelessDialogsOnTop()) {
            User.setKeepModelessDialogsOnTop(currBoolean);
        }
        if ((currBoolean = this.measurementCadence.isSelected()) != User.isCadenceMeasurementStyle()) {
            User.setCadenceMeasurementStyle(currBoolean);
        }
        if ((currBoolean = this.dockMessages.isSelected()) != User.isDockMessagesWindow()) {
            User.setDockMessagesWindow(currBoolean);
        }
        if ((currInt = this.generalPanningDistance.getSelectedIndex()) != User.getPanningDistance()) {
            User.setPanningDistance(currInt);
        }
        if ((currInt = this.displayStyle.getSelectedIndex()) != User.getDisplayStyle()) {
            User.setDisplayStyle(currInt);
            Job.getUserInterface().showInformationMessage("Changes to the display style take effect when Electric next starts", "Note");
        }
        boolean renewDrawing = false;
        if (this.pixelDisplay.isSelected()) {
            currInt = 0;
        } else if (this.vectorDisplay.isSelected()) {
            currInt = 1;
        } else if (this.layerDisplay.isSelected()) {
            currInt = 2;
        }
        if (currInt != User.getDisplayAlgorithm()) {
            User.setDisplayAlgorithm(currInt);
            renewDrawing = true;
        }
        if ((currBoolean = this.generalUseGreekImages.isSelected()) != User.isUseCellGreekingImages()) {
            User.setUseCellGreekingImages(currBoolean);
            renewDrawing = true;
        }
        if ((currDouble = TextUtils.atof(this.generalGreekLimit.getText())) != User.getGreekSizeLimit()) {
            User.setGreekSizeLimit(currDouble);
            renewDrawing = true;
        }
        if ((currDouble = TextUtils.atof(this.generalGreekCellLimit.getText()) / 100.0) != User.getGreekCellSizeLimit()) {
            User.setGreekCellSizeLimit(currDouble);
            renewDrawing = true;
        }
        if ((currDouble = TextUtils.atof(this.patternScaleLimit.getText())) != User.getPatternedScaleLimit()) {
            User.setPatternedScaleLimit(currDouble);
            renewDrawing = true;
        }
        boolean bl = currBoolean = !this.useNewBlending.isSelected();
        if (currBoolean != User.isLegacyComposite()) {
            User.setLegacyComposite(currBoolean);
            renewDrawing = true;
        }
        if ((currDouble = TextUtils.atof(this.alphaBlendingOvercolorLimit.getText())) != User.getAlphaBlendingOvercolorLimit()) {
            User.setAlphaBlendingOvercolorLimit(currDouble);
            renewDrawing = true;
        }
        if (renewDrawing) {
            EditWindow.displayAlgorithmChanged();
        }
        if (this.resetAllOpacity) {
            LayerVisibility.setDefaultOpacity();
        }
    }

    @Override
    public void reset() {
        if (User.isFactoryShowHierarchicalCursorCoordinates() != User.isShowHierarchicalCursorCoordinates()) {
            User.setShowHierarchicalCursorCoordinates(User.isFactoryShowHierarchicalCursorCoordinates());
        }
        if (User.isFactorySideBarOnRight() != User.isSideBarOnRight()) {
            User.setSideBarOnRight(User.isFactorySideBarOnRight());
        }
        if (User.isFactoryDimUpperLevelWhenDownInPlace() != User.isDimUpperLevelWhenDownInPlace()) {
            User.setDimUpperLevelWhenDownInPlace(User.isFactoryDimUpperLevelWhenDownInPlace());
        }
        if (User.isFactoryShowCellsInNewWindow() != User.isShowCellsInNewWindow()) {
            User.setShowCellsInNewWindow(User.isFactoryShowCellsInNewWindow());
        }
        if (User.isFactoryErrorHighlightingPulsate() != User.isErrorHighlightingPulsate()) {
            User.setErrorHighlightingPulsate(User.isFactoryErrorHighlightingPulsate());
        }
        if (User.isFactoryShiftWindowToErrors() != User.isShiftWindowToErrors()) {
            User.setShiftWindowToErrors(User.isFactoryShiftWindowToErrors());
        }
        if (User.isFactoryKeepModelessDialogsOnTop() != User.isKeepModelessDialogsOnTop()) {
            User.setKeepModelessDialogsOnTop(User.isFactoryKeepModelessDialogsOnTop());
        }
        if (User.isFactoryCadenceMeasurementStyle() != User.isCadenceMeasurementStyle()) {
            User.setCadenceMeasurementStyle(User.isFactoryCadenceMeasurementStyle());
        }
        if (User.getFactoryPanningDistance() != User.getPanningDistance()) {
            User.setPanningDistance(User.getFactoryPanningDistance());
        }
        if (User.getFactoryDisplayStyle() != User.getDisplayStyle()) {
            User.setDisplayStyle(User.getFactoryDisplayStyle());
        }
        if (User.getFactoryDisplayAlgorithm() != User.getDisplayAlgorithm()) {
            User.setDisplayAlgorithm(User.getFactoryDisplayAlgorithm());
        }
        if (User.isFactoryUseCellGreekingImages() != User.isUseCellGreekingImages()) {
            User.setUseCellGreekingImages(User.isFactoryUseCellGreekingImages());
        }
        if (User.getFactoryGreekSizeLimit() != User.getGreekSizeLimit()) {
            User.setGreekSizeLimit(User.getFactoryGreekSizeLimit());
        }
        if (User.getFactoryGreekCellSizeLimit() != User.getGreekCellSizeLimit()) {
            User.setGreekCellSizeLimit(User.getFactoryGreekCellSizeLimit());
        }
        if (User.getFactoryPatternedScaleLimit() != User.getPatternedScaleLimit()) {
            User.setPatternedScaleLimit(User.getFactoryPatternedScaleLimit());
        }
        if (User.isFactoryLegacyComposite() != User.isLegacyComposite()) {
            User.setLegacyComposite(User.isFactoryLegacyComposite());
        }
        if (User.getFactoryAlphaBlendingOvercolorLimit() != User.getAlphaBlendingOvercolorLimit()) {
            User.setAlphaBlendingOvercolorLimit(User.getFactoryAlphaBlendingOvercolorLimit());
        }
        LayerVisibility.setDefaultOpacity();
    }

    private void initComponents() {
        this.displayAlgorithm = new ButtonGroup();
        this.general = new JPanel();
        this.generalShowCursorCoordinates = new JCheckBox();
        this.sideBarOnRight = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.generalPanningDistance = new JComboBox();
        this.jPanel1 = new JPanel();
        this.pixelDisplay = new JRadioButton();
        this.vectorDisplay = new JRadioButton();
        this.generalUseGreekImages = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.layerDisplay = new JRadioButton();
        this.jLabel8 = new JLabel();
        this.useNewBlending = new JCheckBox();
        this.alphaBlendingLimitLabel = new JLabel();
        this.resetOpacity = new JButton();
        this.alphaBlendingOvercolorLimit = new JTextField();
        this.patternScaleLimit = new JTextField();
        this.generalGreekCellLimit = new JTextField();
        this.generalGreekLimit = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel2 = new JLabel();
        this.displayStyle = new JComboBox();
        this.makeErrorHighlightingPulsate = new JCheckBox();
        this.dimUpperWhenDownInPlace = new JCheckBox();
        this.showCellsInNewWindow = new JCheckBox();
        this.shiftWindowToErrors = new JCheckBox();
        this.keepModelessDialogsOnTop = new JCheckBox();
        this.measurementCadence = new JCheckBox();
        this.dockMessages = new JCheckBox();
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DisplayControlTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.general.setLayout(new GridBagLayout());
        this.generalShowCursorCoordinates.setText("Show hierarchical cursor coordinates in status bar");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.general.add((Component)this.generalShowCursorCoordinates, gridBagConstraints);
        this.sideBarOnRight.setText("Side Bar defaults to the right side");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.sideBarOnRight, gridBagConstraints);
        this.jLabel1.setText("Panning distance:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.generalPanningDistance, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Display Algorithm"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.displayAlgorithm.add(this.pixelDisplay);
        this.pixelDisplay.setText("Pixel Display Algorithm (old)");
        this.pixelDisplay.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.pixelDisplay, gridBagConstraints);
        this.displayAlgorithm.add(this.vectorDisplay);
        this.vectorDisplay.setText("Vector Display Algorithm (new)");
        this.vectorDisplay.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.vectorDisplay, gridBagConstraints);
        this.generalUseGreekImages.setText("Use cell images when simplifying");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.jPanel1.add((Component)this.generalUseGreekImages, gridBagConstraints);
        this.jLabel4.setText("Simplify objects smaller than:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel6.setText("Do not simplify cells greater than:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 4, 4);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.displayAlgorithm.add(this.layerDisplay);
        this.layerDisplay.setText("Layer Display Algorithm (experimental)");
        this.layerDisplay.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.layerDisplay, gridBagConstraints);
        this.jLabel8.setText("Pattern scale limit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.jPanel1.add((Component)this.jLabel8, gridBagConstraints);
        this.useNewBlending.setText("Use newer blending algorithm");
        this.useNewBlending.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useNewBlending.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayControlTab.this.useNewBlendingActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 2, 4);
        this.jPanel1.add((Component)this.useNewBlending, gridBagConstraints);
        this.alphaBlendingLimitLabel.setText("Alpha blending overcolor limit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 40, 2, 4);
        this.jPanel1.add((Component)this.alphaBlendingLimitLabel, gridBagConstraints);
        this.resetOpacity.setText("Reset all Layer Opacity Values");
        this.resetOpacity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayControlTab.this.resetOpacityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 30, 4, 4);
        this.jPanel1.add((Component)this.resetOpacity, gridBagConstraints);
        this.alphaBlendingOvercolorLimit.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.alphaBlendingOvercolorLimit, gridBagConstraints);
        this.patternScaleLimit.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.patternScaleLimit, gridBagConstraints);
        this.generalGreekCellLimit.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.generalGreekCellLimit, gridBagConstraints);
        this.generalGreekLimit.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.generalGreekLimit, gridBagConstraints);
        this.jLabel5.setText("pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel7.setText("percent of screen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.general.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel2.setText("Display style:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.general.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.general.add((Component)this.displayStyle, gridBagConstraints);
        this.makeErrorHighlightingPulsate.setText("Make error highlighting pulsate");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.makeErrorHighlightingPulsate, gridBagConstraints);
        this.dimUpperWhenDownInPlace.setText("Dim upper levels of hierarchy when editing Down-In-Place");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.dimUpperWhenDownInPlace, gridBagConstraints);
        this.showCellsInNewWindow.setText("Show cell results in new window");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.showCellsInNewWindow, gridBagConstraints);
        this.shiftWindowToErrors.setText("Shift window to show errors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.shiftWindowToErrors, gridBagConstraints);
        this.keepModelessDialogsOnTop.setText("Keep modeless dialogs on top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.keepModelessDialogsOnTop, gridBagConstraints);
        this.measurementCadence.setText("Cadence measurement style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.measurementCadence, gridBagConstraints);
        this.dockMessages.setText("Dock messages window to each edit window");
        this.dockMessages.setToolTipText("If checked, the messages window will appear as a new pane below each edit pane.  If unchecked there will be only one messages window and it will be free-floating.");
        this.dockMessages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DisplayControlTab.this.dockMessagesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.general.add((Component)this.dockMessages, gridBagConstraints);
        this.getContentPane().add((Component)this.general, new GridBagConstraints());
        this.pack();
    }

    private void useNewBlendingActionPerformed(ActionEvent evt) {
        this.alphaBlendingLimitLabel.setEnabled(this.useNewBlending.isSelected());
        this.alphaBlendingOvercolorLimit.setEditable(this.useNewBlending.isSelected());
    }

    private void resetOpacityActionPerformed(ActionEvent evt) {
        this.resetAllOpacity = true;
        this.resetOpacity.setEnabled(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void dockMessagesActionPerformed(ActionEvent evt) {
    }
}

