/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.variable.Variable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public abstract class ImmutableElectricObject {
    private final Variable[] vars;
    public final int flags;

    ImmutableElectricObject(Variable[] vars, int flags) {
        this.vars = vars;
        this.flags = flags;
    }

    Variable[] arrayWithVariable(Variable var) {
        return ImmutableElectricObject.arrayWithVariable(this.vars, var);
    }

    static Variable[] arrayWithVariable(Variable[] vars, Variable var) {
        int varIndex = ImmutableElectricObject.searchVar(vars, var.getKey());
        int newLength = vars.length;
        if (varIndex < 0) {
            varIndex ^= 0xFFFFFFFF;
            ++newLength;
        } else if (vars[varIndex] == var) {
            return vars;
        }
        Variable[] newVars = new Variable[newLength];
        System.arraycopy(vars, 0, newVars, 0, varIndex);
        newVars[varIndex] = var;
        int tailLength = newLength - (varIndex + 1);
        System.arraycopy(vars, vars.length - tailLength, newVars, varIndex + 1, tailLength);
        return newVars;
    }

    Variable[] arrayWithoutVariable(Variable.Key key) {
        return ImmutableElectricObject.arrayWithoutVariable(this.vars, key);
    }

    static Variable[] arrayWithoutVariable(Variable[] vars, Variable.Key key) {
        int varIndex = ImmutableElectricObject.searchVar(vars, key);
        if (varIndex < 0) {
            return vars;
        }
        if (vars.length == 1 && varIndex == 0) {
            return Variable.NULL_ARRAY;
        }
        Variable[] newVars = new Variable[vars.length - 1];
        System.arraycopy(vars, 0, newVars, 0, varIndex);
        System.arraycopy(vars, varIndex + 1, newVars, varIndex, newVars.length - varIndex);
        return newVars;
    }

    Variable[] arrayWithRenamedIds(IdMapper idMapper) {
        return ImmutableElectricObject.arrayWithRenamedIds(this.vars, idMapper);
    }

    static Variable[] arrayWithRenamedIds(Variable[] vars, IdMapper idMapper) {
        Variable[] newVars = null;
        for (int i = 0; i < vars.length; ++i) {
            Variable oldVar = vars[i];
            Variable newVar = oldVar.withRenamedIds(idMapper);
            if (newVar != oldVar && newVars == null) {
                newVars = new Variable[vars.length];
                System.arraycopy(vars, 0, newVars, 0, i);
            }
            if (newVars == null) continue;
            newVars[i] = newVar;
        }
        return newVars != null ? newVars : vars;
    }

    public Variable getVar(Variable.Key key) {
        int varIndex = this.searchVar(key);
        return varIndex >= 0 ? this.vars[varIndex] : null;
    }

    public <T> T getVarValue(Variable.Key key, Class type) {
        Object value2;
        Variable var = this.getVar(key);
        if (var != null && type.isInstance(value2 = var.getObject())) {
            return (T)value2;
        }
        return null;
    }

    public Iterator<Variable> getVariables() {
        return ArrayIterator.iterator(this.vars);
    }

    public Variable[] toVariableArray() {
        return this.vars.length == 0 ? this.vars : (Variable[])this.vars.clone();
    }

    public int getNumVariables() {
        return this.vars.length;
    }

    public Variable getVar(int varIndex) {
        return this.vars[varIndex];
    }

    Variable[] getVars() {
        return this.vars;
    }

    public int searchVar(Variable.Key key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return ImmutableElectricObject.searchVar(this.vars, key);
    }

    static int searchVar(Variable[] vars, Variable.Key key) {
        int low = 0;
        int high = vars.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Variable var = vars[mid];
            int cmp = var.getKey().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    void write(IdWriter writer) throws IOException {
        boolean hasVars = this.vars.length > 0;
        writer.writeBoolean(hasVars);
        if (hasVars) {
            this.writeVars(writer);
        }
    }

    void writeVars(IdWriter writer) throws IOException {
        ImmutableElectricObject.writeVars(this.vars, writer);
    }

    static void writeVars(Variable[] vars, IdWriter writer) throws IOException {
        writer.writeInt(vars.length);
        for (int i = 0; i < vars.length; ++i) {
            vars[i].write(writer);
        }
    }

    static Variable[] readVars(IdReader reader) throws IOException {
        int length = reader.readInt();
        if (length == 0) {
            return Variable.NULL_ARRAY;
        }
        Variable[] vars = new Variable[length];
        for (int i = 0; i < length; ++i) {
            vars[i] = Variable.read(reader);
        }
        return vars;
    }

    public abstract int hashCodeExceptVariables();

    public abstract boolean equalsExceptVariables(ImmutableElectricObject var1);

    public boolean equalsVariables(ImmutableElectricObject o) {
        return Arrays.equals(this.vars, o.vars);
    }

    void check(boolean inheritAllowed) {
        if (this.vars.length == 0) {
            return;
        }
        this.vars[0].check(false, inheritAllowed);
        for (int i = 1; i < this.vars.length; ++i) {
            this.vars[i].check(false, inheritAllowed);
            assert (this.vars[i - 1].getKey().compareTo(this.vars[i].getKey()) < 0);
        }
    }
}

