/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.routing.RoutingFrame;
import com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore.Route;
import com.sun.electric.tool.routing.experimentalLeeMoore1.LeeMoore.Tupel;
import com.sun.electric.tool.routing.experimentalLeeMoore1.ThreadBorders;
import com.sun.electric.tool.routing.experimentalLeeMoore1.yana;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutingArray {
    public int size_x;
    public int size_y;
    public int numLayers;
    private int[][][] array;
    final int ARRAY_OVERSIZE = 80;
    final int NET_ID_OFFSET = 10;
    final int START_POINT = -1;
    final int END_POINT = -2;
    final int EMPTY_POINT = 0;
    final int RESERVED_POINT = -2147483647;
    final int BLOCKED_POINT = Integer.MIN_VALUE;
    double minWidth;
    private final boolean DEBUG = false;
    private final boolean USE_MULTI_TERMINAL_ALGORITHM = false;

    public RoutingArray(int size_x, int size_y, int numLayers, Tupel[] blocked) {
        this.size_x = size_x;
        this.size_y = size_y;
        this.numLayers = numLayers;
        this.array = new int[size_x][size_y][numLayers];
        this.setBlocked(blocked);
    }

    public RoutingArray(Cell c, int numLayers, List<RoutingFrame.RoutingGeometry> blocked, double minWidth) {
        ERectangle r = c.getBounds();
        int distanceBetweenWires = yana.distanceBetweenWires == 0 ? 3 : yana.distanceBetweenWires;
        this.size_x = (int)(r.getLambdaWidth() + 80.0) / distanceBetweenWires;
        this.size_y = (int)(r.getLambdaHeight() + 80.0) / distanceBetweenWires;
        this.numLayers = numLayers;
        this.minWidth = minWidth;
        this.array = new int[this.size_x][this.size_y][numLayers];
        this.setBlocked(blocked);
    }

    private void setValue(Tupel t, int val) {
        int x = t.getX_InsideRoutingArray();
        int y = t.getY_InsideRoutingArray();
        int l = t.getLayer();
        this.array[x][y][l] = val;
    }

    private int getValue(Tupel t) {
        return this.array[t.getX_InsideRoutingArray()][t.getY_InsideRoutingArray()][t.getLayer()];
    }

    private void setValue(Tupel t, int val, ThreadBorders tb) {
        int x = t.getX_InsideRoutingArray();
        int y = t.getY_InsideRoutingArray();
        int l = t.getLayer();
        this.array[x][y][l] = val;
    }

    public void setBlocked(Tupel[] blocked) {
        for (int i = 0; i < blocked.length; ++i) {
            this.setValue(blocked[i], Integer.MIN_VALUE);
        }
    }

    private void markUsed(Tupel[] route, int val) {
        for (int i = 0; i < route.length; ++i) {
            this.setValue(route[i], val);
        }
    }

    public void reserveForRouting(Tupel[] tupels, int netID) {
        for (Tupel tupel : tupels) {
            int l;
            int y;
            int x = tupel.getX_InsideRoutingArray();
            if (this.array[x][y = tupel.getY_InsideRoutingArray()][l = tupel.getLayer()] == 0 || this.array[x][y][l] == netID) {
                this.setValue(tupel, netID);
                continue;
            }
            this.setValue(tupel, Integer.MIN_VALUE);
        }
    }

    public ArrayList<Tupel> getBlocked() {
        ArrayList<Tupel> blocked = new ArrayList<Tupel>();
        for (int i = 0; i < this.size_x; ++i) {
            for (int j = 0; j < this.size_y; ++j) {
                for (int k = 0; k < this.numLayers; ++k) {
                    if (this.array[i][j][k] >= 0) continue;
                    blocked.add(new Tupel(i, j, k, false));
                }
            }
        }
        return blocked;
    }

    public void setBlocked(List<RoutingFrame.RoutingGeometry> blockages) {
        for (RoutingFrame.RoutingGeometry rg : blockages) {
            this.setBlocked(this.grow(rg.getBounds(), this.minWidth), rg.getLayer().getMetalNumber() - 1);
        }
    }

    private Rectangle2D grow(Rectangle2D r, double size2) {
        double spacing = size2 / 2.0;
        int x = (int)(r.getX() - spacing);
        int y = (int)(r.getY() - spacing);
        int width = (int)Math.floor(r.getWidth() + size2);
        int height = (int)Math.floor(r.getHeight() + size2);
        return new Rectangle(x, y, width, height);
    }

    private void setBlocked(Rectangle2D r, int layer) {
        int i;
        int x = (int)r.getX();
        int y = (int)r.getY();
        int width = (int)Math.floor(r.getWidth());
        int height = (int)Math.floor(r.getHeight());
        ArrayList<Tupel> blocked = new ArrayList<Tupel>();
        int h_border = x + width;
        int v_border = y + height;
        for (i = x; i < h_border; ++i) {
            blocked.add(new Tupel(i, y, layer, true));
            blocked.add(new Tupel(i, v_border - 1, layer, true));
        }
        for (i = y; i < v_border; ++i) {
            blocked.add(new Tupel(x, i, layer, true));
            blocked.add(new Tupel(h_border - 1, i, layer, true));
        }
        this.setBlocked(blocked.toArray(new Tupel[0]));
    }

    private void setBlocked(Route r, int netID) {
        if (r == null) {
            return;
        }
        List<Tupel> l = r.getRoutingList();
        this.markUsed(l.toArray(new Tupel[0]), -1 * (netID + 10));
    }

    private void createBlockingsAroundStartEnd(Tupel start, Tupel end, ThreadBorders border) {
        if (this.isStartEndTupel(start)) {
            if (this.getLeftNeighbour(start, border) == 0) {
                this.setValue(this.leftNeighbour(start), -2147483647, border);
            }
            if (this.getRightNeighbour(start, border) == 0) {
                this.setValue(this.rightNeighbour(start), -2147483647, border);
            }
            if (this.getTopNeighbour(start, border) == 0) {
                this.setValue(this.topNeighbour(start), -2147483647, border);
            }
            if (this.getBottomNeighbour(start, border) == 0) {
                this.setValue(this.bottomNeighbour(start), -2147483647, border);
            }
        }
        if (this.isStartEndTupel(end)) {
            if (this.getLeftNeighbour(end, border) == 0) {
                this.setValue(this.leftNeighbour(end), -2147483647, border);
            }
            if (this.getRightNeighbour(end, border) == 0) {
                this.setValue(this.rightNeighbour(end), -2147483647, border);
            }
            if (this.getTopNeighbour(end, border) == 0) {
                this.setValue(this.topNeighbour(end), -2147483647, border);
            }
            if (this.getBottomNeighbour(end, border) == 0) {
                this.setValue(this.bottomNeighbour(end), -2147483647, border);
            }
        }
    }

    private void clearRouting(ThreadBorders tb) {
        for (int i = tb.getLowIndexX(); i <= tb.getHighIndexX(); ++i) {
            for (int j = tb.getLowIndexY(); j <= tb.getHighIndexY(); ++j) {
                for (int k = 0; k < this.numLayers; ++k) {
                    if (this.array[i][j][k] > 0) {
                        this.array[i][j][k] = 0;
                        continue;
                    }
                    if (this.array[i][j][k] >= 0 || this.array[i][j][k] <= -3) continue;
                    this.array[i][j][k] = Integer.MIN_VALUE;
                }
            }
        }
    }

    @Deprecated
    public Route route(Tupel start, Tupel end, int netID) {
        ThreadBorders border = new ThreadBorders(0, this.array.length - 1, 0, this.array[0].length - 1);
        return this.route(start, end, border, netID);
    }

    public Route route(Tupel start, Tupel end, ThreadBorders border, int netID) {
        if (start.isEqualPosition(end)) {
            return null;
        }
        boolean useMultiTerminalAlgorithm = false;
        this.prepareStartEndPoint(start, end, border);
        LinkedList<Tupel> start_queue = new LinkedList<Tupel>();
        start_queue.offer(start);
        start_queue.offer(null);
        SearchResult res = this.search(start_queue, border, end, -1 * (netID + 10), useMultiTerminalAlgorithm);
        int length = res.getLength();
        Tupel foundEnd = res.getFoundEnd();
        if (length >= 0) {
            Route r = new Route();
            r.setReversed(useMultiTerminalAlgorithm);
            r.addFieldInFront(new Tupel(foundEnd.getX_InsideRoutingArray(), foundEnd.getY_InsideRoutingArray(), foundEnd.getLayer(), false));
            r = this.trace(r, length, border);
            this.setBlocked(r, netID);
            this.clearRouting(border);
            this.createBlockingsAroundStartEnd(start, end, border);
            return r;
        }
        this.clearRouting(border);
        return null;
    }

    private void prepareStartEndPoint(Tupel start, Tupel end, ThreadBorders border) {
        this.setValue(start, -1, border);
        if (this.isStartEndTupel(start)) {
            if (this.getLeftNeighbour(start, border) == -2147483647) {
                this.setValue(this.leftNeighbour(start), 0, border);
            }
            if (this.getRightNeighbour(start, border) == -2147483647) {
                this.setValue(this.rightNeighbour(start), 0, border);
            }
            if (this.getTopNeighbour(start, border) == -2147483647) {
                this.setValue(this.topNeighbour(start), 0, border);
            }
            if (this.getBottomNeighbour(start, border) == -2147483647) {
                this.setValue(this.bottomNeighbour(start), 0, border);
            }
        }
        this.setValue(end, -2, border);
        if (this.isStartEndTupel(end)) {
            if (this.getLeftNeighbour(end, border) == -2147483647) {
                this.setValue(this.leftNeighbour(end), 0, border);
            }
            if (this.getRightNeighbour(end, border) == -2147483647) {
                this.setValue(this.rightNeighbour(end), 0, border);
            }
            if (this.getTopNeighbour(end, border) == -2147483647) {
                this.setValue(this.topNeighbour(end), 0, border);
            }
            if (this.getBottomNeighbour(end, border) == -2147483647) {
                this.setValue(this.bottomNeighbour(end), 0, border);
            }
        }
    }

    private boolean isStartEndTupel(Tupel t) {
        return t.getX_InsideElectric() != Tupel.convertRoutingArrayToElectricCoordinates_X(t.getX_InsideRoutingArray()) || t.getY_InsideElectric() != Tupel.convertRoutingArrayToElectricCoordinates_Y(t.getY_InsideRoutingArray());
    }

    private Route trace(Route r, int length, ThreadBorders b) {
        while (true) {
            Tupel t = r.getFirstTupel();
            if (length == -2) {
                return r;
            }
            if (length == 0) {
                length = -1;
            }
            if (t.getLayer() % 2 == 0) {
                if (this.getLeftNeighbour(t, b) == length) {
                    r.addFieldInFront(this.leftNeighbour(t));
                    --length;
                    continue;
                }
                if (this.getRightNeighbour(t, b) == length) {
                    r.addFieldInFront(this.rightNeighbour(t));
                    --length;
                    continue;
                }
            } else {
                if (this.getTopNeighbour(t, b) == length) {
                    r.addFieldInFront(this.topNeighbour(t));
                    --length;
                    continue;
                }
                if (this.getBottomNeighbour(t, b) == length) {
                    r.addFieldInFront(this.bottomNeighbour(t));
                    --length;
                    continue;
                }
            }
            if (this.getLayerUpNeighbour(t) == length) {
                r.addFieldInFront(this.layerUpNeighbour(t));
                --length;
                continue;
            }
            if (this.getLayerDownNeighbour(t) == length) {
                r.addFieldInFront(this.layerDownNeighbour(t));
                --length;
                continue;
            }
            this.printNeighbourhood(b, t);
        }
    }

    private void printNeighbourhood(ThreadBorders b, Tupel t) {
        System.out.println("Neighbourhood around " + t);
        System.out.println("left: " + this.getLeftNeighbour(t, b));
        System.out.println("right: " + this.getRightNeighbour(t, b));
        System.out.println("top: " + this.getTopNeighbour(t, b));
        System.out.println("bottom: " + this.getBottomNeighbour(t, b));
        System.out.println("layerup: " + this.getLayerUpNeighbour(t));
        System.out.println("layerdown: " + this.getLayerDownNeighbour(t));
        System.out.println("self: " + this.array[t.getX_InsideRoutingArray()][t.getY_InsideRoutingArray()][t.getLayer()]);
    }

    private SearchResult search(Queue<Tupel> queue, ThreadBorders b, Tupel end, int netID, boolean multiTerminal) {
        int val = 1;
        Tupel foundEnd = null;
        boolean found = false;
        while (!found) {
            Tupel neighbour;
            int neighbourValue;
            Tupel t = queue.poll();
            if (t == null) {
                if (queue.size() == 0) {
                    return new SearchResult(end, -1);
                }
                queue.offer(null);
                ++val;
                continue;
            }
            if (t.getLayer() % 2 == 0) {
                neighbourValue = this.getLeftNeighbour(t, b);
                switch (neighbourValue) {
                    case -1: {
                        break;
                    }
                    case -2: {
                        found = true;
                        foundEnd = this.leftNeighbour(t);
                        break;
                    }
                    case 0: {
                        neighbour = this.leftNeighbour(t);
                        queue.offer(neighbour);
                        this.setValue(neighbour, val, b);
                        break;
                    }
                    default: {
                        if (!multiTerminal || neighbourValue != netID) break;
                        found = true;
                        foundEnd = this.leftNeighbour(t);
                    }
                }
                neighbourValue = this.getRightNeighbour(t, b);
                switch (neighbourValue) {
                    case -1: {
                        break;
                    }
                    case -2: {
                        found = true;
                        foundEnd = this.rightNeighbour(t);
                        break;
                    }
                    case 0: {
                        neighbour = this.rightNeighbour(t);
                        queue.offer(neighbour);
                        this.setValue(neighbour, val, b);
                        break;
                    }
                    default: {
                        if (multiTerminal && neighbourValue == netID) {
                            found = true;
                            foundEnd = this.rightNeighbour(t);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else {
                neighbourValue = this.getTopNeighbour(t, b);
                switch (neighbourValue) {
                    case -1: {
                        break;
                    }
                    case -2: {
                        found = true;
                        foundEnd = this.topNeighbour(t);
                        break;
                    }
                    case 0: {
                        neighbour = this.topNeighbour(t);
                        queue.offer(neighbour);
                        this.setValue(neighbour, val, b);
                        break;
                    }
                    default: {
                        if (!multiTerminal || neighbourValue != netID) break;
                        found = true;
                        foundEnd = this.topNeighbour(t);
                    }
                }
                neighbourValue = this.getBottomNeighbour(t, b);
                switch (neighbourValue) {
                    case -1: {
                        break;
                    }
                    case -2: {
                        found = true;
                        foundEnd = this.bottomNeighbour(t);
                        break;
                    }
                    case 0: {
                        neighbour = this.bottomNeighbour(t);
                        queue.offer(neighbour);
                        this.setValue(neighbour, val, b);
                        break;
                    }
                    default: {
                        if (!multiTerminal || neighbourValue != netID) break;
                        found = true;
                        foundEnd = this.bottomNeighbour(t);
                    }
                }
            }
            neighbourValue = this.getLayerUpNeighbour(t);
            switch (neighbourValue) {
                case -1: {
                    break;
                }
                case -2: {
                    found = true;
                    foundEnd = this.layerUpNeighbour(t);
                    break;
                }
                case 0: {
                    neighbour = this.layerUpNeighbour(t);
                    queue.offer(neighbour);
                    this.setValue(neighbour, val, b);
                    break;
                }
                default: {
                    if (!multiTerminal || neighbourValue != netID) break;
                    found = true;
                    foundEnd = this.layerUpNeighbour(t);
                }
            }
            neighbourValue = this.getLayerDownNeighbour(t);
            switch (neighbourValue) {
                case -1: {
                    break;
                }
                case -2: {
                    found = true;
                    foundEnd = this.layerDownNeighbour(t);
                    break;
                }
                case 0: {
                    neighbour = this.layerDownNeighbour(t);
                    queue.offer(neighbour);
                    this.setValue(neighbour, val, b);
                    break;
                }
                default: {
                    if (!multiTerminal || neighbourValue != netID) break;
                    found = true;
                    foundEnd = this.layerDownNeighbour(t);
                }
            }
            if (!found) continue;
            if (!foundEnd.isEqual(end)) {
                // empty if block
            }
            if (val == 1) {
                // empty if block
            }
            return new SearchResult(foundEnd, val - 1);
        }
        return new SearchResult(end, -1);
    }

    private int getLeftNeighbour(Tupel t, ThreadBorders b) {
        int x = t.getX_InsideRoutingArray();
        int y = t.getY_InsideRoutingArray();
        int l = t.getLayer();
        if (x > b.getLowIndexX()) {
            return this.array[x - 1][y][l];
        }
        return Integer.MIN_VALUE;
    }

    private int getRightNeighbour(Tupel t, ThreadBorders b) {
        int x = t.getX_InsideRoutingArray();
        int y = t.getY_InsideRoutingArray();
        int l = t.getLayer();
        if (x < b.getHighIndexX()) {
            return this.array[x + 1][y][l];
        }
        return Integer.MIN_VALUE;
    }

    private int getBottomNeighbour(Tupel t, ThreadBorders b) {
        int x = t.getX_InsideRoutingArray();
        int y = t.getY_InsideRoutingArray();
        int l = t.getLayer();
        if (y > b.getLowIndexY()) {
            return this.array[x][y - 1][l];
        }
        return Integer.MIN_VALUE;
    }

    private int getTopNeighbour(Tupel t, ThreadBorders b) {
        int x = t.getX_InsideRoutingArray();
        int y = t.getY_InsideRoutingArray();
        int l = t.getLayer();
        if (y < b.getHighIndexY()) {
            return this.array[x][y + 1][l];
        }
        return Integer.MIN_VALUE;
    }

    private int getLayerUpNeighbour(Tupel t) {
        int x = t.getX_InsideRoutingArray();
        int y = t.getY_InsideRoutingArray();
        int l = t.getLayer();
        if (l < this.array[0][0].length - 1) {
            return this.array[x][y][l + 1];
        }
        return Integer.MIN_VALUE;
    }

    private int getLayerDownNeighbour(Tupel t) {
        int x = t.getX_InsideRoutingArray();
        int y = t.getY_InsideRoutingArray();
        int l = t.getLayer();
        if (l > 0) {
            return this.array[x][y][l - 1];
        }
        return Integer.MIN_VALUE;
    }

    private Tupel leftNeighbour(Tupel t) {
        return new Tupel(t.getX_InsideRoutingArray() - 1, t.getY_InsideRoutingArray(), t.getLayer(), false);
    }

    private Tupel rightNeighbour(Tupel t) {
        return new Tupel(t.getX_InsideRoutingArray() + 1, t.getY_InsideRoutingArray(), t.getLayer(), false);
    }

    private Tupel topNeighbour(Tupel t) {
        return new Tupel(t.getX_InsideRoutingArray(), t.getY_InsideRoutingArray() + 1, t.getLayer(), false);
    }

    private Tupel bottomNeighbour(Tupel t) {
        return new Tupel(t.getX_InsideRoutingArray(), t.getY_InsideRoutingArray() - 1, t.getLayer(), false);
    }

    private Tupel layerUpNeighbour(Tupel t) {
        return new Tupel(t.getX_InsideRoutingArray(), t.getY_InsideRoutingArray(), t.getLayer() + 1, false);
    }

    private Tupel layerDownNeighbour(Tupel t) {
        return new Tupel(t.getX_InsideRoutingArray(), t.getY_InsideRoutingArray(), t.getLayer() - 1, false);
    }

    public void markReserved() {
        for (int i = 0; i < this.array.length; ++i) {
            for (int j = 0; j < this.array[0].length; ++j) {
                for (int k = 0; k < this.numLayers; ++k) {
                    if (this.array[i][j][k] <= 0) continue;
                    this.array[i][j][k] = -2147483647;
                }
            }
        }
    }

    class SearchResult {
        Tupel foundEnd;
        int length;

        public Tupel getFoundEnd() {
            return this.foundEnd;
        }

        public int getLength() {
            return this.length;
        }

        public SearchResult(Tupel foundEnd, int length) {
            this.foundEnd = foundEnd;
            this.length = length;
        }
    }
}

