/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.EquivalentSchematicExports;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNetLayout;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Name;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.TechPool;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.GenMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;

class ImmutableNetSchem {
    private static final boolean DEBUG = false;
    final Snapshot snapshot;
    private final TechPool techPool;
    private final Schematics schem;
    private final PrimitivePortId busPinPortId;
    private final ArcProto busArc;
    final CellTree cellTree;
    private final CellBackup cellBackup;
    private final CellBackup.Memoization m;
    private final CellRevision cellRevision;
    final CellId cellId;
    private final ImmutableArrayList<ImmutableExport> exports;
    private final ImmutableArrayList<ImmutableNodeInst> nodes;
    private final ImmutableArrayList<ImmutableArcInst> arcs;
    private final int numExports;
    private final int numNodes;
    private final int numArcs;
    private final int[] ni_pi;
    private final int arcsOffset;
    private final int[] tailConn;
    private final int[] headConn;
    private final int[] drawns;
    private final ArrayList<PortInst> stack = new ArrayList();
    private int numDrawns;
    private int numExportedDrawns;
    private int numConnectedDrawns;
    private final HashMap<Name, GenMath.MutableInteger> netNames = new HashMap();
    private int netNameCount;
    private int exportedNetNameCount;
    final int[] portOffsets;
    private final int[] drawnOffsets;
    IconInst[] iconInsts;
    private final Name[] drawnNames;
    private final int[] drawnWidths;
    Global.Set globals;
    int[] equivPortsN;
    int[] equivPortsP;
    int[] equivPortsA;
    IdentityHashMap<Name, Global.Set> globalPartitions;
    CellId implementationCellId;
    private IdentityHashMap<IconInst, Set<Global>> iconInstExcludeGlobals;
    int netNamesOffset;

    ImmutableNetSchem(Snapshot snapshot, CellId cellId) {
        int i;
        CellId mainSchemId;
        assert (cellId.isIcon() || cellId.isSchematic());
        this.snapshot = snapshot;
        this.cellId = cellId;
        this.techPool = snapshot.techPool;
        this.schem = this.techPool.getSchematics();
        this.busPinPortId = this.schem != null ? this.schem.busPinNode.getPort(0).getId() : null;
        this.busArc = this.schem != null ? this.schem.bus_arc : null;
        this.cellTree = snapshot.getCellTree(cellId);
        this.cellBackup = this.cellTree.top;
        this.m = this.cellBackup.getMemoization();
        this.cellRevision = this.cellBackup.cellRevision;
        this.exports = this.cellRevision.exports;
        this.nodes = this.cellRevision.nodes;
        this.arcs = this.cellRevision.arcs;
        this.numExports = this.cellRevision.exports.size();
        this.numNodes = this.cellRevision.nodes.size();
        this.numArcs = this.cellRevision.arcs.size();
        CellId implementationCellId = cellId;
        if (cellId.isIcon() && (mainSchemId = snapshot.getMainSchematics(cellId)) != null) {
            this.getEquivExports(mainSchemId);
            implementationCellId = mainSchemId;
        }
        this.implementationCellId = implementationCellId;
        this.ni_pi = new int[this.numNodes];
        int offset = this.numExports;
        for (i = 0; i < this.numNodes; ++i) {
            ImmutableNodeInst n = (ImmutableNodeInst)this.nodes.get(i);
            this.ni_pi[i] = offset;
            offset += this.getNumPorts(n.protoId);
        }
        this.arcsOffset = offset;
        this.headConn = new int[offset += this.numArcs];
        this.tailConn = new int[offset];
        this.drawns = new int[offset];
        for (i = this.numExports; i < this.arcsOffset; ++i) {
            this.headConn[i] = i;
            this.tailConn[i] = i;
        }
        for (i = 0; i < this.numExports; ++i) {
            int portOffset = i;
            ImmutableExport export = (ImmutableExport)this.exports.get(i);
            int orig = this.getPortInstOffset(export.originalNodeId, export.originalPortId);
            this.headConn[portOffset] = this.headConn[orig];
            this.headConn[orig] = portOffset;
            this.tailConn[portOffset] = -1;
        }
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a = (ImmutableArcInst)this.arcs.get(arcIndex);
            int arcOffset = this.arcsOffset + arcIndex;
            int head2 = this.getPortInstOffset(a.headNodeId, a.headPortId);
            this.headConn[arcOffset] = this.headConn[head2];
            this.headConn[head2] = arcOffset;
            int tail2 = this.getPortInstOffset(a.tailNodeId, a.tailPortId);
            this.tailConn[arcOffset] = this.tailConn[tail2];
            this.tailConn[tail2] = arcOffset;
        }
        this.makeDrawns();
        this.initNetnames();
        this.portOffsets = new int[this.numExports + 1];
        this.drawnNames = new Name[this.numDrawns];
        this.drawnWidths = new int[this.numDrawns];
        this.drawnOffsets = new int[this.numDrawns];
        this.calcDrawnWidths();
        this.initNodables();
        int mapSize = this.netNamesOffset + this.netNames.size();
        int[] netMapN = ImmutableNetLayout.initMap(mapSize);
        this.localConnections(netMapN);
        int[] netMapP = (int[])netMapN.clone();
        int[] netMapA = (int[])netMapN.clone();
        this.internalConnections(netMapN, netMapP, netMapA);
        ImmutableNetLayout.closureMap(netMapN);
        ImmutableNetLayout.closureMap(netMapP);
        ImmutableNetLayout.closureMap(netMapA);
        this.updateInterface(netMapN, netMapP, netMapA);
    }

    private void addToDrawn1(PortInst pi) {
        ArcProto ap;
        ImmutableArcInst a;
        int piOffset = pi.getPortInstOffset();
        if (this.drawns[piOffset] >= 0) {
            return;
        }
        if (pi.portId instanceof PrimitivePortId && this.techPool.getPrimitivePort((PrimitivePortId)pi.portId).isIsolated()) {
            return;
        }
        this.drawns[piOffset] = this.numDrawns;
        int k = piOffset;
        while (this.headConn[k] != piOffset) {
            if (this.drawns[k = this.headConn[k]] >= 0) continue;
            if (k < this.arcsOffset) {
                this.drawns[k] = this.numDrawns;
                continue;
            }
            a = (ImmutableArcInst)this.arcs.get(k - this.arcsOffset);
            ap = this.techPool.getArcProto(a.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC || pi.portId == this.busPinPortId && ap != this.busArc) continue;
            this.drawns[k] = this.numDrawns;
            PortInst tpi = new PortInst(a, 0);
            if (tpi.portId == this.busPinPortId && ap != this.busArc) continue;
            this.stack.add(tpi);
        }
        k = piOffset;
        while (this.tailConn[k] != piOffset) {
            if (this.drawns[k = this.tailConn[k]] >= 0) continue;
            a = (ImmutableArcInst)this.arcs.get(k - this.arcsOffset);
            ap = this.techPool.getArcProto(a.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC || pi.portId == this.busPinPortId && ap != this.busArc) continue;
            this.drawns[k] = this.numDrawns;
            PortInst hpi = new PortInst(a, 1);
            if (hpi.portId == this.busPinPortId && ap != this.busArc) continue;
            this.stack.add(hpi);
        }
    }

    private void addToDrawn(PortInst pi) {
        assert (this.stack.isEmpty());
        this.stack.add(pi);
        while (!this.stack.isEmpty()) {
            pi = this.stack.remove(this.stack.size() - 1);
            PortProtoId ppId = pi.portId;
            int numPorts = this.getNumPorts(ppId.getParentId());
            if (numPorts == 1 || ppId instanceof ExportId) {
                this.addToDrawn1(pi);
                continue;
            }
            PrimitivePort pp = this.techPool.getPrimitivePort((PrimitivePortId)ppId);
            PrimitiveNode pn = pp.getParent();
            int topology = pp.getTopology();
            for (int i = 0; i < numPorts; ++i) {
                PrimitivePort pp2 = pn.getPort(i);
                if (pp2.getTopology() != topology) continue;
                this.addToDrawn1(new PortInst(((PortInst)pi).n.nodeId, pp2.getId()));
            }
        }
    }

    void makeDrawns() {
        int i;
        Arrays.fill(this.drawns, -1);
        this.numDrawns = 0;
        for (i = 0; i < this.numExports; ++i) {
            if (this.drawns[i] >= 0) continue;
            this.drawns[i] = this.numDrawns++;
            ImmutableExport export = (ImmutableExport)this.exports.get(i);
            this.addToDrawn(new PortInst(export));
        }
        this.numExportedDrawns = this.numDrawns;
        for (i = 0; i < this.numArcs; ++i) {
            PortInst tpi;
            if (this.drawns[this.arcsOffset + i] >= 0) continue;
            ImmutableArcInst a = (ImmutableArcInst)this.arcs.get(i);
            ArcProto ap = this.techPool.getArcProto(a.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC) continue;
            this.drawns[this.arcsOffset + i] = this.numDrawns;
            PortInst hpi = new PortInst(a, 1);
            if (hpi.portId != this.busPinPortId || ap == this.busArc) {
                this.addToDrawn(hpi);
            }
            if ((tpi = new PortInst(a, 0)).portId != this.busPinPortId || ap == this.busArc) {
                this.addToDrawn(tpi);
            }
            ++this.numDrawns;
        }
        this.numConnectedDrawns = this.numDrawns;
        for (i = 0; i < this.numNodes; ++i) {
            PrimitiveNode pn;
            ImmutableNodeInst n = (ImmutableNodeInst)this.nodes.get(i);
            if (n.protoId instanceof CellId ? this.isIconOfParent(n) : (pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId)).getFunction() == PrimitiveNode.Function.ART && pn != Generic.tech().simProbeNode || pn == Artwork.tech().pinNode || pn == Generic.tech().invisiblePinNode) continue;
            int numPortInsts = this.getNumPorts(n.protoId);
            for (int j = 0; j < numPortInsts; ++j) {
                PortInst pi = new PortInst(n.nodeId, this.getPortIdByIndex(n.protoId, j));
                int piOffset = pi.getPortInstOffset();
                if (this.drawns[piOffset] >= 0 || n.protoId instanceof PrimitiveNodeId && this.techPool.getPrimitivePort((PrimitivePortId)pi.portId).isIsolated()) continue;
                this.addToDrawn(pi);
                ++this.numDrawns;
            }
        }
    }

    private void initNetnames() {
        this.netNameCount = 0;
        for (ImmutableExport e : this.exports) {
            this.addNetNames(e.name);
        }
        this.exportedNetNameCount = this.netNameCount;
        for (ImmutableArcInst a : this.arcs) {
            ArcProto ap = this.techPool.getArcProto(a.protoId);
            if (ap.getFunction() == ArcProto.Function.NONELEC) continue;
            assert (!a.name.isBus() || ap == this.busArc);
            if (!a.isUsernamed()) continue;
            this.addNetNames(a.name);
        }
        assert (this.netNameCount == this.netNames.size());
    }

    private void addNetNames(Name name) {
        for (int i = 0; i < name.busWidth(); ++i) {
            this.addNetName(name.subname(i));
        }
    }

    private void addNetName(Name name) {
        GenMath.MutableInteger nn = this.netNames.get(name);
        if (nn == null) {
            nn = new GenMath.MutableInteger(-1);
            this.netNames.put(name, nn);
        }
        if (nn.intValue() < 0) {
            nn.setValue(this.netNameCount++);
        }
    }

    void calcDrawnWidths() {
        int arcIndex;
        int oldWidth;
        int i;
        Arrays.fill(this.drawnNames, null);
        Arrays.fill(this.drawnWidths, -1);
        for (i = 0; i < this.numExports; ++i) {
            int drawn = this.drawns[i];
            Name name = ((ImmutableExport)this.exports.get((int)i)).name;
            int newWidth = name.busWidth();
            oldWidth = this.drawnWidths[drawn];
            if (oldWidth < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = newWidth;
                continue;
            }
            if (oldWidth == newWidth) continue;
            this.reportDrawnWidthError(this.drawnNames[drawn].toString(), name.toString());
            if (oldWidth >= newWidth) continue;
            this.drawnNames[drawn] = name;
            this.drawnWidths[drawn] = newWidth;
        }
        for (arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            Name name;
            ImmutableArcInst a = (ImmutableArcInst)this.arcs.get(arcIndex);
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || (name = a.name).isTempname()) continue;
            int newWidth = name.busWidth();
            int oldWidth2 = this.drawnWidths[drawn];
            if (oldWidth2 < 0) {
                this.drawnNames[drawn] = name;
                this.drawnWidths[drawn] = newWidth;
                continue;
            }
            if (oldWidth2 == newWidth) continue;
            this.reportDrawnWidthError(this.drawnNames[drawn].toString(), name.toString());
            if (oldWidth2 >= newWidth) continue;
            this.drawnNames[drawn] = name;
            this.drawnWidths[drawn] = newWidth;
        }
        for (arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0) continue;
            ImmutableArcInst a = (ImmutableArcInst)this.arcs.get(arcIndex);
            Name name = a.name;
            if (!name.isTempname() || (oldWidth = this.drawnWidths[drawn]) >= 0) continue;
            this.drawnNames[drawn] = name;
            if (a.protoId == this.busArc.getId()) continue;
            this.drawnWidths[drawn] = 1;
        }
        for (i = 0; i < this.numNodes; ++i) {
            PrimitiveNode pn;
            ImmutableNodeInst n = (ImmutableNodeInst)this.nodes.get(i);
            if (n.protoId instanceof PrimitiveNodeId && ((pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId)).getFunction().isPin() || pn == Schematics.tech().offpageNode)) continue;
            int numPortInsts = this.getNumPorts(n.protoId);
            for (int j = 0; j < numPortInsts; ++j) {
                PortInst pi = new PortInst(n.nodeId, this.getPortIdByIndex(n.protoId, j));
                int drawn = this.drawns[pi.getPortInstOffset()];
                if (drawn < 0) continue;
                int oldWidth3 = this.drawnWidths[drawn];
                int newWidth = 1;
                if (n.protoId instanceof CellId) {
                    CellBackup subCell = this.snapshot.getCell((CellId)n.protoId);
                    CellId subCellId = subCell.cellRevision.d.cellId;
                    if (subCellId.isIcon() || subCellId.isSchematic()) {
                        int arraySize = subCellId.isIcon() ? n.name.busWidth() : 1;
                        int portWidth = ((ImmutableExport)subCell.cellRevision.exports.get((int)j)).name.busWidth();
                        if (oldWidth3 == portWidth) continue;
                        newWidth = arraySize * portWidth;
                    }
                }
                if (oldWidth3 < 0) {
                    this.drawnWidths[drawn] = newWidth;
                    continue;
                }
                if (oldWidth3 == newWidth) continue;
                String msg = "Network: Schematic " + this.cellId + " has net <" + this.drawnNames[drawn] + "> with width conflict in connection " + ((PortInst)pi).n.name + " " + pi.portId;
                System.out.println(msg);
            }
        }
        for (i = 0; i < this.drawnWidths.length; ++i) {
            if (this.drawnWidths[i] >= 1) continue;
            this.drawnWidths[i] = 1;
        }
    }

    private void reportDrawnWidthError(String firstname, String badname) {
        String msg = "Network: Schematic " + this.cellId + " has net with conflict width of names <" + firstname + "> and <" + badname + ">";
        System.out.println(msg);
    }

    private void initNodables() {
        int i;
        Global.Buf globalBuf = new Global.Buf();
        HashMap nodeInstExcludeGlobal = null;
        for (int i2 = 0; i2 < this.numNodes; ++i2) {
            PortCharacteristic characteristic;
            String msg;
            ImmutableNodeInst n = (ImmutableNodeInst)this.nodes.get(i2);
            if (n.protoId instanceof CellId && (((CellId)n.protoId).isIcon() || ((CellId)n.protoId).isSchematic())) {
                if (n.name.hasDuplicates()) {
                    msg = this.cellId + ": Node name <" + n.name + "> has duplicate subnames";
                    System.out.println(msg);
                }
            } else if (n.name.isBus()) {
                msg = this.cellId + ": Array name <" + n.name + "> can be assigned only to icon nodes";
                System.out.println(msg);
            }
            if (n.protoId instanceof CellId) {
                String errorMsg;
                CellId subCellId = (CellId)n.protoId;
                if (!subCellId.isIcon() && !subCellId.isSchematic() || this.isIconOfParent(n)) continue;
                EquivalentSchematicExports netEq = this.getEquivExports((CellId)n.protoId);
                EquivalentSchematicExports schemEq = netEq.implementation;
                assert (schemEq != null && schemEq.getCellId() != this.cellId);
                Global.Set gs = schemEq.getGlobals();
                if (schemEq.implementation.globalPartitions != null) {
                    int numPortInsts = this.getNumPorts(n.protoId);
                    HashSet<Global> gb = null;
                    for (int j = 0; j < numPortInsts; ++j) {
                        PortInst pi = new PortInst(n.nodeId, this.getPortIdByIndex(n.protoId, j));
                        int piOffset = pi.getPortInstOffset();
                        int drawn = this.drawns[piOffset];
                        if (drawn < 0 || drawn >= this.numConnectedDrawns) continue;
                        ImmutableExport e = (ImmutableExport)netEq.exports.get(j);
                        assert (e.exportId == pi.portId);
                        Name busName = e.name;
                        for (int busIndex = 0; busIndex < busName.busWidth(); ++busIndex) {
                            Name exportName = busName.subname(busIndex);
                            Global.Set globalsOnElement = schemEq.globalPartitions.get(exportName);
                            if (globalsOnElement == null) continue;
                            if (gb == null) {
                                gb = new HashSet<Global>();
                            }
                            for (int l = 0; l < globalsOnElement.size(); ++l) {
                                Global g = globalsOnElement.get(l);
                                gb.add(g);
                            }
                        }
                    }
                    if (gb != null) {
                        if (nodeInstExcludeGlobal == null) {
                            nodeInstExcludeGlobal = new HashMap();
                        }
                        nodeInstExcludeGlobal.put(n, gb);
                        gs = gs.remove(gb.iterator());
                    }
                }
                if ((errorMsg = globalBuf.addToBuf(gs)) == null) continue;
                String msg2 = "Network: " + this.cellId + " has globals with conflicting characteristic " + errorMsg;
                System.out.println(msg2);
                continue;
            }
            Global g = this.globalInst(n);
            if (g == null) continue;
            if (g == Global.ground) {
                characteristic = PortCharacteristic.GND;
            } else if (g == Global.power) {
                characteristic = PortCharacteristic.PWR;
            } else {
                characteristic = PortCharacteristic.findCharacteristic(n.techBits);
                if (characteristic == null) {
                    String msg3 = "Network: " + this.cellId + " has global " + g.getName() + " with unknown characteristic bits";
                    System.out.println(msg3);
                    characteristic = PortCharacteristic.UNKNOWN;
                }
            }
            String errorMsg = globalBuf.addToBuf(g, characteristic);
            if (errorMsg == null) continue;
            String msg4 = "Network: " + this.cellId + " has global with conflicting characteristic " + errorMsg;
            System.out.println(msg4);
        }
        this.globals = globalBuf.getBuf();
        int mapOffset = this.portOffsets[0] = this.globals.size();
        for (i = 1; i <= this.numExports; ++i) {
            ImmutableExport export = (ImmutableExport)this.exports.get(i - 1);
            this.portOffsets[i] = mapOffset += export.name.busWidth();
        }
        this.equivPortsN = new int[mapOffset];
        this.equivPortsP = new int[mapOffset];
        this.equivPortsA = new int[mapOffset];
        for (i = 0; i < this.numDrawns; ++i) {
            this.drawnOffsets[i] = mapOffset;
            mapOffset += this.drawnWidths[i];
        }
        this.iconInsts = new IconInst[this.numNodes];
        this.iconInstExcludeGlobals = null;
        for (int nodeIndex = 0; nodeIndex < this.numNodes; ++nodeIndex) {
            Set gs;
            IconInst iconInst;
            CellId subCellId;
            ImmutableNodeInst n = (ImmutableNodeInst)this.nodes.get(nodeIndex);
            if (!(n.protoId instanceof CellId) || !(subCellId = (CellId)n.protoId).isIcon() && !subCellId.isSchematic()) continue;
            this.iconInsts[nodeIndex] = iconInst = new IconInst(n, mapOffset);
            if (this.isIconOfParent(n)) continue;
            EquivalentSchematicExports netEq = iconInst.eq;
            EquivalentSchematicExports schemEq = netEq.implementation;
            assert (schemEq != null);
            Set set = gs = nodeInstExcludeGlobal != null ? (Set)nodeInstExcludeGlobal.get(n) : null;
            if (gs != null) {
                if (this.iconInstExcludeGlobals == null) {
                    this.iconInstExcludeGlobals = new IdentityHashMap();
                }
                this.iconInstExcludeGlobals.put(iconInst, gs);
            }
            assert (iconInst.numExtendedExports == schemEq.equivPortsN.length);
            mapOffset += iconInst.numExtendedExports * n.name.busWidth();
        }
        this.netNamesOffset = mapOffset;
    }

    private Global globalInst(ImmutableNodeInst n) {
        String globalName;
        if (!(n.protoId instanceof PrimitiveNodeId)) {
            return null;
        }
        PrimitiveNode pn = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId);
        if (pn == Schematics.tech().groundNode) {
            return Global.ground;
        }
        if (pn == Schematics.tech().powerNode) {
            return Global.power;
        }
        if (pn == Schematics.tech().globalNode && (globalName = (String)n.getVarValue(Schematics.SCHEM_GLOBAL_NAME, String.class)) != null) {
            return Global.newGlobal(globalName);
        }
        return null;
    }

    private void localConnections(int[] netMap) {
        int k;
        for (k = 0; k < this.numExports; ++k) {
            ImmutableExport e = (ImmutableExport)this.exports.get(k);
            int portOffset = this.portOffsets[k];
            Name expNm = e.name;
            int busWidth = expNm.busWidth();
            int drawn = this.drawns[k];
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i = 0; i < busWidth; ++i) {
                ImmutableNetLayout.connectMap(netMap, portOffset + i, drawnOffset + (busWidth == this.drawnWidths[drawn] ? i : i % this.drawnWidths[drawn]));
                GenMath.MutableInteger nn = this.netNames.get(expNm.subname(i));
                ImmutableNetLayout.connectMap(netMap, portOffset + i, this.netNamesOffset + nn.intValue());
            }
        }
        for (k = 0; k < this.numNodes; ++k) {
            ImmutableNodeInst n = (ImmutableNodeInst)this.nodes.get(k);
            if (this.isIconOfParent(n)) continue;
            if (n.protoId instanceof PrimitiveNodeId) {
                Global g = this.globalInst(n);
                if (g != null) {
                    int drawn = this.drawns[this.ni_pi[k]];
                    ImmutableNetLayout.connectMap(netMap, this.globals.indexOf(g), this.drawnOffsets[drawn]);
                }
                if (n.protoId != this.schem.wireConNode.getId()) continue;
                this.connectWireCon(netMap, n);
                continue;
            }
            IconInst iconInst = this.iconInsts[k];
            if (iconInst == null || iconInst.iconOfParent) continue;
            assert (iconInst.nodeInst == n);
            CellId subCellId = (CellId)n.protoId;
            assert (subCellId.isIcon() || subCellId.isSchematic());
            EquivalentSchematicExports iconEq = iconInst.eq;
            EquivalentSchematicExports schemEq = iconEq.implementation;
            assert (schemEq != null);
            Name nodeName = n.name;
            int arraySize = nodeName.busWidth();
            int numPorts = this.getNumPorts(n.protoId);
            CellBackup subCell = this.snapshot.getCell(subCellId);
            for (int m = 0; m < numPorts; ++m) {
                int width;
                ImmutableExport e = (ImmutableExport)subCell.cellRevision.exports.get(m);
                Name busExportName = e.name;
                int busWidth = busExportName.busWidth();
                int drawn = this.drawns[this.ni_pi[k] + m];
                if (drawn < 0 || (width = this.drawnWidths[drawn]) != busWidth && width != busWidth * arraySize) continue;
                for (int arrayIndex = 0; arrayIndex < arraySize; ++arrayIndex) {
                    int nodeOffset = iconInst.netMapOffset + arrayIndex * iconInst.numExtendedExports;
                    int busOffset = this.drawnOffsets[drawn];
                    if (width != busWidth) {
                        busOffset += busWidth * arrayIndex;
                    }
                    for (int j = 0; j < busWidth; ++j) {
                        Name exportName = busExportName.subname(j);
                        int portOffset = schemEq.getExportNameMapOffset(exportName);
                        if (portOffset < 0) continue;
                        ImmutableNetLayout.connectMap(netMap, busOffset + j, nodeOffset + portOffset);
                    }
                }
            }
        }
        for (int arcIndex = 0; arcIndex < this.numArcs; ++arcIndex) {
            ImmutableArcInst a = (ImmutableArcInst)this.arcs.get(arcIndex);
            int drawn = this.drawns[this.arcsOffset + arcIndex];
            if (drawn < 0 || !a.isUsernamed()) continue;
            int busWidth = this.drawnWidths[drawn];
            Name arcNm = a.name;
            if (arcNm.busWidth() != busWidth) continue;
            int drawnOffset = this.drawnOffsets[drawn];
            for (int i = 0; i < busWidth; ++i) {
                GenMath.MutableInteger nn = this.netNames.get(arcNm.subname(i));
                ImmutableNetLayout.connectMap(netMap, drawnOffset + i, this.netNamesOffset + nn.intValue());
            }
        }
        for (IconInst iconInst : this.iconInsts) {
            if (iconInst == null || iconInst.iconOfParent) continue;
            Set<Global> excludeGlobals = null;
            if (this.iconInstExcludeGlobals != null) {
                excludeGlobals = this.iconInstExcludeGlobals.get(iconInst);
            }
            for (int k2 = 0; k2 < iconInst.nodeInst.name.busWidth(); ++k2) {
                EquivalentSchematicExports eq2 = iconInst.eq.implementation;
                assert (eq2.implementation == eq2);
                int numGlobals = eq2.portOffsets[0];
                if (numGlobals == 0) continue;
                int nodableOffset = iconInst.netMapOffset + k2 * iconInst.numExtendedExports;
                for (int i = 0; i < numGlobals; ++i) {
                    Global g = eq2.globals.get(i);
                    if (excludeGlobals != null && excludeGlobals.contains(g)) continue;
                    ImmutableNetLayout.connectMap(netMap, this.globals.indexOf(g), nodableOffset + i);
                }
            }
        }
        ImmutableNetLayout.closureMap(netMap);
    }

    private void connectWireCon(int[] netMap, ImmutableNodeInst n) {
        ImmutableArcInst a1 = null;
        ImmutableArcInst a2 = null;
        for (ImmutableArcInst a : this.m.getConnections(null, n, null)) {
            if (a1 == null) {
                a1 = a;
                continue;
            }
            if (a2 == null) {
                a2 = a;
                continue;
            }
            String msg = "Network: Schematic " + this.cellId + " has connector " + n.name + " which merges more than two arcs";
            System.out.println(msg);
            return;
        }
        if (a2 == null || a1 == a2) {
            return;
        }
        int large = this.getArcDrawn(a1);
        int small = this.getArcDrawn(a2);
        if (large < 0 || small < 0) {
            return;
        }
        if (this.drawnWidths[small] > this.drawnWidths[large]) {
            int temp = small;
            small = large;
            large = temp;
        }
        for (int i = 0; i < this.drawnWidths[large]; ++i) {
            ImmutableNetLayout.connectMap(netMap, this.drawnOffsets[large] + i, this.drawnOffsets[small] + i % this.drawnWidths[small]);
        }
    }

    private void internalConnections(int[] netMapF, int[] netMapP, int[] netMapA) {
        int jA;
        int jP;
        int i;
        int[] eqA;
        int[] eqP;
        int[] eqN;
        Object eq2;
        for (int k = 0; k < this.numNodes; ++k) {
            ImmutableNodeInst n = (ImmutableNodeInst)this.nodes.get(k);
            int nodeOffset = this.ni_pi[k];
            if (n.protoId instanceof PrimitiveNodeId) {
                PrimitiveNode.Function fun = this.getFunction(n);
                if (fun == PrimitiveNode.Function.RESIST) {
                    ImmutableNetLayout.connectMap(netMapP, this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                    ImmutableNetLayout.connectMap(netMapA, this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                    continue;
                }
                if (!fun.isComplexResistor()) continue;
                ImmutableNetLayout.connectMap(netMapA, this.drawnOffsets[this.drawns[nodeOffset]], this.drawnOffsets[this.drawns[nodeOffset + 1]]);
                continue;
            }
            IconInst iconInst = this.iconInsts[k];
            if (iconInst != null) continue;
            CellId subCellId = (CellId)n.protoId;
            assert (!subCellId.isIcon() && !subCellId.isSchematic());
            eq2 = this.snapshot.getCellTree(subCellId).getEquivPorts();
            eqN = ((EquivPorts)eq2).getEquivPortsN();
            eqP = ((EquivPorts)eq2).getEquivPortsP();
            eqA = ((EquivPorts)eq2).getEquivPortsA();
            int numPorts = ((EquivPorts)eq2).getNumExports();
            assert (eqN.length == numPorts && eqP.length == numPorts && eqA.length == numPorts);
            for (i = 0; i < numPorts; ++i) {
                int dj;
                int dj2;
                int dj3;
                int di = this.drawns[nodeOffset + i];
                if (di < 0) continue;
                int jN = eqN[i];
                if (i != jN && (dj3 = this.drawns[nodeOffset + jN]) >= 0) {
                    ImmutableNetLayout.connectMap(netMapF, this.drawnOffsets[di], this.drawnOffsets[dj3]);
                }
                if (i != (jP = eqP[i]) && (dj2 = this.drawns[nodeOffset + jP]) >= 0) {
                    ImmutableNetLayout.connectMap(netMapP, this.drawnOffsets[di], this.drawnOffsets[dj2]);
                }
                if (i == (jA = eqA[i]) || (dj = this.drawns[nodeOffset + jA]) < 0) continue;
                ImmutableNetLayout.connectMap(netMapA, this.drawnOffsets[di], this.drawnOffsets[dj]);
            }
        }
        for (IconInst iconInst : this.iconInsts) {
            if (iconInst == null || iconInst.iconOfParent) continue;
            for (int k = 0; k < iconInst.nodeInst.name.busWidth(); ++k) {
                eq2 = iconInst.eq.implementation;
                assert (((EquivalentSchematicExports)eq2).implementation == eq2);
                eqN = ((EquivalentSchematicExports)eq2).getEquivPortsN();
                eqP = ((EquivalentSchematicExports)eq2).getEquivPortsP();
                eqA = ((EquivalentSchematicExports)eq2).getEquivPortsA();
                int nodableOffset = iconInst.netMapOffset + k * iconInst.numExtendedExports;
                for (i = 0; i < eqN.length; ++i) {
                    int io = nodableOffset + i;
                    int jF = eqN[i];
                    if (i != jF) {
                        ImmutableNetLayout.connectMap(netMapF, io, nodableOffset + jF);
                    }
                    if (i != (jP = eqP[i])) {
                        ImmutableNetLayout.connectMap(netMapP, io, nodableOffset + jP);
                    }
                    if (i == (jA = eqA[i])) continue;
                    ImmutableNetLayout.connectMap(netMapA, io, nodableOffset + jA);
                }
            }
        }
    }

    private void updateInterface(int[] netMapN, int[] netMapP, int[] netMapA) {
        for (int i = 0; i < this.equivPortsN.length; ++i) {
            this.equivPortsN[i] = netMapN[i];
            this.equivPortsP[i] = netMapP[i];
            this.equivPortsA[i] = netMapA[i];
        }
        for (int exportIndex = 0; exportIndex < this.numExports; ++exportIndex) {
            ImmutableExport e = (ImmutableExport)this.exports.get(exportIndex);
            if (!this.isGlobalPartition(e)) continue;
            if (this.globalPartitions == null) {
                this.globalPartitions = new IdentityHashMap();
            }
            int busWidth = e.name.busWidth();
            for (int k = 0; k < busWidth; ++k) {
                Global.Buf globalBuf = null;
                int q = this.equivPortsN[this.portOffsets[exportIndex] + k];
                for (int l = 0; l < this.globals.size(); ++l) {
                    if (this.equivPortsN[l] != q) continue;
                    Global g = this.globals.get(l);
                    if (globalBuf == null) {
                        globalBuf = new Global.Buf();
                    }
                    globalBuf.addToBuf(g, this.globals.getCharacteristic(g));
                }
                if (globalBuf == null) continue;
                Name n = e.name.subname(k);
                Global.Set globs = this.globalPartitions.get(n);
                if (globs != null) {
                    globalBuf.addToBuf(globs);
                }
                this.globalPartitions.put(n, globalBuf.getBuf());
            }
        }
    }

    private boolean isGlobalPartition(ImmutableExport e) {
        return e.originalPortId.parentId == this.schem.globalPartitionNode.getId();
    }

    private boolean isIconOfParent(ImmutableNodeInst n) {
        if (!(n.protoId instanceof CellId)) {
            return false;
        }
        CellBackup subCell = this.snapshot.getCell((CellId)n.protoId);
        CellId subCellId = subCell.cellRevision.d.cellId;
        return subCellId.isIcon() && this.cellId.isSchematic() && subCellId.libId == this.cellId.libId && subCell.cellRevision.d.groupName.equals(this.cellRevision.d.groupName);
    }

    private ImmutableExport getEquivalentPort(CellRevision otherCell, ImmutableExport e) {
        if (this.cellRevision == otherCell) {
            return e;
        }
        return this.findExport(otherCell, e.name);
    }

    public ImmutableExport findExport(CellRevision cell, Name name) {
        int portIndex = this.searchExport(cell, name.toString());
        if (portIndex >= 0) {
            return (ImmutableExport)cell.exports.get(portIndex);
        }
        return null;
    }

    private int searchExport(CellRevision cellRevision, String name) {
        ImmutableArrayList<ImmutableExport> exports = cellRevision.exports;
        int low = 0;
        int high = exports.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            ImmutableExport e = (ImmutableExport)exports.get(mid);
            int cmp = TextUtils.STRING_NUMBER_ORDER.compare(e.name.toString(), name);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public PrimitiveNode.Function getFunction(ImmutableNodeInst n) {
        if (n.protoId instanceof CellId) {
            return PrimitiveNode.Function.UNKNOWN;
        }
        PrimitiveNode np = this.techPool.getPrimitiveNode((PrimitiveNodeId)n.protoId);
        return np.getTechnology().getPrimitiveFunction(np, n.techBits);
    }

    private EquivalentSchematicExports getEquivExports(CellId cellId) {
        if (!cellId.isIcon() && !cellId.isSchematic()) {
            throw new IllegalArgumentException();
        }
        EquivalentSchematicExports eq2 = this.snapshot.equivSchemExports[cellId.cellIndex];
        if (eq2 == null) {
            ImmutableNetSchem netSchem = new ImmutableNetSchem(this.snapshot, cellId);
            this.snapshot.equivSchemExports[cellId.cellIndex] = eq2 = new EquivalentSchematicExports(netSchem);
        }
        return eq2;
    }

    private int getArcDrawn(ImmutableArcInst a) {
        int arcIndex = this.m.getArcIndex(a);
        return this.drawns[this.arcsOffset + arcIndex];
    }

    private int getPortInstOffset(int nodeId, PortProtoId portId) {
        return this.ni_pi[this.m.getNodeIndexByNodeId(nodeId)] + this.getPortIndex(portId);
    }

    private int getNumPorts(NodeProtoId nodeProtoId) {
        if (nodeProtoId instanceof CellId) {
            return this.snapshot.getCell((CellId)((CellId)nodeProtoId)).cellRevision.exports.size();
        }
        return this.techPool.getPrimitiveNode((PrimitiveNodeId)nodeProtoId).getNumPorts();
    }

    private PortProtoId getPortIdByIndex(NodeProtoId nodeProtoId, int portIndex) {
        if (nodeProtoId instanceof CellId) {
            return ((ImmutableExport)this.snapshot.getCell((CellId)((CellId)nodeProtoId)).cellRevision.exports.get((int)portIndex)).exportId;
        }
        return this.techPool.getPrimitiveNode((PrimitiveNodeId)nodeProtoId).getPort(portIndex).getId();
    }

    private int getPortIndex(PortProtoId portId) {
        if (portId instanceof ExportId) {
            ExportId exportId = (ExportId)portId;
            return this.snapshot.getCell((CellId)exportId.getParentId()).cellRevision.getExportIndexByExportId(exportId);
        }
        return this.techPool.getPrimitivePort((PrimitivePortId)portId).getPortIndex();
    }

    private class PortInst {
        private final ImmutableNodeInst n;
        private final int nodeIndex;
        private final PortProtoId portId;
        private final int portIndex;

        private PortInst(int nodeId, PortProtoId portId) {
            this.nodeIndex = ImmutableNetSchem.this.m.getNodeIndexByNodeId(nodeId);
            this.n = (ImmutableNodeInst)ImmutableNetSchem.this.nodes.get(this.nodeIndex);
            this.portId = portId;
            this.portIndex = ImmutableNetSchem.this.getPortIndex(portId);
        }

        private PortInst(ImmutableExport e) {
            this(e.originalNodeId, e.originalPortId);
        }

        private PortInst(ImmutableArcInst a, int end) {
            this(end != 0 ? a.headNodeId : a.tailNodeId, end != 0 ? a.headPortId : a.tailPortId);
        }

        private int getPortInstOffset() {
            return ImmutableNetSchem.this.ni_pi[this.nodeIndex] + this.portIndex;
        }
    }

    private class IconInst {
        final ImmutableNodeInst nodeInst;
        final boolean iconOfParent;
        final int netMapOffset;
        final int numExtendedExports;
        final EquivalentSchematicExports eq;

        private IconInst(ImmutableNodeInst n, int nodeOffset) {
            assert (n.protoId.isIcon() || n.protoId.isSchematic());
            this.nodeInst = n;
            this.iconOfParent = ImmutableNetSchem.this.isIconOfParent(n);
            this.netMapOffset = nodeOffset;
            this.eq = this.iconOfParent ? null : ImmutableNetSchem.this.getEquivExports((CellId)n.protoId);
            this.numExtendedExports = this.iconOfParent ? -1000000 : this.eq.implementation.numExpandedExports;
        }
    }
}

