/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.GenerateVHDL;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.DigitalAnalysis;
import com.sun.electric.tool.simulation.DigitalSignal;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.als.ALS;
import com.sun.electric.tool.user.CompileVHDL;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Simulation
extends Tool {
    private static Simulation tool = new Simulation();
    public static final Variable.Key RISE_DELAY_KEY = Variable.newKey("SIM_rise_delay");
    public static final Variable.Key FALL_DELAY_KEY = Variable.newKey("SIM_fall_delay");
    public static final Variable.Key WEAK_NODE_KEY = Variable.newKey("SIM_weak_node");
    public static final Variable.Key M_FACTOR_KEY = Variable.newKey("ATTR_M");
    public static final int ALS_ENGINE = 0;
    public static final int IRSIM_ENGINE = 1;
    private static boolean irsimChecked = false;
    private static Class<?> irsimClass = null;
    private static Method irsimSimulateMethod;
    private static boolean fleetChecked;
    private static Class<?> fleetClass;
    private static EMenu fleetSimMenu;
    private static final int CONVERT_TO_VHDL = 1;
    private static final int COMPILE_VHDL_FOR_SIM = 4;
    private static Pref cacheFastHenryUseSingleFrequency;
    private static Pref cacheFastHenryStartFrequency;
    private static Pref cacheFastHenryEndFrequency;
    private static Pref cacheFastHenryRunsPerDecade;
    private static Pref cacheFastHenryMultiPole;
    private static Pref cacheFastHenryNumPoles;
    private static Pref cacheFastHenryDefThickness;
    private static Pref cacheFastHenryWidthSubdivisions;
    private static Pref cacheFastHenryHeightSubdivisions;
    private static Pref cacheFastHenryMaxSegLength;
    private static Pref cacheVerilogStopAtStandardCells;
    private static Pref cachePreserveVerilogFormating;
    private static Pref cacheVerilogParameterizeModuleNames;
    private static Pref cacheVerilogRunPlacementTool;
    private static Pref cacheCDLLibName;
    private static Pref cacheCDLLibPath;
    private static Pref cacheCDLConvertBrackets;
    private static Pref cacheCDLIncludeFile;
    private static Pref cacheCDLIgnoreResistors;
    private static Pref cacheBuiltInResimulateEach;
    private static Pref cacheBuiltInAutoAdvance;
    private static Pref cacheWaveformDisplayMultiState;
    private static Pref cacheIRSIMShowsCommands;
    private static Pref cacheIRSIMDebugging;
    private static Pref cacheIRSIMParameterFile;
    private static Pref cacheIRSIMStepModel;
    private static Pref cacheIRSIMDelayedX;
    private static Pref cacheSpiceEngine;
    private static Pref cacheSpiceLevel;
    private static Pref cacheSpiceOutputFormat;
    private static Pref cacheSpiceShortResistors;
    public static final String spiceRunChoiceDontRun = "Don't Run";
    public static final String spiceRunChoiceRunIgnoreOutput = "Run, Ignore Output";
    public static final String spiceRunChoiceRunReportOutput = "Run, Report Output";
    private static final String[] spiceRunChoices;
    private static Pref cacheSpiceRunChoice;
    private static Pref cacheSpiceRunDir;
    private static Pref cacheSpiceUseRunDir;
    private static Pref cacheSpiceOutputOverwrite;
    private static Pref cacheSpiceRunProbe;
    private static Pref cacheSpiceRunProgram;
    private static Pref cacheSpiceRunProgramArgs;
    private static Pref cacheSpicePartsLibrary;
    private static Pref cacheSpiceHeaderCardInfo;
    private static Pref cacheSpiceTrailerCardInfo;
    private static Pref cacheSpiceParasiticsLevel;
    public static Pref cacheParasiticsUseVerboseNaming;
    public static Pref cacheParasiticsBackAnnotateLayout;
    public static Pref cacheParasiticsExtractPowerGround;
    public static Pref cacheParasiticsUseExemptedNetsFile;
    public static Pref cacheParasiticsIgnoreExemptedNets;
    public static Pref cacheParasiticsExtractsR;
    public static Pref cacheParasiticsExtractsC;
    private static Pref cacheGlobalTreatment;
    private static Pref cacheSpiceWritePwrGndInTopCell;
    private static Pref cacheSpiceUseCellParameters;
    private static Pref cacheSpiceWriteTransSizeInLambda;
    private static Pref cacheSpiceWriteSubcktTopCell;
    private static Pref cacheSpiceWriteTopCellInstance;
    private static Pref cacheSpiceWriteEmptySubckts;
    private static Pref cacheSpiceWriteFinalDotEnd;
    private static Pref cachedSpiceIgnoreParasiticResistors;
    private static Pref cachedSpiceIgnoreModelFiles;
    private static Pref cacheSpiceEpicReaderMemorySize;
    private static Pref cacheSpiceExtractedNetDelimiter;
    private static Pref cachedUseLegacySimulationCode;

    private Simulation() {
        super("simulation");
    }

    public void init() {
    }

    public static Simulation getSimulationTool() {
        return tool;
    }

    public static void startSimulation(int engine, boolean forceDeck, Cell prevCell, Engine prevEngine) {
        Cell cell = null;
        VarContext context = null;
        String fileName = null;
        if (prevCell != null) {
            cell = prevCell;
        } else {
            UserInterface ui = Job.getUserInterface();
            if (forceDeck) {
                fileName = OpenFile.chooseInputFile(FileType.IRSIM, "IRSIM deck to simulate");
                if (fileName == null) {
                    return;
                }
                cell = ui.getCurrentCell();
            } else {
                cell = ui.needCurrentCell();
                if (cell == null) {
                    return;
                }
                EditWindow_ wnd = ui.getCurrentEditWindow_();
                if (wnd != null) {
                    context = wnd.getVarContext();
                }
            }
        }
        switch (engine) {
            case 0: {
                Cell originalCell = cell;
                int activities = 0;
                if (cell.getView() != View.NETLISTALS) {
                    if (cell.isSchematic() || cell.getView() == View.LAYOUT) {
                        Cell vhdlCell = cell.otherView(View.VHDL);
                        if (vhdlCell != null && vhdlCell.getRevisionDate().after(cell.getRevisionDate())) {
                            cell = vhdlCell;
                        } else {
                            activities |= 5;
                        }
                    }
                    if (cell.getView() == View.VHDL) {
                        Cell netListCell = cell.otherView(View.NETLISTQUISC);
                        if (netListCell != null && netListCell.getRevisionDate().after(cell.getRevisionDate())) {
                            cell = netListCell;
                        } else {
                            activities |= 4;
                        }
                    }
                }
                new DoALSActivity(cell, activities, originalCell, prevEngine);
                break;
            }
            case 1: {
                if (!Simulation.hasIRSIM()) {
                    return;
                }
                Simulation.runIRSIM(cell, context, fileName);
            }
        }
    }

    public static boolean hasIRSIM() {
        if (!irsimChecked) {
            irsimChecked = true;
            try {
                irsimClass = Class.forName("com.sun.electric.plugins.irsim.Analyzer");
            }
            catch (ClassNotFoundException e) {
                irsimClass = null;
                return false;
            }
            try {
                irsimSimulateMethod = irsimClass.getMethod("simulateCell", Cell.class, VarContext.class, String.class);
            }
            catch (NoSuchMethodException e) {
                irsimClass = null;
                return false;
            }
        }
        return irsimClass != null;
    }

    public static void runIRSIM(Cell cell, VarContext context, String fileName) {
        try {
            irsimSimulateMethod.invoke(irsimClass, cell, context, fileName);
            return;
        }
        catch (Exception e) {
            System.out.println("Unable to run the IRSIM simulator");
            e.printStackTrace(System.out);
            return;
        }
    }

    public static boolean hasFLEET() {
        if (!fleetChecked) {
            fleetChecked = true;
            try {
                fleetClass = Class.forName("com.sunlabs.fleetsim.electricPlugin.FleetSimElectricPlugin");
            }
            catch (ClassNotFoundException e) {
                fleetClass = null;
                return false;
            }
            try {
                Method fleetMenuMethod = fleetClass.getMethod("fleetSimMenu", new Class[0]);
                fleetSimMenu = (EMenu)fleetMenuMethod.invoke(fleetClass, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                fleetClass = null;
                return false;
            }
            catch (Exception e) {
                System.out.println("Unable to get FleetSimMenu");
                e.printStackTrace(System.out);
            }
        }
        return fleetClass != null;
    }

    public static EMenu FLEETMenu() {
        return fleetSimMenu;
    }

    public static void update() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.update();
    }

    public static void setSignalHigh() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.setSignalHigh();
    }

    public static void setSignalLow() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.setSignalLow();
    }

    public static void setSignalX() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.setSignalX();
    }

    public static void setClock() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        double period = ClockSpec.getClockSpec();
        if (period <= 0.0) {
            return;
        }
        engine.setClock(period);
    }

    public static void showSignalInfo() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.showSignalInfo();
    }

    public static void removeStimuliFromSignal() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.removeStimuliFromSignal();
    }

    public static boolean removeSelectedStimuli() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return false;
        }
        return engine.removeSelectedStimuli();
    }

    public static void removeAllStimuli() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.removeAllStimuli();
    }

    public static void saveStimuli() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.saveStimuli();
    }

    public static void restoreStimuli() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.restoreStimuli();
    }

    private static Engine findEngine() {
        Engine engine = null;
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WaveformWindow ww;
            Engine e;
            WindowFrame wf = it.next();
            if (!(wf.getContent() instanceof WaveformWindow) || (e = (ww = (WaveformWindow)wf.getContent()).getSimData().getEngine()) == null) continue;
            if (wf == WindowFrame.getCurrentWindowFrame()) {
                return e;
            }
            engine = e;
        }
        if (engine == null) {
            System.out.println("No simulator is ready to handle the command");
        }
        return engine;
    }

    public static void setSpiceModel() {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        NodeInst ni = (NodeInst)wnd.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        new SetSpiceModel(ni);
    }

    public static void setVerilogWireCommand(int type) {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        List<Geometric> list = wnd.getHighlightedEObjs(false, true);
        if (list.size() == 0) {
            System.out.println("Must select arcs before setting their type");
            return;
        }
        new SetWireType(list, type);
    }

    public static void setTransistorStrengthCommand(boolean weak) {
        UserInterface ui = Job.getUserInterface();
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        NodeInst ni = (NodeInst)wnd.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        new SetTransistorStrength(ni, weak);
    }

    public static void showSimulationData(Stimuli sd, WaveformWindow ww) {
        if (ww != null) {
            ww.setSimData(sd);
            return;
        }
        Iterator<Analysis> anIt = sd.getAnalyses();
        if (!anIt.hasNext()) {
            System.out.println("ERROR: No simulation data found: waveform window not shown");
            return;
        }
        Analysis an = anIt.next();
        WindowFrame wf = WindowFrame.createWaveformWindow(sd);
        ww = (WaveformWindow)wf.getContent();
        if (sd.getCell() != null) {
            String[] signalNames = WaveformWindow.getSignalOrder(sd.getCell());
            boolean showedSomething = false;
            boolean wantUnlockedTime = false;
            Analysis.AnalysisType onlyType = null;
            for (int i = 0; i < signalNames.length; ++i) {
                int tabPos;
                String signalName = signalNames[i];
                Signal xAxisSignal = null;
                int start = 0;
                if (signalName.startsWith("\t")) {
                    String analysisName;
                    Analysis.AnalysisType analysisType;
                    int openPos = signalName.indexOf(40);
                    int tabPos2 = signalName.indexOf(9, 1);
                    start = tabPos2 + 1;
                    if (openPos >= 0) {
                        tabPos2 = openPos;
                    }
                    if ((analysisType = Analysis.AnalysisType.findAnalysisType(analysisName = signalName.substring(1, tabPos2))) == null || (an = sd.findAnalysis(analysisType)) == null) continue;
                    if (openPos >= 0) {
                        int closePos = signalName.indexOf(41);
                        String sigName = signalName.substring(openPos + 1, closePos);
                        xAxisSignal = (Signal)an.findSignalForNetwork(sigName);
                        wantUnlockedTime = true;
                    }
                }
                if (onlyType == null) {
                    onlyType = an.getAnalysisType();
                }
                if (an.getAnalysisType() != onlyType) {
                    wantUnlockedTime = true;
                }
                Panel wp = null;
                boolean firstSignal = true;
                do {
                    Object sSig;
                    tabPos = signalName.indexOf(9, start);
                    String sigName = null;
                    if (tabPos < 0) {
                        sigName = signalName.substring(start);
                    } else {
                        sigName = signalName.substring(start, tabPos);
                        start = tabPos + 1;
                    }
                    Color sigColor = null;
                    int colorPos = sigName.indexOf(" {");
                    if (colorPos >= 0) {
                        String[] colorNames = sigName.substring(colorPos + 2).split(",");
                        int red = TextUtils.atoi(colorNames[0]);
                        int green = TextUtils.atoi(colorNames[1]);
                        int blue = TextUtils.atoi(colorNames[2]);
                        sigColor = new Color(red, green, blue);
                        sigName = sigName.substring(0, colorPos);
                    }
                    if ((sSig = an.findSignalForNetwork(sigName)) == null) continue;
                    if (firstSignal) {
                        firstSignal = false;
                        wp = new Panel(ww, sd.isAnalog(), an.getAnalysisType());
                        if (xAxisSignal != null) {
                            wp.setXAxisSignal(xAxisSignal);
                        }
                        wp.makeSelectedPanel(-1, -1);
                        showedSomething = true;
                    }
                    WaveSignal ws = new WaveSignal(wp, (Signal)sSig);
                    if (sigColor == null) continue;
                    ws.setColor(sigColor);
                } while (tabPos >= 0);
            }
            if (showedSomething) {
                if (wantUnlockedTime) {
                    ww.togglePanelXAxisLock();
                    Iterator<Panel> it = ww.getPanels();
                    while (it.hasNext()) {
                        Panel panel = it.next();
                        panel.makeSelectedPanel(-1, -1);
                        ww.fillScreen();
                    }
                } else {
                    ww.fillScreen();
                }
                return;
            }
        }
        if (an == null) {
            System.out.println("ERROR: No simulation data found: waveform window not shown");
            return;
        }
        if (sd.isAnalog()) {
            Panel wp = new Panel(ww, sd.isAnalog(), an.getAnalysisType());
            Rectangle2D bounds = an.getBounds();
            double lowValue = bounds.getMinY();
            double highValue = bounds.getMaxY();
            wp.setYAxisRange(lowValue, highValue);
            wp.makeSelectedPanel(-1, -1);
        } else {
            int numSignals = 0;
            List allSignals = an.getSignals();
            Simulation.makeBussedSignals((DigitalAnalysis)an);
            for (int i = 0; i < allSignals.size(); ++i) {
                DigitalSignal sDSig = (DigitalSignal)allSignals.get(i);
                if (sDSig.getSignalContext() != null || sDSig.isInBus() || sDSig.getSignalName().indexOf(64) >= 0) continue;
                Panel wp = new Panel(ww, sd.isAnalog(), an.getAnalysisType());
                wp.makeSelectedPanel(-1, -1);
                new WaveSignal(wp, sDSig);
                if (++numSignals > 15) break;
            }
        }
        ww.getPanel().validate();
        ww.fillScreen();
    }

    private static void makeBussedSignals(DigitalAnalysis an) {
        List signals = an.getSignals();
        for (int i = 0; i < signals.size(); ++i) {
            Signal nextSig;
            int nextBracketPos;
            int j;
            Signal sSig = (Signal)signals.get(i);
            int thisBracketPos = sSig.getSignalName().indexOf(91);
            if (thisBracketPos < 0) continue;
            String prefix = sSig.getSignalName().substring(0, thisBracketPos);
            for (j = i + 1; j < signals.size() && (nextBracketPos = (nextSig = (Signal)signals.get(j)).getSignalName().indexOf(91)) >= 0 && thisBracketPos == nextBracketPos && prefix.equals(nextSig.getSignalName().substring(0, nextBracketPos)) && !(sSig.getSignalContext() == null ^ nextSig.getSignalContext() == null) && (sSig.getSignalContext() == null || sSig.getSignalContext().equals(nextSig.getSignalContext())); ++j) {
            }
            int numSignals = j - i;
            if (numSignals <= 1) continue;
            DigitalSignal busSig = new DigitalSignal(an);
            busSig.setSignalName(prefix, sSig.getSignalContext());
            busSig.buildBussedSignalList();
            for (int k = i; k < j; ++k) {
                DigitalSignal subSig = (DigitalSignal)signals.get(k);
                busSig.addToBussedSignalList(subSig);
            }
            i = j - 1;
        }
    }

    public static boolean isFastHenryUseSingleFrequency() {
        return cacheFastHenryUseSingleFrequency.getBoolean();
    }

    public static void setFastHenryUseSingleFrequency(boolean s) {
        cacheFastHenryUseSingleFrequency.setBoolean(s);
    }

    public static boolean isFactoryFastHenryUseSingleFrequency() {
        return cacheFastHenryUseSingleFrequency.getBooleanFactoryValue();
    }

    public static double getFastHenryStartFrequency() {
        return cacheFastHenryStartFrequency.getDouble();
    }

    public static void setFastHenryStartFrequency(double s) {
        cacheFastHenryStartFrequency.setDouble(s);
    }

    public static double getFactoryFastHenryStartFrequency() {
        return cacheFastHenryStartFrequency.getDoubleFactoryValue();
    }

    public static double getFastHenryEndFrequency() {
        return cacheFastHenryEndFrequency.getDouble();
    }

    public static void setFastHenryEndFrequency(double e) {
        cacheFastHenryEndFrequency.setDouble(e);
    }

    public static double getFactoryFastHenryEndFrequency() {
        return cacheFastHenryEndFrequency.getDoubleFactoryValue();
    }

    public static int getFastHenryRunsPerDecade() {
        return cacheFastHenryRunsPerDecade.getInt();
    }

    public static void setFastHenryRunsPerDecade(int r) {
        cacheFastHenryRunsPerDecade.setInt(r);
    }

    public static int getFactoryFastHenryRunsPerDecade() {
        return cacheFastHenryRunsPerDecade.getIntFactoryValue();
    }

    public static boolean isFastHenryMultiPole() {
        return cacheFastHenryMultiPole.getBoolean();
    }

    public static void setFastHenryMultiPole(boolean mp) {
        cacheFastHenryMultiPole.setBoolean(mp);
    }

    public static boolean isFactoryFastHenryMultiPole() {
        return cacheFastHenryMultiPole.getBooleanFactoryValue();
    }

    public static int getFastHenryNumPoles() {
        return cacheFastHenryNumPoles.getInt();
    }

    public static void setFastHenryNumPoles(int p) {
        cacheFastHenryNumPoles.setInt(p);
    }

    public static int getFactoryFastHenryNumPoles() {
        return cacheFastHenryNumPoles.getIntFactoryValue();
    }

    public static double getFastHenryDefThickness() {
        return cacheFastHenryDefThickness.getDouble();
    }

    public static void setFastHenryDefThickness(double t) {
        cacheFastHenryDefThickness.setDouble(t);
    }

    public static double getFactoryFastHenryDefThickness() {
        return cacheFastHenryDefThickness.getDoubleFactoryValue();
    }

    public static int getFastHenryWidthSubdivisions() {
        return cacheFastHenryWidthSubdivisions.getInt();
    }

    public static void setFastHenryWidthSubdivisions(int w) {
        cacheFastHenryWidthSubdivisions.setInt(w);
    }

    public static int getFactoryFastHenryWidthSubdivisions() {
        return cacheFastHenryWidthSubdivisions.getIntFactoryValue();
    }

    public static int getFastHenryHeightSubdivisions() {
        return cacheFastHenryHeightSubdivisions.getInt();
    }

    public static void setFastHenryHeightSubdivisions(int h) {
        cacheFastHenryHeightSubdivisions.setInt(h);
    }

    public static int getFactoryFastHenryHeightSubdivisions() {
        return cacheFastHenryHeightSubdivisions.getIntFactoryValue();
    }

    public static double getFastHenryMaxSegLength() {
        return cacheFastHenryMaxSegLength.getDouble();
    }

    public static void setFastHenryMaxSegLength(double s) {
        cacheFastHenryMaxSegLength.setDouble(s);
    }

    public static double getFactoryFastHenryMaxSegLength() {
        return cacheFastHenryMaxSegLength.getDoubleFactoryValue();
    }

    public static boolean getVerilogUseAssign() {
        return Simulation.getVerilogUseAssignSetting().getBoolean();
    }

    public static Setting getVerilogUseAssignSetting() {
        return ToolSettings.getVerilogUseAssignSetting();
    }

    public static boolean getVerilogUseTrireg() {
        return Simulation.getVerilogUseTriregSetting().getBoolean();
    }

    public static Setting getVerilogUseTriregSetting() {
        return ToolSettings.getVerilogUseTriregSetting();
    }

    public static void setVerilogStopAtStandardCells(boolean b) {
        cacheVerilogStopAtStandardCells.setBoolean(b);
    }

    public static boolean getVerilogStopAtStandardCells() {
        return cacheVerilogStopAtStandardCells.getBoolean();
    }

    public static boolean getFactoryVerilogStopAtStandardCells() {
        return cacheVerilogStopAtStandardCells.getBooleanFactoryValue();
    }

    public static void setPreserveVerilogFormating(boolean b) {
        cachePreserveVerilogFormating.setBoolean(b);
    }

    public static boolean getPreserveVerilogFormating() {
        return cachePreserveVerilogFormating.getBoolean();
    }

    public static boolean getFactoryPreserveVerilogFormating() {
        return cachePreserveVerilogFormating.getBooleanFactoryValue();
    }

    public static void setVerilogParameterizeModuleNames(boolean b) {
        cacheVerilogParameterizeModuleNames.setBoolean(b);
    }

    public static boolean getVerilogParameterizeModuleNames() {
        return cacheVerilogParameterizeModuleNames.getBoolean();
    }

    public static boolean getFactoryVerilogParameterizeModuleNames() {
        return cacheVerilogParameterizeModuleNames.getBooleanFactoryValue();
    }

    public static void setVerilogRunPlacementTool(boolean b) {
        cacheVerilogRunPlacementTool.setBoolean(b);
    }

    public static boolean getVerilogRunPlacementTool() {
        return cacheVerilogRunPlacementTool.getBoolean();
    }

    public static boolean getFactoryVerilogRunPlacementTool() {
        return cacheVerilogRunPlacementTool.getBooleanFactoryValue();
    }

    public static String getCDLLibName() {
        return cacheCDLLibName.getString();
    }

    public static void setCDLLibName(String libName) {
        cacheCDLLibName.setString(libName);
    }

    public static String getFactoryCDLLibName() {
        return cacheCDLLibName.getStringFactoryValue();
    }

    public static String getCDLLibPath() {
        return cacheCDLLibPath.getString();
    }

    public static void setCDLLibPath(String libName) {
        cacheCDLLibPath.setString(libName);
    }

    public static String getFactoryCDLLibPath() {
        return cacheCDLLibPath.getStringFactoryValue();
    }

    public static boolean isCDLConvertBrackets() {
        return cacheCDLConvertBrackets.getBoolean();
    }

    public static void setCDLConvertBrackets(boolean c) {
        cacheCDLConvertBrackets.setBoolean(c);
    }

    public static boolean isFactoryCDLConvertBrackets() {
        return cacheCDLConvertBrackets.getBooleanFactoryValue();
    }

    public static String getCDLIncludeFile() {
        return cacheCDLIncludeFile.getString();
    }

    public static void setCDLIncludeFile(String file) {
        cacheCDLIncludeFile.setString(file);
    }

    public static String getFactoryCDLIncludeFile() {
        return cacheCDLIncludeFile.getStringFactoryValue();
    }

    public static boolean getCDLIgnoreResistors() {
        return cacheCDLIgnoreResistors.getBoolean();
    }

    public static void setCDLIgnoreResistors(boolean b) {
        cacheCDLIgnoreResistors.setBoolean(b);
    }

    public static boolean isBuiltInResimulateEach() {
        return cacheBuiltInResimulateEach.getBoolean();
    }

    public static void setBuiltInResimulateEach(boolean r) {
        cacheBuiltInResimulateEach.setBoolean(r);
    }

    public static boolean isFactoryBuiltInResimulateEach() {
        return cacheBuiltInResimulateEach.getBooleanFactoryValue();
    }

    public static boolean isBuiltInAutoAdvance() {
        return cacheBuiltInAutoAdvance.getBoolean();
    }

    public static void setBuiltInAutoAdvance(boolean r) {
        cacheBuiltInAutoAdvance.setBoolean(r);
    }

    public static boolean isFactoryBuiltInAutoAdvance() {
        return cacheBuiltInAutoAdvance.getBooleanFactoryValue();
    }

    public static boolean isWaveformDisplayMultiState() {
        return cacheWaveformDisplayMultiState.getBoolean();
    }

    public static void setWaveformDisplayMultiState(boolean m) {
        cacheWaveformDisplayMultiState.setBoolean(m);
    }

    public static boolean isFactoryWaveformDisplayMultiState() {
        return cacheWaveformDisplayMultiState.getBooleanFactoryValue();
    }

    public static boolean isIRSIMShowsCommands() {
        return cacheIRSIMShowsCommands.getBoolean();
    }

    public static void setIRSIMShowsCommands(boolean r) {
        cacheIRSIMShowsCommands.setBoolean(r);
    }

    public static boolean isFactoryIRSIMShowsCommands() {
        return cacheIRSIMShowsCommands.getBooleanFactoryValue();
    }

    public static int getIRSIMDebugging() {
        return cacheIRSIMDebugging.getInt();
    }

    public static void setIRSIMDebugging(int p) {
        cacheIRSIMDebugging.setInt(p);
    }

    public static int getFactoryIRSIMDebugging() {
        return cacheIRSIMDebugging.getIntFactoryValue();
    }

    public static String getIRSIMParameterFile() {
        return cacheIRSIMParameterFile.getString();
    }

    public static void setIRSIMParameterFile(String p) {
        cacheIRSIMParameterFile.setString(p);
    }

    public static String getFactoryIRSIMParameterFile() {
        return cacheIRSIMParameterFile.getStringFactoryValue();
    }

    public static String getIRSIMStepModel() {
        return cacheIRSIMStepModel.getString();
    }

    public static void setIRSIMStepModel(String m) {
        cacheIRSIMStepModel.setString(m);
    }

    public static String getFactoryIRSIMStepModel() {
        return cacheIRSIMStepModel.getStringFactoryValue();
    }

    public static boolean isIRSIMDelayedX() {
        return cacheIRSIMDelayedX.getBoolean();
    }

    public static void setIRSIMDelayedX(boolean b) {
        cacheIRSIMDelayedX.setBoolean(b);
    }

    public static boolean isFactoryIRSIMDelayedX() {
        return cacheIRSIMDelayedX.getBooleanFactoryValue();
    }

    public static SpiceEngine getSpiceEngine() {
        int cache = cacheSpiceEngine.getInt();
        for (SpiceEngine p : SpiceEngine.values()) {
            if (p.code() != cache) continue;
            return p;
        }
        throw new Error("No Spice engine found");
    }

    public static void setSpiceEngine(SpiceEngine engine) {
        cacheSpiceEngine.setInt(engine.code());
    }

    public static SpiceEngine getFactorySpiceEngine() {
        int cache = cacheSpiceEngine.getIntFactoryValue();
        for (SpiceEngine p : SpiceEngine.values()) {
            if (p.code() != cache) continue;
            return p;
        }
        throw new Error("No Spice engine found");
    }

    public static String getSpiceLevel() {
        return cacheSpiceLevel.getString();
    }

    public static void setSpiceLevel(String level) {
        cacheSpiceLevel.setString(level);
    }

    public static String getFactorySpiceLevel() {
        return cacheSpiceLevel.getStringFactoryValue();
    }

    public static String getSpiceOutputFormat() {
        return cacheSpiceOutputFormat.getString();
    }

    public static void setSpiceOutputFormat(String format) {
        cacheSpiceOutputFormat.setString(format);
    }

    public static String getFactorySpiceOutputFormat() {
        return cacheSpiceOutputFormat.getStringFactoryValue();
    }

    public static int getSpiceShortResistors() {
        return cacheSpiceShortResistors.getInt();
    }

    public static void setSpiceShortResistors(int sr) {
        cacheSpiceShortResistors.setInt(sr);
    }

    public static int getFactorySpiceShortResistors() {
        return cacheSpiceShortResistors.getIntFactoryValue();
    }

    public static String[] getSpiceRunChoiceValues() {
        return spiceRunChoices;
    }

    public static String getSpiceRunChoice() {
        return spiceRunChoices[cacheSpiceRunChoice.getInt()];
    }

    public static void setSpiceRunChoice(String choice) {
        String[] values = Simulation.getSpiceRunChoiceValues();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(choice)) continue;
            cacheSpiceRunChoice.setInt(i);
            return;
        }
    }

    public static String getFactorySpiceRunChoice() {
        return spiceRunChoices[cacheSpiceRunChoice.getIntFactoryValue()];
    }

    public static String getSpiceRunDir() {
        return cacheSpiceRunDir.getString();
    }

    public static void setSpiceRunDir(String dir) {
        cacheSpiceRunDir.setString(dir);
    }

    public static String getFactorySpiceRunDir() {
        return cacheSpiceRunDir.getStringFactoryValue();
    }

    public static boolean getSpiceUseRunDir() {
        return cacheSpiceUseRunDir.getBoolean();
    }

    public static void setSpiceUseRunDir(boolean b) {
        cacheSpiceUseRunDir.setBoolean(b);
    }

    public static boolean getFactorySpiceUseRunDir() {
        return cacheSpiceUseRunDir.getBooleanFactoryValue();
    }

    public static boolean getSpiceOutputOverwrite() {
        return cacheSpiceOutputOverwrite.getBoolean();
    }

    public static void setSpiceOutputOverwrite(boolean b) {
        cacheSpiceOutputOverwrite.setBoolean(b);
    }

    public static boolean getFactorySpiceOutputOverwrite() {
        return cacheSpiceOutputOverwrite.getBooleanFactoryValue();
    }

    public static boolean getSpiceRunProbe() {
        return cacheSpiceRunProbe.getBoolean();
    }

    public static void setSpiceRunProbe(boolean b) {
        cacheSpiceRunProbe.setBoolean(b);
    }

    public static boolean getFactorySpiceRunProbe() {
        return cacheSpiceRunProbe.getBooleanFactoryValue();
    }

    public static String getSpiceRunProgram() {
        return cacheSpiceRunProgram.getString();
    }

    public static void setSpiceRunProgram(String c) {
        cacheSpiceRunProgram.setString(c);
    }

    public static String getFactorySpiceRunProgram() {
        return cacheSpiceRunProgram.getStringFactoryValue();
    }

    public static String getSpiceRunProgramArgs() {
        return cacheSpiceRunProgramArgs.getString();
    }

    public static void setSpiceRunProgramArgs(String c) {
        cacheSpiceRunProgramArgs.setString(c);
    }

    public static String getFactorySpiceRunProgramArgs() {
        return cacheSpiceRunProgramArgs.getStringFactoryValue();
    }

    public static String getSpicePartsLibrary() {
        if (cacheSpicePartsLibrary == null) {
            String[] libNames = LibFile.getSpicePartsLibraries();
            cacheSpicePartsLibrary = Pref.makeStringPref("SpicePartsLibrary", Simulation.tool.prefs, libNames[0]);
        }
        return cacheSpicePartsLibrary.getString();
    }

    public static void setSpicePartsLibrary(String parts) {
        if (cacheSpicePartsLibrary == null) {
            String[] libNames = LibFile.getSpicePartsLibraries();
            cacheSpicePartsLibrary = Pref.makeStringPref("SpicePartsLibrary", Simulation.tool.prefs, libNames[0]);
        }
        cacheSpicePartsLibrary.setString(parts);
    }

    public static String getFactorySpicePartsLibrary() {
        if (cacheSpicePartsLibrary == null) {
            String[] libNames = LibFile.getSpicePartsLibraries();
            cacheSpicePartsLibrary = Pref.makeStringPref("SpicePartsLibrary", Simulation.tool.prefs, libNames[0]);
        }
        return cacheSpicePartsLibrary.getStringFactoryValue();
    }

    public static String getSpiceHeaderCardInfo() {
        return cacheSpiceHeaderCardInfo.getString();
    }

    public static void setSpiceHeaderCardInfo(String spec) {
        cacheSpiceHeaderCardInfo.setString(spec);
    }

    public static String getFactorySpiceHeaderCardInfo() {
        return cacheSpiceHeaderCardInfo.getStringFactoryValue();
    }

    public static String getSpiceTrailerCardInfo() {
        return cacheSpiceTrailerCardInfo.getString();
    }

    public static void setSpiceTrailerCardInfo(String spec) {
        cacheSpiceTrailerCardInfo.setString(spec);
    }

    public static String getFactorySpiceTrailerCardInfo() {
        return cacheSpiceTrailerCardInfo.getStringFactoryValue();
    }

    public static SpiceParasitics getSpiceParasiticsLevel() {
        int curCode = cacheSpiceParasiticsLevel.getInt();
        for (SpiceParasitics p : SpiceParasitics.values()) {
            if (p.code() != curCode) continue;
            return p;
        }
        return null;
    }

    public static void setSpiceParasiticsLevel(SpiceParasitics p) {
        cacheSpiceParasiticsLevel.setInt(p.code);
    }

    public static SpiceParasitics getFactorySpiceParasiticsLevel() {
        int curCode = cacheSpiceParasiticsLevel.getIntFactoryValue();
        for (SpiceParasitics p : SpiceParasitics.values()) {
            if (p.code() != curCode) continue;
            return p;
        }
        return null;
    }

    public static boolean isParasiticsUseVerboseNaming() {
        return cacheParasiticsUseVerboseNaming.getBoolean();
    }

    public static void setParasiticsUseVerboseNaming(boolean b) {
        cacheParasiticsUseVerboseNaming.setBoolean(b);
    }

    public static boolean isFactoryParasiticsUseVerboseNaming() {
        return cacheParasiticsUseVerboseNaming.getBooleanFactoryValue();
    }

    public static boolean isParasiticsBackAnnotateLayout() {
        return cacheParasiticsBackAnnotateLayout.getBoolean();
    }

    public static void setParasiticsBackAnnotateLayout(boolean b) {
        cacheParasiticsBackAnnotateLayout.setBoolean(b);
    }

    public static boolean isFactoryParasiticsBackAnnotateLayout() {
        return cacheParasiticsBackAnnotateLayout.getBooleanFactoryValue();
    }

    public static boolean isParasiticsExtractPowerGround() {
        return cacheParasiticsExtractPowerGround.getBoolean();
    }

    public static void setParasiticsExtractPowerGround(boolean b) {
        cacheParasiticsExtractPowerGround.setBoolean(b);
    }

    public static boolean isFactoryParasiticsExtractPowerGround() {
        return cacheParasiticsExtractPowerGround.getBooleanFactoryValue();
    }

    public static boolean isParasiticsUseExemptedNetsFile() {
        return cacheParasiticsUseExemptedNetsFile.getBoolean();
    }

    public static void setParasiticsUseExemptedNetsFile(boolean b) {
        cacheParasiticsUseExemptedNetsFile.setBoolean(b);
    }

    public static boolean isFactoryParasiticsUseExemptedNetsFile() {
        return cacheParasiticsUseExemptedNetsFile.getBooleanFactoryValue();
    }

    public static boolean isParasiticsIgnoreExemptedNets() {
        return cacheParasiticsIgnoreExemptedNets.getBoolean();
    }

    public static void setParasiticsIgnoreExemptedNets(boolean b) {
        cacheParasiticsIgnoreExemptedNets.setBoolean(b);
    }

    public static boolean isFactoryParasiticsIgnoreExemptedNets() {
        return cacheParasiticsIgnoreExemptedNets.getBooleanFactoryValue();
    }

    public static boolean isParasiticsExtractsR() {
        return cacheParasiticsExtractsR.getBoolean();
    }

    public static void setParasiticsExtractsR(boolean b) {
        cacheParasiticsExtractsR.setBoolean(b);
    }

    public static boolean isFactoryParasiticsExtractsR() {
        return cacheParasiticsExtractsR.getBooleanFactoryValue();
    }

    public static boolean isParasiticsExtractsC() {
        return cacheParasiticsExtractsC.getBoolean();
    }

    public static void setParasiticsExtractsC(boolean b) {
        cacheParasiticsExtractsC.setBoolean(b);
    }

    public static boolean isFactoryParasiticsExtractsC() {
        return cacheParasiticsExtractsC.getBooleanFactoryValue();
    }

    public static SpiceGlobal getSpiceGlobalTreatment() {
        return SpiceGlobal.find(cacheGlobalTreatment.getInt());
    }

    public static void setSpiceGlobalTreatment(SpiceGlobal g) {
        cacheGlobalTreatment.setInt(g.getCode());
    }

    public static SpiceGlobal getFactorySpiceGlobalTreatment() {
        return SpiceGlobal.find(cacheGlobalTreatment.getIntFactoryValue());
    }

    public static boolean isSpiceWritePwrGndInTopCell() {
        return cacheSpiceWritePwrGndInTopCell.getBoolean();
    }

    public static void setSpiceWritePwrGndInTopCell(boolean g) {
        cacheSpiceWritePwrGndInTopCell.setBoolean(g);
    }

    public static boolean isFactorySpiceWritePwrGndInTopCell() {
        return cacheSpiceWritePwrGndInTopCell.getBooleanFactoryValue();
    }

    public static boolean isSpiceUseCellParameters() {
        return cacheSpiceUseCellParameters.getBoolean();
    }

    public static void setSpiceUseCellParameters(boolean p) {
        cacheSpiceUseCellParameters.setBoolean(p);
    }

    public static boolean isFactorySpiceUseCellParameters() {
        return cacheSpiceUseCellParameters.getBooleanFactoryValue();
    }

    public static boolean isSpiceWriteTransSizeInLambda() {
        return cacheSpiceWriteTransSizeInLambda.getBoolean();
    }

    public static void setSpiceWriteTransSizeInLambda(boolean l) {
        cacheSpiceWriteTransSizeInLambda.setBoolean(l);
    }

    public static boolean isFactorySpiceWriteTransSizeInLambda() {
        return cacheSpiceWriteTransSizeInLambda.getBooleanFactoryValue();
    }

    public static boolean isSpiceWriteSubcktTopCell() {
        return cacheSpiceWriteSubcktTopCell.getBoolean();
    }

    public static void setSpiceWriteSubcktTopCell(boolean b) {
        cacheSpiceWriteSubcktTopCell.setBoolean(b);
    }

    public static boolean isFactorySpiceWriteSubcktTopCell() {
        return cacheSpiceWriteSubcktTopCell.getBooleanFactoryValue();
    }

    public static boolean isSpiceWriteTopCellInstance() {
        return cacheSpiceWriteTopCellInstance.getBoolean();
    }

    public static void setSpiceWriteTopCellInstance(boolean b) {
        cacheSpiceWriteTopCellInstance.setBoolean(b);
    }

    public static boolean isSpiceWriteEmtpySubckts() {
        return cacheSpiceWriteEmptySubckts.getBoolean();
    }

    public static void setSpiceWriteEmptySubckts(boolean b) {
        cacheSpiceWriteEmptySubckts.setBoolean(b);
    }

    public static boolean isSpiceWriteFinalDotEnd() {
        return cacheSpiceWriteFinalDotEnd.getBoolean();
    }

    public static void setSpiceWriteFinalDotEnd(boolean b) {
        cacheSpiceWriteFinalDotEnd.setBoolean(b);
    }

    public static boolean isFactorySpiceWriteFinalDotEnd() {
        return cacheSpiceWriteFinalDotEnd.getBooleanFactoryValue();
    }

    public static boolean isSpiceIgnoreParasiticResistors() {
        return cachedSpiceIgnoreParasiticResistors.getBoolean();
    }

    public static void setSpiceIgnoreParasiticResistors(boolean b) {
        cachedSpiceIgnoreParasiticResistors.setBoolean(b);
    }

    public static boolean isSpiceIgnoreModelFiles() {
        return cachedSpiceIgnoreModelFiles.getBoolean();
    }

    public static void setSpiceIgnoreModelFiles(boolean b) {
        cachedSpiceIgnoreModelFiles.setBoolean(b);
    }

    public static boolean isFactorySpiceIgnoreModelFiles() {
        return cachedSpiceIgnoreModelFiles.getBooleanFactoryValue();
    }

    public static int getSpiceEpicMemorySize() {
        return cacheSpiceEpicReaderMemorySize.getInt();
    }

    public static void setSpiceEpicMemorySize(int limit) {
        cacheSpiceEpicReaderMemorySize.setInt(limit);
    }

    public static int getFactorySpiceEpicMemorySize() {
        return cacheSpiceEpicReaderMemorySize.getIntFactoryValue();
    }

    public static String getSpiceExtractedNetDelimiter() {
        return cacheSpiceExtractedNetDelimiter.getString();
    }

    public static void setSpiceExtractedNetDelimiter(String s) {
        cacheSpiceExtractedNetDelimiter.setString(s);
    }

    public static String getFactorySpiceExtractedNetDelimiter() {
        return cacheSpiceExtractedNetDelimiter.getStringFactoryValue();
    }

    public static boolean isUseLegacySimulationCode() {
        return cachedUseLegacySimulationCode.getBoolean();
    }

    public static void setUseLegacySimulationCode(boolean b) {
        cachedUseLegacySimulationCode.setBoolean(b);
    }

    public static boolean isFactoryUseLegacySimulationCode() {
        return cachedUseLegacySimulationCode.getBooleanFactoryValue();
    }

    static {
        fleetChecked = false;
        fleetClass = null;
        fleetSimMenu = null;
        cacheFastHenryUseSingleFrequency = Pref.makeBooleanPref("FastHenryUseSingleFrequency", Simulation.tool.prefs, false);
        cacheFastHenryStartFrequency = Pref.makeDoublePref("FastHenryStartFrequency", Simulation.tool.prefs, 0.0);
        cacheFastHenryEndFrequency = Pref.makeDoublePref("FastHenryEndFrequency", Simulation.tool.prefs, 0.0);
        cacheFastHenryRunsPerDecade = Pref.makeIntPref("FastHenryRunsPerDecade", Simulation.tool.prefs, 1);
        cacheFastHenryMultiPole = Pref.makeBooleanPref("FastHenryMultiPole", Simulation.tool.prefs, false);
        cacheFastHenryNumPoles = Pref.makeIntPref("FastHenryNumPoles", Simulation.tool.prefs, 20);
        cacheFastHenryDefThickness = Pref.makeDoublePref("FastHenryDefThickness", Simulation.tool.prefs, 2.0);
        cacheFastHenryWidthSubdivisions = Pref.makeIntPref("FastHenryWidthSubdivisions", Simulation.tool.prefs, 1);
        cacheFastHenryHeightSubdivisions = Pref.makeIntPref("FastHenryHeightSubdivisions", Simulation.tool.prefs, 1);
        cacheFastHenryMaxSegLength = Pref.makeDoublePref("FastHenryMaxSegLength", Simulation.tool.prefs, 0.0);
        cacheVerilogStopAtStandardCells = Pref.makeBooleanPref("VerilogStopAtStandardCells", Simulation.tool.prefs, false);
        cachePreserveVerilogFormating = Pref.makeBooleanPref("PreserveVerilogFormating", Simulation.tool.prefs, true);
        cacheVerilogParameterizeModuleNames = Pref.makeBooleanPref("VerilogParamertizeModuleNames", Simulation.tool.prefs, false);
        cacheVerilogRunPlacementTool = Pref.makeBooleanPref("cacheVerilogRunPlacementTool", Simulation.tool.prefs, false);
        cacheCDLLibName = Pref.makeStringPref("CDLLibName", Simulation.tool.prefs, "");
        cacheCDLLibPath = Pref.makeStringPref("CDLLibPath", Simulation.tool.prefs, "");
        cacheCDLConvertBrackets = Pref.makeBooleanPref("CDLConvertBrackets", Simulation.tool.prefs, false);
        cacheCDLIncludeFile = Pref.makeStringPref("CDLIncludeFile", Simulation.tool.prefs, "");
        cacheCDLIgnoreResistors = Pref.makeBooleanPref("CDLLIgnoreResistors", Simulation.tool.prefs, false);
        cacheBuiltInResimulateEach = Pref.makeBooleanPref("BuiltInResimulateEach", Simulation.tool.prefs, true);
        cacheBuiltInAutoAdvance = Pref.makeBooleanPref("BuiltInAutoAdvance", Simulation.tool.prefs, false);
        cacheWaveformDisplayMultiState = Pref.makeBooleanPref("WaveformDisplayMultiState", Simulation.tool.prefs, false);
        cacheIRSIMShowsCommands = Pref.makeBooleanPref("IRSIMShowsCommands", Simulation.tool.prefs, false);
        cacheIRSIMDebugging = Pref.makeIntPref("IRSIMDebugging", Simulation.tool.prefs, 0);
        cacheIRSIMParameterFile = Pref.makeStringPref("IRSIMParameterFile", Simulation.tool.prefs, "scmos0.3.prm");
        cacheIRSIMStepModel = Pref.makeStringPref("IRSIMStepModel", Simulation.tool.prefs, "RC");
        cacheIRSIMDelayedX = Pref.makeBooleanPref("IRSIMDelayedX", Simulation.tool.prefs, true);
        cacheSpiceEngine = Pref.makeIntPref("SpiceEngine", Simulation.tool.prefs, SpiceEngine.SPICE_ENGINE_H.code());
        cacheSpiceLevel = Pref.makeStringPref("SpiceLevel", Simulation.tool.prefs, "1");
        cacheSpiceOutputFormat = Pref.makeStringPref("SpiceOutputFormat", Simulation.tool.prefs, "Standard");
        cacheSpiceShortResistors = Pref.makeIntPref("SpiceShortResistors", Simulation.tool.prefs, 0);
        spiceRunChoices = new String[]{spiceRunChoiceDontRun, spiceRunChoiceRunIgnoreOutput, spiceRunChoiceRunReportOutput};
        cacheSpiceRunChoice = Pref.makeIntPref("SpiceRunChoice", Simulation.tool.prefs, 0);
        cacheSpiceRunDir = Pref.makeStringPref("SpiceRunDir", Simulation.tool.prefs, "");
        cacheSpiceUseRunDir = Pref.makeBooleanPref("SpiceUseRunDir", Simulation.tool.prefs, false);
        cacheSpiceOutputOverwrite = Pref.makeBooleanPref("SpiceOverwriteOutputFile", Simulation.tool.prefs, false);
        cacheSpiceRunProbe = Pref.makeBooleanPref("SpiceRunProbe", Simulation.tool.prefs, false);
        cacheSpiceRunProgram = Pref.makeStringPref("SpiceRunProgram", Simulation.tool.prefs, "");
        cacheSpiceRunProgramArgs = Pref.makeStringPref("SpiceRunProgramArgs", Simulation.tool.prefs, "");
        cacheSpicePartsLibrary = null;
        cacheSpiceHeaderCardInfo = Pref.makeStringPref("SpiceHeaderCardInfo", Simulation.tool.prefs, "");
        cacheSpiceTrailerCardInfo = Pref.makeStringPref("SpiceTrailerCardInfo", Simulation.tool.prefs, "");
        cacheSpiceParasiticsLevel = Pref.makeIntPref("SpiceParasiticsLevel", Simulation.tool.prefs, SpiceParasitics.SIMPLE.code());
        cacheParasiticsUseVerboseNaming = Pref.makeBooleanPref("ParasiticsUseVerboseNaming", Simulation.tool.prefs, true);
        cacheParasiticsBackAnnotateLayout = Pref.makeBooleanPref("ParasiticsBackAnnotateLayout", Simulation.tool.prefs, false);
        cacheParasiticsExtractPowerGround = Pref.makeBooleanPref("ParasiticsExtractPowerGround", Simulation.tool.prefs, false);
        cacheParasiticsUseExemptedNetsFile = Pref.makeBooleanPref("UseExemptedNetsFile", Simulation.tool.prefs, false);
        cacheParasiticsIgnoreExemptedNets = Pref.makeBooleanPref("IgnoreExemptedNets", Simulation.tool.prefs, true);
        cacheParasiticsExtractsR = Pref.makeBooleanPref("ParasiticsExtractsR", Simulation.tool.prefs, true);
        cacheParasiticsExtractsC = Pref.makeBooleanPref("ParasiticsExtractsC", Simulation.tool.prefs, true);
        cacheGlobalTreatment = Pref.makeIntPref("SpiceGlobalTreatment", Simulation.tool.prefs, SpiceGlobal.USEGLOBALBLOCK.getCode());
        cacheSpiceWritePwrGndInTopCell = Pref.makeBooleanPref("cacheSpiceWritePwrGndInTopCell", Simulation.tool.prefs, true);
        cacheSpiceUseCellParameters = Pref.makeBooleanPref("SpiceUseCellParameters", Simulation.tool.prefs, false);
        cacheSpiceWriteTransSizeInLambda = Pref.makeBooleanPref("SpiceWriteTransSizeInLambda", Simulation.tool.prefs, false);
        cacheSpiceWriteSubcktTopCell = Pref.makeBooleanPref("SpiceWriteSubcktTopCell", Simulation.tool.prefs, false);
        cacheSpiceWriteTopCellInstance = Pref.makeBooleanPref("SpiceWriteTopCellInstance", Simulation.tool.prefs, true);
        cacheSpiceWriteEmptySubckts = Pref.makeBooleanPref("SpiceWriteEmptySubckts", Simulation.tool.prefs, true);
        cacheSpiceWriteFinalDotEnd = Pref.makeBooleanPref("SpiceWriteFinalDotEnd", Simulation.tool.prefs, true);
        cachedSpiceIgnoreParasiticResistors = Pref.makeBooleanPref("SpiceIgnoreParasiticResistors", Simulation.tool.prefs, false);
        cachedSpiceIgnoreModelFiles = Pref.makeBooleanPref("SpiceIgnoreModelFiles", Simulation.tool.prefs, false);
        cacheSpiceEpicReaderMemorySize = Pref.makeIntPref("SpiceEpicReaderMemorySize", Simulation.tool.prefs, 1000);
        cacheSpiceExtractedNetDelimiter = Pref.makeStringPref("SpiceExtractedNetDelimiter", Simulation.tool.prefs, ":");
        cachedUseLegacySimulationCode = Pref.makeBooleanPref("UseLegacySimulationCode", Simulation.tool.prefs, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SpiceGlobal
    extends Enum<SpiceGlobal> {
        public static final /* enum */ SpiceGlobal NONE = new SpiceGlobal(0);
        public static final /* enum */ SpiceGlobal USEGLOBALBLOCK = new SpiceGlobal(1);
        public static final /* enum */ SpiceGlobal USESUBCKTPORTS = new SpiceGlobal(2);
        private int code;
        private static final /* synthetic */ SpiceGlobal[] $VALUES;

        public static final SpiceGlobal[] values() {
            return (SpiceGlobal[])$VALUES.clone();
        }

        public static SpiceGlobal valueOf(String name) {
            return Enum.valueOf(SpiceGlobal.class, name);
        }

        private SpiceGlobal(int c) {
            this.code = c;
        }

        public int getCode() {
            return this.code;
        }

        public static SpiceGlobal find(int c) {
            for (SpiceGlobal s : SpiceGlobal.values()) {
                if (s.code != c) continue;
                return s;
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new SpiceGlobal[]{NONE, USEGLOBALBLOCK, USESUBCKTPORTS};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpiceParasitics {
        SIMPLE(0, "Trans area/perim only"),
        RC_CONSERVATIVE(1, "Conservative RC"),
        RC_PROXIMITY(2, "Proximity-based RC");

        private int code;
        private String name;

        private SpiceParasitics(int val, String name) {
            this.code = val;
            this.name = name;
        }

        public int code() {
            return this.code;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpiceEngine {
        SPICE_ENGINE_2(0, "Spice 2"),
        SPICE_ENGINE_3(1, "Spice 3"),
        SPICE_ENGINE_H(2, "HSpice"),
        SPICE_ENGINE_P(3, "PSpice"),
        SPICE_ENGINE_G(4, "Gnucap"),
        SPICE_ENGINE_S(5, "SmartSpice"),
        SPICE_ENGINE_H_ASSURA(6, "HSpice for Assura"),
        SPICE_ENGINE_H_CALIBRE(7, "HSpice for Calibre");

        private int code;
        private String name;

        private SpiceEngine(int val, String name) {
            this.code = val;
            this.name = name;
        }

        public int code() {
            return this.code;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class ClockSpec
    extends EDialog {
        private double period = -1.0;
        private JRadioButton freqBut;
        private JRadioButton periodBut;
        private JTextField freqField;
        private JTextField periodField;

        public static double getClockSpec() {
            ClockSpec dialog = new ClockSpec((Frame)TopLevel.getCurrentJFrame(), true);
            dialog.setVisible(true);
            return dialog.period;
        }

        public ClockSpec(Frame parent, boolean modal) {
            super(parent, modal);
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Clock Specification");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ClockSpec.this.closeDialog(evt);
                }
            });
            ButtonGroup fp = new ButtonGroup();
            this.freqBut = new JRadioButton("Frequency:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            this.getContentPane().add((Component)this.freqBut, gbc);
            fp.add(this.freqBut);
            this.freqField = new JTextField();
            this.freqField.setColumns(12);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.freqField, gbc);
            this.periodBut = new JRadioButton("Period:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            this.getContentPane().add((Component)this.periodBut, gbc);
            fp.add(this.periodBut);
            this.periodBut.setSelected(true);
            this.periodField = new JTextField();
            this.periodField.setColumns(12);
            this.periodField.setText("0.00000001");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.periodField, gbc);
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ClockSpec.this.cancel(evt);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            JButton ok = new JButton("OK");
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ClockSpec.this.ok(evt);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            this.pack();
            this.getRootPane().setDefaultButton(ok);
            this.finishInitialization();
        }

        protected void escapePressed() {
            this.cancel(null);
        }

        private void cancel(ActionEvent evt) {
            this.closeDialog(null);
        }

        private void ok(ActionEvent evt) {
            if (this.freqBut.isSelected()) {
                double freq = TextUtils.atof(this.freqField.getText());
                if (freq != 0.0) {
                    this.period = 1.0 / freq;
                }
            } else {
                this.period = TextUtils.atof(this.periodField.getText());
            }
            this.closeDialog(null);
        }

        private void closeDialog(WindowEvent evt) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SetTransistorStrength
    extends Job {
        private NodeInst ni;
        private boolean weak;

        protected SetTransistorStrength(NodeInst ni, boolean weak) {
            super("Change Transistor Strength", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.weak = weak;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            if (this.weak) {
                this.ni.newDisplayVar(WEAK_NODE_KEY, "Weak");
            } else if (this.ni.getVar(WEAK_NODE_KEY) != null) {
                this.ni.delVar(WEAK_NODE_KEY);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetWireType
    extends Job {
        private List<Geometric> list;
        private int type;

        protected SetWireType(List<Geometric> list, int type) {
            super("Change Verilog Wire Types", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = list;
            this.type = type;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            for (Geometric geom : this.list) {
                ArcInst ai = (ArcInst)geom;
                switch (this.type) {
                    case 0: {
                        ai.newDisplayVar(Verilog.WIRE_TYPE_KEY, "wire");
                        break;
                    }
                    case 1: {
                        ai.newDisplayVar(Verilog.WIRE_TYPE_KEY, "trireg");
                        break;
                    }
                    case 2: {
                        if (ai.getVar(Verilog.WIRE_TYPE_KEY) == null) break;
                        ai.delVar(Verilog.WIRE_TYPE_KEY);
                    }
                }
            }
            return true;
        }
    }

    private static class SetSpiceModel
    extends Job {
        private NodeInst ni;

        protected SetSpiceModel(NodeInst ni) {
            super("Set Spice Model", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            this.ni.newDisplayVar(Spice.SPICE_MODEL_KEY, "SPICE-Model");
            return true;
        }
    }

    private static class DoALSActivity
    extends Job {
        private Cell cell;
        private Cell originalCell;
        private int activities;
        private transient Engine prevEngine;
        private List<Cell> textCellsToRedraw;
        private GenerateVHDL.VHDLPreferences vp = new GenerateVHDL.VHDLPreferences(false);

        private DoALSActivity(Cell cell, int activities, Cell originalCell, Engine prevEngine) {
            super("ALS Simulation", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.activities = activities;
            this.originalCell = originalCell;
            this.prevEngine = prevEngine;
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Library destLib = this.cell.getLibrary();
            this.textCellsToRedraw = new ArrayList<Cell>();
            this.fieldVariableChanged("textCellsToRedraw");
            if ((this.activities & 1) != 0) {
                System.out.print("Generating VHDL from '" + this.cell + "' ...");
                List<String> vhdlStrings = GenerateVHDL.convertCell(this.cell, this.vp);
                if (vhdlStrings == null) {
                    throw new JobException("No VHDL produced");
                }
                String cellName = this.cell.getName() + "{vhdl}";
                Cell vhdlCell = this.cell.getLibrary().findNodeProto(cellName);
                if (vhdlCell == null && (vhdlCell = Cell.makeInstance(this.cell.getLibrary(), cellName)) == null) {
                    return false;
                }
                String[] array = new String[vhdlStrings.size()];
                for (int i = 0; i < vhdlStrings.size(); ++i) {
                    array[i] = vhdlStrings.get(i);
                }
                vhdlCell.setTextViewContents(array);
                this.textCellsToRedraw.add(vhdlCell);
                System.out.println(" Done, created " + vhdlCell);
                this.cell = vhdlCell;
                this.fieldVariableChanged("cell");
            }
            if ((this.activities & 4) != 0) {
                System.out.print("Compiling VHDL in " + this.cell + " ...");
                CompileVHDL c = new CompileVHDL(this.cell);
                if (c.hasErrors()) {
                    throw new JobException("ERRORS during compilation, no netlist produced");
                }
                List<String> netlistStrings = c.getALSNetlist(destLib);
                if (netlistStrings == null) {
                    throw new JobException("No netlist produced");
                }
                String cellName = this.cell.getName() + "{net.als}";
                Cell netlistCell = this.cell.getLibrary().findNodeProto(cellName);
                if (netlistCell == null && (netlistCell = Cell.makeInstance(this.cell.getLibrary(), cellName)) == null) {
                    return false;
                }
                String[] array = new String[netlistStrings.size()];
                for (int i = 0; i < netlistStrings.size(); ++i) {
                    array[i] = netlistStrings.get(i);
                }
                netlistCell.setTextViewContents(array);
                this.textCellsToRedraw.add(netlistCell);
                System.out.println(" Done, created " + netlistCell);
                this.cell = netlistCell;
                this.fieldVariableChanged("cell");
            }
            return true;
        }

        public void terminateOK() {
            for (Cell cell : this.textCellsToRedraw) {
                TextWindow.updateText(cell);
            }
            if (this.prevEngine != null) {
                ALS.restartSimulation(this.cell, this.originalCell, (ALS)this.prevEngine);
            } else {
                ALS.simulateNetlist(this.cell, this.originalCell);
            }
        }
    }
}

