/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogAnalysis;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.Waveform;
import com.sun.electric.tool.simulation.WaveformImpl;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class LTSpiceOut
extends Simulate {
    private static final boolean DEBUG = false;
    private boolean complexValues;

    LTSpiceOut() {
    }

    protected void readSimulationOutput(Stimuli sd, URL fileURL, Cell cell) throws IOException {
        if (this.openBinaryInput(fileURL)) {
            return;
        }
        LTSpiceOut.startProgressDialog("LTSpice output", fileURL.getFile());
        this.readRawLTSpiceFile(cell, sd);
        LTSpiceOut.stopProgressDialog();
        this.closeInput();
    }

    private void readRawLTSpiceFile(Cell cell, Stimuli sd) throws IOException {
        String line;
        this.complexValues = false;
        boolean realValues = false;
        int signalCount = -1;
        String[] signalNames = null;
        int rowCount = -1;
        Analysis.AnalysisType aType = AnalogAnalysis.ANALYSIS_TRANS;
        while ((line = this.getLineFromBinary()) != null) {
            this.updateProgressDialog(line.length());
            int colonPos = line.indexOf(58);
            if (colonPos < 0) continue;
            String keyWord = line.substring(0, colonPos);
            String restOfLine = line.substring(colonPos + 1).trim();
            if (keyWord.equals("Plotname")) {
                if (!restOfLine.equals("AC Analysis")) continue;
                aType = AnalogAnalysis.ANALYSIS_AC;
                continue;
            }
            if (keyWord.equals("Flags")) {
                int r;
                int complex = restOfLine.indexOf("complex");
                if (complex >= 0) {
                    this.complexValues = true;
                }
                if ((r = restOfLine.indexOf("real")) < 0) continue;
                realValues = true;
                continue;
            }
            if (keyWord.equals("No. Variables")) {
                signalCount = TextUtils.atoi(restOfLine) - 1;
                continue;
            }
            if (keyWord.equals("No. Points")) {
                rowCount = TextUtils.atoi(restOfLine);
                continue;
            }
            if (keyWord.equals("Variables")) {
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return;
                }
                signalNames = new String[signalCount];
                for (int i = 0; i <= signalCount && (restOfLine = this.getLineFromBinary()) != null; ++i) {
                    int nameEnd;
                    int nameStart;
                    this.updateProgressDialog(restOfLine.length());
                    restOfLine = restOfLine.trim();
                    int indexOnLine = TextUtils.atoi(restOfLine);
                    if (indexOnLine != i) {
                        System.out.println("Warning: Variable " + i + " has number " + indexOnLine);
                    }
                    for (nameStart = 0; nameStart < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameStart)); ++nameStart) {
                    }
                    while (nameStart < restOfLine.length() && Character.isWhitespace(restOfLine.charAt(nameStart))) {
                        ++nameStart;
                    }
                    for (nameEnd = nameStart; nameEnd < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameEnd)); ++nameEnd) {
                    }
                    String name = restOfLine.substring(nameStart, nameEnd);
                    if (name.startsWith("V(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    }
                    if (i <= 0) continue;
                    signalNames[i - 1] = name;
                }
                continue;
            }
            if (!keyWord.equals("Binary")) continue;
            if (signalCount < 0) {
                System.out.println("Missing variable count in file");
                return;
            }
            if (rowCount < 0) {
                System.out.println("Missing point count in file");
                return;
            }
            SweepAnalysisLT an = new SweepAnalysisLT(sd, aType);
            sd.setCell(cell);
            double[][] values = new double[signalCount][rowCount];
            double[] timeValues = new double[rowCount];
            for (int j = 0; j < rowCount; ++j) {
                double time = this.getNextDouble();
                timeValues[j] = Math.abs(time);
                for (int i = 0; i < signalCount; ++i) {
                    double value = 0.0;
                    value = realValues ? (double)this.getNextFloat() : this.getNextDouble();
                    values[i][j] = value;
                }
            }
            ArrayList<Integer> sweepLengths = new ArrayList<Integer>();
            int sweepStart = 0;
            int sweepCount = 0;
            for (int j = 1; j <= rowCount; ++j) {
                if (j != rowCount && !(timeValues[j] < timeValues[j - 1])) continue;
                int sl = j - sweepStart;
                sweepLengths.add(new Integer(sl));
                sweepStart = j;
                an.addSweep(Integer.toString(++sweepCount));
            }
            an.commonTime = new double[sweepCount][];
            int offset = 0;
            for (int s = 0; s < sweepCount; ++s) {
                int sweepLength = (Integer)sweepLengths.get(s);
                an.commonTime[s] = new double[sweepLength];
                for (int j = 0; j < sweepLength; ++j) {
                    an.commonTime[s][j] = timeValues[j + offset];
                }
                ArrayList<double[]> allTheData = new ArrayList<double[]>();
                for (int i = 0; i < signalCount; ++i) {
                    double[] oneSetOfData = new double[sweepLength];
                    for (int j = 0; j < sweepLength; ++j) {
                        oneSetOfData[j] = values[i][j + offset];
                    }
                    allTheData.add(oneSetOfData);
                }
                an.theSweeps.add(allTheData);
                offset += sweepLength;
            }
            for (int i = 0; i < signalCount; ++i) {
                String name = signalNames[i];
                int lastDotPos = name.lastIndexOf(46);
                String context = null;
                if (lastDotPos >= 0) {
                    context = name.substring(0, lastDotPos);
                    name = name.substring(lastDotPos + 1);
                }
                double minTime = 0.0;
                double maxTime = 0.0;
                double minValues = 0.0;
                double maxValues = 0.0;
                an.addSignal(signalNames[i], context, minTime, maxTime, minValues, maxValues);
            }
            return;
        }
    }

    private double getNextDouble() throws IOException {
        long lt = this.dataInputStream.readLong();
        lt = Long.reverseBytes(lt);
        double t = Double.longBitsToDouble(lt);
        int amtRead = 8;
        if (this.complexValues) {
            amtRead *= 2;
            this.dataInputStream.readLong();
        }
        this.updateProgressDialog(amtRead);
        return t;
    }

    private float getNextFloat() throws IOException {
        int lt = this.dataInputStream.readInt();
        lt = Integer.reverseBytes(lt);
        float t = Float.intBitsToFloat(lt);
        int amtRead = 4;
        if (this.complexValues) {
            amtRead *= 2;
            this.dataInputStream.readInt();
        }
        this.updateProgressDialog(amtRead);
        return t;
    }

    private static class SweepAnalysisLT
    extends AnalogAnalysis {
        double[][] commonTime;
        List<List<double[]>> theSweeps = new ArrayList<List<double[]>>();

        private SweepAnalysisLT(Stimuli sd, Analysis.AnalysisType type) {
            super(sd, type, false);
        }

        protected Waveform[] loadWaveforms(AnalogSignal signal) {
            int sigIndex = signal.getIndexInAnalysis();
            Waveform[] waveforms = new Waveform[this.commonTime.length];
            for (int sweep = 0; sweep < waveforms.length; ++sweep) {
                double[] times = this.commonTime[sweep];
                List<double[]> theSweep = this.theSweeps.get(sweep);
                WaveformImpl waveform = new WaveformImpl(times, theSweep.get(sigIndex));
                waveforms[sweep] = waveform;
            }
            return waveforms;
        }
    }
}

