/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.CodeExpression;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.output.Spice;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sue
extends Input {
    private SueExtraWire[] transistorWires = new SueExtraWire[]{new SueExtraWire("d", 3.0, 0.0), new SueExtraWire("s", -3.0, 0.0), new SueExtraWire("g", 0.0, 4.5)};
    private SueExtraWire[] transistor4Wires = new SueExtraWire[]{new SueExtraWire("d", 3.0, 0.0), new SueExtraWire("s", -3.0, 0.0), new SueExtraWire("b", -0.25, -2.5), new SueExtraWire("g", 0.0, 4.5)};
    private SueExtraWire[] resistorWires = new SueExtraWire[]{new SueExtraWire("a", -3.0, 0.0), new SueExtraWire("b", 3.0, 0.0)};
    private SueExtraWire[] capacitorWires = new SueExtraWire[]{new SueExtraWire("a", 0.0, 1.75), new SueExtraWire("b", 0.0, -1.75)};
    private SueExtraWire[] twoPortWires = new SueExtraWire[]{new SueExtraWire("a", -11.25, 3.625), new SueExtraWire("b", -11.25, -3.625), new SueExtraWire("x", 11.25, 3.625), new SueExtraWire("y", 11.25, -3.625)};
    private SueEquiv[] sueEquivs;
    private SueEquiv[] sueEquivs4;
    private String sueLastLine;
    private String lastLineRead;
    private List<String> sueDirectories;
    private SuePreferences localPrefs;
    private Technology curTech;

    Sue(SuePreferences ap) {
        this.sueEquivs = new SueEquiv[]{new SueEquiv("pmos10", Schematics.tech().transistorNode, false, 900, false, -2.0, 0.0, PrimitiveNode.Function.TRAPMOS, this.transistorWires), new SueEquiv("nmos10", Schematics.tech().transistorNode, false, 900, false, -2.0, 0.0, PrimitiveNode.Function.TRANMOS, this.transistorWires), new SueEquiv("pmos4", Schematics.tech().transistorNode, false, 900, false, -2.0, 0.0, PrimitiveNode.Function.TRAPMOS, this.transistorWires), new SueEquiv("nmos4", Schematics.tech().transistorNode, false, 900, false, -2.0, 0.0, PrimitiveNode.Function.TRANMOS, this.transistorWires), new SueEquiv("pmos", Schematics.tech().transistorNode, false, 900, false, -2.0, 0.0, PrimitiveNode.Function.TRAPMOS, this.transistorWires), new SueEquiv("nmos", Schematics.tech().transistorNode, false, 900, false, -2.0, 0.0, PrimitiveNode.Function.TRANMOS, this.transistorWires), new SueEquiv("capacitor", Schematics.tech().capacitorNode, false, 0, false, 0.0, 0.0, null, this.capacitorWires), new SueEquiv("resistor", Schematics.tech().resistorNode, false, 900, false, 0.0, 0.0, null, this.resistorWires), new SueEquiv("inductor", Schematics.tech().inductorNode, false, 0, false, 0.0, 0.0, null, null), new SueEquiv("cccs", Schematics.tech().twoportNode, false, 0, false, 1.25, -6.875, PrimitiveNode.Function.CCCS, this.twoPortWires), new SueEquiv("ccvs", Schematics.tech().twoportNode, false, 0, false, 1.25, -6.875, PrimitiveNode.Function.CCVS, this.twoPortWires), new SueEquiv("vcvs", Schematics.tech().twoportNode, false, 0, false, 1.25, -6.875, PrimitiveNode.Function.VCVS, this.twoPortWires), new SueEquiv("vccs", Schematics.tech().twoportNode, false, 0, false, -1.875, -5.0, PrimitiveNode.Function.VCCS, null)};
        this.sueEquivs4 = new SueEquiv[]{new SueEquiv("pmos10", Schematics.tech().transistor4Node, false, 0, true, -2.0, 0.0, PrimitiveNode.Function.TRAPMOS, this.transistor4Wires), new SueEquiv("nmos10", Schematics.tech().transistor4Node, false, 900, false, -2.0, 0.0, PrimitiveNode.Function.TRANMOS, this.transistor4Wires), new SueEquiv("pmos4", Schematics.tech().transistor4Node, false, 0, true, -2.0, 0.0, PrimitiveNode.Function.TRAPMOS, this.transistor4Wires), new SueEquiv("nmos4", Schematics.tech().transistor4Node, false, 900, false, -2.0, 0.0, PrimitiveNode.Function.TRANMOS, this.transistor4Wires), new SueEquiv("pmos", Schematics.tech().transistor4Node, false, 0, true, -2.0, 0.0, PrimitiveNode.Function.TRAPMOS, this.transistor4Wires), new SueEquiv("nmos", Schematics.tech().transistor4Node, false, 900, false, -2.0, 0.0, PrimitiveNode.Function.TRANMOS, this.transistor4Wires), new SueEquiv("capacitor", Schematics.tech().capacitorNode, false, 0, false, 0.0, 0.0, null, this.capacitorWires), new SueEquiv("resistor", Schematics.tech().resistorNode, false, 900, false, 0.0, 0.0, null, this.resistorWires), new SueEquiv("inductor", Schematics.tech().inductorNode, false, 0, false, 0.0, 0.0, null, null), new SueEquiv("cccs", Schematics.tech().twoportNode, false, 0, false, 1.25, -6.875, PrimitiveNode.Function.CCCS, this.twoPortWires), new SueEquiv("ccvs", Schematics.tech().twoportNode, false, 0, false, 1.25, -6.875, PrimitiveNode.Function.CCVS, this.twoPortWires), new SueEquiv("vcvs", Schematics.tech().twoportNode, false, 0, false, 1.25, -6.875, PrimitiveNode.Function.VCVS, this.twoPortWires), new SueEquiv("vccs", Schematics.tech().twoportNode, false, 0, false, -1.875, -5.0, PrimitiveNode.Function.VCCS, null)};
        this.localPrefs = ap;
    }

    @Override
    protected Library importALibrary(Library lib, Technology tech, Map<Library, Cell> currentCells) {
        String cellName = lib.getName();
        this.curTech = tech;
        this.sueDirectories = new ArrayList<String>();
        String topDirName = TextUtils.getFilePath(lib.getLibFile());
        this.sueDirectories.add(topDirName);
        File topDir = new File(topDirName);
        String[] fileList = topDir.list();
        for (int i = 0; i < fileList.length; ++i) {
            File subDir;
            if (!fileList[i].startsWith("suelib_")) continue;
            String dirName = topDirName + fileList[i];
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            if (!(subDir = new File(dirName)).isDirectory()) continue;
            this.sueDirectories.add(dirName);
        }
        int lastSep = topDirName.lastIndexOf(47);
        if (lastSep >= 0 && topDirName.substring(lastSep + 1).startsWith("suelib_")) {
            String upDirName = topDirName.substring(0, lastSep);
            File upperDir = new File(upDirName);
            String[] upFileList = upperDir.list();
            for (int i = 0; i < upFileList.length; ++i) {
                String dirName;
                File subDir;
                if (!upFileList[i].startsWith("suelib_") || !(subDir = new File(dirName = upDirName + upFileList[i])).isDirectory()) continue;
                this.sueDirectories.add(dirName);
            }
        }
        try {
            Cell topCell = this.readFile(lib, cellName, this.lineReader);
            if (topCell == null) {
                return null;
            }
            currentCells.put(lib, topCell);
        }
        catch (IOException e) {
            System.out.println("ERROR reading Sue libraries");
        }
        return lib;
    }

    private Cell readFile(Library lib, String cellName, LineNumberReader lr) throws IOException {
        double hei;
        ERectangle bounds;
        double wid;
        NodeInst ni;
        List<String> keywords;
        boolean placeIcon = false;
        ArrayList<SueWire> sueWires = new ArrayList<SueWire>();
        ArrayList<SueNet> sueNets = new ArrayList<SueNet>();
        Cell cell = null;
        Cell schemCell = null;
        Cell iconCell = null;
        this.lastLineRead = null;
        Point2D iconPt = null;
        ArrayList<String> argumentKey = new ArrayList<String>();
        ArrayList<String> argumentValue = new ArrayList<String>();
        HashSet<NodeInst> invertNodeOutput = new HashSet<NodeInst>();
        HashMap<String, ArrayList<NodeInst>> duplicateNames = new HashMap<String, ArrayList<NodeInst>>();
        block0: while ((keywords = this.getNextLine(lr)) != null) {
            int count = keywords.size();
            if (count == 0) continue;
            String keyword0 = keywords.get(0);
            if (keyword0.equalsIgnoreCase("proc")) {
                if (cell != null) {
                    this.placeWires(sueWires, sueNets, cell, invertNodeOutput);
                    this.placeNets(sueNets, cell);
                    sueWires = new ArrayList();
                    sueNets = new ArrayList();
                }
                if (count < 2) {
                    System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ": 'proc' is missing arguments: " + this.lastLineRead);
                    continue;
                }
                String keyword1 = keywords.get(1);
                if (keyword1.startsWith("SCHEMATIC_")) {
                    String subCellName = keyword1.substring(10);
                    if (subCellName.equalsIgnoreCase("[get_file_name]")) {
                        subCellName = cellName;
                    }
                    subCellName = subCellName + "{sch}";
                    schemCell = cell = Cell.makeInstance(lib, subCellName);
                    placeIcon = false;
                    continue;
                }
                if (keyword1.startsWith("ICON_")) {
                    String subCellName = keyword1.substring(5);
                    if (subCellName.equalsIgnoreCase("[get_file_name]")) {
                        subCellName = cellName;
                    }
                    subCellName = subCellName + "{ic}";
                    iconCell = cell = Cell.makeInstance(lib, subCellName);
                    continue;
                }
                System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ": unknown 'proc' statement: " + this.lastLineRead);
                continue;
            }
            if (keyword0.equalsIgnoreCase("make")) {
                Point2D.Double offPt;
                AffineTransform trans;
                if (count < 2) {
                    System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ": 'make' is missing arguments: " + this.lastLineRead);
                    continue;
                }
                ParseParameters parP = new ParseParameters(keywords, 2);
                String keyword1 = keywords.get(1);
                if (keyword1.equalsIgnoreCase(cellName)) {
                    if (parP.pt == null) continue;
                    iconPt = parP.pt;
                    placeIcon = true;
                    continue;
                }
                if (keyword1.equalsIgnoreCase("name_net_m") || keyword1.equalsIgnoreCase("name_net_s") || keyword1.equalsIgnoreCase("name_net")) {
                    if (parP.theName == null) continue;
                    SueNet sn = new SueNet();
                    sn.pt = parP.pt;
                    sn.label = parP.theName;
                    sueNets.add(sn);
                    continue;
                }
                NodeProto proto = null;
                double xOff = 0.0;
                double yOff = 0.0;
                PortCharacteristic type = PortCharacteristic.UNKNOWN;
                double xShrink = 0.0;
                double yShrink = 0.0;
                boolean invertOutput = false;
                int rotation = 0;
                boolean transpose = false;
                PrimitiveNode.Function detailFunct = null;
                SueExtraWire[] extraWires = null;
                if (keyword1.equalsIgnoreCase("inout")) {
                    proto = Schematics.tech().offpageNode;
                    AffineTransform trans2 = Orientation.fromC(parP.rot, parP.trn).pureRotate();
                    Point2D.Double offPt2 = new Point2D.Double(2.0, 0.0);
                    trans2.transform(offPt2, offPt2);
                    xOff = ((Point2D)offPt2).getX();
                    yOff = ((Point2D)offPt2).getY();
                    type = PortCharacteristic.BIDIR;
                } else if (keyword1.equalsIgnoreCase("input")) {
                    proto = Schematics.tech().offpageNode;
                    AffineTransform trans3 = Orientation.fromC(parP.rot, parP.trn).pureRotate();
                    Point2D.Double offPt3 = new Point2D.Double(-2.0, 0.0);
                    trans3.transform(offPt3, offPt3);
                    xOff = ((Point2D)offPt3).getX();
                    yOff = ((Point2D)offPt3).getY();
                    type = PortCharacteristic.IN;
                } else if (keyword1.equalsIgnoreCase("output")) {
                    proto = Schematics.tech().offpageNode;
                    AffineTransform trans4 = Orientation.fromC(parP.rot, parP.trn).pureRotate();
                    Point2D.Double offPt4 = new Point2D.Double(2.0, 0.0);
                    trans4.transform(offPt4, offPt4);
                    xOff = ((Point2D)offPt4).getX();
                    yOff = ((Point2D)offPt4).getY();
                    type = PortCharacteristic.OUT;
                } else if (keyword1.equalsIgnoreCase("rename_net")) {
                    proto = Schematics.tech().wirePinNode;
                } else if (keyword1.equalsIgnoreCase("global")) {
                    Name busName = Name.findName(parP.theName);
                    int busWidth = busName.busWidth();
                    if (busWidth > 1) {
                        proto = Schematics.tech().busPinNode;
                    } else {
                        proto = Schematics.tech().wirePinNode;
                        if (parP.theName.equalsIgnoreCase("gnd")) {
                            trans = Orientation.fromC(parP.rot, parP.trn).pureRotate();
                            offPt = new Point2D.Double(0.0, -2.0);
                            trans.transform(offPt, offPt);
                            xOff = ((Point2D)offPt).getX();
                            yOff = ((Point2D)offPt).getY();
                            proto = Schematics.tech().groundNode;
                            type = PortCharacteristic.GND;
                        }
                        if (parP.theName.equalsIgnoreCase("vdd")) {
                            proto = Schematics.tech().powerNode;
                            type = PortCharacteristic.PWR;
                        }
                    }
                } else if (keyword1.equalsIgnoreCase("join_net")) {
                    proto = Schematics.tech().wireConNode;
                    xShrink = -2.0;
                    AffineTransform trans5 = Orientation.fromC(parP.rot, parP.trn).pureRotate();
                    Point2D.Double offPt5 = new Point2D.Double(1.25, 0.0);
                    trans5.transform(offPt5, offPt5);
                    xOff = ((Point2D)offPt5).getX();
                    yOff = ((Point2D)offPt5).getY();
                }
                if (proto == null) {
                    int i;
                    SueEquiv[] curEquivs = this.sueEquivs;
                    if (this.localPrefs.use4PortTransistors) {
                        curEquivs = this.sueEquivs4;
                    }
                    for (i = 0; i < curEquivs.length && !keyword1.equalsIgnoreCase(curEquivs[i].sueName); ++i) {
                    }
                    if (i < curEquivs.length) {
                        proto = curEquivs[i].intProto;
                        invertOutput = curEquivs[i].netateOutput;
                        rotation = curEquivs[i].rotation;
                        transpose = curEquivs[i].transpose;
                        trans = Orientation.fromC(parP.rot, parP.trn).pureRotate();
                        offPt = new Point2D.Double(curEquivs[i].xOffset, curEquivs[i].yOffset);
                        trans.transform(offPt, offPt);
                        xOff = ((Point2D)offPt).getX();
                        yOff = ((Point2D)offPt).getY();
                        if (transpose) {
                            parP.trn = !parP.trn;
                            parP.rot = rotation - parP.rot;
                            if (parP.rot < 0) {
                                parP.rot += 3600;
                            }
                        } else {
                            parP.rot += rotation;
                            if (parP.rot >= 3600) {
                                parP.rot -= 3600;
                            }
                        }
                        detailFunct = curEquivs[i].detailFunct;
                        extraWires = curEquivs[i].extraWires;
                    }
                }
                if (proto == null) {
                    Cell np;
                    proto = this.getNodeProto(lib, keyword1);
                    if (proto == null) {
                        proto = this.readFromDisk(lib, keyword1);
                    }
                    if (proto != null && (np = ((Cell)proto).iconView()) != null) {
                        proto = np;
                    }
                }
                if (keyword1.startsWith("title_")) continue;
                if (proto == null) {
                    System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ", cannot create instance of " + keyword1 + " (no Sue object with that name)");
                    continue;
                }
                double wid2 = proto.getDefWidth();
                double hei2 = proto.getDefHeight();
                if (proto instanceof Cell) {
                    ERectangle bounds2 = ((Cell)proto).getBounds();
                    wid2 = ((RectangularShape)bounds2).getWidth();
                    hei2 = ((RectangularShape)bounds2).getHeight();
                }
                Orientation or = Orientation.fromC(parP.rot, parP.trn);
                parP.rot = or.getAngle();
                NodeInst ni2 = NodeInst.makeInstance(proto, (Point2D)new Point2D.Double(parP.pt.getX() + xOff, parP.pt.getY() + yOff), wid2 -= xShrink, hei2 -= yShrink, cell, or, null, detailFunct);
                if (ni2 == null) continue;
                if (invertOutput) {
                    invertNodeOutput.add(ni2);
                }
                if (proto instanceof Cell && ((Cell)proto).isIcon()) {
                    ni2.setExpanded();
                }
                if (extraWires != null) {
                    for (int i = 0; i < extraWires.length; ++i) {
                        ArcInst ai;
                        PortProto pp = proto.findPortProto(((SueExtraWire)extraWires[i]).portName);
                        if (pp == null) continue;
                        PortInst pi = ni2.findPortInstFromProto(pp);
                        Poly portPoly = pi.getPoly();
                        double x = portPoly.getCenterX();
                        double y = portPoly.getCenterY();
                        AffineTransform trans6 = ni2.getOrient().pureRotate();
                        Point2D.Double dPt = new Point2D.Double(extraWires[i].xOffset, extraWires[i].yOffset);
                        trans6.transform(dPt, dPt);
                        PrimitiveNode wirePin = Schematics.tech().wirePinNode;
                        double pinx = x + ((Point2D)dPt).getX();
                        double piny = y + ((Point2D)dPt).getY();
                        PortInst ppi = this.findPinNode(pinx, piny, cell);
                        if (ppi == null) {
                            NodeInst nni = NodeInst.makeInstance(Schematics.tech().wirePinNode, new Point2D.Double(pinx, piny), wirePin.getDefWidth(), wirePin.getDefHeight(), cell);
                            if (nni == null) continue;
                            ppi = nni.getOnlyPortInst();
                        }
                        if ((ai = ArcInst.makeInstanceBase(Schematics.tech().wire_arc, 0.0, pi, ppi)) == null) {
                            System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ", error adding extra wires to node " + keyword1);
                            break;
                        }
                        if (x == pinx || y == piny) continue;
                        ai.setFixedAngle(false);
                    }
                }
                if (parP.theName != null) {
                    if (proto == Schematics.tech().offpageNode && parP.theName != null) {
                        Export ppt;
                        Iterator<PortInst> it = ni2.getPortInsts();
                        PortInst pi = it.next();
                        if (keyword1.equalsIgnoreCase("output")) {
                            pi = it.next();
                        }
                        if ((ppt = this.newExport(cell, pi, parP.theName, type)) == null) {
                            System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ", could not create export " + parP.theName);
                        }
                    } else {
                        NodeInst oNi = cell.findNode(parP.theName);
                        if (oNi == null) {
                            ni2.setName(parP.theName);
                        } else {
                            ArrayList<NodeInst> dups = (ArrayList<NodeInst>)duplicateNames.get(parP.theName);
                            if (dups == null) {
                                dups = new ArrayList<NodeInst>();
                                dups.add(ni2);
                                duplicateNames.put(parP.theName, dups);
                            }
                            dups.add(oNi);
                        }
                    }
                }
                int varCount = 0;
                for (int i = 2; i < count; i += 2) {
                    String keyword = keywords.get(i);
                    if (!keyword.startsWith("-") || keyword.equalsIgnoreCase("-origin") || keyword.equalsIgnoreCase("-orient") || keyword.equalsIgnoreCase("-type") || keyword.equalsIgnoreCase("-name")) continue;
                    ++varCount;
                }
                int varIndex = 1;
                double varOffset = ni2.getYSize() / (double)(varCount + 1);
                for (int i = 2; i < count; i += 2) {
                    Variable contentsVar;
                    String keyword = keywords.get(i);
                    if (!keyword.startsWith("-") || keyword.equalsIgnoreCase("-origin") || keyword.equalsIgnoreCase("-orient") || keyword.equalsIgnoreCase("-type") || keyword.equalsIgnoreCase("-name")) continue;
                    boolean halveSize = false;
                    boolean isParam = false;
                    double xpos = 0.0;
                    double ypos = 0.0;
                    String sueVarName = null;
                    if (keyword.charAt(1) == 'w') {
                        sueVarName = "ATTR_width";
                        xpos = 2.0;
                        ypos = -4.0;
                    } else if (keyword.charAt(1) == 'l') {
                        sueVarName = "ATTR_length";
                        xpos = -2.0;
                        ypos = -4.0;
                        halveSize = true;
                    } else if (keyword.substring(1).equals("capacitance") && proto == Schematics.tech().capacitorNode) {
                        sueVarName = Schematics.SCHEM_CAPACITANCE.getName();
                    } else if (keyword.substring(1).equals("resistance") && proto == Schematics.tech().resistorNode) {
                        sueVarName = Schematics.SCHEM_RESISTANCE.getName();
                    } else {
                        sueVarName = "ATTR_" + keyword.substring(1);
                        if (sueVarName.indexOf(32) >= 0) {
                            System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ", bad variable name: " + sueVarName);
                            continue block0;
                        }
                        xpos = 0.0;
                        ypos = ni2.getYSize() / 2.0 - (double)varIndex * varOffset;
                        isParam = true;
                    }
                    Object newObject = null;
                    String pt = keywords.get(i + 1);
                    if (keyword.charAt(1) == 'W' && keyword.length() > 2) {
                        newObject = keyword.substring(2) + ":" + this.parseExpression(pt);
                    } else {
                        int len = pt.length() - 1;
                        if (Character.toLowerCase(pt.charAt(len)) == 'u') {
                            if (TextUtils.isANumber(pt = pt.substring(0, len - 1))) {
                                newObject = new Double(TextUtils.convertFromDistance(TextUtils.atof(pt), this.curTech, TextUtils.UnitScale.MICRO));
                            }
                            pt = pt + "u";
                        }
                        if (newObject == null && TextUtils.isANumber(pt)) {
                            newObject = new Integer(TextUtils.atoi(pt));
                            if (pt.indexOf(46) >= 0 || pt.toLowerCase().indexOf(101) >= 0) {
                                newObject = new Double(TextUtils.atof(pt));
                            }
                        }
                        if (newObject == null) {
                            newObject = this.parseExpression(pt);
                        }
                    }
                    boolean makeJava = false;
                    if (newObject instanceof String) {
                        makeJava = EvalJavaBsh.evalJavaBsh.isValidJava((String)newObject);
                    }
                    Variable.Key varKey = Variable.newKey(sueVarName);
                    MutableTextDescriptor mtd = MutableTextDescriptor.getNodeTextDescriptor();
                    ++varIndex;
                    mtd.setOff(xpos, ypos);
                    if (halveSize) {
                        if (mtd.getSize().isAbsolute()) {
                            mtd.setAbsSize((int)(mtd.getSize().getSize() / 2.0));
                        } else {
                            mtd.setRelSize(mtd.getSize().getSize() / 2.0);
                        }
                    }
                    if (isParam) {
                        mtd.setParam(true);
                        mtd.setDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                    }
                    Object instObject = newObject;
                    if (makeJava) {
                        instObject = Variable.withCode(newObject, CodeExpression.Code.JAVA);
                    }
                    ni2.newVar(varKey, instObject, TextDescriptor.newTextDescriptor(mtd));
                    NodeProto np = ni2.getProto();
                    if (!isParam || !ni2.isCellInstance()) continue;
                    Cell cnp = ((Cell)np).contentsView();
                    if (cnp == null) {
                        cnp = (Cell)np;
                    }
                    if ((contentsVar = cnp.getParameterOrVariable(varKey)) != null) continue;
                    TextDescriptor td = TextDescriptor.getCellTextDescriptor().withParam(true).withDispPart(AbstractTextDescriptor.DispPos.NAMEVALUE);
                    newObject = Variable.withCode(newObject, CodeExpression.Code.SPICE);
                    cnp.getCellGroup().addParam(Variable.newInstance(varKey, newObject, td));
                }
                continue;
            }
            if (keyword0.equalsIgnoreCase("make_wire")) {
                SueWire sw = new SueWire();
                double fx = Sue.convertXCoord(TextUtils.atof(keywords.get(1)));
                double fy = Sue.convertYCoord(TextUtils.atof(keywords.get(2)));
                ((SueWire)sw).pt[0] = new Point2D.Double(fx, fy);
                double tx = Sue.convertXCoord(TextUtils.atof(keywords.get(3)));
                double ty = Sue.convertYCoord(TextUtils.atof(keywords.get(4)));
                ((SueWire)sw).pt[1] = new Point2D.Double(tx, ty);
                sueWires.add(sw);
                continue;
            }
            if (keyword0.equalsIgnoreCase("icon_term")) {
                PortInst pi;
                Export ppt;
                double pY;
                ParseParameters parP = new ParseParameters(keywords, 1);
                PrimitiveNode proto = Schematics.tech().busPinNode;
                double pX = proto.getDefWidth();
                NodeInst ni3 = NodeInst.makeInstance(proto, parP.pt, pX, pY = proto.getDefHeight(), cell);
                if (ni3 == null || (ppt = Export.newInstance(cell, pi = ni3.getOnlyPortInst(), parP.theName, parP.type)) != null) continue;
                System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ", could not create port " + parP.theName);
                continue;
            }
            if (keyword0.equalsIgnoreCase("icon_arc")) {
                double sY;
                double sX;
                Point2D.Double ctr;
                NodeInst ni4;
                if (count != 9) {
                    System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ": needs 9 arguments, has " + count + ": " + this.lastLineRead);
                    continue;
                }
                int start = 0;
                int extent = 359;
                double p1X = Sue.convertXCoord(TextUtils.atof(keywords.get(1)));
                double p1Y = Sue.convertYCoord(TextUtils.atof(keywords.get(2)));
                double p2X = Sue.convertXCoord(TextUtils.atof(keywords.get(3)));
                double p2Y = Sue.convertYCoord(TextUtils.atof(keywords.get(4)));
                if (keywords.get(5).equals("-start")) {
                    start = TextUtils.atoi(keywords.get(6));
                }
                if (keywords.get(7).equals("-extent")) {
                    extent = TextUtils.atoi(keywords.get(8));
                }
                if ((ni4 = NodeInst.makeInstance(Artwork.tech().circleNode, ctr = new Point2D.Double((p1X + p2X) / 2.0, (p1Y + p2Y) / 2.0), sX = Math.abs(p1X - p2X), sY = Math.abs(p1Y - p2Y), cell)) == null || extent == 359) continue;
                if (extent < 0) {
                    start += extent;
                    extent = -extent;
                }
                double rExtent = extent + 1;
                rExtent = rExtent * Math.PI / 180.0;
                double rstart = (double)start * Math.PI / 180.0;
                ni4.setArcDegrees(rstart, rExtent);
                continue;
            }
            if (keyword0.equalsIgnoreCase("icon_line")) {
                double lY;
                double lX;
                ArrayList<Point2D.Double> pointList = new ArrayList<Point2D.Double>();
                double x = 0.0;
                for (int i = 1; i < keywords.size() && !keywords.get(i).equals("-tags"); ++i) {
                    if (i % 2 != 0) {
                        x = Sue.convertXCoord(TextUtils.atof(keywords.get(i)));
                        continue;
                    }
                    double y = Sue.convertYCoord(TextUtils.atof(keywords.get(i)));
                    pointList.add(new Point2D.Double(x, y));
                }
                int keyCount = pointList.size();
                if (keyCount == 0) continue;
                Point2D firstPt = (Point2D)pointList.get(0);
                double hX = lX = firstPt.getX();
                double hY = lY = firstPt.getY();
                for (int i = 1; i < keyCount; ++i) {
                    Point2D nextPt = (Point2D)pointList.get(i);
                    if (nextPt.getX() < lX) {
                        lX = nextPt.getX();
                    }
                    if (nextPt.getX() > hX) {
                        hX = nextPt.getX();
                    }
                    if (nextPt.getY() < lY) {
                        lY = nextPt.getY();
                    }
                    if (!(nextPt.getY() > hY)) continue;
                    hY = nextPt.getY();
                }
                double cX = (lX + hX) / 2.0;
                double cY = (lY + hY) / 2.0;
                Point2D.Double ctr = new Point2D.Double(cX, cY);
                NodeInst ni5 = NodeInst.makeInstance(Artwork.tech().openedPolygonNode, ctr, hX - lX, hY - lY, cell);
                if (ni5 == null) {
                    return null;
                }
                Point2D[] points = new EPoint[keyCount];
                for (int i = 0; i < keyCount; ++i) {
                    Point2D pt = (Point2D)pointList.get(i);
                    points[i] = new EPoint(pt.getX(), pt.getY());
                }
                ni5.setTrace(points);
                continue;
            }
            if (keyword0.equalsIgnoreCase("icon_setup")) {
                String keyword1 = keywords.get(1);
                if (!keyword1.equalsIgnoreCase("$args")) {
                    System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ": has unrecognized 'icon_setup'");
                    continue;
                }
                int ptPos = 0;
                String pt = keywords.get(2);
                int ptLen = pt.length();
                if (ptPos < ptLen && pt.charAt(ptPos) == '{') {
                    ++ptPos;
                }
                while (true) {
                    String arg;
                    int argLen;
                    int argPos;
                    if (ptPos < ptLen && pt.charAt(ptPos) == ' ') {
                        ++ptPos;
                        continue;
                    }
                    if (ptPos >= ptLen || pt.charAt(ptPos) == '}') continue block0;
                    int argStart = ptPos;
                    int curly = 0;
                    while (ptPos < ptLen) {
                        char chr = pt.charAt(ptPos);
                        if (curly == 0 && (chr == ' ' || chr == '}')) break;
                        if (chr == '{') {
                            ++curly;
                        }
                        if (chr == '}') {
                            --curly;
                        }
                        ++ptPos;
                    }
                    if ((argPos = 0) < (argLen = (arg = pt.substring(argStart, ptPos++)).length()) && arg.charAt(argPos) == '{') {
                        ++argPos;
                        if (arg.endsWith("}")) {
                            arg = arg.substring(0, --argLen);
                        }
                    }
                    int keyStart = argPos;
                    while (argPos < argLen && arg.charAt(argPos) != ' ') {
                        ++argPos;
                    }
                    String key = arg.substring(keyStart, argPos);
                    while (argPos < argLen && arg.charAt(argPos) == ' ') {
                        ++argPos;
                    }
                    String value = arg.substring(argPos);
                    if (value.startsWith("{") && (value = value.substring(1)).endsWith("}")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    argumentKey.add(key);
                    argumentValue.add(value);
                }
            }
            if (keyword0.equalsIgnoreCase("icon_property")) {
                ParseParameters parP = new ParseParameters(keywords, 1);
                if (parP.theLabel == null) continue;
                StringBuffer infstr = new StringBuffer();
                for (int i = 0; i < parP.theLabel.length(); ++i) {
                    char chr = parP.theLabel.charAt(i);
                    if (chr == '$') {
                        String key;
                        int j;
                        String partial = parP.theLabel.substring(i + 1);
                        for (j = 0; j < argumentKey.size() && !partial.startsWith(key = (String)argumentKey.get(j)); ++j) {
                        }
                        if (j < argumentKey.size()) {
                            infstr.append((String)argumentValue.get(j));
                            i += ((String)argumentKey.get(j)).length();
                            continue;
                        }
                    }
                    infstr.append(chr);
                }
                parP.theLabel = infstr.toString();
                NodeInst ni6 = NodeInst.makeInstance(Generic.tech().invisiblePinNode, parP.pt, 0.0, 0.0, cell);
                if (ni6 == null) continue;
                ni6.newDisplayVar(Artwork.ART_MESSAGE, parP.theLabel);
                continue;
            }
            if (keyword0.equalsIgnoreCase("make_text")) {
                NodeInst ni7;
                ParseParameters parP = new ParseParameters(keywords, 1);
                if (parP.theText == null || (ni7 = NodeInst.makeInstance(Generic.tech().invisiblePinNode, parP.pt, 0.0, 0.0, cell)) == null) continue;
                if (parP.theText.startsWith("^")) {
                    ni7.newVar(Spice.SPICE_CARD_KEY, (Object)parP.theText.substring(1), TextDescriptor.getAnnotationTextDescriptor().withColorIndex(14));
                    continue;
                }
                ni7.newDisplayVar(Artwork.ART_MESSAGE, parP.theText);
                continue;
            }
            if (keyword0.equalsIgnoreCase("icon_title") || keyword0.equalsIgnoreCase("make_line") || keyword0.equalsIgnoreCase("}")) continue;
            System.out.println("Cell " + cellName + ", line " + lr.getLineNumber() + ": unknown keyword (" + keyword0 + "): " + this.lastLineRead);
        }
        if (placeIcon && schemCell != null && iconCell != null && (ni = NodeInst.makeInstance(iconCell, iconPt, wid = ((RectangularShape)(bounds = iconCell.getBounds())).getWidth(), hei = ((RectangularShape)bounds).getHeight(), schemCell)) != null) {
            ni.setExpanded();
        }
        for (String name : duplicateNames.keySet()) {
            List dups = (List)duplicateNames.get(name);
            System.out.print("Cell " + cell.getName() + " has multiple nodes with the same Sue name (" + name + "):");
            for (NodeInst ni8 : dups) {
                System.out.print(" " + ni8.describe(false));
            }
            System.out.println();
        }
        if (cell != null) {
            this.placeWires(sueWires, sueNets, cell, invertNodeOutput);
            this.placeNets(sueNets, cell);
        }
        if (schemCell != null) {
            return schemCell;
        }
        return iconCell;
    }

    private Export newExport(Cell cell, PortInst pi, String theName, PortCharacteristic pc) {
        String portName = theName;
        int i = 0;
        Export ppt;
        while ((ppt = (Export)cell.findPortProto(portName)) != null) {
            int openPos = theName.indexOf(91);
            portName = openPos < 0 ? theName + "-" + i : theName.substring(0, openPos) + "-" + i + theName.substring(openPos);
            ++i;
        }
        return Export.newInstance(cell, pi, portName, pc);
    }

    private PortInst findPinNode(double x, double y, Cell cell) {
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(x, y, 0.0, 0.0);
        Iterator<RTBounds> sea = cell.searchIterator(searchBounds);
        while (sea.hasNext()) {
            RTBounds geom = sea.next();
            if (!(geom instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)geom;
            Iterator<PortInst> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = it.next();
                Poly poly = pi.getPoly();
                if (poly.getCenterX() != x || poly.getCenterY() != y) continue;
                return pi;
            }
        }
        return null;
    }

    private NodeProto readFromDisk(Library lib, String name) {
        for (String directory : this.sueDirectories) {
            String subFileName = directory + name + ".sue";
            LineNumberReader lr = null;
            try {
                FileInputStream fis = new FileInputStream(subFileName);
                InputStreamReader is = new InputStreamReader(fis);
                lr = new LineNumberReader(is);
            }
            catch (FileNotFoundException e) {
                continue;
            }
            if (lr == null) continue;
            try {
                String saveLastLine = this.sueLastLine;
                this.sueLastLine = null;
                this.readFile(lib, name, lr);
                this.sueLastLine = saveLastLine;
                Cell cell = lib.findNodeProto(name);
                if (cell == null) continue;
                return cell;
            }
            catch (IOException e) {
                System.out.println("ERROR reading Sue libraries");
            }
        }
        return null;
    }

    private NodeProto getNodeProto(Library lib, String protoname) {
        Iterator<Cell> it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            if (!cell.getName().equalsIgnoreCase(protoname)) continue;
            Cell icon = cell.iconView();
            if (icon != null) {
                return icon;
            }
            return cell;
        }
        return null;
    }

    private void placeWires(List<SueWire> sueWires, List<SueNet> sueNets, Cell cell, Set invertNodeOutput) {
        for (SueWire sw : sueWires) {
            ((SueWire)sw).pi[1] = null;
            ((SueWire)sw).pi[0] = null;
            sw.proto = null;
        }
        for (SueNet sn : sueNets) {
            for (SueWire sw : sueWires) {
                for (int i = 0; i < 2; ++i) {
                    if (sw.pt[i].getX() != sn.pt.getX() || sw.pt[i].getY() != sn.pt.getY()) continue;
                    Name snName = Name.findName(sn.label);
                    if (snName != null && snName.busWidth() > 1) {
                        sw.proto = Schematics.tech().bus_arc;
                        continue;
                    }
                    sw.proto = Schematics.tech().wire_arc;
                }
            }
        }
        for (SueWire sw : sueWires) {
            for (int i = 0; i < 2; ++i) {
                if (sw.pi[i] != null) continue;
                Iterator<NodeInst> it = cell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    PortInst pi = this.wiredPort(ni, sw.pt[i], sw.pt[1 - i]);
                    if (pi == null) continue;
                    ((SueWire)sw).pi[i] = pi;
                    boolean isBus = false;
                    PortOriginal fp = new PortOriginal(pi);
                    PortInst bottomPort = fp.getBottomPort();
                    NodeInst bottomNi = bottomPort.getNodeInst();
                    if (bottomNi.getProto() == Schematics.tech().wireConNode) continue;
                    if (!isBus && ni.getProto() == Schematics.tech().offpageNode) {
                        Iterator<Export> eIt = ni.getExports();
                        while (eIt.hasNext()) {
                            Export e = eIt.next();
                            Name eName = Name.findName(e.getName());
                            if (eName.busWidth() <= 1) continue;
                            isBus = true;
                        }
                    }
                    if (isBus) {
                        sw.proto = Schematics.tech().bus_arc;
                        continue;
                    }
                    if (sw.proto != null) continue;
                    sw.proto = Schematics.tech().wire_arc;
                }
            }
        }
        boolean propagatedBus = true;
        while (propagatedBus) {
            propagatedBus = false;
            for (SueWire sw : sueWires) {
                if (sw.proto != Schematics.tech().bus_arc) continue;
                for (SueWire oSw : sueWires) {
                    if (oSw.proto != null) continue;
                    for (int i = 0; i < 2; ++i) {
                        for (int j = 0; j < 2; ++j) {
                            if (sw.pt[i].getX() != oSw.pt[j].getX() || sw.pt[i].getY() != oSw.pt[j].getY()) continue;
                            oSw.proto = Schematics.tech().bus_arc;
                            propagatedBus = true;
                        }
                    }
                }
            }
        }
        for (SueWire sw : sueWires) {
            for (int i = 0; i < 2; ++i) {
                int j;
                if (sw.pi[i] != null) continue;
                PrimitiveNode proto = Schematics.tech().wirePinNode;
                if (sw.proto == Schematics.tech().bus_arc) {
                    proto = Schematics.tech().busPinNode;
                }
                for (SueWire oSw : sueWires) {
                    if (oSw == sw) continue;
                    for (j = 0; j < 2; ++j) {
                        if (sw.pt[i].getX() != oSw.pt[j].getX() || sw.pt[i].getY() != oSw.pt[j].getY()) continue;
                        if (oSw.pi[j] != null) {
                            ((SueWire)sw).pi[i] = oSw.pi[j];
                            break;
                        }
                        if (oSw.proto != Schematics.tech().bus_arc) continue;
                        proto = Schematics.tech().busPinNode;
                    }
                    if (sw.pi[i] == null) continue;
                    break;
                }
                if (sw.pi[i] == null) {
                    NodeInst ni = NodeInst.makeInstance(proto, sw.pt[i], proto.getDefWidth(), proto.getDefHeight(), cell);
                    ((SueWire)sw).pi[i] = ni.getOnlyPortInst();
                }
                for (SueWire oSw : sueWires) {
                    if (oSw == sw) continue;
                    for (j = 0; j < 2; ++j) {
                        if (sw.pt[i].getX() != oSw.pt[j].getX() || sw.pt[i].getY() != oSw.pt[j].getY() || oSw.pi[j] != null) continue;
                        ((SueWire)oSw).pi[j] = sw.pi[i];
                    }
                }
            }
        }
        for (SueWire sw : sueWires) {
            for (int i = 0; i < 2; ++i) {
                if (sw.pi[i] != null) continue;
                ((SueWire)sw).pi[i] = this.findNode(sw.pt[i], sw.pt[1 - i], cell, sw.pi[1 - i]);
                if (sw.pi[i] != null) continue;
                PrimitiveNode proto = Schematics.tech().wirePinNode;
                if (sw.proto == Schematics.tech().bus_arc) {
                    proto = Schematics.tech().busPinNode;
                }
                NodeInst ni = NodeInst.makeInstance(proto, sw.pt[i], proto.getDefWidth(), proto.getDefHeight(), cell);
                ((SueWire)sw).pi[i] = ni.getOnlyPortInst();
            }
        }
        for (SueWire sw : sueWires) {
            ArcInst ai;
            if (sw.proto == null) {
                sw.proto = Schematics.tech().wire_arc;
            }
            if (sw.proto == Schematics.tech().bus_arc) {
                for (int i = 0; i < 2; ++i) {
                    double ysize;
                    double xsize;
                    double py;
                    if (sw.pi[i].getPortProto().getBasePort().connectsTo(Schematics.tech().bus_arc)) continue;
                    double px = (sw.pt[0].getX() + sw.pt[1].getX()) / 2.0;
                    Point2D.Double pt = new Point2D.Double(px, py = (sw.pt[0].getY() + sw.pt[1].getY()) / 2.0);
                    NodeInst ni = NodeInst.makeInstance(Schematics.tech().busPinNode, pt, xsize = Schematics.tech().busPinNode.getDefWidth(), ysize = Schematics.tech().busPinNode.getDefHeight(), cell);
                    if (ni == null) break;
                    PortInst pi = ni.getOnlyPortInst();
                    ArcInst ai2 = ArcInst.makeInstanceBase(Generic.tech().unrouted_arc, 0.0, pi, sw.pi[i]);
                    if (ai2 == null) {
                        System.out.println("Error making fake connection");
                        break;
                    }
                    ((SueWire)sw).pi[i] = pi;
                    ((SueWire)sw).pt[i] = pt;
                }
            }
            if ((ai = ArcInst.makeInstance(sw.proto, sw.pi[0], sw.pi[1], sw.pt[0], sw.pt[1], null)) == null) {
                System.out.println(cell + ": Could not run a wire from " + sw.pi[0].getNodeInst().describe(true) + " to " + sw.pi[1].getNodeInst().describe(true));
                continue;
            }
            if (invertNodeOutput.contains(sw.pi[0].getNodeInst()) && sw.pi[0].getPortProto().getName().equals("y")) {
                ai.setHeadNegated(true);
            }
            if (!invertNodeOutput.contains(sw.pi[1].getNodeInst()) || !sw.pi[1].getPortProto().getName().equals("y")) continue;
            ai.setTailNegated(true);
        }
        Iterator<NodeInst> it = cell.getNodes();
        block28: while (it.hasNext()) {
            NodeInst ni = it.next();
            if (ni.getProto() != Schematics.tech().offpageNode || ni.hasConnections()) continue;
            PortInst pi = ni.getPortInst(1);
            Poly piPoly = pi.getPoly();
            double x = piPoly.getCenterX();
            double y = piPoly.getCenterY();
            Rectangle2D.Double searchBounds = new Rectangle2D.Double(x, y, 0.0, 0.0);
            Iterator<RTBounds> sea = cell.searchIterator(searchBounds);
            while (sea.hasNext()) {
                NodeInst oNi;
                RTBounds geom = sea.next();
                if (!(geom instanceof NodeInst) || (oNi = (NodeInst)geom) == ni) continue;
                boolean wired = false;
                Iterator<PortInst> oIt = oNi.getPortInsts();
                while (oIt.hasNext()) {
                    PortInst oPi = oIt.next();
                    Poly oPiPoly = oPi.getPoly();
                    double oX = oPiPoly.getCenterX();
                    double oY = oPiPoly.getCenterY();
                    if (oX != x || oY != y) continue;
                    ArcProto ap = null;
                    for (int i = 0; i < 3; ++i) {
                        switch (i) {
                            case 0: {
                                ap = Schematics.tech().bus_arc;
                                break;
                            }
                            case 1: {
                                ap = Schematics.tech().wire_arc;
                                break;
                            }
                            case 2: {
                                ap = Generic.tech().unrouted_arc;
                            }
                        }
                        if (pi.getPortProto().getBasePort().connectsTo(ap) && oPi.getPortProto().getBasePort().connectsTo(ap)) break;
                    }
                    ArcInst.makeInstance(ap, pi, oPi);
                    wired = true;
                    break;
                }
                if (!wired) continue;
                continue block28;
            }
        }
    }

    private PortInst findNode(Point2D pt, Point2D oPt, Cell cell, PortInst notThisPort) {
        double slop = 10.0;
        PortInst bestPi = null;
        double bestDist = Double.MAX_VALUE;
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(pt.getX() - slop, pt.getY() - slop, slop * 2.0, slop * 2.0);
        Iterator<RTBounds> sea = cell.searchIterator(searchBounds);
        while (sea.hasNext()) {
            RTBounds geom = sea.next();
            if (!(geom instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)geom;
            if (notThisPort != null && ni == notThisPort.getNodeInst() || ni.getProto() == Schematics.tech().wirePinNode) continue;
            Iterator<PortInst> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = it.next();
                Poly poly = pi.getPoly();
                Rectangle2D bounds = poly.getBounds2D();
                double thisX = oPt.getX();
                double thisY = oPt.getY();
                if (pt.getX() == oPt.getX()) {
                    if (oPt.getX() < bounds.getMinX() || oPt.getX() > bounds.getMaxX()) continue;
                    thisX = oPt.getX();
                    thisY = bounds.getCenterY();
                } else if (pt.getY() == oPt.getY()) {
                    if (oPt.getY() < bounds.getMinY() || oPt.getY() > bounds.getMaxY()) continue;
                    thisX = bounds.getCenterX();
                    thisY = oPt.getY();
                } else if (!poly.isInside(oPt)) continue;
                double dist = oPt.distance(new Point2D.Double(thisX, thisY));
                if (bestPi != null && !(dist < bestDist)) continue;
                bestPi = pi;
                bestDist = dist;
            }
        }
        return bestPi;
    }

    private PortInst wiredPort(NodeInst ni, Point2D pt, Point2D oPt) {
        Iterator<PortInst> it = ni.getPortInsts();
        while (it.hasNext()) {
            PortInst pi = it.next();
            Poly poly = pi.getPoly();
            if (!poly.isInside(pt)) continue;
            return pi;
        }
        if (ni.getTrueCenterX() != pt.getX() || ni.getTrueCenterY() != pt.getY()) {
            return null;
        }
        double bestDist = Double.MAX_VALUE;
        PortInst bestPi = null;
        Iterator<PortInst> it2 = ni.getPortInsts();
        while (it2.hasNext()) {
            PortInst pi = it2.next();
            Poly poly = pi.getPoly();
            Point2D.Double ctr = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
            double dist = ctr.distance(oPt);
            if (dist > bestDist) continue;
            bestDist = dist;
            bestPi = pi;
        }
        Poly poly = bestPi.getPoly();
        pt.setLocation(poly.getCenterX(), poly.getCenterY());
        return bestPi;
    }

    private void placeNets(List<SueNet> sueNets, Cell cell) {
        for (int pass = 0; pass < 3; ++pass) {
            for (SueNet sn : sueNets) {
                String busName;
                if (sn.label.startsWith("[") ? pass == 0 : pass != 0) continue;
                Name lableName = Name.findName(sn.label);
                boolean isBus = false;
                if (lableName.busWidth() > 1) {
                    isBus = true;
                }
                ArcInst bestAi = null;
                double bestDist = Double.MAX_VALUE;
                Rectangle2D.Double searchBounds = new Rectangle2D.Double(sn.pt.getX(), sn.pt.getY(), 0.0, 0.0);
                Iterator<RTBounds> sea = cell.searchIterator(searchBounds);
                while (sea.hasNext()) {
                    RTBounds geom = sea.next();
                    if (geom instanceof NodeInst) continue;
                    ArcInst ai = (ArcInst)geom;
                    if (isBus ? ai.getProto() != Schematics.tech().bus_arc : ai.getProto() == Schematics.tech().bus_arc) continue;
                    double cx = (ai.getHeadLocation().getX() + ai.getTailLocation().getX()) / 2.0;
                    double cy = (ai.getHeadLocation().getY() + ai.getTailLocation().getY()) / 2.0;
                    Point2D.Double ctr = new Point2D.Double(cx, cy);
                    double dist = ctr.distance(sn.pt);
                    if (bestAi != null && !(dist < bestDist)) continue;
                    bestAi = ai;
                    bestDist = dist;
                }
                if (bestAi == null || (pass != 1 ? pass == 2 && bestAi.getProto() == Schematics.tech().bus_arc : bestAi.getProto() != Schematics.tech().bus_arc)) continue;
                String netName = sn.label;
                if (netName.startsWith("[") && (busName = this.findBusName(bestAi)) != null) {
                    netName = busName + netName;
                }
                bestAi.setName(netName);
            }
        }
    }

    private String findBusName(ArcInst ai) {
        HashSet<ArcInst> arcsSeen = new HashSet<ArcInst>();
        String busName = this.searchBusName(ai, arcsSeen);
        if (busName == null) {
            int index = 1;
            while (true) {
                String pseudoBusName = "NET" + index;
                int len = pseudoBusName.length();
                boolean found = false;
                Iterator<ArcInst> it = ai.getParent().getArcs();
                while (it.hasNext()) {
                    ArcInst oAi = it.next();
                    String arcName = oAi.getName();
                    if (arcName.equalsIgnoreCase(pseudoBusName)) {
                        found = true;
                        break;
                    }
                    if (!arcName.startsWith(pseudoBusName) || arcName.charAt(len) != '[') continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return pseudoBusName;
                }
                ++index;
            }
        }
        return busName;
    }

    private String searchBusName(ArcInst ai, Set<ArcInst> arcsSeen) {
        arcsSeen.add(ai);
        if (ai.getProto() == Schematics.tech().bus_arc) {
            String arcName = ai.getName();
            int openPos = arcName.indexOf(91);
            if (openPos >= 0) {
                arcName = arcName.substring(0, openPos);
            }
            return arcName;
        }
        for (int i = 0; i < 2; ++i) {
            Iterator<Object> it;
            NodeInst ni = ai.getPortInst(i).getNodeInst();
            if (ni.getProto() != Schematics.tech().wirePinNode && ni.getProto() != Schematics.tech().busPinNode && ni.getProto() != Schematics.tech().offpageNode) continue;
            if (ni.getProto() == Schematics.tech().busPinNode || ni.getProto() == Schematics.tech().offpageNode) {
                it = ni.getExports();
                while (it.hasNext()) {
                    Export pp = it.next();
                    String busName = pp.getName();
                    int openPos = busName.indexOf(91);
                    if (openPos < 0) continue;
                    return busName.substring(0, openPos);
                }
            }
            it = ni.getConnections();
            while (it.hasNext()) {
                String busName;
                Connection con = (Connection)it.next();
                ArcInst oAi = con.getArc();
                if (arcsSeen.contains(oAi) || (busName = this.searchBusName(oAi, arcsSeen)) == null) continue;
                return busName;
            }
        }
        return null;
    }

    private List<String> getNextLine(LineNumberReader lr) throws IOException {
        this.lastLineRead = null;
        int lineNo = 0;
        while (true) {
            if (this.sueLastLine == null) {
                this.sueLastLine = lr.readLine();
                if (this.sueLastLine == null) {
                    return null;
                }
            }
            if (lineNo == 0) {
                this.lastLineRead = this.sueLastLine;
            } else {
                if (this.sueLastLine.length() == 0 || this.sueLastLine.charAt(0) != '+') break;
                this.lastLineRead = this.lastLineRead + this.sueLastLine.substring(1);
            }
            this.sueLastLine = null;
            ++lineNo;
        }
        boolean inBlank = true;
        ArrayList<String> keywords = new ArrayList<String>();
        int startIndex = 0;
        int len = this.lastLineRead.length();
        int curlyDepth = 0;
        for (int i = 0; i < len; ++i) {
            char pt = this.lastLineRead.charAt(i);
            if (pt == '{') {
                ++curlyDepth;
            }
            if (pt == '}') {
                --curlyDepth;
            }
            if ((pt == ' ' || pt == '\t') && curlyDepth == 0) {
                if (!inBlank) {
                    String keyword = this.lastLineRead.substring(startIndex, i).trim();
                    keywords.add(keyword);
                    startIndex = i;
                }
                inBlank = true;
                continue;
            }
            if (inBlank) {
                startIndex = i;
            }
            inBlank = false;
        }
        String keyword = this.lastLineRead.substring(startIndex, len).trim();
        if (keyword.length() > 0) {
            keywords.add(keyword);
        }
        return keywords;
    }

    private String parseExpression(String expression) {
        if (!this.localPrefs.convertExpressions) {
            return expression;
        }
        StringBuffer infstr = new StringBuffer();
        for (int i = 0; i < expression.length(); ++i) {
            char chr;
            int startKey = i;
            while (i < expression.length() && (chr = expression.charAt(i)) != ' ' && chr != '\t' && chr != ',' && chr != '+' && chr != '-' && chr != '*' && chr != '/' && chr != '(' && chr != ')') {
                ++i;
            }
            if (i > startKey) {
                String keyword = expression.substring(startKey, i);
                if (!(TextUtils.isANumber(keyword) || i < expression.length() && expression.charAt(i) == '(')) {
                    infstr.append('@');
                }
                infstr.append(keyword);
            }
            if (i >= expression.length()) continue;
            infstr.append(expression.charAt(i));
            ++i;
        }
        return infstr.toString();
    }

    private static double convertXCoord(double x) {
        return x / 8.0;
    }

    private static double convertYCoord(double y) {
        return -y / 8.0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParseParameters {
        int count;
        Point2D pt = null;
        int rot = 0;
        boolean trn = false;
        PortCharacteristic type = PortCharacteristic.UNKNOWN;
        String theName = null;
        String theLabel = null;
        String theText = null;

        private ParseParameters(List<String> keywords, int start) {
            for (int i = start; i < keywords.size(); i += 2) {
                String keyword = keywords.get(i);
                String param = "";
                if (i + 1 < keywords.size()) {
                    param = keywords.get(i + 1);
                }
                if (keyword.equalsIgnoreCase("-origin")) {
                    int j = 0;
                    if (param.charAt(j) == '{') {
                        ++j;
                    }
                    double x = TextUtils.atof(param.substring(j));
                    while (j < param.length() - 1 && !Character.isWhitespace(param.charAt(j))) {
                        ++j;
                    }
                    while (j < param.length() - 1 && Character.isWhitespace(param.charAt(j))) {
                        ++j;
                    }
                    double y = TextUtils.atof(param.substring(j));
                    this.pt = new Point2D.Double(Sue.convertXCoord(x), Sue.convertYCoord(y));
                }
                if (keyword.equalsIgnoreCase("-orient")) {
                    if (param.equalsIgnoreCase("R90")) {
                        this.rot = 900;
                    } else if (param.equalsIgnoreCase("R270")) {
                        this.rot = 2700;
                    } else if (param.equalsIgnoreCase("RXY")) {
                        this.rot = 1800;
                    } else if (param.equalsIgnoreCase("RY")) {
                        this.rot = 900;
                        this.trn = true;
                    } else if (param.equalsIgnoreCase("R90X")) {
                        this.rot = 0;
                        this.trn = true;
                    } else if (param.equalsIgnoreCase("R90Y")) {
                        this.rot = 1800;
                        this.trn = true;
                    } else if (param.equalsIgnoreCase("RX")) {
                        this.rot = 2700;
                        this.trn = true;
                    }
                    this.rot = (3600 - this.rot) % 3600;
                }
                if (keyword.equalsIgnoreCase("-type")) {
                    if (param.equalsIgnoreCase("input")) {
                        this.type = PortCharacteristic.IN;
                    } else if (param.equalsIgnoreCase("output")) {
                        this.type = PortCharacteristic.OUT;
                    } else if (param.equalsIgnoreCase("inout")) {
                        this.type = PortCharacteristic.BIDIR;
                    }
                }
                if (!keyword.equalsIgnoreCase("-name") && !keyword.equalsIgnoreCase("-label") && !keyword.equalsIgnoreCase("-text")) continue;
                String infstr = param;
                if (infstr.startsWith("{") && infstr.endsWith("}")) {
                    int len = infstr.length();
                    infstr = infstr.substring(1, len - 1);
                }
                if (keyword.equalsIgnoreCase("-name")) {
                    this.theName = infstr;
                    continue;
                }
                if (keyword.equalsIgnoreCase("-label")) {
                    this.theLabel = infstr;
                    continue;
                }
                if (!keyword.equalsIgnoreCase("-text")) continue;
                this.theText = infstr;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SuePreferences
    extends Input.InputPreferences {
        public boolean use4PortTransistors;
        public boolean convertExpressions;

        public SuePreferences(boolean factory) {
            super(factory);
        }

        @Override
        public void initFromUserDefaults() {
            this.use4PortTransistors = IOTool.isSueUses4PortTransistors();
            this.convertExpressions = IOTool.isSueConvertsExpressions();
        }

        @Override
        public Library doInput(URL fileURL, Library lib, Technology tech, Map<Library, Cell> currentCells, Job job) {
            Sue in = new Sue(this);
            if (in.openTextInput(fileURL)) {
                return null;
            }
            lib = in.importALibrary(lib, tech, currentCells);
            in.closeInput();
            return lib;
        }
    }

    private static class SueNet {
        private Point2D pt;
        private String label;

        private SueNet() {
        }
    }

    private static class SueWire {
        private Point2D[] pt = new Point2D[2];
        private PortInst[] pi = new PortInst[2];
        private ArcProto proto;

        private SueWire() {
        }
    }

    private static class SueEquiv {
        private String sueName;
        private NodeProto intProto;
        private boolean netateOutput;
        private int rotation;
        private boolean transpose;
        private double xOffset;
        private double yOffset;
        private PrimitiveNode.Function detailFunct;
        private SueExtraWire[] extraWires;

        private SueEquiv(String sueName, NodeProto intProto, boolean netateOutput, int rotation, boolean transpose, double xOffset, double yOffset, PrimitiveNode.Function detailFunct, SueExtraWire[] extraWires) {
            this.sueName = sueName;
            this.intProto = intProto;
            this.netateOutput = netateOutput;
            this.rotation = rotation;
            this.transpose = transpose;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.detailFunct = detailFunct;
            this.extraWires = extraWires;
        }
    }

    private static class SueExtraWire {
        private String portName;
        private double xOffset;
        private double yOffset;

        private SueExtraWire(String portName, double xOffset, double yOffset) {
            this.portName = portName;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }
    }
}

