/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.Waveform;
import com.sun.electric.tool.simulation.WaveformImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalogAnalysis
extends Analysis<AnalogSignal> {
    private List<Object> sweeps;
    private double[] commonTime;
    private HashMap<AnalogSignal, Waveform[]> waveformCache = new HashMap();

    public AnalogAnalysis(Stimuli sd, Analysis.AnalysisType type) {
        super(sd, type);
        if (type != ANALYSIS_MEAS) {
            this.sweeps = new ArrayList<Object>();
        }
    }

    @Override
    public void finished() {
        super.finished();
        if (this.sweeps != null) {
            this.sweeps.clear();
        }
    }

    @Override
    public boolean isAnalog() {
        return true;
    }

    public void addSweep(Object obj) {
        this.sweeps.add(obj);
        this.setBoundsDirty();
    }

    public int getNumSweeps() {
        return this.sweeps != null ? Math.max(this.sweeps.size(), 1) : 1;
    }

    public Object getSweep(int i) {
        if (this.sweeps == null || this.sweeps.size() == 0) {
            return null;
        }
        return this.sweeps.get(i);
    }

    public void buildCommonTime(int numEvents) {
        this.commonTime = new double[numEvents];
    }

    public void setCommonTime(int index, double time) {
        this.commonTime[index] = time;
        this.setBoundsDirty();
    }

    public double[] getCommonTimeArray() {
        return this.commonTime;
    }

    public AnalogSignal addSignal(String signalName, String signalContext, double[] values) {
        AnalogSignal as = this.addEmptySignal(signalName, signalContext);
        Waveform[] waveforms = new Waveform[]{new WaveformImpl(this.getCommonTimeArray(), values)};
        this.waveformCache.put(as, waveforms);
        return as;
    }

    public AnalogSignal addSignal(String signalName, String signalContext, double minTime, double maxTime, double minValue, double maxValue) {
        AnalogSignal as = this.addEmptySignal(signalName, signalContext);
        return as;
    }

    private AnalogSignal addEmptySignal(String signalName, String signalContext) {
        AnalogSignal as = new AnalogSignal(this);
        as.setSignalName(signalName, signalContext);
        return as;
    }

    public Waveform getWaveform(AnalogSignal signal, int sweep) {
        Waveform[] waveforms = this.waveformCache.get(signal);
        if (waveforms == null) {
            if (signal.getAnalysis() != this) {
                throw new IllegalArgumentException();
            }
            waveforms = this.loadWaveforms(signal);
            assert (waveforms.length == this.getNumSweeps());
            this.waveformCache.put(signal, waveforms);
        }
        return waveforms[sweep];
    }

    protected Waveform[] loadWaveforms(AnalogSignal signal) {
        throw new UnsupportedOperationException();
    }
}

