/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;

public class Subcircuit
extends Part {
    private final int[] pinCoeffs;
    private final SubcircuitInfo subcircuitInfo;

    private String getPortName(int i) {
        return this.subcircuitInfo.getPortName(i);
    }

    @Override
    public String valueDescription() {
        return "";
    }

    @Override
    public int[] getPinCoeffs() {
        return this.pinCoeffs;
    }

    @Override
    public boolean parallelMerge(Part p) {
        return false;
    }

    @Override
    public Integer hashCodeForParallelMerge() {
        int hc = this.pins.length;
        for (int i = 0; i < this.pins.length; ++i) {
            hc += this.pins[i].hashCode() * this.pinCoeffs[i];
        }
        hc += this.getClass().hashCode();
        return new Integer(hc += this.subcircuitInfo.getID());
    }

    @Override
    public String typeString() {
        return this.subcircuitInfo.getName();
    }

    @Override
    public int typeCode() {
        return 3 + (this.subcircuitInfo.getID() << 4);
    }

    @Override
    public PinType getPinTypeOfNthPin(int n) {
        PinType[] pinTypes = this.subcircuitInfo.getPinTypes();
        return pinTypes[n];
    }

    @Override
    public String connectionDescription(Wire w) {
        String msg = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (msg.length() != 0) {
                msg = msg + ',';
            }
            msg = msg + this.getPortName(i);
        }
        return msg;
    }

    @Override
    public String connectionDescription(int maxCon) {
        String msg = "";
        for (int i = 0; i < maxCon && i < this.pins.length; ++i) {
            if (msg.length() != 0) {
                msg = msg + " ";
            }
            msg = msg + this.getPortName(i) + "=" + this.pins[i].getName();
        }
        return msg;
    }

    public Subcircuit(NccNameProxy.PartNameProxy instName, SubcircuitInfo subcircuitInfo, Wire[] pins) {
        super(instName, pins);
        this.subcircuitInfo = subcircuitInfo;
        this.pinCoeffs = subcircuitInfo.getPortCoeffs();
    }

    public static class SubcircuitPinType
    implements PinType {
        private int typeCode;
        private int portIndex;
        private String description;

        public SubcircuitPinType(int typeCode, int portIndex, String description) {
            this.typeCode = typeCode;
            this.portIndex = portIndex;
            this.description = description;
        }

        @Override
        public String description() {
            return this.description;
        }
    }
}

