/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.TechType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class AbutRouter {
    private final TechType tech;

    private static void prln(String msg) {
        System.out.println(msg);
    }

    private AbutRouter(TechType tech) {
        this.tech = tech;
    }

    private void sortByX(List<PortInst> ports) {
        Collections.sort(ports, new Comparator<PortInst>(){

            @Override
            public int compare(PortInst pi1, PortInst pi2) {
                double delta = pi1.getCenter().getX() - pi2.getCenter().getX();
                if (delta > 0.0) {
                    return 1;
                }
                if (delta == 0.0) {
                    return 0;
                }
                if (delta < 0.0) {
                    return -1;
                }
                LayoutLib.error(true, "some ports have unordered Y coordinates");
                return 0;
            }
        });
    }

    private List<PortInst> findPortsNearBoundary(NodeInst ni, double boundaryY, double distFromBoundary) {
        ArrayList<PortInst> boundaryPorts = new ArrayList<PortInst>();
        Iterator<PortInst> piIt = ni.getPortInsts();
        while (piIt.hasNext()) {
            PortInst pi = piIt.next();
            double y = pi.getCenter().getY();
            if (!(Math.abs(y - boundaryY) <= distFromBoundary)) continue;
            boundaryPorts.add(pi);
        }
        this.sortByX(boundaryPorts);
        return boundaryPorts;
    }

    private List<PortInst> getAndRemovePortsAtX(double x, List<PortInst> ports) {
        ArrayList<PortInst> portsAtX = new ArrayList<PortInst>();
        while (ports.size() != 0 && ports.get(0).getCenter().getX() == x) {
            portsAtX.add(ports.get(0));
            ports.remove(0);
        }
        return portsAtX;
    }

    private boolean powerToGroundShort(PortInst pi1, PortInst pi2) {
        PortCharacteristic ch1 = pi1.getPortProto().getCharacteristic();
        PortCharacteristic ch2 = pi2.getPortProto().getCharacteristic();
        return ch1 == PortCharacteristic.PWR && ch2 == PortCharacteristic.GND || ch1 == PortCharacteristic.GND && ch2 == PortCharacteristic.PWR;
    }

    private void connectAlignedPorts(List<PortInst> botPorts, List<PortInst> topPorts) {
        block0: for (PortInst piB : botPorts) {
            ArcProto arcB = this.tech.highestLayer(piB.getPortProto());
            for (PortInst piT : topPorts) {
                if (!piT.getPortProto().connectsTo(arcB)) continue;
                if (this.powerToGroundShort(piB, piT)) {
                    AbutRouter.prln("Power and Ground ports overlap: " + piB + " " + piT);
                    continue;
                }
                double w = LayoutLib.widestWireWidth(piB);
                AbutRouter.prln("Connecting ports: " + piB + " and " + piT + " using " + arcB + " width " + w);
                LayoutLib.newArcInst(arcB, w, piB, piT);
                continue block0;
            }
        }
    }

    private void abutRouteBotTop(NodeInst bot, NodeInst top, double distFromBoundary) {
        double botMaxY = bot.findEssentialBounds().getMaxY();
        double topMinY = top.findEssentialBounds().getMinY();
        List<PortInst> botPorts = this.findPortsNearBoundary(bot, botMaxY, distFromBoundary);
        List<PortInst> topPorts = this.findPortsNearBoundary(top, topMinY, distFromBoundary);
        while (botPorts.size() != 0 && topPorts.size() != 0) {
            PortInst tFirst;
            double tX;
            PortInst bFirst = botPorts.get(0);
            double bX = bFirst.getCenter().getX();
            if (bX < (tX = (tFirst = topPorts.get(0)).getCenter().getX())) {
                botPorts.remove(0);
                continue;
            }
            if (bX > tX) {
                topPorts.remove(0);
                continue;
            }
            List<PortInst> alignedBotPorts = this.getAndRemovePortsAtX(bX, botPorts);
            List<PortInst> alignedTopPorts = this.getAndRemovePortsAtX(bX, topPorts);
            this.connectAlignedPorts(alignedBotPorts, alignedTopPorts);
        }
    }

    public static void abutRouteBotTop(NodeInst bot, NodeInst top, double distFromBoundary, TechType tech) {
        AbutRouter ar = new AbutRouter(tech);
        ar.abutRouteBotTop(bot, top, distFromBoundary);
    }
}

