/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.LibId;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.text.CellName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class IdManager {
    private final ArrayList<LibId> libIds = new ArrayList();
    private final HashMap<String, LibId> libIdsByName = new HashMap();
    private final ArrayList<CellId> cellIds = new ArrayList();
    private final AtomicInteger snapshotCount = new AtomicInteger();
    private final Snapshot initialSnapshot = new Snapshot(this);

    public synchronized LibId newLibId(String libName) {
        LibId libId = this.libIdsByName.get(libName);
        return libId != null ? libId : this.newLibIdInternal(libName);
    }

    public synchronized LibId getLibId(int libIndex) {
        return this.libIds.get(libIndex);
    }

    private LibId newLibIdInternal(String libName) {
        int libIndex = this.libIds.size();
        LibId libId = new LibId(this, libName, libIndex);
        this.libIds.add(libId);
        this.libIdsByName.put(libName, libId);
        assert (this.libIds.size() == this.libIdsByName.size());
        return libId;
    }

    synchronized CellId newCellId(LibId libId, CellName cellName) {
        assert (libId.idManager == this);
        CellId cellId = libId.getCellId(cellName);
        return cellId != null ? cellId : this.newCellIdInternal(libId, cellName);
    }

    public synchronized CellId getCellId(int cellIndex) {
        return this.cellIds.get(cellIndex);
    }

    private CellId newCellIdInternal(LibId libId, CellName cellName) {
        int cellIndex = this.cellIds.size();
        CellId cellId = new CellId(libId, cellName, cellIndex);
        this.cellIds.add(cellId);
        libId.putCellId(cellId);
        return cellId;
    }

    public Snapshot getInitialSnapshot() {
        return this.initialSnapshot;
    }

    int newSnapshotId() {
        return this.snapshotCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDiffs(SnapshotWriter writer) throws IOException {
        CellId cellId;
        int cellIndex;
        CellId[] cellIdsArray;
        LibId[] libIdsArray;
        IdManager idManager = this;
        synchronized (idManager) {
            libIdsArray = this.libIds.toArray(LibId.NULL_ARRAY);
            cellIdsArray = this.cellIds.toArray(CellId.NULL_ARRAY);
        }
        writer.writeInt(libIdsArray.length);
        for (int libIndex = writer.libCount; libIndex < libIdsArray.length; ++libIndex) {
            LibId libId = libIdsArray[libIndex];
            writer.writeString(libId.libName);
        }
        writer.setLibCount(libIdsArray.length);
        writer.writeInt(cellIdsArray.length);
        for (cellIndex = writer.exportCounts.length; cellIndex < cellIdsArray.length; ++cellIndex) {
            cellId = cellIdsArray[cellIndex];
            writer.writeLibId(cellId.libId);
            writer.writeString(cellId.cellName.toString());
        }
        writer.setCellCount(cellIdsArray.length);
        for (cellIndex = 0; cellIndex < cellIdsArray.length; ++cellIndex) {
            int exportCount;
            cellId = cellIdsArray[cellIndex];
            int numExportIds = cellId.numExportIds();
            if (numExportIds == (exportCount = writer.exportCounts[cellIndex])) continue;
            writer.writeInt(cellIndex);
            int numNewExportIds = numExportIds - exportCount;
            assert (numNewExportIds > 0);
            writer.writeInt(numNewExportIds);
            for (int i = 0; i < numNewExportIds; ++i) {
                writer.writeString(cellId.getPortId((int)(exportCount + i)).externalId);
            }
            writer.exportCounts[cellIndex] = numExportIds;
        }
        writer.writeInt(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readDiffs(SnapshotReader reader) throws IOException {
        IdManager idManager = this;
        synchronized (idManager) {
            int oldLibIdsCount = this.libIds.size();
            int oldCellIdsCount = this.cellIds.size();
        }
        int libIdsCount = reader.readInt();
        for (int libIndex = oldLibIdsCount; libIndex < libIdsCount; ++libIndex) {
            this.newLibId(reader.readString());
        }
        int cellIdsCount = reader.readInt();
        for (int cellIndex = oldCellIdsCount; cellIndex < cellIdsCount; ++cellIndex) {
            LibId libId = reader.readLibId();
            this.newCellId(libId, CellName.parseName(reader.readString()));
        }
        IdManager cellIndex = this;
        synchronized (cellIndex) {
            assert (libIdsCount == this.libIds.size());
            assert (cellIdsCount == this.cellIds.size());
        }
        while ((cellIndex = reader.readInt()) != -1) {
            CellId cellId = this.getCellId(cellIndex);
            int numNewExportIds = reader.readInt();
            for (int i = 0; i < numNewExportIds; ++i) {
                String exportIdString = reader.readString();
                cellId.newExportId(exportIdString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkInvariants() {
        int numCellIds;
        IdManager idManager = this;
        synchronized (idManager) {
            int numLibIds = this.libIds.size();
            assert (numLibIds == this.libIdsByName.size());
            for (int libIndex = 0; libIndex < numLibIds; ++libIndex) {
                LibId libId = this.getLibId(libIndex);
                assert (libId.idManager == this);
                assert (libId.libIndex == libIndex);
                libId.check();
                assert (this.libIdsByName.get(libId.libName) == libId);
            }
            for (Map.Entry<String, LibId> e : this.libIdsByName.entrySet()) {
                LibId libId = e.getValue();
                assert (libId.idManager == this);
                assert (libId.libName == e.getKey());
                assert (this.getLibId(libId.libIndex) == libId);
            }
            numCellIds = this.cellIds.size();
        }
        for (int cellIndex = 0; cellIndex < numCellIds; ++cellIndex) {
            CellId cellId = this.getCellId(cellIndex);
            assert (cellId.idManager == this);
            assert (cellId.cellIndex == cellIndex);
            assert (cellId.libId.getCellId(cellId.cellName) == cellId);
            cellId.check();
        }
    }
}

