/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.user.Highlighter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteElementPort
extends RouteElement {
    private NodeProto np;
    private PortProto portProto;
    private EPoint location;
    private double width;
    private double height;
    private boolean isBisectArcPin;
    private List<RouteElementArc> newArcs;
    private transient Poly portInstSite;
    private NodeInst nodeInst;
    private PortInst portInst;

    private RouteElementPort(RouteElement.RouteElementAction action, Cell cell) {
        super(action, cell);
    }

    public static RouteElementPort newNode(Cell cell, NodeProto np, PortProto newNodePort, Point2D location, double width, double height) {
        RouteElementPort e = new RouteElementPort(RouteElement.RouteElementAction.newNode, cell);
        e.np = np;
        e.portProto = newNodePort;
        e.location = EPoint.snap(location);
        e.isBisectArcPin = false;
        e.newArcs = new ArrayList<RouteElementArc>();
        e.setNodeSize(new Dimension2D.Double(width, height));
        e.nodeInst = null;
        e.portInst = null;
        Point2D[] points = new Point2D[]{location};
        e.portInstSite = new Poly(points);
        return e;
    }

    public static RouteElementPort deleteNode(NodeInst nodeInstToDelete) {
        RouteElementPort e = new RouteElementPort(RouteElement.RouteElementAction.deleteNode, nodeInstToDelete.getParent());
        e.np = nodeInstToDelete.getProto();
        e.portProto = null;
        e.location = EPoint.snap(nodeInstToDelete.getTrueCenter());
        e.isBisectArcPin = false;
        e.newArcs = new ArrayList<RouteElementArc>();
        e.setNodeSize(new Dimension2D.Double(nodeInstToDelete.getXSize(), nodeInstToDelete.getYSize()));
        e.nodeInst = nodeInstToDelete;
        e.portInst = null;
        e.portInstSite = null;
        return e;
    }

    public static RouteElementPort existingPortInst(PortInst existingPortInst, EPoint portInstSite) {
        Point2D[] points = new Point2D[]{portInstSite};
        Poly poly = new Poly(points);
        return RouteElementPort.existingPortInst(existingPortInst, poly);
    }

    public static RouteElementPort existingPortInst(PortInst existingPortInst, Poly portInstSite) {
        RouteElementPort e = new RouteElementPort(RouteElement.RouteElementAction.existingPortInst, existingPortInst.getNodeInst().getParent());
        NodeInst nodeInst = existingPortInst.getNodeInst();
        e.np = nodeInst.getProto();
        e.portProto = existingPortInst.getPortProto();
        e.location = EPoint.snap(nodeInst.getTrueCenter());
        e.isBisectArcPin = false;
        e.newArcs = new ArrayList<RouteElementArc>();
        e.setNodeSize(new Dimension2D.Double(nodeInst.getXSize(), nodeInst.getYSize()));
        e.nodeInst = nodeInst;
        e.portInst = existingPortInst;
        e.portInstSite = portInstSite;
        return e;
    }

    public PortProto getPortProto() {
        return this.portProto;
    }

    public PortInst getPortInst() {
        return this.portInst;
    }

    public NodeInst getNodeInst() {
        return this.nodeInst;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setBisectArcPin(boolean state) {
        this.isBisectArcPin = state;
    }

    public boolean isBisectArcPin() {
        return this.isBisectArcPin;
    }

    public void addConnectingNewArc(RouteElementArc re) {
        if (re.getAction() != RouteElement.RouteElementAction.newArc) {
            return;
        }
        this.newArcs.add(re);
    }

    public void removeConnectingNewArc(RouteElementArc re) {
        if (re.getAction() != RouteElement.RouteElementAction.newArc) {
            return;
        }
        this.newArcs.remove(re);
    }

    public double getWidestConnectingArc(ArcProto ap) {
        double width = -1.0;
        if (this.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            Iterator<Connection> it = this.portInst.getConnections();
            while (it.hasNext()) {
                double newWidth;
                Connection conn = it.next();
                ArcInst arc = conn.getArc();
                if (arc.getProto() != ap || !((newWidth = arc.getWidth() - arc.getProto().getWidthOffset()) > width)) continue;
                width = newWidth;
            }
        }
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            if (this.newArcs == null) {
                return -1.0;
            }
            for (RouteElementArc re : this.newArcs) {
                if (re.getArcProto() != ap || !(re.getOffsetArcWidth() > width)) continue;
                width = re.getOffsetArcWidth();
            }
        }
        return width;
    }

    public Iterator<RouteElement> getNewArcs() {
        ArrayList<RouteElementArc> list = new ArrayList<RouteElementArc>();
        list.addAll(this.newArcs);
        return list.iterator();
    }

    public Dimension2D.Double getNodeSize() {
        return new Dimension2D.Double(this.width, this.height);
    }

    public void setNodeSize(Dimension2D size) {
        SizeOffset so = this.np.getProtoSizeOffset();
        double widthoffset = so.getLowXOffset() + so.getHighXOffset();
        double heightoffset = so.getLowYOffset() + so.getHighYOffset();
        double defWidth = this.np.getDefWidth() - widthoffset;
        double defHeight = this.np.getDefHeight() - heightoffset;
        this.width = size.getWidth() > defWidth ? size.getWidth() : defWidth;
        this.height = size.getHeight() > defHeight ? size.getHeight() : defHeight;
    }

    public Poly getConnectingSite() {
        return this.portInstSite;
    }

    @Override
    public ElectricObject doAction() {
        EDatabase.serverDatabase().checkChanging();
        if (this.isDone()) {
            return null;
        }
        NodeInst returnObj = null;
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            SizeOffset so = this.np.getProtoSizeOffset();
            double widthso = this.width + so.getLowXOffset() + so.getHighXOffset();
            double heightso = this.height + so.getLowYOffset() + so.getHighYOffset();
            this.nodeInst = NodeInst.makeInstance(this.np, this.location, widthso, heightso, this.getCell());
            if (this.nodeInst == null) {
                return null;
            }
            this.portInst = this.nodeInst.findPortInstFromProto(this.portProto);
            returnObj = this.nodeInst;
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteNode) {
            this.nodeInst.kill();
        }
        this.setDone();
        return returnObj;
    }

    @Override
    public void addHighlightArea(Highlighter highlighter) {
        if (!this.isShowHighlight()) {
            return;
        }
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            Rectangle2D.Double bounds = new Rectangle2D.Double(this.location.getX() - 0.5 * this.width, this.location.getY() - 0.5 * this.height, this.width, this.height);
            highlighter.addArea(bounds, this.getCell());
        }
        if (this.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            highlighter.addElectricObject(this.portInst, this.getCell());
        }
    }

    @Override
    public String toString() {
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            return "RouteElementPort newNode " + this.np + " size " + this.width + "," + this.height + " at " + this.location;
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteNode) {
            return "RouteElementPort deleteNode " + this.nodeInst;
        }
        if (this.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            return "RouteElementPort existingPortInst " + this.portInst;
        }
        return "RouteElement bad action";
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.portInstSite != null) {
            Point2D[] points = this.portInstSite.getPoints();
            s.writeInt(points.length);
            for (int i = 0; i < points.length; ++i) {
                s.writeDouble(points[i].getX());
                s.writeDouble(points[i].getY());
            }
        } else {
            s.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int len = s.readInt();
        if (len >= 0) {
            Point2D[] points = new Point2D[len];
            for (int i = 0; i < len; ++i) {
                double x = s.readDouble();
                double y = s.readDouble();
                points[i] = new Point2D.Double(x, y);
            }
        }
    }
}

