/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.technology.ArcProto;

public class ImmutableArcInst {
    private static final int FIXED = 1;
    private static final int FIXANG = 2;
    private static final int DISK_AANGLE = 16352;
    private static final int DISK_AANGLESH = 5;
    private static final int ISHEADNEGATED = 65536;
    private static final int DISK_NOEXTEND = 131072;
    private static final int ISTAILNEGATED = 262144;
    private static final int HEADARROW = 524288;
    private static final int DISK_ISDIRECTIONAL = 524288;
    private static final int TAILNOEXTEND = 0x100000;
    private static final int DISK_NOTEND0 = 0x100000;
    private static final int HEADNOEXTEND = 0x200000;
    private static final int DISK_NOTEND1 = 0x200000;
    private static final int DISK_REVERSEEND = 0x400000;
    private static final int CANTSLIDE = 0x800000;
    private static final int TAILARROW = 0x2000000;
    private static final int BODYARROW = 0x4000000;
    private static final int HARDSELECTA = Integer.MIN_VALUE;
    public static final Flag RIGID;
    public static final Flag FIXED_ANGLE;
    public static final Flag SLIDABLE;
    public static final Flag TAIL_ARROWED;
    public static final Flag HEAD_ARROWED;
    public static final Flag BODY_ARROWED;
    public static final Flag TAIL_EXTENDED;
    public static final Flag HEAD_EXTENDED;
    public static final Flag TAIL_NEGATED;
    public static final Flag HEAD_NEGATED;
    public static final Flag HARD_SELECT;
    private static int COMMON_BITS;
    public static final int DATABASE_FLAGS;
    public final int arcId;
    public final ArcProto protoType;
    public final Name name;
    public final int duplicate;
    public final ImmutableTextDescriptor nameDescriptor;
    public final int tailNodeId;
    public final PortProtoId tailPortId;
    public final EPoint tailLocation;
    public final int headNodeId;
    public final PortProtoId headPortId;
    public final EPoint headLocation;
    public final double width;
    public final double length;
    public final short angle;
    public final int flags;
    static final /* synthetic */ boolean $assertionsDisabled;

    ImmutableArcInst(int arcId, ArcProto protoType, Name name, int duplicate, ImmutableTextDescriptor nameDescriptor, int tailNodeId, PortProtoId tailPortId, EPoint tailLocation, int headNodeId, PortProtoId headPortId, EPoint headLocation, double width, double length, short angle, int flags) {
        this.arcId = arcId;
        this.protoType = protoType;
        this.name = name;
        this.duplicate = duplicate;
        this.nameDescriptor = nameDescriptor;
        this.tailNodeId = tailNodeId;
        this.tailPortId = tailPortId;
        this.tailLocation = tailLocation;
        this.headNodeId = headNodeId;
        this.headPortId = headPortId;
        this.headLocation = headLocation;
        this.width = width;
        this.length = length;
        this.angle = angle;
        this.flags = flags;
        this.check();
    }

    public static ImmutableArcInst newInstance(int arcId, ArcProto protoType, Name name, int duplicate, ImmutableTextDescriptor nameDescriptor, int tailNodeId, PortProtoId tailPortId, EPoint tailLocation, int headNodeId, PortProtoId headPortId, EPoint headLocation, double width, int angle, int flags) {
        if (protoType == null) {
            throw new NullPointerException("protoType");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && name.isBus()) {
            throw new IllegalArgumentException("name");
        }
        if (duplicate < 0) {
            throw new IllegalArgumentException("duplicate");
        }
        if (!(width >= 0.0)) {
            throw new IllegalArgumentException("width");
        }
        if (tailPortId == null) {
            throw new NullPointerException("tailPortId");
        }
        if (tailLocation == null) {
            throw new NullPointerException("tailLocation");
        }
        if (headPortId == null) {
            throw new NullPointerException("headPortId");
        }
        if (headLocation == null) {
            throw new NullPointerException("headLocation");
        }
        if ((width = DBMath.round(width)) == -0.0) {
            width = 0.0;
        }
        if ((angle %= 3600) < 0) {
            angle += 3600;
        }
        return new ImmutableArcInst(arcId, protoType, name, duplicate, nameDescriptor, tailNodeId, tailPortId, tailLocation, headNodeId, headPortId, headLocation, width, tailLocation.distance(headLocation), ImmutableArcInst.updateAngle((short)angle, tailLocation, headLocation), flags &= DATABASE_FLAGS);
    }

    public ImmutableArcInst withName(Name name, int duplicate) {
        if (this.name.equals(name) && this.duplicate == duplicate) {
            return this;
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname() && name.isBus()) {
            throw new IllegalArgumentException("name");
        }
        if (duplicate < 0) {
            throw new IllegalArgumentException("duplicate");
        }
        return new ImmutableArcInst(this.arcId, this.protoType, name, duplicate, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, this.angle, this.flags);
    }

    public ImmutableArcInst withNameDescriptor(ImmutableTextDescriptor nameDescriptor) {
        if (this.nameDescriptor == nameDescriptor) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.duplicate, nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, this.angle, this.flags);
    }

    public ImmutableArcInst withLocations(EPoint tailLocation, EPoint headLocation) {
        if (this.tailLocation.equals(tailLocation) && this.headLocation.equals(headLocation)) {
            return this;
        }
        if (tailLocation == null) {
            throw new NullPointerException("tailLocation");
        }
        if (headLocation == null) {
            throw new NullPointerException("headLocation");
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.duplicate, this.nameDescriptor, this.tailNodeId, this.tailPortId, tailLocation, this.headNodeId, this.headPortId, headLocation, this.width, tailLocation.distance(headLocation), ImmutableArcInst.updateAngle(this.angle, tailLocation, headLocation), this.flags);
    }

    public ImmutableArcInst withWidth(double width) {
        if (this.width == width) {
            return this;
        }
        if (!(width >= 0.0)) {
            throw new IllegalArgumentException("width");
        }
        if ((width = DBMath.round(width)) == -0.0) {
            width = 0.0;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.duplicate, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, width, this.length, this.angle, this.flags);
    }

    public ImmutableArcInst withAngle(int angle) {
        if (!this.tailLocation.equals(this.headLocation)) {
            return this;
        }
        if ((angle %= 3600) < 0) {
            angle += 3600;
        }
        if (this.angle == angle) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.duplicate, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, (short)angle, this.flags);
    }

    public ImmutableArcInst withFlags(int flags) {
        if (this.flags == (flags &= DATABASE_FLAGS)) {
            return this;
        }
        return new ImmutableArcInst(this.arcId, this.protoType, this.name, this.duplicate, this.nameDescriptor, this.tailNodeId, this.tailPortId, this.tailLocation, this.headNodeId, this.headPortId, this.headLocation, this.width, this.length, this.angle, flags);
    }

    public ImmutableArcInst withFlag(Flag flag, boolean value) {
        return this.withFlags(flag.set(this.flags, value));
    }

    private static short updateAngle(short angle, EPoint tailLocation, EPoint headLocation) {
        if (tailLocation.equals(headLocation)) {
            return angle;
        }
        return (short)DBMath.figureAngle(tailLocation, headLocation);
    }

    public boolean is(Flag flag) {
        return flag.is(this.flags);
    }

    public void check() {
        if (!$assertionsDisabled && this.protoType == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.name == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.name.isValid() && !this.name.hasEmptySubnames())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.name.isTempname() && this.name.isBus()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.duplicate < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.tailPortId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.tailLocation == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.headPortId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.headLocation == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.width > 0.0 || this.width == 0.0 && 1.0 / this.width > 0.0)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && DBMath.round(this.width) != this.width) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (this.flags & ~DATABASE_FLAGS) != 0) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0 <= this.angle && this.angle < 3600)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.length != this.tailLocation.distance(this.headLocation)) {
            throw new AssertionError();
        }
    }

    public int getElibBits() {
        int elibAngle;
        boolean normalEnd;
        int elibBits = this.flags & COMMON_BITS;
        if (!HEAD_EXTENDED.is(this.flags) || !TAIL_EXTENDED.is(this.flags)) {
            elibBits |= 0x20000;
            if (HEAD_EXTENDED.is(this.flags) != TAIL_EXTENDED.is(this.flags)) {
                if (TAIL_EXTENDED.is(this.flags)) {
                    elibBits |= 0x100000;
                }
                if (HEAD_EXTENDED.is(this.flags)) {
                    elibBits |= 0x200000;
                }
            }
        }
        if (HEAD_ARROWED.is(this.flags) || TAIL_ARROWED.is(this.flags) || BODY_ARROWED.is(this.flags)) {
            elibBits |= 0x80000;
            if (TAIL_ARROWED.is(this.flags)) {
                elibBits |= 0x400000;
            }
            if (!HEAD_ARROWED.is(this.flags) && !TAIL_ARROWED.is(this.flags)) {
                elibBits |= 0x200000;
            }
        }
        boolean bl = normalEnd = (elibBits & 0x400000) == 0;
        if (TAIL_NEGATED.is(this.flags)) {
            elibBits |= normalEnd ? 262144 : 65536;
        }
        if (HEAD_NEGATED.is(this.flags)) {
            elibBits |= normalEnd ? 65536 : 262144;
        }
        if ((elibAngle = (this.angle + 5) / 10) >= 360) {
            elibAngle -= 360;
        }
        return elibBits | elibAngle << 5;
    }

    public static int flagsFromElib(int elibBits) {
        int newBits = elibBits & COMMON_BITS;
        if ((elibBits & 0x40000) != 0) {
            newBits |= (elibBits & 0x400000) == 0 ? 262144 : 65536;
        }
        if ((elibBits & 0x10000) != 0) {
            newBits |= (elibBits & 0x400000) == 0 ? 65536 : 262144;
        }
        if ((elibBits & 0x20000) != 0) {
            if ((elibBits & 0x100000) == 0) {
                newBits |= 0x100000;
            }
            if ((elibBits & 0x200000) == 0) {
                newBits |= 0x200000;
            }
        }
        if ((elibBits & 0x80000) != 0) {
            newBits |= 0x4000000;
            if ((elibBits & 0x400000) == 0) {
                if ((elibBits & 0x200000) == 0) {
                    newBits |= 0x80000;
                }
            } else if ((elibBits & 0x100000) == 0) {
                newBits |= 0x2000000;
            }
        }
        return newBits;
    }

    public static int angleFromElib(int elibBits) {
        int angle = (elibBits & 0x3FE0) >> 5;
        return angle % 360 * 10;
    }

    static {
        $assertionsDisabled = !ImmutableArcInst.class.desiredAssertionStatus();
        RIGID = new Flag(1);
        FIXED_ANGLE = new Flag(2);
        SLIDABLE = new FlagInv(0x800000);
        TAIL_ARROWED = new Flag(0x2000000);
        HEAD_ARROWED = new Flag(524288);
        BODY_ARROWED = new Flag(0x4000000);
        TAIL_EXTENDED = new FlagInv(0x100000);
        HEAD_EXTENDED = new FlagInv(0x200000);
        TAIL_NEGATED = new Flag(262144);
        HEAD_NEGATED = new Flag(65536);
        HARD_SELECT = new Flag(Integer.MIN_VALUE);
        COMMON_BITS = -2139095037;
        DATABASE_FLAGS = COMMON_BITS | 0x4000000 | 0x40000 | 0x100000 | 0x2000000 | 0x10000 | 0x200000 | 0x80000;
    }

    private static class FlagInv
    extends Flag {
        private FlagInv(int mask) {
            super(mask);
        }

        public boolean is(int userBits) {
            return !super.is(userBits);
        }

        public int set(int userBits, boolean value) {
            return super.set(userBits, !value);
        }
    }

    public static class Flag {
        private final int mask;

        private Flag(int mask) {
            this.mask = mask;
        }

        public boolean is(int userBits) {
            return (userBits & this.mask) != 0;
        }

        public int set(int userBits, boolean value) {
            return value ? userBits | this.mask : userBits & ~this.mask;
        }
    }
}

