/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.user.Highlighter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RouteElementArc
extends RouteElement {
    private ArcProto arcProto;
    private double arcWidth;
    private RouteElementPort headRE;
    private RouteElementPort tailRE;
    private Point2D headConnPoint;
    private Point2D tailConnPoint;
    private String arcName;
    private TextDescriptor arcNameDescriptor;
    private int arcAngle;
    private ArcInst inheritFrom;
    private ArcInst arcInst;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RouteElementArc(RouteElement.RouteElementAction action, Cell cell) {
        super(action, cell);
    }

    public static RouteElementArc newArc(Cell cell, ArcProto ap, double arcWidth, RouteElementPort headRE, RouteElementPort tailRE, Point2D headConnPoint, Point2D tailConnPoint, String name, TextDescriptor nameTextDescriptor, ArcInst inheritFrom) {
        RouteElementArc e = new RouteElementArc(RouteElement.RouteElementAction.newArc, cell);
        e.arcProto = ap;
        e.arcWidth = arcWidth;
        e.headRE = headRE;
        e.tailRE = tailRE;
        e.arcName = name;
        e.arcNameDescriptor = nameTextDescriptor;
        if (headRE.getAction() != RouteElement.RouteElementAction.newNode && headRE.getAction() != RouteElement.RouteElementAction.existingPortInst) {
            System.out.println("  ERROR: headRE of newArc RouteElementArc must be newNode or existingPortInst");
        }
        if (tailRE.getAction() != RouteElement.RouteElementAction.newNode && tailRE.getAction() != RouteElement.RouteElementAction.existingPortInst) {
            System.out.println("  ERROR: tailRE of newArc RouteElementArc must be newNode or existingPortInst");
        }
        headRE.addConnectingNewArc(e);
        tailRE.addConnectingNewArc(e);
        e.headConnPoint = headConnPoint;
        e.tailConnPoint = tailConnPoint;
        if (!$assertionsDisabled && e.headConnPoint == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && e.tailConnPoint == null) {
            throw new AssertionError();
        }
        e.arcAngle = 0;
        e.arcInst = null;
        e.inheritFrom = inheritFrom;
        return e;
    }

    public static RouteElementArc deleteArc(ArcInst arcInstToDelete) {
        RouteElementArc e = new RouteElementArc(RouteElement.RouteElementAction.deleteArc, arcInstToDelete.getParent());
        e.arcProto = arcInstToDelete.getProto();
        e.arcWidth = arcInstToDelete.getWidth();
        e.headRE = RouteElementPort.existingPortInst(arcInstToDelete.getHeadPortInst(), arcInstToDelete.getHeadLocation());
        e.tailRE = RouteElementPort.existingPortInst(arcInstToDelete.getTailPortInst(), arcInstToDelete.getTailLocation());
        e.arcName = arcInstToDelete.getName();
        e.arcNameDescriptor = arcInstToDelete.getTextDescriptor(ArcInst.ARC_NAME_TD);
        e.headConnPoint = arcInstToDelete.getHeadLocation();
        e.tailConnPoint = arcInstToDelete.getTailLocation();
        e.arcAngle = 0;
        e.arcInst = arcInstToDelete;
        e.inheritFrom = null;
        return e;
    }

    public ArcProto getArcProto() {
        return this.arcProto;
    }

    public RouteElementPort getHead() {
        return this.headRE;
    }

    public RouteElementPort getTail() {
        return this.tailRE;
    }

    public Point2D getHeadConnPoint() {
        return this.headConnPoint;
    }

    public Point2D getTailConnPoint() {
        return this.tailConnPoint;
    }

    public double getArcWidth() {
        return this.arcWidth;
    }

    public double getOffsetArcWidth() {
        return this.arcWidth - this.arcProto.getWidthOffset();
    }

    public void setArcWidth(double width) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            this.arcWidth = width;
        }
    }

    public void setOffsetArcWidth(double width) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            this.arcWidth = width + this.arcProto.getWidthOffset();
        }
    }

    public void setArcAngle(int angle) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            this.arcAngle = angle;
        }
    }

    public boolean isArcVertical() {
        Point2D head = this.headConnPoint;
        Point2D tail = this.tailConnPoint;
        if (head == null) {
            head = this.headRE.getLocation();
        }
        if (tail == null) {
            tail = this.tailRE.getLocation();
        }
        if (head == null || tail == null) {
            return false;
        }
        return head.getX() == tail.getX();
    }

    public boolean isArcHorizontal() {
        Point2D head = this.headConnPoint;
        Point2D tail = this.tailConnPoint;
        if (head == null) {
            head = this.headRE.getLocation();
        }
        if (tail == null) {
            tail = this.tailRE.getLocation();
        }
        if (head == null || tail == null) {
            return false;
        }
        return head.getY() == tail.getY();
    }

    public boolean replaceArcEnd(RouteElementPort oldEnd, RouteElementPort newEnd) {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            Poly poly = newEnd.getConnectingSite();
            if (this.headRE == oldEnd && poly != null && poly.contains(this.headConnPoint)) {
                this.headRE = newEnd;
                oldEnd.removeConnectingNewArc(this);
                newEnd.addConnectingNewArc(this);
            }
            if (this.tailRE == oldEnd && poly != null && poly.contains(this.tailConnPoint)) {
                this.tailRE = newEnd;
                oldEnd.removeConnectingNewArc(this);
                newEnd.addConnectingNewArc(this);
            }
        }
        return this.headRE != oldEnd && this.tailRE != oldEnd;
    }

    public ElectricObject doAction() {
        Job.checkChanging();
        if (this.isDone()) {
            return null;
        }
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            PrimitiveNode pNp;
            Dimension2D autoGrowth;
            NodeInst tailNi;
            NodeProto np;
            PrimitiveNode pNp2;
            Dimension2D autoGrowth2;
            NodeInst headNi;
            NodeProto np2;
            PortInst headPi = this.headRE.getPortInst();
            PortInst tailPi = this.tailRE.getPortInst();
            Point2D headPoint = this.headConnPoint;
            Point2D tailPoint = this.tailConnPoint;
            Poly headPoly = headPi.getPoly();
            if (!headPoly.isInside(headPoint) && (np2 = (headNi = headPi.getNodeInst()).getProto()) instanceof PrimitiveNode && (autoGrowth2 = (pNp2 = (PrimitiveNode)np2).getAutoGrowth()) != null) {
                headNi.modifyInstance(0.0, 0.0, autoGrowth2.getWidth(), autoGrowth2.getHeight(), 0);
            }
            if (!(headPoly = headPi.getPoly()).isInside(headPoint)) {
                Rectangle2D headBounds = headPi.getBounds();
                System.out.println("Arc head (" + headPoint.getX() + "," + headPoint.getY() + ") not inside port " + headPi + " which is " + headBounds.getMinX() + "<=X<=" + headBounds.getMaxX() + " and " + headBounds.getMinY() + "<=Y<=" + headBounds.getMaxY());
                System.out.println("  Arc ran from " + headPi.getNodeInst() + ", port " + headPi.getPortProto().getName() + " to " + tailPi.getNodeInst() + ", port " + tailPi.getPortProto().getName());
                headPoly = headPi.getPoly();
                return null;
            }
            Poly tailPoly = tailPi.getPoly();
            if (!tailPoly.isInside(tailPoint) && (np = (tailNi = tailPi.getNodeInst()).getProto()) instanceof PrimitiveNode && (autoGrowth = (pNp = (PrimitiveNode)np).getAutoGrowth()) != null) {
                tailNi.modifyInstance(0.0, 0.0, autoGrowth.getWidth(), autoGrowth.getHeight(), 0);
            }
            if (!(tailPoly = tailPi.getPoly()).isInside(tailPoint)) {
                Rectangle2D tailBounds = tailPi.getBounds();
                System.out.println("Arc tail (" + tailPoint.getX() + "," + tailPoint.getY() + ") not inside port " + headPi + " which is " + tailBounds.getMinX() + "<=X<=" + tailBounds.getMaxX() + " and " + tailBounds.getMinY() + "<=Y<=" + tailBounds.getMaxY());
                System.out.println("  Arc ran from " + headPi.getNodeInst() + ", port " + headPi.getPortProto().getName() + " to " + tailPi.getNodeInst() + ", port " + tailPi.getPortProto().getName());
                return null;
            }
            ArcInst newAi = ArcInst.makeInstance(this.arcProto, this.arcWidth, headPi, tailPi, headPoint, tailPoint, this.arcName);
            if (newAi == null) {
                return null;
            }
            if (this.arcAngle != 0) {
                newAi.setAngle(this.arcAngle);
            }
            if (this.arcName != null && this.arcNameDescriptor != null) {
                newAi.setTextDescriptor(ArcInst.ARC_NAME_TD, this.arcNameDescriptor);
            }
            this.setDone();
            this.arcInst = newAi;
            this.arcInst.copyPropertiesFrom(this.inheritFrom);
            return newAi;
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteArc) {
            if (this.arcInst.isLinked()) {
                this.arcInst.kill();
            }
            this.setDone();
        }
        return null;
    }

    public void addHighlightArea(Highlighter highlighter) {
        if (!this.isShowHighlight()) {
            return;
        }
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            Point2D.Double tail2;
            Point2D.Double tail1;
            Point2D.Double head2;
            Point2D.Double head1;
            double offsetEnds;
            Point2D headPoint = this.headConnPoint;
            Point2D tailPoint = this.tailConnPoint;
            boolean endsExtend = this.arcProto.isExtended();
            double offset = 0.5 * this.getOffsetArcWidth();
            double d = offsetEnds = endsExtend ? offset : 0.0;
            if (headPoint.getX() == tailPoint.getX()) {
                double offsetY;
                double offsetX;
                if (headPoint.getY() > tailPoint.getY()) {
                    offsetX = offset;
                    offsetY = offsetEnds;
                } else {
                    offsetX = offset;
                    offsetY = -offsetEnds;
                }
                head1 = new Point2D.Double(headPoint.getX() + offsetX, headPoint.getY() + offsetY);
                head2 = new Point2D.Double(headPoint.getX() - offsetX, headPoint.getY() + offsetY);
                tail1 = new Point2D.Double(tailPoint.getX() + offsetX, tailPoint.getY() - offsetY);
                tail2 = new Point2D.Double(tailPoint.getX() - offsetX, tailPoint.getY() - offsetY);
            } else {
                double offsetY;
                double offsetX;
                if (headPoint.getX() > tailPoint.getX()) {
                    offsetX = offsetEnds;
                    offsetY = offset;
                } else {
                    offsetX = -offsetEnds;
                    offsetY = offset;
                }
                head1 = new Point2D.Double(headPoint.getX() + offsetX, headPoint.getY() + offsetY);
                head2 = new Point2D.Double(headPoint.getX() + offsetX, headPoint.getY() - offsetY);
                tail1 = new Point2D.Double(tailPoint.getX() - offsetX, tailPoint.getY() + offsetY);
                tail2 = new Point2D.Double(tailPoint.getX() - offsetX, tailPoint.getY() - offsetY);
            }
            Cell cell = this.getCell();
            highlighter.addLine(head1, tail1, cell);
            highlighter.addLine(head2, tail2, cell);
            highlighter.addLine(head1, head2, cell);
            highlighter.addLine(tail1, tail2, cell);
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteArc) {
            highlighter.addElectricObject(this.arcInst, this.getCell());
        }
    }

    public String toString() {
        if (this.getAction() == RouteElement.RouteElementAction.newArc) {
            return "RouteElementArc-new " + this.arcProto + " width=" + this.arcWidth + ",\n   head: " + this.headRE + "\n   tail: " + this.tailRE;
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteArc) {
            return "RouteElementArc-delete " + this.arcInst;
        }
        return "RouteElement bad action";
    }

    static {
        $assertionsDisabled = !RouteElementArc.class.desiredAssertionStatus();
    }
}

