/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.util.Iterator;

public abstract class NccNameProxy {
    private String commonPathPrefix;

    public static String removePrefix(String commonPathPrefix, String fullName) {
        if (commonPathPrefix.length() == 0) {
            return fullName;
        }
        LayoutLib.error(!fullName.startsWith(commonPathPrefix), "common path prefix not found");
        int start = commonPathPrefix.length() + 1;
        if (start > fullName.length() - 1) {
            return "";
        }
        return fullName.substring(start);
    }

    public String toString() {
        LayoutLib.error(true, "Please tell Russell about this use of toString");
        return null;
    }

    abstract HierarchyEnumerator.NameProxy nameProxy();

    NccNameProxy(String commonPathPrefix) {
        this.commonPathPrefix = commonPathPrefix;
    }

    public boolean nameIsInTopContext() {
        return this.nameProxy().getContext() == VarContext.globalContext;
    }

    public Cell leafCell() {
        return this.nameProxy().leafCell();
    }

    public String leafName() {
        return this.nameProxy().leafName();
    }

    public String getName() {
        return NccNameProxy.removePrefix(this.commonPathPrefix, this.nameProxy().toString());
    }

    public String cellInstPath() {
        return NccNameProxy.removePrefix(this.commonPathPrefix, this.nameProxy().getContext().getInstPath("/"));
    }

    public static class WireNameProxy
    extends NccNameProxy {
        HierarchyEnumerator.NetNameProxy nameProxy;

        HierarchyEnumerator.NameProxy nameProxy() {
            return this.nameProxy;
        }

        public WireNameProxy(HierarchyEnumerator.NetNameProxy nameProxy, String commonPathPrefix) {
            super(commonPathPrefix);
            this.nameProxy = nameProxy;
        }

        public HierarchyEnumerator.NetNameProxy getNetNameProxy() {
            return this.nameProxy;
        }

        public Iterator getNetNames() {
            return this.nameProxy.leafNames();
        }
    }

    public static class PartNameProxy
    extends NccNameProxy {
        private HierarchyEnumerator.NodableNameProxy nameProxy;

        HierarchyEnumerator.NameProxy nameProxy() {
            return this.nameProxy;
        }

        public PartNameProxy(HierarchyEnumerator.NodableNameProxy nameProxy, String commonPathPrefix) {
            super(commonPathPrefix);
            this.nameProxy = nameProxy;
        }
    }
}

