/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.logicaleffort;

import com.sun.electric.database.network.Network;
import com.sun.electric.tool.logicaleffort.LENodable;
import java.util.ArrayList;
import java.util.List;

public class LEPin {
    private Dir dir;
    private float le;
    private String name;
    private Network net;
    private LENodable instance;

    protected LEPin(String name, Dir dir, float le, Network net, LENodable instance) {
        this.name = name;
        this.dir = dir;
        this.le = le;
        this.net = net;
        this.instance = instance;
    }

    protected Dir getDir() {
        return this.dir;
    }

    protected String getName() {
        return this.name;
    }

    protected float getLE() {
        return this.le;
    }

    protected LENodable getInstance() {
        return this.instance;
    }

    protected Network getNetwork() {
        return this.net;
    }

    protected static ArrayList getPinListType(List pins, Dir dir) {
        ArrayList<LEPin> typepins = new ArrayList<LEPin>();
        for (int i = 0; i < pins.size(); ++i) {
            if (((LEPin)pins.get(i)).getDir() != dir) continue;
            typepins.add((LEPin)pins.get(i));
        }
        return typepins;
    }

    protected static ArrayList getInoutPins(List pins) {
        return LEPin.getPinListType(pins, Dir.INOUT);
    }

    protected static ArrayList getInputPins(List pins) {
        return LEPin.getPinListType(pins, Dir.INPUT);
    }

    protected static ArrayList getOutputPins(List pins) {
        return LEPin.getPinListType(pins, Dir.OUTPUT);
    }

    protected static class Dir {
        private final String name;
        protected static final Dir INPUT = new Dir("input");
        protected static final Dir OUTPUT = new Dir("output");
        protected static final Dir INOUT = new Dir("inout");
        protected static final Dir NODIR = new Dir("nodir");

        private Dir(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

