/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class StatusBar
extends JPanel
implements HighlightListener {
    private WindowFrame frame;
    private String coords = null;
    public JLabel fieldSelected;
    public JLabel fieldSize;
    public JLabel fieldTech;
    public JLabel fieldCoords;
    private static String selectionOverride = null;

    public StatusBar(WindowFrame frame) {
        super(new GridLayout());
        this.setBorder(new BevelBorder(1));
        this.frame = frame;
        this.fieldSelected = new JLabel();
        this.addField(this.fieldSelected, 0);
        this.fieldSize = new JLabel();
        this.addField(this.fieldSize, 1);
        this.fieldTech = new JLabel();
        this.addField(this.fieldTech, 2);
        this.fieldCoords = new JLabel();
        if (User.isShowCursorCoordinates()) {
            this.addField(this.fieldCoords, 3);
        }
        Highlight.addHighlightListener(this);
    }

    private void addField(JLabel field, int index) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = index;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        this.add((Component)field, gbc);
    }

    public static void setShowCoordinates(boolean show) {
        User.setShowCursorCoordinates(show);
        if (TopLevel.isMDIMode()) {
            StatusBar sb = TopLevel.getCurrentJFrame().getStatusBar();
            if (show) {
                sb.addField(sb.fieldCoords, 3);
            } else {
                sb.remove(sb.fieldCoords);
            }
        } else {
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                StatusBar sb = wf.getFrame().getStatusBar();
                if (show) {
                    sb.addField(sb.fieldCoords, 3);
                    continue;
                }
                sb.remove(sb.fieldCoords);
            }
        }
        StatusBar.updateStatusBar();
    }

    public static void setCoordinates(String coords, WindowFrame wf) {
        StatusBar sb = null;
        sb = TopLevel.isMDIMode() ? TopLevel.getCurrentJFrame().getStatusBar() : wf.getFrame().getStatusBar();
        sb.coords = coords;
        sb.redoStatusBar();
    }

    public static void setSelectionOverride(String ov) {
        selectionOverride = ov;
        StatusBar.updateStatusBar();
    }

    public void highlightChanged() {
        this.updateSelectedText();
    }

    public static void updateStatusBar() {
        if (TopLevel.isMDIMode()) {
            StatusBar sb = TopLevel.getCurrentJFrame().getStatusBar();
            sb.redoStatusBar();
        } else {
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                StatusBar sb = wf.getFrame().getStatusBar();
                sb.redoStatusBar();
            }
        }
    }

    private void redoStatusBar() {
        this.updateSelectedText();
        Cell cell = null;
        if (this.frame == null) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null) {
                cell = wf.getContent().getCell();
            }
        } else {
            Cell cellInPanel = this.frame.getContent().getCell();
            if (cellInPanel != null) {
                cell = cellInPanel;
            }
        }
        String sizeMsg = "";
        if (cell != null) {
            if (cell.getView().isTextView()) {
                int len = 0;
                String[] textLines = cell.getTextViewContents();
                if (textLines != null) {
                    len = textLines.length;
                }
                sizeMsg = "LINES: " + len;
            } else {
                Rectangle2D bounds = cell.getBounds();
                sizeMsg = "SIZE: " + TextUtils.formatDouble(bounds.getWidth(), 1) + "x" + TextUtils.formatDouble(bounds.getHeight(), 1);
            }
        }
        this.fieldSize.setText(sizeMsg);
        Technology tech = Technology.getCurrent();
        if (tech != null) {
            String message = "TECHNOLOGY: " + tech.getTechName();
            if (tech.isScaleRelevant()) {
                message = message + " (scale=" + tech.getScale() + "nm)";
            }
            this.fieldTech.setText(message);
        }
        if (this.coords == null) {
            this.fieldCoords.setText("");
        } else {
            this.fieldCoords.setText(this.coords);
        }
    }

    private void updateSelectedText() {
        String selectedMsg = "NOTHING SELECTED";
        if (selectionOverride != null) {
            selectedMsg = selectionOverride;
        } else {
            int nodeCount = 0;
            int arcCount = 0;
            int textCount = 0;
            Highlight lastHighlight = null;
            Iterator hIt = Highlight.getHighlights();
            while (hIt.hasNext()) {
                Highlight h = (Highlight)hIt.next();
                if (h.getType() == Highlight.Type.EOBJ) {
                    ElectricObject eObj = h.getElectricObject();
                    if (eObj instanceof PortInst) {
                        lastHighlight = h;
                        ++nodeCount;
                        continue;
                    }
                    if (eObj instanceof NodeInst) {
                        lastHighlight = h;
                        ++nodeCount;
                        continue;
                    }
                    if (!(eObj instanceof ArcInst)) continue;
                    lastHighlight = h;
                    ++arcCount;
                    continue;
                }
                if (h.getType() != Highlight.Type.TEXT) continue;
                lastHighlight = h;
                ++textCount;
            }
            if (nodeCount + arcCount + textCount == 1) {
                selectedMsg = "SELECTED " + this.getSelectedText(lastHighlight);
            } else if (nodeCount + arcCount + textCount > 0) {
                StringBuffer buf = new StringBuffer();
                buf.append("SELECTED:");
                if (nodeCount > 0) {
                    buf.append(" " + nodeCount + " NODES");
                }
                if (arcCount > 0) {
                    if (nodeCount > 0) {
                        buf.append(",");
                    }
                    buf.append(" " + arcCount + " ARCS");
                }
                if (textCount > 0) {
                    if (nodeCount + arcCount > 0) {
                        buf.append(",");
                    }
                    buf.append(" " + textCount + " TEXT");
                }
                buf.append(". LAST: " + this.getSelectedText(lastHighlight));
                selectedMsg = buf.toString();
            }
        }
        this.fieldSelected.setText(selectedMsg);
    }

    private String getSelectedText(Highlight h) {
        if (h.getType() == Highlight.Type.EOBJ) {
            ElectricObject eObj = h.getElectricObject();
            if (eObj instanceof PortInst) {
                PortInst thePort = (PortInst)eObj;
                NodeInst theNode = thePort.getNodeInst();
                return "NODE: " + theNode.describe() + " PORT: \"" + thePort.getPortProto().getName() + "\"";
            }
            if (eObj instanceof NodeInst) {
                NodeInst theNode = (NodeInst)eObj;
                return "NODE: " + theNode.describe();
            }
            if (eObj instanceof ArcInst) {
                ArcInst theArc = (ArcInst)eObj;
                return "ARC: " + theArc.describe();
            }
        } else if (h.getType() == Highlight.Type.TEXT) {
            if (h.getVar() != null) {
                return "TEXT: " + h.getVar().getFullDescription(h.getElectricObject());
            }
            if (h.getName() != null) {
                if (h.getElectricObject() instanceof NodeInst) {
                    return "TEXT: Node name";
                }
                return "TEXT: Arc name";
            }
            if (h.getElectricObject() instanceof Export) {
                return "TEXT: Export name";
            }
            return "TEXT: Cell instance name";
        }
        return null;
    }

    public void finished() {
        Highlight.removeHighlightListener(this);
    }
}

