/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.gates.Inv;
import com.sun.electric.tool.generator.layout.gates.Inv2i;
import com.sun.electric.tool.generator.layout.gates.Inv2iKn;
import com.sun.electric.tool.generator.layout.gates.Inv2iKp;
import com.sun.electric.tool.generator.layout.gates.InvCLK;
import com.sun.electric.tool.generator.layout.gates.InvCTLn;
import com.sun.electric.tool.generator.layout.gates.InvHT;
import com.sun.electric.tool.generator.layout.gates.InvLT;
import com.sun.electric.tool.generator.layout.gates.Inv_passgate;
import com.sun.electric.tool.generator.layout.gates.Nand2;
import com.sun.electric.tool.generator.layout.gates.Nand2HLT;
import com.sun.electric.tool.generator.layout.gates.Nand2HLT_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2LT;
import com.sun.electric.tool.generator.layout.gates.Nand2LT_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2PH;
import com.sun.electric.tool.generator.layout.gates.Nand2PHfk;
import com.sun.electric.tool.generator.layout.gates.Nand2_sy;
import com.sun.electric.tool.generator.layout.gates.Nand2en;
import com.sun.electric.tool.generator.layout.gates.Nand2en_sy;
import com.sun.electric.tool.generator.layout.gates.Nand3;
import com.sun.electric.tool.generator.layout.gates.Nand3LT;
import com.sun.electric.tool.generator.layout.gates.Nand3LT_sy3;
import com.sun.electric.tool.generator.layout.gates.Nand3MLT;
import com.sun.electric.tool.generator.layout.gates.Nand3_sy3;
import com.sun.electric.tool.generator.layout.gates.Nand3en_sy;
import com.sun.electric.tool.generator.layout.gates.Nand3en_sy3;
import com.sun.electric.tool.generator.layout.gates.Nms1;
import com.sun.electric.tool.generator.layout.gates.Nms2;
import com.sun.electric.tool.generator.layout.gates.Nms2_sy;
import com.sun.electric.tool.generator.layout.gates.Nms3_sy3;
import com.sun.electric.tool.generator.layout.gates.Nor2;
import com.sun.electric.tool.generator.layout.gates.Nor2LT;
import com.sun.electric.tool.generator.layout.gates.Nor2kresetV;
import com.sun.electric.tool.generator.layout.gates.Pms1;
import com.sun.electric.tool.generator.layout.gates.Pms2;
import com.sun.electric.tool.generator.layout.gates.Pms2_sy;
import java.util.HashSet;

class GenerateLayoutForGatesInSchematic
extends HierarchyEnumerator.Visitor {
    private final StdCellParams stdCell;
    private final StdCellParams stdCellPwr;
    private final HashSet visitedCells = new HashSet();

    public GenerateLayoutForGatesInSchematic(StdCellParams stdCell, StdCellParams stdCellPwr) {
        this.stdCell = stdCell;
        this.stdCellPwr = stdCellPwr;
    }

    private static double getNumericVal(Object val) {
        if (val == null) {
            return -1.0;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        LayoutLib.error(true, "not a numeric value: " + val);
        return 0.0;
    }

    private void generateCell(Nodable iconInst, VarContext context) {
        String pNm = iconInst.getProto().getName();
        Variable var = iconInst.getVar("ATTR_X");
        double x = GenerateLayoutForGatesInSchematic.getNumericVal(context.evalVar(var, iconInst));
        if (x == -1.0) {
            return;
        }
        StdCellParams sc = this.stdCell;
        boolean unknown = false;
        int pwr = pNm.indexOf("_pwr");
        if (pwr != -1) {
            pNm = pNm.substring(0, pwr);
            sc = this.stdCellPwr;
        }
        if (pNm.equals("nms1")) {
            Nms1.makePart(x, sc);
        } else if (pNm.equals("nms1K")) {
            Nms1.makePart(x, sc);
        } else if (pNm.equals("nms2")) {
            Nms2.makePart(x, sc);
        } else if (pNm.equals("nms2_sy")) {
            Nms2_sy.makePart(x, sc);
        } else if (pNm.equals("nms3_sy3")) {
            Nms3_sy3.makePart(x, sc);
        } else if (pNm.equals("pms1")) {
            Pms1.makePart(x, sc);
        } else if (pNm.equals("pms1K")) {
            Pms1.makePart(x, sc);
        } else if (pNm.equals("pms2")) {
            Pms2.makePart(x, sc);
        } else if (pNm.equals("pms2_sy")) {
            Pms2_sy.makePart(x, sc);
        } else if (pNm.equals("inv")) {
            Inv.makePart(x, sc);
        } else if (pNm.equals("invCTLn")) {
            InvCTLn.makePart(x, sc);
        } else if (pNm.equals("inv_passgate")) {
            Inv_passgate.makePart(x, sc);
        } else if (pNm.equals("inv2i")) {
            Inv2i.makePart(x, sc);
        } else if (pNm.equals("inv2iKp")) {
            Inv2iKp.makePart(x, sc);
        } else if (pNm.equals("inv2iKn")) {
            Inv2iKn.makePart(x, sc);
        } else if (pNm.equals("invLT")) {
            InvLT.makePart(x, sc);
        } else if (pNm.equals("invHT")) {
            InvHT.makePart(x, sc);
        } else if (pNm.equals("invCLK")) {
            InvCLK.makePart(x, sc);
        } else if (pNm.equals("nand2")) {
            Nand2.makePart(x, sc);
        } else if (pNm.equals("nand2k")) {
            Nand2.makePart(x, sc);
        } else if (pNm.equals("nand2en")) {
            Nand2en.makePart(x, sc);
        } else if (pNm.equals("nand2en_sy")) {
            Nand2en_sy.makePart(x, sc);
        } else if (pNm.equals("nand2HLT")) {
            Nand2HLT.makePart(x, sc);
        } else if (pNm.equals("nand2LT")) {
            Nand2LT.makePart(x, sc);
        } else if (pNm.equals("nand2_sy")) {
            Nand2_sy.makePart(x, sc);
        } else if (pNm.equals("nand2HLT_sy")) {
            Nand2HLT_sy.makePart(x, sc);
        } else if (pNm.equals("nand2LT_sy")) {
            Nand2LT_sy.makePart(x, sc);
        } else if (pNm.equals("nand2PH")) {
            Nand2PH.makePart(x, sc);
        } else if (pNm.equals("nand2PHfk")) {
            Nand2PHfk.makePart(x, sc);
        } else if (pNm.equals("nand3")) {
            Nand3.makePart(x, sc);
        } else if (pNm.equals("nand3MLT")) {
            Nand3MLT.makePart(x, sc);
        } else if (pNm.equals("nand3LT")) {
            Nand3LT.makePart(x, sc);
        } else if (pNm.equals("nand3_sy3")) {
            Nand3_sy3.makePart(x, sc);
        } else if (pNm.equals("nand3en_sy")) {
            Nand3en_sy.makePart(x, sc);
        } else if (pNm.equals("nand3LT_sy3")) {
            Nand3LT_sy3.makePart(x, sc);
        } else if (pNm.equals("nand3en_sy3")) {
            Nand3en_sy3.makePart(x, sc);
        } else if (pNm.equals("nor2")) {
            Nor2.makePart(x, sc);
        } else if (pNm.equals("nor2LT")) {
            Nor2LT.makePart(x, sc);
        } else if (pNm.equals("nor2kresetV")) {
            Nor2kresetV.makePart(x, sc);
        } else {
            unknown = true;
        }
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        if (this.visitedCells.contains(cell)) {
            return false;
        }
        this.visitedCells.add(cell);
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        if (no instanceof NodeInst) {
            return false;
        }
        Cell cell = (Cell)no.getProto();
        Library lib = cell.getLibrary();
        String libNm = lib.getName();
        if (libNm.equals("redFour") || libNm.equals("power2_gates")) {
            this.generateCell(no, info.getContext());
            return false;
        }
        return true;
    }
}

