/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.services.MarkupRenderer;
import org.apache.tapestry5.services.MarkupRendererFilter;

public class ConfigureHTMLElementFilter
implements MarkupRendererFilter {
    private final ThreadLocale threadLocale;
    private final boolean debugEnabled;

    public ConfigureHTMLElementFilter(ThreadLocale threadLocale, @Symbol(value="tapestry.production-mode") boolean productionMode) {
        this.threadLocale = threadLocale;
        this.debugEnabled = !productionMode;
    }

    @Override
    public void renderMarkup(MarkupWriter writer, MarkupRenderer renderer) {
        renderer.renderMarkup(writer);
        Element html = writer.getDocument().find("html");
        if (html != null) {
            html.attributes("data-locale", this.threadLocale.getLocale().toString());
            if (this.debugEnabled) {
                html.attributes("data-debug-enabled", "true");
            }
        }
    }
}

