/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.tapestry5.http.services.Dispatcher;
import org.apache.tapestry5.http.services.Request;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.rest.OpenApiDescriptionGenerator;

public class OpenApiDescriptionDispatcher
implements Dispatcher {
    private final String path;
    private final OpenApiDescriptionGenerator openApiDescriptionGenerator;
    private byte[] cachedDescription;
    private final boolean productionMode;

    public OpenApiDescriptionDispatcher(@Symbol(value="tapestry.openapi-description-path") String path, OpenApiDescriptionGenerator openApiDescriptionGenerator, @Symbol(value="tapestry.production-mode") boolean productionMode) {
        this.path = path;
        this.openApiDescriptionGenerator = openApiDescriptionGenerator;
        this.productionMode = productionMode;
    }

    public boolean dispatch(Request request, Response response) throws IOException {
        boolean dispatched = false;
        if (this.path.equals(request.getPath())) {
            byte[] description = this.getDescriptionAsByteArray();
            response.setContentLength(description.length);
            response.getOutputStream("application/json").write(description);
            dispatched = true;
        }
        return dispatched;
    }

    private byte[] getDescriptionAsByteArray() {
        byte[] bytes;
        if (this.productionMode && this.cachedDescription != null) {
            bytes = this.cachedDescription;
        } else {
            bytes = this.openApiDescriptionGenerator.generate(new JSONObject()).toCompactString().getBytes(Charset.forName("UTF-8"));
            if (this.productionMode) {
                this.cachedDescription = bytes;
            }
        }
        return bytes;
    }
}

