/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.kaptcha.components;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.kaptcha.components.KaptchaImage;
import org.apache.tapestry5.services.FieldValidatorSource;

@SupportsInformalParameters
@Import(stylesheet={"kaptcha.css"})
public class KaptchaField
extends AbstractField {
    @Parameter(required=true, defaultPrefix="component")
    private KaptchaImage image;
    @Parameter(value="symbol:tapestry.kaptcha-default-visible")
    private boolean visible;
    @Inject
    private Messages messages;
    @Inject
    private FieldValidatorSource fieldValidatorSource;

    public boolean isRequired() {
        return true;
    }

    protected void processSubmission(String controlName) {
        String userValue = this.request.getParameter(controlName);
        this.validationTracker.recordInput((Field)this, userValue);
        if (TapestryInternalUtils.isEqual((Object)this.image.getCaptchaText(), (Object)userValue)) {
            return;
        }
        this.validationTracker.recordError((Field)this, this.messages.get("tapestry-incorrect-captcha"));
    }

    boolean beginRender(MarkupWriter writer) {
        writer.element("input", new Object[]{"type", this.visible ? "text" : "password", "id", this.getClientId(), "class", "form-control", "name", this.getControlName(), "value", this.visible ? this.validationTracker.getInput((Field)this) : ""});
        this.resources.renderInformalParameters(writer);
        FieldValidator fieldValidator = this.fieldValidatorSource.createValidator((Field)this, "required", null);
        fieldValidator.render(writer);
        writer.end();
        return false;
    }
}

