/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services.pageload;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.internal.services.ComponentDependencyRegistry;
import org.apache.tapestry5.internal.services.InternalComponentInvalidationEventHub;
import org.apache.tapestry5.ioc.annotations.ComponentClasses;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.pageload.PageClassLoaderContext;
import org.apache.tapestry5.services.pageload.PageClassLoaderContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageClassLoaderContextManagerImpl
implements PageClassLoaderContextManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageClassLoaderContextManager.class);
    private final ComponentDependencyRegistry componentDependencyRegistry;
    private final ComponentClassResolver componentClassResolver;
    private final InternalComponentInvalidationEventHub invalidationHub;
    private final InvalidationEventHub componentClassesInvalidationEventHub;
    private final boolean multipleClassLoaders;
    private static final ThreadLocal<Integer> NESTED_MERGE_COUNT = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<Boolean> INVALIDATING_CONTEXT = ThreadLocal.withInitial(() -> false);
    private static final AtomicInteger MERGED_COUNTER = new AtomicInteger(1);
    private Function<ClassLoader, PlasticProxyFactory> plasticProxyFactoryProvider;
    private PageClassLoaderContext root;

    public PageClassLoaderContextManagerImpl(ComponentDependencyRegistry componentDependencyRegistry, ComponentClassResolver componentClassResolver, InternalComponentInvalidationEventHub invalidationHub, @ComponentClasses InvalidationEventHub componentClassesInvalidationEventHub, @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassLoaders) {
        this.componentDependencyRegistry = componentDependencyRegistry;
        this.componentClassResolver = componentClassResolver;
        this.invalidationHub = invalidationHub;
        this.componentClassesInvalidationEventHub = componentClassesInvalidationEventHub;
        this.multipleClassLoaders = multipleClassLoaders;
        invalidationHub.addInvalidationCallback(this::listen);
        NESTED_MERGE_COUNT.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateUnknownContext() {
        PageClassLoaderContextManagerImpl pageClassLoaderContextManagerImpl = this;
        synchronized (pageClassLoaderContextManagerImpl) {
            this.markAsNotInvalidatingContext();
            for (PageClassLoaderContext context : this.root.getChildren()) {
                if (!context.isUnknown()) continue;
                this.invalidateAndFireInvalidationEvents(context);
                break;
            }
        }
    }

    @Override
    public void initialize(PageClassLoaderContext root, Function<ClassLoader, PlasticProxyFactory> plasticProxyFactoryProvider) {
        if (this.root != null) {
            throw new IllegalStateException("PageClassloaderContextManager.initialize() can only be called once");
        }
        Objects.requireNonNull(root);
        Objects.requireNonNull(plasticProxyFactoryProvider);
        this.root = root;
        this.plasticProxyFactoryProvider = plasticProxyFactoryProvider;
        if (this.multipleClassLoaders) {
            LOGGER.debug("Root context: {}", (Object)root);
        }
    }

    @Override
    public PageClassLoaderContext get(String className) {
        String enclosingClassName = PlasticUtils.getEnclosingClassName((String)className);
        PageClassLoaderContext context = this.root.findByClassName(enclosingClassName);
        if (context == null) {
            HashSet<String> classesToInvalidate = new HashSet<String>();
            context = this.processUsingDependencies(enclosingClassName, this.root, () -> this.getUnknownContext(this.root, this.plasticProxyFactoryProvider), this.plasticProxyFactoryProvider, classesToInvalidate);
            if (!classesToInvalidate.isEmpty()) {
                this.invalidate(classesToInvalidate);
            }
            if (!className.equals(enclosingClassName)) {
                this.loadClass(className, context);
            }
        }
        return context;
    }

    private PageClassLoaderContext getUnknownContext(PageClassLoaderContext root, Function<ClassLoader, PlasticProxyFactory> plasticProxyFactoryProvider) {
        PageClassLoaderContext unknownContext = null;
        for (PageClassLoaderContext child : root.getChildren()) {
            if (!child.getName().equals("unknown")) continue;
            unknownContext = child;
            break;
        }
        if (unknownContext == null) {
            unknownContext = new PageClassLoaderContext("unknown", root, Collections.emptySet(), plasticProxyFactoryProvider.apply(root.getClassLoader()), this::get);
            root.addChild(unknownContext);
            if (this.multipleClassLoaders) {
                LOGGER.debug("Unknown context: {}", (Object)unknownContext);
            }
        }
        return unknownContext;
    }

    private PageClassLoaderContext processUsingDependencies(String className, PageClassLoaderContext root, Supplier<PageClassLoaderContext> unknownContextProvider, Function<ClassLoader, PlasticProxyFactory> plasticProxyFactoryProvider, Set<String> classesToInvalidate) {
        return this.processUsingDependencies(className, root, unknownContextProvider, plasticProxyFactoryProvider, classesToInvalidate, new HashSet<String>());
    }

    private PageClassLoaderContext processUsingDependencies(String className, PageClassLoaderContext root, Supplier<PageClassLoaderContext> unknownContextProvider, Function<ClassLoader, PlasticProxyFactory> plasticProxyFactoryProvider, Set<String> classesToInvalidate, Set<String> alreadyProcessed) {
        return this.processUsingDependencies(className, root, unknownContextProvider, plasticProxyFactoryProvider, classesToInvalidate, alreadyProcessed, true);
    }

    /*
     * WARNING - void declaration
     */
    private PageClassLoaderContext processUsingDependencies(String className, PageClassLoaderContext root, Supplier<PageClassLoaderContext> unknownContextProvider, Function<ClassLoader, PlasticProxyFactory> plasticProxyFactoryProvider, Set<String> classesToInvalidate, Set<String> alreadyProcessed, boolean processCircularDependencies) {
        PageClassLoaderContext context = root.findByClassName(className);
        if (context == null) {
            if (!root.getPlasticManager().shouldInterceptClassLoading(className)) {
                context = root;
            } else if (!this.componentDependencyRegistry.contains(className) || !this.multipleClassLoaders) {
                context = unknownContextProvider.get();
            } else {
                alreadyProcessed.add(className);
                ArrayList<String> dependencies = new ArrayList<String>(this.getDependenciesWithoutPages(className));
                Collections.sort(dependencies);
                for (String string : dependencies) {
                    if (alreadyProcessed.contains(string)) continue;
                    this.processUsingDependencies(string, root, unknownContextProvider, plasticProxyFactoryProvider, classesToInvalidate, alreadyProcessed, false);
                }
                HashSet<PageClassLoaderContext> contextDependencies = new HashSet<PageClassLoaderContext>();
                for (String dependency : dependencies) {
                    PageClassLoaderContext dependencyContext = root.findByClassName(dependency);
                    if (dependencyContext == null) {
                        dependencyContext = this.processUsingDependencies(dependency, root, unknownContextProvider, plasticProxyFactoryProvider, classesToInvalidate, alreadyProcessed);
                    }
                    if (dependencyContext.isRoot()) continue;
                    contextDependencies.add(dependencyContext);
                }
                if (contextDependencies.size() == 0) {
                    context = new PageClassLoaderContext(this.getContextName(className), root, Collections.singleton(className), plasticProxyFactoryProvider.apply(root.getClassLoader()), this::get);
                } else {
                    void var11_15;
                    if (contextDependencies.size() == 1) {
                        PageClassLoaderContext pageClassLoaderContext = (PageClassLoaderContext)contextDependencies.iterator().next();
                    } else {
                        PageClassLoaderContext pageClassLoaderContext = this.merge(contextDependencies, plasticProxyFactoryProvider, root, classesToInvalidate);
                    }
                    context = new PageClassLoaderContext(this.getContextName(className), (PageClassLoaderContext)var11_15, Collections.singleton(className), plasticProxyFactoryProvider.apply(var11_15.getClassLoader()), this::get);
                }
                context.getParent().addChild(context);
                if (!this.componentClassResolver.isPage(className) || this.componentDependencyRegistry.getDependencies(className, ComponentDependencyRegistry.DependencyType.USAGE).isEmpty()) {
                    this.loadClass(className, context);
                }
                LOGGER.debug("New context: {}", (Object)context);
            }
        }
        context.addClass(className);
        return context;
    }

    private Set<String> getDependenciesWithoutPages(String className) {
        HashSet<String> dependencies = new HashSet<String>();
        dependencies.addAll(this.componentDependencyRegistry.getDependencies(className, ComponentDependencyRegistry.DependencyType.USAGE));
        dependencies.addAll(this.componentDependencyRegistry.getDependencies(className, ComponentDependencyRegistry.DependencyType.SUPERCLASS));
        return Collections.unmodifiableSet(dependencies);
    }

    private Class<?> loadClass(String className, PageClassLoaderContext context) {
        try {
            ClassLoader classLoader = context.getPlasticManager().getClassLoader();
            return classLoader.loadClass(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PageClassLoaderContext merge(Set<PageClassLoaderContext> contextDependencies, Function<ClassLoader, PlasticProxyFactory> plasticProxyFactoryProvider, PageClassLoaderContext root, Set<String> classesToInvalidate) {
        PageClassLoaderContext parent;
        NESTED_MERGE_COUNT.set(NESTED_MERGE_COUNT.get() + 1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Nested merge count going up to {}", (Object)NESTED_MERGE_COUNT.get());
            StringBuilder builder = new StringBuilder();
            builder.append("Merging the following page classloader contexts into one:\n");
            for (PageClassLoaderContext context : contextDependencies) {
                String classes = context.getClassNames().stream().map(this::getContextName).sorted().collect(Collectors.joining(", "));
                builder.append(String.format("\t%s (parent %s) (%s)\n", context.getName(), context.getParent().getName(), classes));
            }
            LOGGER.debug(builder.toString().trim());
        }
        HashSet<PageClassLoaderContext> allContextsIncludingDescendents = new HashSet<PageClassLoaderContext>();
        for (PageClassLoaderContext context : contextDependencies) {
            allContextsIncludingDescendents.add(context);
            allContextsIncludingDescendents.addAll(context.getDescendents());
        }
        HashSet<PageClassLoaderContext> furtherDependencies = new HashSet<PageClassLoaderContext>();
        HashSet<String> classNames = new HashSet<String>();
        for (PageClassLoaderContext context : contextDependencies) {
            PageClassLoaderContext parent2;
            if (!context.isRoot()) {
                classNames.addAll(context.getClassNames());
            }
            if ((parent2 = context.getParent()).isRoot() || allContextsIncludingDescendents.contains(parent2)) continue;
            furtherDependencies.add(parent2);
        }
        List<PageClassLoaderContext> contextsToInvalidate = contextDependencies.stream().filter(c -> !c.isRoot()).collect(Collectors.toList());
        if (!contextsToInvalidate.isEmpty()) {
            classesToInvalidate.addAll(this.invalidate(contextsToInvalidate.toArray(new PageClassLoaderContext[contextsToInvalidate.size()])));
        }
        if (furtherDependencies.size() == 0) {
            parent = root;
        } else if (furtherDependencies.size() == 1) {
            parent = (PageClassLoaderContext)furtherDependencies.iterator().next();
        } else {
            parent = this.merge(furtherDependencies, plasticProxyFactoryProvider, root, classesToInvalidate);
            LOGGER.debug("New context: {}", (Object)parent);
        }
        PageClassLoaderContext merged = new PageClassLoaderContext("merged " + MERGED_COUNTER.getAndIncrement(), parent, classNames, plasticProxyFactoryProvider.apply(parent.getClassLoader()), this::get);
        parent.addChild(merged);
        NESTED_MERGE_COUNT.set(NESTED_MERGE_COUNT.get() - 1);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Nested merge count going down to {}", (Object)NESTED_MERGE_COUNT.get());
        }
        return merged;
    }

    @Override
    public void clear(String className) {
        PageClassLoaderContext context = this.root.findByClassName(className);
        if (context != null) {
            this.invalidate(context);
        }
    }

    private String getContextName(String className) {
        String contextName = this.componentClassResolver.getLogicalName(className);
        if (contextName == null) {
            contextName = className;
        }
        return contextName;
    }

    @Override
    public Set<String> invalidate(PageClassLoaderContext ... contexts) {
        HashSet<String> classNames = new HashSet<String>();
        for (PageClassLoaderContext context : contexts) {
            this.addClassNames(context, classNames);
            context.invalidate();
            if (context.getParent() == null) continue;
            context.getParent().removeChild(context);
        }
        return classNames;
    }

    private List<String> listen(List<String> resources) {
        List<String> returnValue;
        if (!this.multipleClassLoaders) {
            for (PageClassLoaderContext context : this.root.getChildren()) {
                context.invalidate();
            }
            returnValue = Collections.emptyList();
        } else if (INVALIDATING_CONTEXT.get().booleanValue()) {
            returnValue = Collections.emptyList();
        } else {
            HashSet<PageClassLoaderContext> contextsToInvalidate = new HashSet<PageClassLoaderContext>();
            for (String resource : resources) {
                PageClassLoaderContext context = this.root.findByClassName(resource);
                if (context == null || context.isRoot()) continue;
                contextsToInvalidate.add(context);
            }
            Set<String> furtherResources = this.invalidate(contextsToInvalidate.toArray(new PageClassLoaderContext[contextsToInvalidate.size()]));
            furtherResources.removeAll(resources);
            returnValue = new ArrayList<String>(furtherResources);
        }
        return returnValue;
    }

    @Override
    public void invalidateAndFireInvalidationEvents(PageClassLoaderContext ... contexts) {
        this.markAsInvalidatingContext();
        if (this.multipleClassLoaders) {
            Set<String> classNames = this.invalidate(contexts);
            this.invalidate(classNames);
        } else {
            this.invalidate(Collections.EMPTY_SET);
        }
        this.markAsNotInvalidatingContext();
    }

    private void markAsNotInvalidatingContext() {
        INVALIDATING_CONTEXT.set(false);
    }

    private void markAsInvalidatingContext() {
        INVALIDATING_CONTEXT.set(true);
    }

    private void invalidate(Set<String> classesToInvalidate) {
        if (!classesToInvalidate.isEmpty()) {
            LOGGER.debug("Invalidating classes {}", classesToInvalidate);
            this.markAsInvalidatingContext();
            ArrayList<String> classesToInvalidateAsList = new ArrayList<String>(classesToInvalidate);
            this.componentDependencyRegistry.disableInvalidations();
            try {
                this.invalidationHub.fireInvalidationEvent(classesToInvalidateAsList);
                this.componentClassesInvalidationEventHub.fireInvalidationEvent(classesToInvalidateAsList);
                this.markAsNotInvalidatingContext();
            }
            finally {
                this.componentDependencyRegistry.enableInvalidations();
            }
        }
    }

    private void addClassNames(PageClassLoaderContext context, Set<String> classNames) {
        classNames.addAll(context.getClassNames());
        for (PageClassLoaderContext child : context.getChildren()) {
            this.addClassNames(child, classNames);
        }
    }

    @Override
    public PageClassLoaderContext getRoot() {
        return this.root;
    }

    @Override
    public boolean isMerging() {
        return NESTED_MERGE_COUNT.get() > 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public Class<?> getClassInstance(Class<?> clasz, String pageName) {
        String className = clasz.getName();
        PageClassLoaderContext context = this.root.findByClassName(className);
        if (context == null) {
            context = this.get(className);
        }
        try {
            clasz = context.getProxyFactory().getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new TapestryException(e.getMessage(), (Throwable)e);
        }
        return clasz;
    }

    @Override
    public void preload() {
        PageClassLoaderContext context = new PageClassLoaderContext("unknown", this.root, Collections.emptySet(), this.plasticProxyFactoryProvider.apply(this.root.getClassLoader()), this::get);
        List<String> pageNames = this.componentClassResolver.getPageNames();
        ArrayList<String> classNames = new ArrayList<String>(pageNames.size());
        long start = System.currentTimeMillis();
        LOGGER.info("Preloading dependency information for {} pages", (Object)pageNames.size());
        for (String page : pageNames) {
            try {
                String className = this.componentClassResolver.resolvePageNameToClassName(page);
                this.componentDependencyRegistry.register(context.getClassLoader().loadClass(className));
                classNames.add(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        long finish = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Dependency information gathered in %.3f ms", (double)(finish - start) / 1000.0));
        }
        context.invalidate();
        LOGGER.info("Starting preloading page classloader contexts");
        start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            for (String className : classNames) {
                this.get(className);
            }
        }
        finish = System.currentTimeMillis();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Preloading of page classloadercontexts finished in %.3f ms", (double)(finish - start) / 1000.0));
        }
    }
}

