/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.internal.transform.ReadOnlyComponentFieldConduit;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.ApplicationStateManager;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class ApplicationStateWorker
implements ComponentClassTransformWorker2 {
    private final ApplicationStateManager applicationStateManager;
    private final ComponentClassCache componentClassCache;

    public ApplicationStateWorker(ApplicationStateManager applicationStateManager, ComponentClassCache componentClassCache) {
        this.applicationStateManager = applicationStateManager;
        this.componentClassCache = componentClassCache;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(SessionState.class)) {
            SessionState annotation = (SessionState)field.getAnnotation(SessionState.class);
            this.transform(plasticClass, field, annotation.create());
            field.claim((Object)annotation);
        }
    }

    private void transform(PlasticClass transformation, PlasticField field, final boolean create) {
        final Class fieldClass = this.componentClassCache.forName(field.getTypeName());
        field.setConduit(new FieldConduit(){

            public void set(Object instance, InstanceContext context, Object newValue) {
                ApplicationStateWorker.this.applicationStateManager.set(fieldClass, newValue);
            }

            public Object get(Object instance, InstanceContext context) {
                return create ? ApplicationStateWorker.this.applicationStateManager.get(fieldClass) : ApplicationStateWorker.this.applicationStateManager.getIfExists(fieldClass);
            }
        });
        final String expectedName = field.getName() + "Exists";
        List fields = ((Flow)F.flow((Collection)transformation.getAllFields()).filter((Predicate)new Predicate<PlasticField>(){

            public boolean accept(PlasticField field) {
                return field.getTypeName().equals("boolean") && field.getName().equalsIgnoreCase(expectedName);
            }
        })).toList();
        for (PlasticField existsField : fields) {
            existsField.claim((Object)this);
            String className = transformation.getClassName();
            String fieldName = existsField.getName();
            existsField.setConduit((FieldConduit)new ReadOnlyComponentFieldConduit(className, fieldName){

                public Object get(Object instance, InstanceContext context) {
                    return ApplicationStateWorker.this.applicationStateManager.exists(fieldClass);
                }
            });
        }
    }
}

