/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.tapestry5.http.services.Response;
import org.apache.tapestry5.services.ComponentEventResultProcessor;
import org.apache.tapestry5.services.HttpStatus;

public class HttpStatusComponentEventResultProcessor
implements ComponentEventResultProcessor<HttpStatus> {
    private final Response response;

    public HttpStatusComponentEventResultProcessor(Response response) {
        this.response = response;
    }

    @Override
    public void processResultValue(HttpStatus value) throws IOException {
        this.response.setStatus(value.getStatusCode());
        Map<String, String> extraHttpHeaders = value.getExtraHttpHeaders();
        for (String header : extraHttpHeaders.keySet()) {
            String headerValue = extraHttpHeaders.get(header);
            this.response.setHeader(header, headerValue);
        }
        if (value.getResponseBody() != null) {
            Objects.requireNonNull(value.getContentType(), "HttpStatus.mimeType cannot be null");
            this.response.getPrintWriter(value.getContentType()).append(value.getResponseBody()).close();
        }
    }
}

