/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.internal.services.EventImpl;
import org.apache.tapestry5.internal.structure.ComponentPageElementResources;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.runtime.ComponentEvent;
import org.slf4j.Logger;

public class ComponentEventImpl
extends EventImpl
implements ComponentEvent {
    private final String eventType;
    private final String originatingComponentId;
    private final EventContext context;
    private final ComponentPageElementResources elementResources;
    private final boolean exactParameterCountMatch;

    public ComponentEventImpl(String eventType, String originatingComponentId, EventContext context, ComponentEventCallback handler, ComponentPageElementResources elementResources, boolean exactParameterCountMatch, ComponentModel model, Logger logger) {
        super(handler, logger, elementResources);
        this.eventType = eventType;
        this.originatingComponentId = originatingComponentId;
        this.elementResources = elementResources;
        this.context = context;
        this.exactParameterCountMatch = exactParameterCountMatch && !model.handleActivationEventContext();
    }

    public String toString() {
        return String.format("ComponentEvent[%s from %s]", this.eventType, this.originatingComponentId.length() == 0 ? "(self)" : this.originatingComponentId);
    }

    @Override
    public boolean matches(String eventType, String componentId, int parameterCount) {
        if (this.isAborted()) {
            return false;
        }
        boolean parameterCountMatch = this.exactParameterCountMatch ? this.context.getCount() == parameterCount : this.context.getCount() >= parameterCount;
        return this.eventType.equalsIgnoreCase(eventType) && parameterCountMatch && (this.originatingComponentId.equalsIgnoreCase(componentId) || componentId.equals(""));
    }

    @Override
    public Object coerceContext(int index, String desiredTypeName) {
        if (index >= this.context.getCount()) {
            throw new IllegalArgumentException(String.format("Method %s has more parameters than there are context values for this component event.", this.getMethodDescription()));
        }
        try {
            Class desiredType = this.elementResources.toClass(desiredTypeName);
            return this.context.get(desiredType, index);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Exception in method %s, parameter #%d: %s", this.getMethodDescription(), index + 1, ex), ex);
        }
    }

    @Override
    public Object[] getContext() {
        int count = this.context.getCount();
        Object[] result = new Object[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.context.get(Object.class, i);
        }
        return result;
    }

    @Override
    public EventContext getEventContext() {
        return this.context;
    }
}

