/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.commons.ObjectLocator;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.transform.InjectionProvider2;

public class AssetInjectionProvider
implements InjectionProvider2 {
    private final AssetSource assetSource;

    public AssetInjectionProvider(AssetSource assetSource) {
        this.assetSource = assetSource;
    }

    @Override
    public boolean provideInjection(PlasticField field, ObjectLocator locator, MutableComponentModel componentModel) {
        Path path = (Path)field.getAnnotation(Path.class);
        if (path == null) {
            return false;
        }
        final String assetPath = path.value();
        final String libraryName = componentModel.getLibraryName();
        ComputedValue<Asset> computedAsset = new ComputedValue<Asset>(){

            public Asset get(InstanceContext context) {
                ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                return AssetInjectionProvider.this.assetSource.getComponentAsset(resources, assetPath, libraryName);
            }
        };
        field.injectComputed((ComputedValue)computedAsset);
        return true;
    }
}

