/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldTranslator;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.bindings.InvariantBinding;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.BindingSource;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.FieldTranslatorSource;
import org.apache.tapestry5.services.FieldValidatorDefaultSource;
import org.apache.tapestry5.services.ValueEncoderSource;

public class ComponentDefaultProviderImpl
implements ComponentDefaultProvider {
    private final PropertyAccess propertyAccess;
    private final BindingSource bindingSource;
    private final ValueEncoderSource valueEncoderSource;
    private final FieldTranslatorSource fieldTranslatorSource;
    private final FieldValidatorDefaultSource fieldValidatorDefaultSource;
    static final FieldValidator NOOP_VALIDATOR = new FieldValidator(){

        public void validate(Object value) throws ValidationException {
        }

        @Override
        public void render(MarkupWriter writer) {
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };

    public ComponentDefaultProviderImpl(PropertyAccess propertyAccess, BindingSource bindingSource, ValueEncoderSource valueEncoderSource, FieldTranslatorSource fieldTranslatorSource, FieldValidatorDefaultSource fieldValidatorDefaultSource) {
        this.propertyAccess = propertyAccess;
        this.bindingSource = bindingSource;
        this.valueEncoderSource = valueEncoderSource;
        this.fieldTranslatorSource = fieldTranslatorSource;
        this.fieldValidatorDefaultSource = fieldValidatorDefaultSource;
    }

    @Override
    public String defaultLabel(ComponentResources resources) {
        assert (resources != null);
        String componentId = resources.getId();
        String key = componentId + "-label";
        Messages containerMessages = resources.getContainerResources().getMessages();
        if (containerMessages.contains(key)) {
            return containerMessages.get(key);
        }
        return TapestryInternalUtils.toUserPresentable(componentId);
    }

    @Override
    public Binding defaultBinding(String parameterName, ComponentResources resources) {
        assert (InternalUtils.isNonBlank((String)parameterName));
        assert (resources != null);
        String componentId = resources.getId();
        Component container = resources.getContainer();
        if (this.propertyAccess.getAdapter((Object)container).getPropertyAdapter(componentId) == null) {
            return null;
        }
        ComponentResources containerResources = resources.getContainerResources();
        return this.bindingSource.newBinding("default " + parameterName, containerResources, "prop", componentId);
    }

    @Override
    public ValueEncoder defaultValueEncoder(String parameterName, ComponentResources resources) {
        assert (InternalUtils.isNonBlank((String)parameterName));
        assert (resources != null);
        Class parameterType = resources.getBoundType(parameterName);
        if (parameterType == null) {
            return null;
        }
        return this.valueEncoderSource.getValueEncoder(parameterType);
    }

    @Override
    public FieldTranslator defaultTranslator(String parameterName, ComponentResources resources) {
        return this.fieldTranslatorSource.createDefaultTranslator(resources, parameterName);
    }

    @Override
    public Binding defaultTranslatorBinding(final String parameterName, final ComponentResources resources) {
        String description = String.format("default translator, parameter %s of %s", parameterName, resources.getCompleteId());
        return new InvariantBinding(resources.getLocation(), FieldTranslator.class, description){

            @Override
            public Object get() {
                return ComponentDefaultProviderImpl.this.defaultTranslator(parameterName, resources);
            }
        };
    }

    @Override
    public FieldValidator defaultValidator(String parameterName, ComponentResources resources) {
        FieldValidator result = this.fieldValidatorDefaultSource.createDefaultValidator(resources, parameterName);
        return result == null ? NOOP_VALIDATOR : result;
    }

    @Override
    public Binding defaultValidatorBinding(final String parameterName, final ComponentResources resources) {
        String description = String.format("default validator, parameter %s of %s", parameterName, resources.getCompleteId());
        return new InvariantBinding(resources.getLocation(), FieldValidator.class, description){

            @Override
            public Object get() {
                return ComponentDefaultProviderImpl.this.defaultValidator(parameterName, resources);
            }
        };
    }
}

