/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ajax;

import java.util.Map;
import org.apache.tapestry5.ClientBodyElement;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;

public class MultiZoneUpdate {
    private final MultiZoneUpdate parent;
    private final String zoneId;
    private final Object renderer;

    public MultiZoneUpdate(String zoneId, Object renderer) {
        this(zoneId, renderer, null);
    }

    public MultiZoneUpdate(ClientBodyElement zone) {
        this(zone.getClientId(), zone.getBody());
    }

    private MultiZoneUpdate(String zoneId, Object renderer, MultiZoneUpdate parent) {
        assert (renderer != null);
        assert (InternalUtils.isNonBlank((String)zoneId));
        this.zoneId = zoneId;
        this.renderer = renderer;
        this.parent = parent;
    }

    public MultiZoneUpdate add(ClientBodyElement zone) {
        assert (zone != null);
        return this.add(zone.getClientId(), zone.getBody());
    }

    public MultiZoneUpdate add(String zoneId, Object renderer) {
        return new MultiZoneUpdate(zoneId, renderer, this);
    }

    public Map<String, Object> getZoneToRenderMap() {
        Map result = CollectionFactory.newMap();
        MultiZoneUpdate cursor = this;
        while (cursor != null) {
            result.put(cursor.zoneId, cursor.renderer);
            cursor = cursor.parent;
        }
        return result;
    }

    public String toString() {
        return String.format("MultiZoneUpdate[%s]", this.getZoneToRenderMap());
    }
}

