/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ui.scope;

import java.io.Serializable;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.DeterministicLevel$;
import org.apache.spark.scheduler.StageInfo;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.ui.scope.RDDOperationCluster;
import org.apache.spark.ui.scope.RDDOperationEdge;
import org.apache.spark.ui.scope.RDDOperationGraph;
import org.apache.spark.ui.scope.RDDOperationNode;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.xml.Utility$;

public final class RDDOperationGraph$
implements Logging,
scala.Serializable {
    public static RDDOperationGraph$ MODULE$;
    private final String STAGE_CLUSTER_PREFIX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RDDOperationGraph$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String STAGE_CLUSTER_PREFIX() {
        return this.STAGE_CLUSTER_PREFIX;
    }

    public RDDOperationGraph makeOperationGraph(StageInfo stage, int retainedNodes) {
        ListBuffer edges = new ListBuffer();
        HashMap nodes = new HashMap();
        HashMap clusters = new HashMap();
        String stageClusterId = new StringBuilder(0).append(this.STAGE_CLUSTER_PREFIX()).append(stage.stageId()).toString();
        String stageClusterName = new StringBuilder(6).append("Stage ").append(stage.stageId()).append((Object)(stage.attemptNumber() == 0 ? "" : new StringBuilder(11).append(" (attempt ").append(stage.attemptNumber()).append(")").toString())).toString();
        RDDOperationCluster rootCluster = new RDDOperationCluster(stageClusterId, false, stageClusterName);
        IntRef rootNodeCount = IntRef.create((int)0);
        HashSet addRDDIds = new HashSet();
        HashSet dropRDDIds = new HashSet();
        ((IterableLike)stage.rddInfos().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)rdd -> {
            RDDOperationGraph$.$anonfun$makeOperationGraph$2(rootNodeCount, retainedNodes, addRDDIds, dropRDDIds, edges, nodes, rootCluster, clusters, rdd);
            return BoxedUnit.UNIT;
        });
        ListBuffer internalEdges = new ListBuffer();
        ListBuffer outgoingEdges = new ListBuffer();
        ListBuffer incomingEdges = new ListBuffer();
        edges.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RDDOperationEdge rDDOperationEdge = x0$1;
            if (rDDOperationEdge != null) {
                boolean toThisGraph;
                RDDOperationEdge rDDOperationEdge2 = rDDOperationEdge;
                boolean fromThisGraph = nodes.contains((Object)BoxesRunTime.boxToInteger((int)rDDOperationEdge2.fromId()));
                Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(fromThisGraph, toThisGraph = nodes.contains((Object)BoxesRunTime.boxToInteger((int)rDDOperationEdge2.toId())));
                if (sp2 != null) {
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl2 = sp2._2$mcZ$sp();
                    if (bl && bl2) {
                        return internalEdges.$plus$eq((Object)rDDOperationEdge2);
                    }
                }
                if (sp2 != null) {
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl3 = sp2._2$mcZ$sp();
                    if (bl && !bl3) {
                        return outgoingEdges.$plus$eq((Object)rDDOperationEdge2);
                    }
                }
                if (sp2 != null) {
                    boolean bl = sp2._1$mcZ$sp();
                    boolean bl4 = sp2._2$mcZ$sp();
                    if (!bl && bl4) {
                        return incomingEdges.$plus$eq((Object)rDDOperationEdge2);
                    }
                }
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Found an orphan edge in stage ").append(stage.stageId()).append(": ").append(rDDOperationEdge2).toString());
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)rDDOperationEdge);
        });
        return new RDDOperationGraph((Seq<RDDOperationEdge>)internalEdges.toSeq(), (Seq<RDDOperationEdge>)outgoingEdges.toSeq(), (Seq<RDDOperationEdge>)incomingEdges.toSeq(), rootCluster);
    }

    public String makeDotFile(RDDOperationGraph graph) {
        scala.collection.mutable.StringBuilder dotFile = new scala.collection.mutable.StringBuilder();
        dotFile.append("digraph G {\n");
        this.makeDotSubgraph(dotFile, graph.rootCluster(), "  ");
        graph.edges().foreach((Function1 & Serializable & scala.Serializable)edge -> dotFile.append(new StringBuilder(6).append("  ").append(edge.fromId()).append("->").append(edge.toId()).append(";\n").toString()));
        dotFile.append("}");
        String result = dotFile.toString();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> result);
        return result;
    }

    private String makeDotNode(RDDOperationNode node) {
        String string;
        String isCached = node.cached() ? " [Cached]" : "";
        String isBarrier = node.barrier() ? " [Barrier]" : "";
        Enumeration.Value value = node.outputDeterministicLevel();
        Enumeration.Value value2 = DeterministicLevel$.MODULE$.DETERMINATE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = "";
        } else {
            Enumeration.Value value4 = DeterministicLevel$.MODULE$.INDETERMINATE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                string = " [Indeterminate]";
            } else {
                Enumeration.Value value6 = DeterministicLevel$.MODULE$.UNORDERED();
                Enumeration.Value value7 = value;
                string = !(value6 != null ? !value6.equals(value7) : value7 != null) ? " [Unordered]" : "";
            }
        }
        String outputDeterministicLevel = string;
        String escapedCallsite = Utility$.MODULE$.escape(node.callsite());
        String label = new StringBuilder(7).append(node.name()).append(" [").append(node.id()).append("]").append(isCached).append(isBarrier).append(outputDeterministicLevel).append("<br>").append(escapedCallsite).toString();
        return new StringBuilder(28).append(node.id()).append(" [labelType=\"html\" label=\"").append(StringEscapeUtils.escapeJava((String)label)).append("\"]").toString();
    }

    private void makeDotSubgraph(scala.collection.mutable.StringBuilder subgraph, RDDOperationCluster cluster, String indent) {
        subgraph.append(indent).append(new StringBuilder(19).append("subgraph cluster").append(cluster.id()).append(" {\n").toString()).append(indent).append(new StringBuilder(12).append("  label=\"").append(StringEscapeUtils.escapeJava((String)cluster.name())).append("\";\n").toString());
        cluster.childNodes().foreach((Function1 & Serializable & scala.Serializable)node -> subgraph.append(indent).append(new StringBuilder(4).append("  ").append(MODULE$.makeDotNode((RDDOperationNode)node)).append(";\n").toString()));
        cluster.childClusters().foreach((Function1 & Serializable & scala.Serializable)cscope -> {
            RDDOperationGraph$.MODULE$.makeDotSubgraph(subgraph, cscope, new StringBuilder(2).append(indent).append("  ").toString());
            return BoxedUnit.UNIT;
        });
        subgraph.append(indent).append("}\n");
    }

    public RDDOperationGraph apply(Seq<RDDOperationEdge> edges, Seq<RDDOperationEdge> outgoingEdges, Seq<RDDOperationEdge> incomingEdges, RDDOperationCluster rootCluster) {
        return new RDDOperationGraph(edges, outgoingEdges, incomingEdges, rootCluster);
    }

    public Option<Tuple4<Seq<RDDOperationEdge>, Seq<RDDOperationEdge>, Seq<RDDOperationEdge>, RDDOperationCluster>> unapply(RDDOperationGraph x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4(x$0.edges(), x$0.outgoingEdges(), x$0.incomingEdges(), (Object)x$0.rootCluster()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ RDDOperationEdge $anonfun$makeOperationGraph$5(RDDInfo rdd$1, int x$8) {
        return new RDDOperationEdge(x$8, rdd$1.id());
    }

    public static final /* synthetic */ void $anonfun$makeOperationGraph$11(Seq pc) {
        if (pc.size() == 2) {
            RDDOperationCluster parentCluster = (RDDOperationCluster)pc.apply(0);
            RDDOperationCluster childCluster = (RDDOperationCluster)pc.apply(1);
            parentCluster.attachChildCluster(childCluster);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeOperationGraph$12(RDDOperationCluster rootCluster$1, RDDOperationCluster cluster) {
        if (!rootCluster$1.childClusters().contains((Object)cluster)) {
            rootCluster$1.attachChildCluster(cluster);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$makeOperationGraph$2(IntRef rootNodeCount$1, int retainedNodes$1, HashSet addRDDIds$1, HashSet dropRDDIds$1, ListBuffer edges$1, HashMap nodes$1, RDDOperationCluster rootCluster$1, HashMap clusters$1, RDDInfo rdd) {
        HashSet hashSet;
        boolean isAllowed;
        boolean bl;
        Seq<Object> parentIds = rdd.parentIds();
        if (parentIds.isEmpty()) {
            ++rootNodeCount$1.elem;
            bl = rootNodeCount$1.elem <= retainedNodes$1;
        } else {
            bl = isAllowed = parentIds.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)id -> addRDDIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)) || !dropRDDIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)));
        }
        if (isAllowed) {
            addRDDIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rdd.id()));
            hashSet = edges$1.$plus$plus$eq((TraversableOnce)((TraversableLike)parentIds.filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)id -> !dropRDDIds$1.contains((Object)BoxesRunTime.boxToInteger((int)id)))).map((Function1 & Serializable & scala.Serializable)x$8 -> RDDOperationGraph$.$anonfun$makeOperationGraph$5(rdd, BoxesRunTime.unboxToInt((Object)x$8)), Seq$.MODULE$.canBuildFrom()));
        } else {
            hashSet = dropRDDIds$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)rdd.id()));
        }
        RDDOperationNode node = (RDDOperationNode)nodes$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)rdd.id()), (Function0 & Serializable & scala.Serializable)() -> {
            StorageLevel storageLevel = rdd.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            return new RDDOperationNode(rdd.id(), rdd.name(), storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2), rdd.isBarrier(), rdd.callSite(), rdd.outputDeterministicLevel());
        });
        if (rdd.scope().isEmpty()) {
            if (isAllowed) {
                rootCluster$1.attachChildNode(node);
                return;
            }
            return;
        }
        Seq rddScopes = (Seq)rdd.scope().map((Function1 & Serializable & scala.Serializable)scope -> scope.getAllScopes()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        Seq rddClusters = (Seq)rddScopes.map((Function1 & Serializable & scala.Serializable)scope -> {
            String clusterId = scope.id();
            String clusterName = scope.name().replaceAll("\\n", "\\\\n");
            return (RDDOperationCluster)clusters$1.getOrElseUpdate((Object)clusterId, (Function0 & Serializable & scala.Serializable)() -> new RDDOperationCluster(clusterId, false, clusterName));
        }, Seq$.MODULE$.canBuildFrom());
        rddClusters.sliding(2).foreach((Function1 & Serializable & scala.Serializable)pc -> {
            RDDOperationGraph$.$anonfun$makeOperationGraph$11(pc);
            return BoxedUnit.UNIT;
        });
        rddClusters.headOption().foreach((Function1 & Serializable & scala.Serializable)cluster -> {
            RDDOperationGraph$.$anonfun$makeOperationGraph$12(rootCluster$1, cluster);
            return BoxedUnit.UNIT;
        });
        if (isAllowed) {
            rddClusters.lastOption().foreach((Function1 & Serializable & scala.Serializable)cluster -> {
                cluster.attachChildNode(node);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private RDDOperationGraph$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.STAGE_CLUSTER_PREFIX = "stage_";
    }
}

