/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.lineage.LineageItem;

public class FederatedResponse
implements Serializable {
    private static final long serialVersionUID = 3142180026498695091L;
    private ResponseType _status;
    private Object[] _data;
    private transient LineageItem _linItem = null;

    public FederatedResponse(ResponseType status) {
        this(status, null, null);
    }

    public FederatedResponse(ResponseType status, Object[] data) {
        this(status, data, (LineageItem)null);
    }

    public FederatedResponse(ResponseType status, Object[] data, LineageItem linItem) {
        this._status = status;
        this._data = data;
        if (this._status == ResponseType.SUCCESS && data == null) {
            this._status = ResponseType.SUCCESS_EMPTY;
        }
        this._linItem = linItem;
    }

    public FederatedResponse(ResponseType status, Object data) {
        this(status, data, null);
    }

    public FederatedResponse(ResponseType status, Object data, LineageItem linItem) {
        this._status = status;
        this._data = new Object[]{data};
        if (this._status == ResponseType.SUCCESS && data == null) {
            this._status = ResponseType.SUCCESS_EMPTY;
        }
        this._linItem = linItem;
    }

    public boolean isSuccessful() {
        return this._status != ResponseType.ERROR;
    }

    public String getErrorMessage() {
        if (this._data[0] instanceof Throwable) {
            return ExceptionUtils.getStackTrace((Throwable)((Throwable)this._data[0]));
        }
        if (this._data[0] instanceof String) {
            return (String)this._data[0];
        }
        return "No readable error message";
    }

    public Object[] getData() throws Exception {
        if (!this.isSuccessful()) {
            this.throwExceptionFromResponse();
        }
        return this._data;
    }

    public long estimateSerializationBufferSize() {
        long minBufferSize = 312L;
        if (this._data != null) {
            for (Object obj : this._data) {
                if (!(obj instanceof CacheBlock)) continue;
                minBufferSize += ((CacheBlock)obj).getExactSerializedSize();
            }
        }
        return minBufferSize;
    }

    public void throwExceptionFromResponse() throws Exception {
        for (Object potentialException : this._data) {
            if (potentialException == null || !(potentialException instanceof Exception)) continue;
            throw (Exception)potentialException;
        }
        String errorMessage = this.getErrorMessage();
        if (this.getErrorMessage() != "No readable error message") {
            throw new DMLRuntimeException(errorMessage);
        }
        throw new DMLRuntimeException("Unknown runtime exception in handling of federated request by federated worker.");
    }

    public LineageItem getLineageItem() {
        return this._linItem;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName().toString());
        sb.append(" response:").append((Object)this._status);
        sb.append("\ndata:\n").append(Arrays.toString(this._data));
        return sb.toString();
    }

    public static enum ResponseType {
        SUCCESS,
        SUCCESS_EMPTY,
        ERROR;

    }
}

