/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource.enumeration;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sysds.resource.CloudInstance;
import org.apache.sysds.resource.CloudUtils;
import org.apache.sysds.resource.ResourceCompiler;
import org.apache.sysds.resource.cost.CostEstimationException;
import org.apache.sysds.resource.cost.CostEstimator;
import org.apache.sysds.resource.enumeration.EnumerationUtils;
import org.apache.sysds.resource.enumeration.GridBasedEnumerator;
import org.apache.sysds.resource.enumeration.InterestBasedEnumerator;
import org.apache.sysds.resource.enumeration.PruneBasedEnumerator;
import org.apache.sysds.runtime.controlprogram.Program;

public abstract class Enumerator {
    public static final int DEFAULT_MIN_EXECUTORS = 0;
    public static final int DEFAULT_MAX_EXECUTORS = 200;
    public static final double COST_DELTA_FRACTION = 0.02;
    static double LINEAR_OBJECTIVE_RATIO = 0.01;
    static double MAX_TIME = Double.MAX_VALUE;
    static double MAX_PRICE = Double.MAX_VALUE;
    static int CPU_QUOTA = 1152;
    HashMap<String, CloudInstance> instances;
    Program program;
    EnumerationStrategy enumStrategy;
    OptimizationStrategy optStrategy;
    protected final int minExecutors;
    protected final int maxExecutors;
    protected final Set<CloudUtils.InstanceFamily> instanceTypesRange;
    protected final Set<CloudUtils.InstanceSize> instanceSizeRange;
    protected final EnumerationUtils.InstanceSearchSpace driverSpace = new EnumerationUtils.InstanceSearchSpace();
    protected final EnumerationUtils.InstanceSearchSpace executorSpace = new EnumerationUtils.InstanceSearchSpace();
    protected AtomicReference<EnumerationUtils.SolutionPoint> optimalSolution = new AtomicReference<Object>(null);

    public static void setCostsWeightFactor(double newFactor) {
        LINEAR_OBJECTIVE_RATIO = newFactor;
    }

    public static void setMinTime(double maxTime) {
        MAX_TIME = maxTime;
    }

    public static void setMinPrice(double maxPrice) {
        MAX_PRICE = maxPrice;
    }

    public static void setCpuQuota(int newQuotaValue) {
        CPU_QUOTA = newQuotaValue;
    }

    public Enumerator(Builder builder) {
        this.program = builder.program;
        this.instances = builder.instances;
        this.enumStrategy = builder.enumStrategy;
        this.optStrategy = builder.optStrategy;
        this.minExecutors = builder.minExecutors;
        this.maxExecutors = builder.maxExecutors;
        this.instanceTypesRange = builder.instanceFamiliesRange;
        this.instanceSizeRange = builder.instanceSizeRange;
        EnumerationUtils.SolutionPoint initSolutionPoint = new EnumerationUtils.SolutionPoint(new EnumerationUtils.ConfigurationPoint(null, null, -1), Double.MAX_VALUE, Double.MAX_VALUE);
        this.optimalSolution.set(initSolutionPoint);
    }

    public abstract void preprocessing();

    public void processing() {
        for (Map.Entry dMemoryEntry : this.driverSpace.entrySet()) {
            long driverMemory = (Long)dMemoryEntry.getKey();
            for (Map.Entry dCoresEntry : ((TreeMap)dMemoryEntry.getValue()).entrySet()) {
                EnumerationUtils.ConfigurationPoint configurationPoint;
                int driverCores = (Integer)dCoresEntry.getKey();
                if (this.evaluateSingleNodeExecution(driverMemory, driverCores)) {
                    ResourceCompiler.setSingleNodeResourceConfigs(driverMemory, driverCores);
                    this.program = ResourceCompiler.doFullRecompilation(this.program);
                    for (CloudInstance dInstance : (LinkedList)dCoresEntry.getValue()) {
                        configurationPoint = new EnumerationUtils.ConfigurationPoint(dInstance);
                        double[] newEstimates = this.getCostEstimate(configurationPoint);
                        this.updateOptimalSolution(newEstimates[0], newEstimates[1], configurationPoint);
                    }
                }
                for (Map.Entry eMemoryEntry : this.executorSpace.entrySet()) {
                    long executorMemory = (Long)eMemoryEntry.getKey();
                    block6: for (Map.Entry eCoresEntry : ((TreeMap)eMemoryEntry.getValue()).entrySet()) {
                        int executorCores = (Integer)eCoresEntry.getKey();
                        ArrayList<Integer> numberExecutorsSet = this.estimateRangeExecutors(driverCores, executorMemory, executorCores);
                        Iterator iterator = numberExecutorsSet.iterator();
                        while (iterator.hasNext()) {
                            int numberExecutors = (Integer)iterator.next();
                            try {
                                ResourceCompiler.setSparkClusterResourceConfigs(driverMemory, driverCores, numberExecutors, executorMemory, executorCores);
                            }
                            catch (IllegalArgumentException e) {
                                continue block6;
                            }
                            this.program = ResourceCompiler.doFullRecompilation(this.program);
                            for (CloudInstance dInstance : (LinkedList)dCoresEntry.getValue()) {
                                for (CloudInstance eInstance : (LinkedList)eCoresEntry.getValue()) {
                                    configurationPoint = new EnumerationUtils.ConfigurationPoint(dInstance, eInstance, numberExecutors);
                                    double[] newEstimates = this.getCostEstimate(configurationPoint);
                                    this.updateOptimalSolution(newEstimates[0], newEstimates[1], configurationPoint);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public EnumerationUtils.SolutionPoint postprocessing() {
        if (this.optimalSolution.get() == null) {
            throw new RuntimeException("No solution have met the constrains. Try adjusting the time/price constrain or switch to 'MinCosts' optimization strategy");
        }
        return this.optimalSolution.get();
    }

    public abstract boolean evaluateSingleNodeExecution(long var1, int var3);

    public abstract ArrayList<Integer> estimateRangeExecutors(int var1, long var2, int var4);

    protected double[] getCostEstimate(EnumerationUtils.ConfigurationPoint point) {
        double monetaryCost;
        double timeCost;
        try {
            timeCost = CostEstimator.estimateExecutionTime(this.program, point.driverInstance, point.executorInstance) + 300.0;
            monetaryCost = CloudUtils.calculateClusterPrice(point, timeCost, CloudUtils.CloudProvider.AWS);
        }
        catch (CostEstimationException e) {
            timeCost = Double.MAX_VALUE;
            monetaryCost = Double.MAX_VALUE;
        }
        return new double[]{timeCost, monetaryCost};
    }

    public void updateOptimalSolution(double newTimeEstimate, double newMonetaryEstimate, EnumerationUtils.ConfigurationPoint newPoint) {
        EnumerationUtils.SolutionPoint currentOptimal = this.optimalSolution.get();
        if (this.optStrategy == OptimizationStrategy.MinCosts) {
            double optimalScore = Enumerator.linearScoringFunction(currentOptimal.timeCost, currentOptimal.monetaryCost);
            double newScore = Enumerator.linearScoringFunction(newTimeEstimate, newMonetaryEstimate);
            if (newScore > optimalScore) {
                return;
            }
            if (newScore == optimalScore && newMonetaryEstimate >= currentOptimal.monetaryCost) {
                return;
            }
        } else if (this.optStrategy == OptimizationStrategy.MinTime) {
            if (newMonetaryEstimate > MAX_PRICE || newTimeEstimate > currentOptimal.timeCost) {
                return;
            }
            if (newTimeEstimate == currentOptimal.timeCost && newMonetaryEstimate > currentOptimal.monetaryCost) {
                return;
            }
        } else if (this.optStrategy == OptimizationStrategy.MinPrice) {
            if (newTimeEstimate > MAX_TIME || newMonetaryEstimate > currentOptimal.monetaryCost) {
                return;
            }
            if (newMonetaryEstimate == currentOptimal.monetaryCost && newTimeEstimate > currentOptimal.timeCost) {
                return;
            }
        }
        EnumerationUtils.SolutionPoint newSolution = new EnumerationUtils.SolutionPoint(newPoint, newTimeEstimate, newMonetaryEstimate);
        this.optimalSolution.set(newSolution);
    }

    static double linearScoringFunction(double time, double price) {
        return LINEAR_OBJECTIVE_RATIO * time + (1.0 - LINEAR_OBJECTIVE_RATIO) * price;
    }

    public HashMap<String, CloudInstance> getInstances() {
        return this.instances;
    }

    public EnumerationUtils.InstanceSearchSpace getDriverSpace() {
        return this.driverSpace;
    }

    public void setDriverSpace(EnumerationUtils.InstanceSearchSpace inputSpace) {
        this.driverSpace.putAll(inputSpace);
    }

    public EnumerationUtils.InstanceSearchSpace getExecutorSpace() {
        return this.executorSpace;
    }

    public void setExecutorSpace(EnumerationUtils.InstanceSearchSpace inputSpace) {
        this.executorSpace.putAll(inputSpace);
    }

    public EnumerationStrategy getEnumStrategy() {
        return this.enumStrategy;
    }

    public OptimizationStrategy getOptStrategy() {
        return this.optStrategy;
    }

    public double getCostsWeightFactor() {
        return LINEAR_OBJECTIVE_RATIO;
    }

    public double getMaxTime() {
        return MAX_TIME;
    }

    public double getMaxPrice() {
        return MAX_PRICE;
    }

    public EnumerationUtils.SolutionPoint getOptimalSolution() {
        return this.optimalSolution.get();
    }

    public static class Builder {
        private Program program = null;
        private HashMap<String, CloudInstance> instances = null;
        private EnumerationStrategy enumStrategy = null;
        private OptimizationStrategy optStrategy = null;
        private int minExecutors = 0;
        private int maxExecutors = 200;
        private Set<CloudUtils.InstanceFamily> instanceFamiliesRange = null;
        private Set<CloudUtils.InstanceSize> instanceSizeRange = null;
        private int stepSizeExecutors = 1;
        private int expBaseExecutors = -1;
        private boolean interestLargestEstimate = true;
        private boolean interestEstimatesInCP = true;
        private boolean interestBroadcastVars = true;
        private boolean interestOutputCaching = false;

        public Builder withRuntimeProgram(Program program) {
            this.program = program;
            return this;
        }

        public Builder withAvailableInstances(HashMap<String, CloudInstance> instances) {
            this.instances = instances;
            return this;
        }

        public Builder withEnumerationStrategy(EnumerationStrategy strategy) {
            this.enumStrategy = strategy;
            return this;
        }

        public Builder withOptimizationStrategy(OptimizationStrategy strategy) {
            this.optStrategy = strategy;
            return this;
        }

        public Builder withNumberExecutorsRange(int min, int max) {
            this.minExecutors = min < 0 ? 0 : min;
            this.maxExecutors = max < 0 ? 200 : max;
            return this;
        }

        public Builder withInstanceFamilyRange(String[] instanceFamilies) {
            this.instanceFamiliesRange = Builder.typeRangeFromStrings(instanceFamilies);
            return this;
        }

        public Builder withInstanceSizeRange(String[] instanceSizes) {
            this.instanceSizeRange = Builder.sizeRangeFromStrings(instanceSizes);
            return this;
        }

        public Builder withStepSizeExecutor(int stepSize) {
            this.stepSizeExecutors = stepSize;
            return this;
        }

        public Builder withInterestLargestEstimate(boolean fitSingleNodeMemory) {
            this.interestLargestEstimate = fitSingleNodeMemory;
            return this;
        }

        public Builder withInterestEstimatesInCP(boolean fitDriverMemory) {
            this.interestEstimatesInCP = fitDriverMemory;
            return this;
        }

        public Builder withInterestBroadcastVars(boolean fitExecutorMemory) {
            this.interestBroadcastVars = fitExecutorMemory;
            return this;
        }

        public Builder withInterestOutputCaching(boolean fitCheckpointMemory) {
            this.interestOutputCaching = fitCheckpointMemory;
            return this;
        }

        public Builder withExpBaseExecutors(int expBaseExecutors) {
            if (expBaseExecutors != -1 && expBaseExecutors < 2) {
                throw new IllegalArgumentException("Given exponent base for number of executors should be -1 or bigger than 1.");
            }
            this.expBaseExecutors = expBaseExecutors;
            return this;
        }

        public Enumerator build() {
            if (this.program == null) {
                throw new IllegalArgumentException("Providing runtime program is required");
            }
            if (this.instances == null) {
                throw new IllegalArgumentException("Providing available instances is required");
            }
            if (this.instanceFamiliesRange == null) {
                this.instanceFamiliesRange = EnumSet.allOf(CloudUtils.InstanceFamily.class);
            }
            if (this.instanceSizeRange == null) {
                this.instanceSizeRange = EnumSet.allOf(CloudUtils.InstanceSize.class);
            }
            HashMap<String, CloudInstance> instancesWithinRange = new HashMap<String, CloudInstance>();
            for (String key : this.instances.keySet()) {
                if (!this.instanceFamiliesRange.contains((Object)CloudUtils.getInstanceFamily(key)) || !this.instanceSizeRange.contains((Object)CloudUtils.getInstanceSize(key))) continue;
                instancesWithinRange.put(key, this.instances.get(key));
            }
            this.instances = instancesWithinRange;
            switch (this.enumStrategy) {
                case GridBased: {
                    return new GridBasedEnumerator(this, this.stepSizeExecutors, this.expBaseExecutors);
                }
                case InterestBased: {
                    return new InterestBasedEnumerator(this, this.interestLargestEstimate, this.interestEstimatesInCP, this.interestBroadcastVars, this.interestOutputCaching);
                }
                case PruneBased: {
                    return new PruneBasedEnumerator(this);
                }
            }
            throw new IllegalArgumentException("Setting an enumeration strategy is required.");
        }

        protected static Set<CloudUtils.InstanceFamily> typeRangeFromStrings(String[] types) throws IllegalArgumentException {
            EnumSet<CloudUtils.InstanceFamily> result = EnumSet.noneOf(CloudUtils.InstanceFamily.class);
            for (String typeAsString : types) {
                CloudUtils.InstanceFamily type = CloudUtils.InstanceFamily.customValueOf(typeAsString);
                result.add(type);
            }
            return result;
        }

        protected static Set<CloudUtils.InstanceSize> sizeRangeFromStrings(String[] sizes) throws IllegalArgumentException {
            EnumSet<CloudUtils.InstanceSize> result = EnumSet.noneOf(CloudUtils.InstanceSize.class);
            for (String sizeAsString : sizes) {
                CloudUtils.InstanceSize size = CloudUtils.InstanceSize.customValueOf(sizeAsString);
                result.add(size);
            }
            return result;
        }
    }

    public static enum OptimizationStrategy {
        MinCosts,
        MinTime,
        MinPrice;

    }

    public static enum EnumerationStrategy {
        GridBased,
        InterestBased,
        PruneBased;

    }
}

