/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IdentityDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class IdentityDictionarySlice
extends IdentityDictionary {
    private static final long serialVersionUID = 2535887782150955098L;
    private final int l;
    private final int u;

    public IdentityDictionarySlice(int nRowCol, boolean withEmpty, int l, int u) {
        super(nRowCol, withEmpty);
        if (u > nRowCol || l < 0 || l >= u) {
            throw new DMLRuntimeException("Invalid slice Identity: " + nRowCol + " range: " + l + "--" + u);
        }
        this.l = l;
        this.u = u;
    }

    @Override
    public double[] getValues() {
        LOG.warn((Object)"Should not call getValues on Identity Dictionary");
        int nCol = this.u - this.l;
        double[] ret = new double[nCol * this.nRowCol];
        for (int i = this.l; i < this.u; ++i) {
            ret[i * nCol + i] = 1.0;
        }
        return ret;
    }

    @Override
    public double getValue(int i) {
        throw new NotImplementedException();
    }

    @Override
    public final double getValue(int r, int c, int nCol) {
        if (r < this.l || r > this.u) {
            return 0.0;
        }
        return super.getValue(r - this.l, c, nCol);
    }

    @Override
    public long getInMemorySize() {
        return IdentityDictionarySlice.getInMemorySize(this.nRowCol);
    }

    public static long getInMemorySize(int numberColumns) {
        return 24L;
    }

    @Override
    public double[] aggregateRows(Builtin fn, int nCol) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, this.l, this.u, fn.execute(1L, 0L));
        return ret;
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, IColIndex colIndexes) {
        for (int i = 0; i < this.u - this.l; ++i) {
            int idx = colIndexes.get(i);
            c[idx] = fn.execute(c[idx], 0.0);
            c[idx] = fn.execute(c[idx], 1.0);
        }
    }

    @Override
    public IDictionary clone() {
        return new IdentityDictionarySlice(this.nRowCol, this.withEmpty, this.l, this.u);
    }

    @Override
    public IDictionary.DictType getDictType() {
        return IDictionary.DictType.IdentitySlice;
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, this.l, this.u, 1.0);
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithDefault(double[] defaultTuple) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, this.l, this.u, 1.0);
        for (int i = 0; i < defaultTuple.length; ++i) {
            int n = i;
            ret[n] = ret[n] + defaultTuple[i];
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithReference(double[] reference) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, this.l, this.u, 1.0);
        for (int i = 0; i < reference.length; ++i) {
            int n = i;
            ret[n] = ret[n] + reference[i] * (double)this.nRowCol;
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        double[] ret = new double[this.nRowCol];
        Arrays.fill(ret, this.l, this.u, 1.0);
        return ret;
    }

    @Override
    public double[] productAllRowsToDouble(int nCol) {
        return new double[this.nRowCol];
    }

    @Override
    public double[] productAllRowsToDoubleWithDefault(double[] defaultTuple) {
        return new double[this.nRowCol];
    }

    @Override
    public void colSum(double[] c, int[] counts, IColIndex colIndexes) {
        for (int i = 0; i < colIndexes.size(); ++i) {
            int idx = colIndexes.get(i);
            c[idx] = counts[i];
        }
    }

    @Override
    public void colSumSq(double[] c, int[] counts, IColIndex colIndexes) {
        this.colSum(c, counts, colIndexes);
    }

    @Override
    public void colProduct(double[] res, int[] counts, IColIndex colIndexes) {
        for (int i = 0; i < colIndexes.size(); ++i) {
            res[colIndexes.get((int)i)] = 0.0;
        }
    }

    @Override
    public double sum(int[] counts, int ncol) {
        double s = 0.0;
        for (int i = this.l; i < this.u; ++i) {
            s += (double)counts[i];
        }
        return s;
    }

    @Override
    public double sumSq(int[] counts, int ncol) {
        return this.sum(counts, ncol);
    }

    @Override
    public IDictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        throw new NotImplementedException("Slice of identity slice ??? this is getting a bit ridiculous");
    }

    @Override
    public boolean containsValue(double pattern) {
        return pattern == 0.0 || pattern == 1.0;
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        return (long)this.sum(counts, nCol);
    }

    @Override
    public MatrixBlockDictionary getMBDict(int nCol) {
        MatrixBlockDictionary r;
        if (this.cache != null && (r = (MatrixBlockDictionary)this.cache.get()) != null) {
            return r;
        }
        MatrixBlockDictionary ret = this.createMBDict();
        this.cache = new SoftReference<MatrixBlockDictionary>(ret);
        return ret;
    }

    private MatrixBlockDictionary createMBDict() {
        MatrixBlock identity = new MatrixBlock(this.nRowCol, this.u - this.l, true);
        for (int i = this.l; i < this.u; ++i) {
            identity.quickSetValue(i, i - this.l, 1.0);
        }
        return new MatrixBlockDictionary(identity);
    }

    @Override
    public String getString(int colIndexes) {
        return "IdentityMatrix of size: " + this.nRowCol;
    }

    @Override
    public String toString() {
        return "IdentityMatrix of size: " + this.nRowCol;
    }

    @Override
    public IDictionary scaleTuples(int[] scaling, int nCol) {
        return this.getMBDict().scaleTuples(scaling, nCol);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.IDENTITY_SLICE.ordinal());
        out.writeInt(this.nRowCol);
        out.writeInt(this.l);
        out.writeInt(this.u);
    }

    public static IdentityDictionary read(DataInput in) throws IOException {
        return new IdentityDictionary(in.readInt());
    }

    @Override
    public long getExactSizeOnDisk() {
        return 13L;
    }

    @Override
    public IDictionary replace(double pattern, double replace, int nCol) {
        if (this.containsValue(pattern)) {
            return this.getMBDict().replace(pattern, replace, nCol);
        }
        return this;
    }

    @Override
    public IDictionary replaceWithReference(double pattern, double replace, double[] reference) {
        if (this.containsValueWithReference(pattern, reference)) {
            return this.getMBDict().replaceWithReference(pattern, replace, reference);
        }
        return this;
    }

    @Override
    public double getSparsity() {
        return 1.0 / (double)this.nRowCol;
    }

    @Override
    public IDictionary preaggValuesFromDense(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut) {
        return this.getMBDict().preaggValuesFromDense(numVals, colIndexes, aggregateColumns, b, cut);
    }

    @Override
    public void addToEntryVectorized(double[] v, int f1, int f2, int f3, int f4, int f5, int f6, int f7, int f8, int t1, int t2, int t3, int t4, int t5, int t6, int t7, int t8, int nCol) {
        throw new NotImplementedException();
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol, int rep) {
        throw new NotImplementedException();
    }

    @Override
    public boolean equals(IDictionary o) {
        if (o instanceof IdentityDictionarySlice) {
            IdentityDictionarySlice os = (IdentityDictionarySlice)o;
            return os.nRowCol == this.nRowCol && os.l == this.l && os.u == this.u;
        }
        if (o instanceof IdentityDictionary) {
            return false;
        }
        MatrixBlock mb = this.getMBDict().getMatrixBlock();
        if (o instanceof MatrixBlockDictionary) {
            return mb.equals(((MatrixBlockDictionary)o).getMatrixBlock());
        }
        if (o instanceof Dictionary) {
            if (mb.isInSparseFormat()) {
                return mb.getSparseBlock().equals(((Dictionary)o)._values, this.nRowCol);
            }
            double[] dv = mb.getDenseBlockValues();
            return Arrays.equals(dv, ((Dictionary)o)._values);
        }
        return false;
    }
}

