/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;

public class CPOperand {
    private String _name;
    private Types.ValueType _valueType;
    private Types.DataType _dataType;
    private boolean _isLiteral;
    private ScalarObject _literal;
    private PrivacyConstraint _privacyConstraint;

    public CPOperand() {
        this("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
    }

    public CPOperand(String str) {
        this("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        this.split(str);
    }

    public CPOperand(String name, Types.ValueType vt, Types.DataType dt) {
        this(name, vt, dt, false);
    }

    public CPOperand(String name, Types.ValueType vt, Types.DataType dt, boolean literal) {
        this._name = name;
        this._valueType = vt;
        this._dataType = dt;
        this._isLiteral = literal;
    }

    public CPOperand(ScalarObject so) {
        this._name = so.getStringValue();
        this._valueType = so.getValueType();
        this._dataType = Types.DataType.SCALAR;
        this._isLiteral = true;
    }

    public CPOperand(CPOperand variable) {
        this._name = variable._name;
        this._valueType = variable._valueType;
        this._dataType = variable._dataType;
        this._isLiteral = variable._isLiteral;
        this._literal = variable._literal;
    }

    public CPOperand(String name, Data dat) {
        this._name = name;
        this._valueType = dat.getValueType();
        this._dataType = dat.getDataType();
        this._isLiteral = false;
    }

    public String getName() {
        return this._name;
    }

    public Types.ValueType getValueType() {
        return this._valueType;
    }

    public Types.DataType getDataType() {
        return this._dataType;
    }

    public boolean isMatrix() {
        return this._dataType.isMatrix();
    }

    public boolean isFrame() {
        return this._dataType.isFrame();
    }

    public boolean isTensor() {
        return this._dataType.isTensor();
    }

    public boolean isList() {
        return this._dataType.isList();
    }

    public boolean isScalar() {
        return this._dataType.isScalar();
    }

    public boolean isLiteral() {
        return this._isLiteral;
    }

    public ScalarObject getLiteral() {
        if (!this._isLiteral) {
            throw new DMLRuntimeException("CPOperand is not a literal.");
        }
        if (this._literal == null) {
            this._literal = ScalarObjectFactory.createScalarObject(this._valueType, this._name);
        }
        return this._literal;
    }

    public void setName(String name) {
        this._name = name;
        this._literal = null;
    }

    public void setLiteral(ScalarObject literal) {
        this._name = String.valueOf(literal);
        this._literal = literal;
        this._isLiteral = this._literal != null;
    }

    public void split(String str) {
        String[] opr = str.split("\u00b7");
        if (opr.length == 4) {
            this._name = opr[0];
            this._dataType = Types.DataType.valueOf(opr[1]);
            this._valueType = Types.ValueType.valueOf(opr[2]);
            this._isLiteral = Boolean.parseBoolean(opr[3]);
        } else if (opr.length == 3) {
            this._name = opr[0];
            this._dataType = Types.DataType.valueOf(opr[1]);
            this._valueType = Types.ValueType.valueOf(opr[2]);
            this._isLiteral = false;
        } else if (opr.length == 1) {
            this._name = opr[0];
            this._dataType = Types.DataType.SCALAR;
            this._valueType = Types.ValueType.FP64;
            this._isLiteral = true;
        } else {
            this._name = opr[0];
            this._valueType = Types.ValueType.valueOf(opr[1]);
        }
    }

    public PrivacyConstraint getPrivacyConstraint() {
        return this._privacyConstraint;
    }

    public void setPrivacyConstraint(PrivacyConstraint privacyConstraint) {
        this._privacyConstraint = privacyConstraint;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public String getLineageLiteral() {
        return InstructionUtils.concatOperandParts(this.getName(), this.getDataType().name(), this.getValueType().name(), String.valueOf(this.isLiteral()));
    }

    public LineageItem getLiteralLineageItem() {
        return new LineageItem(this.getLineageLiteral());
    }

    public String getLineageLiteral(ScalarObject so) {
        return CPOperand.getLineageLiteral(so, this.isLiteral());
    }

    public static String getLineageLiteral(ScalarObject so, boolean isLiteral) {
        return InstructionUtils.concatOperandParts(so.toString(), so.getDataType().name(), so.getValueType().name(), String.valueOf(isLiteral));
    }
}

