/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.sysds.runtime.compress.DMLCompressionException;

public class EstimationFactors {
    protected final int numVals;
    protected final int numOffs;
    protected final int largestOff;
    protected final int[] frequencies;
    protected final int numSingle;
    protected final int numRows;
    protected final boolean lossy;
    protected final boolean zeroIsMostFrequent;
    protected final boolean containNoZeroValues;
    protected final double overAllSparsity;
    protected final double tupleSparsity;

    public EstimationFactors(int nCols, int numVals, int numRows) {
        this.numVals = numVals;
        this.numRows = numRows;
        this.frequencies = null;
        this.numOffs = -1;
        this.largestOff = -1;
        this.numSingle = -1;
        this.lossy = false;
        this.zeroIsMostFrequent = false;
        this.containNoZeroValues = false;
        this.overAllSparsity = 1.0;
        this.tupleSparsity = 1.0;
    }

    public EstimationFactors(int nCols, int numVals, int numOffs, int largestOff, int[] frequencies, int numSingle, int numRows, boolean lossy, boolean zeroIsMostFrequent, double overAllSparsity, double tupleSparsity) {
        this.numVals = numVals;
        this.numOffs = numOffs;
        this.largestOff = largestOff;
        this.frequencies = frequencies;
        this.numSingle = numSingle;
        this.numRows = numRows;
        this.lossy = lossy;
        this.zeroIsMostFrequent = zeroIsMostFrequent;
        this.containNoZeroValues = numOffs == numRows && overAllSparsity < 1.0;
        this.overAllSparsity = overAllSparsity;
        this.tupleSparsity = tupleSparsity;
        if (overAllSparsity > 1.0 || overAllSparsity < 0.0) {
            throw new DMLCompressionException("Invalid OverAllSparsity of: " + overAllSparsity);
        }
        if (tupleSparsity > 1.0 || tupleSparsity < 0.0) {
            throw new DMLCompressionException("Invalid TupleSparsity of:" + tupleSparsity);
        }
        if (largestOff > numRows) {
            throw new DMLCompressionException("Invalid number of instance of most common element should be lower than number of rows. " + largestOff + " > numRows: " + numRows);
        }
        if (numVals <= 0) {
            throw new DMLCompressionException("Should not use this constructor if empty");
        }
        if (numOffs <= 0) {
            throw new DMLCompressionException("Num offs are to low for this constructor");
        }
        if (numVals > numOffs) {
            throw new DMLCompressionException("Num vals cannot be greater than num offs");
        }
        if (largestOff < 0) {
            throw new DMLCompressionException("Invalid number of offset, should be greater than one");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rows:" + this.numRows);
        sb.append(" num Offsets:" + this.numOffs);
        sb.append(" LargestOffset:" + this.largestOff);
        sb.append(" num Singles:" + this.numSingle);
        sb.append(" num Unique Vals:" + this.numVals);
        sb.append(" overallSparsity:" + this.overAllSparsity);
        sb.append(" tupleSparsity:" + this.tupleSparsity);
        return sb.toString();
    }
}

