/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorExact;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorSample;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public interface CompressedSizeEstimatorFactory {
    public static final Log LOG = LogFactory.getLog((String)CompressedSizeEstimatorFactory.class.getName());

    public static CompressedSizeEstimator createEstimator(MatrixBlock data, CompressionSettings cs, int k) {
        int nRows = cs.transposed ? data.getNumColumns() : data.getNumRows();
        int nCols = cs.transposed ? data.getNumRows() : data.getNumColumns();
        double sparsity = data.getSparsity();
        int sampleSize = CompressedSizeEstimatorFactory.getSampleSize(cs, nRows, nCols, sparsity);
        if (data.isEmpty()) {
            return CompressedSizeEstimatorFactory.createExactEstimator(data, cs);
        }
        return CompressedSizeEstimatorFactory.createEstimator(data, cs, sampleSize, k, nRows);
    }

    public static CompressedSizeEstimator createEstimator(MatrixBlock data, CompressionSettings cs, int sampleSize, int k) {
        int nRows = cs.transposed ? data.getNumColumns() : data.getNumRows();
        return CompressedSizeEstimatorFactory.createEstimator(data, cs, sampleSize, k, nRows);
    }

    private static CompressedSizeEstimator createEstimator(MatrixBlock data, CompressionSettings cs, int sampleSize, int k, int nRows) {
        if ((double)sampleSize >= (double)nRows * 0.8) {
            return CompressedSizeEstimatorFactory.createExactEstimator(data, cs);
        }
        return CompressedSizeEstimatorFactory.createSampleEstimator(data, cs, sampleSize, k);
    }

    private static CompressedSizeEstimatorExact createExactEstimator(MatrixBlock data, CompressionSettings cs) {
        LOG.debug((Object)"Using full sample");
        return new CompressedSizeEstimatorExact(data, cs);
    }

    private static CompressedSizeEstimatorSample createSampleEstimator(MatrixBlock data, CompressionSettings cs, int sampleSize, int k) {
        LOG.debug((Object)("Using sample size: " + sampleSize));
        return new CompressedSizeEstimatorSample(data, cs, sampleSize, k);
    }

    private static int getSampleSize(CompressionSettings cs, int nRows, int nCols, double sparsity) {
        int maxSize = Math.min(cs.maxSampleSize, nRows);
        return CompressedSizeEstimatorFactory.getSampleSize(cs.samplePower, nRows, nCols, sparsity, cs.minimumSampleSize, maxSize);
    }

    private static int getSampleSize(double samplePower, int nRows, int nCols, double sparsity, int minSampleSize, int maxSampleSize) {
        int sampleSize = minSampleSize;
        samplePower = Math.max(0.0, Math.min(1.0, samplePower));
        sampleSize += (int)Math.ceil(Math.pow(nRows, samplePower));
        sampleSize = (int)((double)sampleSize * (1.0 / Math.min(sparsity + 0.2, 1.0)));
        sampleSize = Math.max(minSampleSize, Math.min(sampleSize, maxSampleSize));
        return sampleSize;
    }
}

