/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.Network$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.RpcTimeout$;
import org.apache.spark.util.Utils$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;

public final class RpcUtils$ {
    public static RpcUtils$ MODULE$;
    private final RpcTimeout INFINITE_TIMEOUT;
    private final int MAX_MESSAGE_SIZE_IN_MB;

    static {
        new RpcUtils$();
    }

    public RpcEndpointRef makeDriverRef(String name, SparkConf conf, RpcEnv rpcEnv) {
        String driverHost = conf.get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS().key(), "localhost");
        int driverPort = conf.getInt(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT().key(), 7077);
        Utils$.MODULE$.checkHost(driverHost);
        return rpcEnv.setupEndpointRef(new RpcAddress(driverHost, driverPort), name);
    }

    public int numRetries(SparkConf conf) {
        return BoxesRunTime.unboxToInt((Object)conf.get(Network$.MODULE$.RPC_NUM_RETRIES()));
    }

    public long retryWaitMs(SparkConf conf) {
        return BoxesRunTime.unboxToLong((Object)conf.get(Network$.MODULE$.RPC_RETRY_WAIT()));
    }

    public RpcTimeout askRpcTimeout(SparkConf conf) {
        return RpcTimeout$.MODULE$.apply(conf, (Seq<String>)((Seq)new .colon.colon((Object)Network$.MODULE$.RPC_ASK_TIMEOUT().key(), (List)new .colon.colon((Object)Network$.MODULE$.NETWORK_TIMEOUT().key(), (List)Nil$.MODULE$))), "120s");
    }

    public RpcTimeout lookupRpcTimeout(SparkConf conf) {
        return RpcTimeout$.MODULE$.apply(conf, (Seq<String>)((Seq)new .colon.colon((Object)Network$.MODULE$.RPC_LOOKUP_TIMEOUT().key(), (List)new .colon.colon((Object)Network$.MODULE$.NETWORK_TIMEOUT().key(), (List)Nil$.MODULE$))), "120s");
    }

    public RpcTimeout INFINITE_TIMEOUT() {
        return this.INFINITE_TIMEOUT;
    }

    private int MAX_MESSAGE_SIZE_IN_MB() {
        return this.MAX_MESSAGE_SIZE_IN_MB;
    }

    public int maxMessageSizeBytes(SparkConf conf) {
        int maxSizeInMB = BoxesRunTime.unboxToInt((Object)conf.get(Network$.MODULE$.RPC_MESSAGE_MAX_SIZE()));
        if (maxSizeInMB > this.MAX_MESSAGE_SIZE_IN_MB()) {
            throw new IllegalArgumentException(new StringBuilder(31).append(Network$.MODULE$.RPC_MESSAGE_MAX_SIZE().key()).append(" should not be greater than ").append(this.MAX_MESSAGE_SIZE_IN_MB()).append(" MB").toString());
        }
        return maxSizeInMB * 1024 * 1024;
    }

    private RpcUtils$() {
        MODULE$ = this;
        this.INFINITE_TIMEOUT = new RpcTimeout(new package.DurationLong(package$.MODULE$.DurationLong(Long.MAX_VALUE)).nanos(), "infinite");
        this.MAX_MESSAGE_SIZE_IN_MB = 2047;
    }
}

