/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.yarn;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.yarn.DMLAppMasterStatusReporter;
import org.apache.sysml.yarn.DMLAppMasterUtils;
import org.apache.sysml.yarn.DMLYarnClientProxy;

public class DMLAppMaster {
    private static final Log LOG = LogFactory.getLog(DMLAppMaster.class);
    private ApplicationId _appId = null;
    private YarnConfiguration _conf = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runApplicationMaster(String[] args) throws YarnException, IOException {
        this._conf = new YarnConfiguration();
        String containerIdString = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
        ContainerId containerId = ConverterUtils.toContainerId((String)containerIdString);
        this._appId = containerId.getApplicationAttemptId().getApplicationId();
        LOG.info((Object)("SystemML appplication master (applicationID: " + this._appId + ")"));
        AMRMClient rmClient = AMRMClient.createAMRMClient();
        rmClient.init((Configuration)this._conf);
        rmClient.start();
        rmClient.registerApplicationMaster("", 0, "");
        LOG.debug((Object)"Registered the SystemML application master with resource manager");
        DMLAppMasterStatusReporter reporter = new DMLAppMasterStatusReporter((AMRMClient<AMRMClient.ContainerRequest>)rmClient, 10000L);
        reporter.start();
        LOG.debug((Object)"Started status reporter (heartbeat to resource manager)");
        DMLScript.setActiveAM();
        String[] otherArgs = new GenericOptionsParser((Configuration)this._conf, args).getRemainingArgs();
        FinalApplicationStatus status = null;
        try {
            boolean success = DMLScript.executeScript((Configuration)this._conf, otherArgs);
            status = success ? FinalApplicationStatus.SUCCEEDED : FinalApplicationStatus.FAILED;
        }
        catch (DMLScriptException ex) {
            LOG.error((Object)("SystemML-AM: Failed to executed DML script due to stop call:\n\t" + ex.getMessage()));
            status = FinalApplicationStatus.FAILED;
            this.writeMessageToHDFSWorkingDir(ex.getMessage());
        }
        catch (Exception ex) {
            LOG.error((Object)"SystemML-AM: Failed to executed DML script.", (Throwable)ex);
            status = FinalApplicationStatus.FAILED;
        }
        finally {
            reporter.stopStatusReporter();
            LOG.debug((Object)"Stopped status reporter");
            rmClient.unregisterApplicationMaster(status, "", "");
            LOG.debug((Object)"Unregistered the SystemML application master");
        }
    }

    private void writeMessageToHDFSWorkingDir(String msg) {
        DMLConfig conf = ConfigurationManager.getDMLConfig();
        String hdfsWD = DMLAppMasterUtils.constructHDFSWorkingDir(conf, this._appId);
        Path msgPath = new Path(hdfsWD, "stop_msg.txt");
        try {
            FileSystem fs = IOUtilFunctions.getFileSystem(msgPath, (Configuration)this._conf);
            try (FSDataOutputStream fout = fs.create(msgPath, true);){
                fout.writeBytes(msg);
            }
            LOG.debug((Object)("Stop message written to HDFS file: " + msgPath));
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to write stop message to HDFS file: " + msgPath), (Throwable)ex);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            DMLAppMaster am = new DMLAppMaster();
            am.runApplicationMaster(args);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        if (DMLYarnClientProxy.LDEBUG) {
            Logger.getLogger((String)"org.apache.sysml.yarn").setLevel(Level.DEBUG);
        }
    }
}

