/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.Frame;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.utils.dataprep.ConvertToRatingsMatrix_output;

public class Dataprep
extends Script {
    public Dataprep() {
        String string = "scripts/utils/dataprep.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public ConvertToRatingsMatrix_output convertToRatingsMatrix(Object object, Object object2, Object object3) {
        String string = "source('scripts/utils/dataprep.dml') as mlcontextns;[X, M] = mlcontextns::convertToRatingsMatrix(R, thrU, thrP);";
        Script script = new Script(string);
        script.in("R", object).in("thrU", object2).in("thrP", object3).out("X").out("M");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("X");
        Frame frame = mLResults.getFrame("M");
        ConvertToRatingsMatrix_output convertToRatingsMatrix_output = new ConvertToRatingsMatrix_output(matrix, frame);
        return convertToRatingsMatrix_output;
    }

    public String convertToRatingsMatrix__docs() {
        String string = "convertToRatingsMatrix = function(frame[string] R, int thrU, int thrP)\n  return (matrix[double] X, frame[string] M) \n{\n  # recode users and products into continuous numeric ids\n  jspec = \"{ids:true, recode:[1,2]}\";\n  [TX,M] = transformencode( target = R, spec = jspec );\n  \n  # convert triples of user-product-rating into ratings matrix\n  X_full = table( TX[,1], TX[,2], TX[,3] );\n\n  # filter users and products if necessary (filter applies to original counts)\n  X = X_full;\n  if( thrU > 0 )\n    X = removeEmpty(target=X, margin=\"rows\", select=rowSums(X_full!=0)>=thrU);\n  if( thrP > 0 )\n    X = removeEmpty(target=X, margin=\"cols\", select=colSums(X_full!=0)>=thrP);\n}\n";
        return string;
    }

    public String convertToRatingsMatrix__source() {
        String string = "convertToRatingsMatrix = function(frame[string] R, int thrU, int thrP)\n  return (matrix[double] X, frame[string] M) \n{\n  # recode users and products into continuous numeric ids\n  jspec = \"{ids:true, recode:[1,2]}\";\n  [TX,M] = transformencode( target = R, spec = jspec );\n  \n  # convert triples of user-product-rating into ratings matrix\n  X_full = table( TX[,1], TX[,2], TX[,3] );\n\n  # filter users and products if necessary (filter applies to original counts)\n  X = X_full;\n  if( thrU > 0 )\n    X = removeEmpty(target=X, margin=\"rows\", select=rowSums(X_full!=0)>=thrU);\n  if( thrP > 0 )\n    X = removeEmpty(target=X, margin=\"cols\", select=colSums(X_full!=0)>=thrP);\n}\n";
        return string;
    }
}

