/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.util.Top_k2d_output;
import org.apache.sysml.scripts.nn.util.Top_k_output;
import org.apache.sysml.scripts.nn.util.Top_k_row_output;

public class Util
extends Script {
    public Util() {
        String string = "scripts/nn/util.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Top_k2d_output top_k2d(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;[values, indices] = mlcontextns::top_k2d(X, k, C, Hin, Win);";
        Script script = new Script(string);
        script.in("X", object).in("k", object2).in("C", object3).in("Hin", object4).in("Win", object5).out("values").out("indices");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("values");
        Matrix matrix2 = mLResults.getMatrix("indices");
        Top_k2d_output top_k2d_output = new Top_k2d_output(matrix, matrix2);
        return top_k2d_output;
    }

    public String top_k2d__docs() {
        String string = "top_k2d = function(matrix[double] X, int k, int C, int Hin, int Win)\n     return (matrix[double] values, matrix[double] indices) {\n  /*\n   * Computes the top k values (i.e. probabilities) and associated\n   * indices (i.e. classes) for the input matrix X.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - k: Input number of top elements to look for.\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - values: The top k values along a certain dimension, of shape\n   *    (N, k*Hin*Win).\n   *  - indices: The indices of classes, of shape (N, k*Hin*Win).\n   */\n";
        return string;
    }

    public String top_k2d__source() {
        String string = "top_k2d = function(matrix[double] X, int k, int C, int Hin, int Win)\n     return (matrix[double] values, matrix[double] indices) {\n  /*\n   * Computes the top k values (i.e. probabilities) and associated\n   * indices (i.e. classes) for the input matrix X.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - k: Input number of top elements to look for.\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - values: The top k values along a certain dimension, of shape\n   *    (N, k*Hin*Win).\n   *  - indices: The indices of classes, of shape (N, k*Hin*Win).\n   */\n  N = nrow(X)\n\n  # Reshape the input matrix (N, C*Hin*Win) to (N*Hin*Win, C)\n  X_C_NHW = transpose_NCHW_to_CNHW(X, C)\n  X_NHW_C = t(X_C_NHW)\n\n  # Compute the top k for the reshape matrix.\n  [values_NHW_K, indices_NHW_K] = top_k(X_NHW_C, k)  # shape: (N*Hin*Win, k)\n\n  values_K_NHW = t(values_NHW_K)\n  indices_K_NHW = t(indices_NHW_K)\n\n  values =  transpose_NCHW_to_CNHW(values_K_NHW, N)\n  indices = transpose_NCHW_to_CNHW(indices_K_NHW, N)\n}\n";
        return string;
    }

    public Matrix predict_class(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;Prediction = mlcontextns::predict_class(Prob, C, H, W);";
        Script script = new Script(string);
        script.in("Prob", object).in("C", object2).in("H", object3).in("W", object4).out("Prediction");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("Prediction");
        return matrix;
    }

    public String predict_class__docs() {
        String string = "predict_class = function(matrix[double] Prob, int C, int H, int W) return (matrix[double] Prediction) {\n  /*\n   * Computes the class labels from the probabilities.\n   *\n   * Inputs:\n   *  - Prob: Input Probability\n   *  - C: Number of output labels\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - Prediction: Class Labels.\n   */\n";
        return string;
    }

    public String predict_class__source() {
        String string = "predict_class = function(matrix[double] Prob, int C, int H, int W) return (matrix[double] Prediction) {\n  /*\n   * Computes the class labels from the probabilities.\n   *\n   * Inputs:\n   *  - Prob: Input Probability\n   *  - C: Number of output labels\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - Prediction: Class Labels.\n   */\n  if(H == 1 & W == 1) {\n    Prediction = rowIndexMax(Prob); # assuming one-based label mapping\n  }\n  else {\n    N = nrow(Prob);\n    Prediction = matrix(0, rows=N, cols=H*W);\n    parfor(n in 1:N) {\n      Prob1 = matrix(Prob[n,], rows=C, cols=H*W);\n      Prediction[n,] = t(rowIndexMax(t(Prob1))); # assuming one-based label mapping\n    }\n  }\n}\n";
        return string;
    }

    public Matrix im2col(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;img_cols = mlcontextns::im2col(img, Hin, Win, Hf, Wf, strideh, stridew);";
        Script script = new Script(string);
        script.in("img", object).in("Hin", object2).in("Win", object3).in("Hf", object4).in("Wf", object5).in("strideh", object6).in("stridew", object7).out("img_cols");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("img_cols");
        return matrix;
    }

    public String im2col__docs() {
        String string = "im2col = function(matrix[double] img, int Hin, int Win, int Hf, int Wf, int strideh, int stridew)\n    return (matrix[double] img_cols) {\n  /*\n   * Rearrange local image regions (patches) into columns.\n   *\n   * Assumes image has already been padded as necessary.\n   *\n   * Inputs:\n   *  - img: Input image, of shape (C, Hin*Win), where C is the number\n   *      of input channels (depth).\n   *  - Hin: Input height, including padding.\n   *  - Win: Input width, including padding.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *\n   * Outputs:\n   *  - img_cols: Local spatial regions (patches) of the image stretched\n   *      out into columns, of shape (C*Hf*Wf, Hout*Wout).\n   */\n";
        return string;
    }

    public String im2col__source() {
        String string = "im2col = function(matrix[double] img, int Hin, int Win, int Hf, int Wf, int strideh, int stridew)\n    return (matrix[double] img_cols) {\n  /*\n   * Rearrange local image regions (patches) into columns.\n   *\n   * Assumes image has already been padded as necessary.\n   *\n   * Inputs:\n   *  - img: Input image, of shape (C, Hin*Win), where C is the number\n   *      of input channels (depth).\n   *  - Hin: Input height, including padding.\n   *  - Win: Input width, including padding.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *\n   * Outputs:\n   *  - img_cols: Local spatial regions (patches) of the image stretched\n   *      out into columns, of shape (C*Hf*Wf, Hout*Wout).\n   */\n  C = nrow(img)\n  Hout = as.integer(floor((Hin-Hf)/strideh + 1))\n  Wout = as.integer(floor((Win-Wf)/stridew + 1))\n\n  # Note: We start with `img_cols` transposed to allow for row-major\n  # left-indexing inside the loop, which is more performant.\n  img_cols = matrix(0, rows=Hout*Wout, cols=C*Hf*Wf)  # zeros\n  parfor (hout in 1:Hout, check=0) {  # all output rows\n    hin = (hout-1)*strideh + 1\n    parfor (wout in 1:Wout, check=0) {  # all output columns\n      win = (wout-1)*stridew + 1\n      # Extract a local patch of the input image corresponding spatially to the filter sizes.\n      img_patch = matrix(0, rows=C, cols=Hf*Wf)  # zeros\n      parfor (c in 1:C) {  # all channels\n        img_slice = matrix(img[c,], rows=Hin, cols=Win)  # reshape\n        img_patch[c,] = matrix(img_slice[hin:hin+Hf-1, win:win+Wf-1], rows=1, cols=Hf*Wf)\n      }\n      img_cols[(hout-1)*Wout + wout,] = t(matrix(img_patch, rows=C*Hf*Wf, cols=1))  # reshape\n    }\n  }\n  img_cols = t(img_cols)\n}\n";
        return string;
    }

    public Matrix pad_image(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;img_padded = mlcontextns::pad_image(img, Hin, Win, padh, padw, pad_value);";
        Script script = new Script(string);
        script.in("img", object).in("Hin", object2).in("Win", object3).in("padh", object4).in("padw", object5).in("pad_value", object6).out("img_padded");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("img_padded");
        return matrix;
    }

    public String pad_image__docs() {
        String string = "pad_image = function(matrix[double] img, int Hin, int Win, int padh, int padw, double pad_value)\n    return (matrix[double] img_padded) {\n  /*\n   * Pads an image along the height and width dimensions with zeros.\n   *\n   * Inputs:\n   *  - img: Input image, of shape (C, Hin*Win), where C is the number\n   *      of input channels (depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *  - pad_value: Value to use for the padding.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - img_padded: The input image padded along the height and width\n   *      dimensions, of shape (C, (Hin+2*padh)*(Win+2*padw)).\n   */\n";
        return string;
    }

    public String pad_image__source() {
        String string = "pad_image = function(matrix[double] img, int Hin, int Win, int padh, int padw, double pad_value)\n    return (matrix[double] img_padded) {\n  /*\n   * Pads an image along the height and width dimensions with zeros.\n   *\n   * Inputs:\n   *  - img: Input image, of shape (C, Hin*Win), where C is the number\n   *      of input channels (depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *  - pad_value: Value to use for the padding.\n   *      A typical value is 0.\n   *\n   * Outputs:\n   *  - img_padded: The input image padded along the height and width\n   *      dimensions, of shape (C, (Hin+2*padh)*(Win+2*padw)).\n   */\n  C = nrow(img)\n  img_padded = matrix(0, rows=C, cols=(Hin+2*padh)*(Win+2*padw))  # zeros\n  parfor (c in 1:C) {\n    img_slice = matrix(img[c,], rows=Hin, cols=Win)  # depth slice C reshaped\n    img_padded_slice = matrix(pad_value, rows=Hin+2*padh, cols=Win+2*padw)\n    img_padded_slice[padh+1:padh+Hin, padw+1:padw+Win] = img_slice\n    img_padded[c,] = matrix(img_padded_slice, rows=1, cols=(Hin+2*padh)*(Win+2*padw))  # reshape\n  }\n}\n";
        return string;
    }

    public Top_k_row_output top_k_row(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;[values, indices] = mlcontextns::top_k_row(X, r, k);";
        Script script = new Script(string);
        script.in("X", object).in("r", object2).in("k", object3).out("values").out("indices");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("values");
        Matrix matrix2 = mLResults.getMatrix("indices");
        Top_k_row_output top_k_row_output = new Top_k_row_output(matrix, matrix2);
        return top_k_row_output;
    }

    public String top_k_row__docs() {
        String string = "top_k_row = function(matrix[double] X, integer r, integer k)\n    return (matrix[double] values, matrix[double] indices) {\n  /*\n   * Computes the top k values (i.e. probabilities) and associated\n   * indices (i.e. classes) in the rth row of the input matrix X.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - r: Input row number of X to look for.\n   *  - k: Input number of top elements to look for.\n   *\n   * Outputs:\n   *  - values: The top k values at the rth row, of shape\n   *    (1, k).\n   *  - indices: The class indices, of shape (1, k).\n   */\n";
        return string;
    }

    public String top_k_row__source() {
        String string = "top_k_row = function(matrix[double] X, integer r, integer k)\n    return (matrix[double] values, matrix[double] indices) {\n  /*\n   * Computes the top k values (i.e. probabilities) and associated\n   * indices (i.e. classes) in the rth row of the input matrix X.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - r: Input row number of X to look for.\n   *  - k: Input number of top elements to look for.\n   *\n   * Outputs:\n   *  - values: The top k values at the rth row, of shape\n   *    (1, k).\n   *  - indices: The class indices, of shape (1, k).\n   */\n\n  #TODO: do r & k need to be checked in the valid range\n  row = X[r, ]\n  row_t = t(row)\n  indices = order(target=row_t, by=1, decreasing=TRUE, index.return=TRUE)\n  indices = t(indices)\n  indices = indices[1, 1:k]\n\n  values = matrix(0, rows=1, cols=k)\n  for (i in 1:k) {\n    values[1, i] = row[1, as.scalar(indices[1, i])]\n  }\n}\n";
        return string;
    }

    public Top_k_output top_k(Object object, Object object2) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;[values, indices] = mlcontextns::top_k(X, k);";
        Script script = new Script(string);
        script.in("X", object).in("k", object2).out("values").out("indices");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("values");
        Matrix matrix2 = mLResults.getMatrix("indices");
        Top_k_output top_k_output = new Top_k_output(matrix, matrix2);
        return top_k_output;
    }

    public String top_k__docs() {
        String string = "top_k = function(matrix[double] X, integer k)\n     return (matrix[double] values, matrix[double] indices) {\n  /*\n   * Computes the top k values (i.e. probabilities) and associated\n   * indices (i.e. classes) for the input matrix X.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - k: Input number of top elements to look for.\n   *\n   * Outputs:\n   *  - values: The top k values along a certain dimension, of shape\n   *    (N, k).\n   *  - indices: The indices of classes, of shape (N, K).\n   */\n";
        return string;
    }

    public String top_k__source() {
        String string = "top_k = function(matrix[double] X, integer k)\n     return (matrix[double] values, matrix[double] indices) {\n  /*\n   * Computes the top k values (i.e. probabilities) and associated\n   * indices (i.e. classes) for the input matrix X.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, D).\n   *  - k: Input number of top elements to look for.\n   *\n   * Outputs:\n   *  - values: The top k values along a certain dimension, of shape\n   *    (N, k).\n   *  - indices: The indices of classes, of shape (N, K).\n   */\n  N = nrow(X)\n  D = ncol(X)\n  values = matrix(0, rows=N, cols=k)\n  indices = matrix(0, rows=N, cols=k)\n\n  parfor (r in 1:N) {\n    [value, index] = top_k_row(X, r, k)\n    values[r, ] = value\n    indices[r, ] = index\n  }\n}\n";
        return string;
    }

    public Matrix threshold(Object object, Object object2) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;out = mlcontextns::threshold(X, thresh);";
        Script script = new Script(string);
        script.in("X", object).in("thresh", object2).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String threshold__docs() {
        String string = "threshold = function(matrix[double] X, double thresh)\n    return (matrix[double] out) {\n  /*\n   * Computes an indicator matrix with values in {0, 1} depending on\n   * whether or not the values in X are above the input threshold.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - thresh: Input threshold.\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as X.\n   */\n";
        return string;
    }

    public String threshold__source() {
        String string = "threshold = function(matrix[double] X, double thresh)\n    return (matrix[double] out) {\n  /*\n   * Computes an indicator matrix with values in {0, 1} depending on\n   * whether or not the values in X are above the input threshold.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - thresh: Input threshold.\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as X.\n   */\n  out = X > thresh\n}\n";
        return string;
    }

    public Matrix transpose_NCHW_to_CNHW(Object object, Object object2) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;out = mlcontextns::transpose_NCHW_to_CNHW(X, C);";
        Script script = new Script(string);
        script.in("X", object).in("C", object2).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String transpose_NCHW_to_CNHW__docs() {
        String string = "transpose_NCHW_to_CNHW = function(matrix[double] X, int C)\n    return (matrix[double] out) {\n  /*\n   * Reshape util for tensors in NCHW format.\n   * Transposes the 1st and 2nd dimensions.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*H*W).\n   *  - C: Number of channels (dimensionality of depth).\n   *\n   * Outputs:\n   *  - out: Outputs with the N and C axes transposed, of\n   *      shape (C, N*H*W).\n   */\n";
        return string;
    }

    public String transpose_NCHW_to_CNHW__source() {
        String string = "transpose_NCHW_to_CNHW = function(matrix[double] X, int C)\n    return (matrix[double] out) {\n  /*\n   * Reshape util for tensors in NCHW format.\n   * Transposes the 1st and 2nd dimensions.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*H*W).\n   *  - C: Number of channels (dimensionality of depth).\n   *\n   * Outputs:\n   *  - out: Outputs with the N and C axes transposed, of\n   *      shape (C, N*H*W).\n   */\n  N = nrow(X)\n  D = ncol(X) / C\n\n  # This is an easy reshape because the channels remain intact. By\n  # reshaping X to a matrix with N*C rows, we can reduce our task to\n  # re-ordering rows (followed by the obvious reshape to achieve the\n  # required output shape with C rows).\n  #\n  # The difficult part is to obtain the permutation matrix required\n  # for re-ordering the rows. In this case, since we want to bring the\n  # ith channels from all rows together, we will need a column vector\n  # of the following form:\n  # [1, 1+C, 1+2C, ..., 1+(N-1)C,\n  #  2, 2+C, ..., 2+(N-1)C,\n  #  3, 3+C, ..., 3+(N-1)C,\n  #  .\n  #  .\n  #  .\n  #  C, 2C, ..., NC]'\n  # This vector can be produced via an outer call.\n  col_idx = outer(seq(1,C), C*t(seq(0,N-1)), \"+\")\n\n  # Generate the permutation matrix by:\n  # - reshaping the result of outer into a col\n  # - invoking table\n  permut = table(seq(1, N*C), matrix(col_idx, rows=N*C, cols=1), N*C, N*C)\n\n  # Generate the output by:\n  # - pre-multiplying the (reshaped) X with the permutation matrix\n  # - reshape to get the output shape with C rows\n  out = matrix(permut %*% matrix(X, rows=N*C, cols=D), rows=C, cols=N*D)\n}\n";
        return string;
    }

    public Matrix col2im(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;img = mlcontextns::col2im(img_cols, C, Hin, Win, Hf, Wf, strideh, stridew, reduction);";
        Script script = new Script(string);
        script.in("img_cols", object).in("C", object2).in("Hin", object3).in("Win", object4).in("Hf", object5).in("Wf", object6).in("strideh", object7).in("stridew", object8).in("reduction", object9).out("img");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("img");
        return matrix;
    }

    public String col2im__docs() {
        String string = "col2im = function(matrix[double] img_cols, int C, int Hin, int Win, int Hf, int Wf,\n                  int strideh, int stridew, string reduction)\n    return (matrix[double] img) {\n  /*\n   * Create an image from columns of local image regions (patches).\n   *\n   * The reduction strategy determines how to deal with overlapping\n   * patches.  If it is set to \"add\", any overlapping patches will be\n   * added together when creating the image.  This is useful when\n   * computing gradients on the original image given gradients on the\n   * patches.  Otherwise, if \"none\" is provided, any overlapping\n   * patches will just override previous ones when creating the image.\n   * This is useful when recreating an image from the output of\n   * `im2col`.\n   *\n   * Assumes original image was already padded as necessary.\n   *\n   * Inputs:\n   *  - img_cols: Local spatial regions (patches) of the image stretched\n   *      out into columns, of shape (C*Hf*Wf, Hout*Wout).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height, including padding.\n   *  - Win: Input width, including padding.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - reduction: The reduction strategy to use for overlapping\n   *      patches.  Valid options are \"add\" and \"none\".\n   *\n   * Outputs:\n   *  - img: Input image, of shape (C, Hin*Win).\n   */\n";
        return string;
    }

    public String col2im__source() {
        String string = "col2im = function(matrix[double] img_cols, int C, int Hin, int Win, int Hf, int Wf,\n                  int strideh, int stridew, string reduction)\n    return (matrix[double] img) {\n  /*\n   * Create an image from columns of local image regions (patches).\n   *\n   * The reduction strategy determines how to deal with overlapping\n   * patches.  If it is set to \"add\", any overlapping patches will be\n   * added together when creating the image.  This is useful when\n   * computing gradients on the original image given gradients on the\n   * patches.  Otherwise, if \"none\" is provided, any overlapping\n   * patches will just override previous ones when creating the image.\n   * This is useful when recreating an image from the output of\n   * `im2col`.\n   *\n   * Assumes original image was already padded as necessary.\n   *\n   * Inputs:\n   *  - img_cols: Local spatial regions (patches) of the image stretched\n   *      out into columns, of shape (C*Hf*Wf, Hout*Wout).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height, including padding.\n   *  - Win: Input width, including padding.\n   *  - Hf: Filter height.\n   *  - Wf: Filter width.\n   *  - strideh: Stride over height.\n   *  - stridew: Stride over width.\n   *  - reduction: The reduction strategy to use for overlapping\n   *      patches.  Valid options are \"add\" and \"none\".\n   *\n   * Outputs:\n   *  - img: Input image, of shape (C, Hin*Win).\n   */\n  Hout = as.integer(floor((Hin-Hf)/strideh + 1))\n  Wout = as.integer(floor((Win-Wf)/stridew + 1))\n\n  img = matrix(0, rows=C, cols=Hin*Win)  # zeros\n  for (hout in 1:Hout) {  # all output rows\n    hin = (hout-1)*strideh + 1\n    for (wout in 1:Wout) {  # all output columns\n      win = (wout-1)*stridew + 1\n      # Extract a local patch of the input image corresponding spatially to the filter sizes.\n      img_patch = matrix(img_cols[,(hout-1)*Wout + wout], rows=C, cols=Hf*Wf)  # zeros\n      parfor (c in 1:C) {  # all channels\n        img_patch_slice = matrix(img_patch[c,], rows=Hf, cols=Wf)  # reshape\n        if (reduction == \"add\") {\n          img_slice = matrix(0, rows=Hin, cols=Win)\n          img_slice[hin:hin+Hf-1, win:win+Wf-1] = img_patch_slice\n          img[c,] = img[c,] + matrix(img_slice, rows=1, cols=Hin*Win)\n        } else {\n          img_slice = matrix(img[c,], rows=Hin, cols=Win)\n          img_slice[hin:hin+Hf-1, win:win+Wf-1] = img_patch_slice\n          img[c,] = matrix(img_slice, rows=1, cols=Hin*Win)\n        }\n      }\n    }\n  }\n}\n";
        return string;
    }

    public Matrix unpad_image(Object object, Object object2, Object object3, Object object4, Object object5) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;img = mlcontextns::unpad_image(img_padded, Hin, Win, padh, padw);";
        Script script = new Script(string);
        script.in("img_padded", object).in("Hin", object2).in("Win", object3).in("padh", object4).in("padw", object5).out("img");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("img");
        return matrix;
    }

    public String unpad_image__docs() {
        String string = "unpad_image = function(matrix[double] img_padded, int Hin, int Win, int padh, int padw)\n    return (matrix[double] img) {\n  /*\n   * Unpads an image along the height and width dimensions.\n   *\n   * Inputs:\n   *  - img_padded: The input image padded along the height and width\n   *      dimensions, of shape (C, (Hin+2*padh)*(Win+2*padw)).\n   *  - Hin: Input height of unpadded image.\n   *  - Win: Input width of unpadded image.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - img: Input image, of shape (C, Hin*Win), where C is the number\n   *      of input channels (depth).\n   */\n";
        return string;
    }

    public String unpad_image__source() {
        String string = "unpad_image = function(matrix[double] img_padded, int Hin, int Win, int padh, int padw)\n    return (matrix[double] img) {\n  /*\n   * Unpads an image along the height and width dimensions.\n   *\n   * Inputs:\n   *  - img_padded: The input image padded along the height and width\n   *      dimensions, of shape (C, (Hin+2*padh)*(Win+2*padw)).\n   *  - Hin: Input height of unpadded image.\n   *  - Win: Input width of unpadded image.\n   *  - padh: Padding for top and bottom sides.\n   *  - padw: Padding for left and right sides.\n   *\n   * Outputs:\n   *  - img: Input image, of shape (C, Hin*Win), where C is the number\n   *      of input channels (depth).\n   */\n  C = nrow(img_padded)\n  img = matrix(0, rows=C, cols=Hin*Win)\n  parfor (c in 1:C) {\n    img_padded_slice = matrix(img_padded[c,], rows=(Hin+2*padh), cols=(Win+2*padw))\n    img_slice = img_padded_slice[padh+1:padh+Hin, padw+1:padw+Win]\n    img[c,] = matrix(img_slice, rows=1, cols=Hin*Win)\n  }\n}\n";
        return string;
    }

    public Matrix channel_sums(Object object, Object object2, Object object3, Object object4) {
        String string = "source('scripts/nn/util.dml') as mlcontextns;out = mlcontextns::channel_sums(X, C, Hin, Win);";
        Script script = new Script(string);
        script.in("X", object).in("C", object2).in("Hin", object3).in("Win", object4).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String channel_sums__docs() {
        String string = "channel_sums = function(matrix[double] X, int C, int Hin, int Win)\n    return (matrix[double] out) {\n  /*\n   * Computes a channel-wise summation over a 4D input.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (C, 1).\n   */\n";
        return string;
    }

    public String channel_sums__source() {
        String string = "channel_sums = function(matrix[double] X, int C, int Hin, int Win)\n    return (matrix[double] out) {\n  /*\n   * Computes a channel-wise summation over a 4D input.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *  - Hin: Input height.\n   *  - Win: Input width.\n   *\n   * Outputs:\n   *  - out: Outputs, of shape (C, 1).\n   */\n  # Here we sum each column, reshape to (C, Hin*Win), and sum each row to result in the summation\n  # for each channel.\n  out = rowSums(matrix(colSums(X), rows=C, cols=Hin*Win))  # shape (C, 1)\n}\n";
        return string;
    }
}

