/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class Elu
extends Script {
    public Elu() {
        String string = "scripts/nn/layers/elu.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix forward(Object object, Object object2) {
        String string = "source('scripts/nn/layers/elu.dml') as mlcontextns;out = mlcontextns::forward(X, alpha);";
        Script script = new Script(string);
        script.in("X", object).in("alpha", object2).out("out");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        return matrix;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, int alpha)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a ELUs nonlinearity layer.\n   * Reference paper https://arxiv.org/abs/1511.07289v1\n   * Performs an element-wise evaluation of\n   * `f(x) = x if x u2265 0 else u03B1 (exp(x) u2212 1)`.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - alpha: Input, minimum value that the ELU can reach\n   *           Typical value 1\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as `X`.\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, int alpha)\n    return (matrix[double] out) {\n  /*\n   * Computes the forward pass for a ELUs nonlinearity layer.\n   * Reference paper https://arxiv.org/abs/1511.07289v1\n   * Performs an element-wise evaluation of\n   * `f(x) = x if x u2265 0 else u03B1 (exp(x) u2212 1)`.\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (any, any).\n   *  - alpha: Input, minimum value that the ELU can reach\n   *           Typical value 1\n   *\n   * Outputs:\n   *  - out: Outputs, of same shape as `X`.\n   */\n  out = max(0, X) + min(0, alpha * (exp(X) - 1))\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/layers/elu.dml') as mlcontextns;dX = mlcontextns::backward(dout, X, alpha);";
        Script script = new Script(string);
        script.in("dout", object).in("X", object2).in("alpha", object3).out("dX");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] X, int alpha)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a ELU nonlinearity layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of same shape as `X`.\n   *  - X: Previous input data matrix, of shape (any, any).\n   *  - alpha: Minimum value that the ELU can reach\n   *           Typical value 1\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] X, int alpha)\n    return (matrix[double] dX) {\n  /*\n   * Computes the backward pass for a ELU nonlinearity layer.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out` from upstream, of same shape as `X`.\n   *  - X: Previous input data matrix, of shape (any, any).\n   *  - alpha: Minimum value that the ELU can reach\n   *           Typical value 1\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of same shape as `X`.\n   */\n  dX = ((X > 0) + (X < 0) * (alpha * exp(X))) * dout\n}\n";
        return string;
    }
}

