/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;

public class MatrixPackedCell
extends MatrixCell {
    private static final long serialVersionUID = -3633665169444817750L;
    private double[] extras = null;
    private int extra_size = 0;

    public MatrixPackedCell(MatrixPackedCell that) {
        this.value = that.value;
        this.checkAndAllocateSpace(that.extra_size);
        for (int i = 0; i < this.extra_size; ++i) {
            this.extras[i] = that.extras[i];
        }
    }

    public MatrixPackedCell() {
    }

    private void checkAndAllocateSpace(int size) {
        if (this.extras == null || this.extras.length < size) {
            this.extras = new double[size];
        }
        this.extra_size = size;
    }

    public static MatrixPackedCell checkType(MatrixValue cell) {
        if (cell != null && !(cell instanceof MatrixPackedCell)) {
            throw new DMLRuntimeException("the Matrix Value is not MatrixPackedCell!");
        }
        return (MatrixPackedCell)cell;
    }

    public double getExtraByPostition(int i) {
        if (this.extras == null || i >= this.extra_size) {
            return 0.0;
        }
        return this.extras[i];
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue correction, MatrixValue newWithCorrection, boolean deep) {
        this.incrementalAggregate(aggOp, newWithCorrection);
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue newWithCorrection) {
        MatrixPackedCell newWithCor = MatrixPackedCell.checkType(newWithCorrection);
        if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.NONE || aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTROW || aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTCOLUMN) {
            this.checkAndAllocateSpace(1);
            KahanObject buffer = new KahanObject(this.value, this.extras[0]);
            buffer = (KahanObject)aggOp.increOp.fn.execute(buffer, newWithCor.value, newWithCor.getExtraByPostition(0));
            this.value = buffer._sum;
            this.extras[0] = buffer._correction;
        } else if (aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTROW || aggOp.correctionLocation == PartialAggregate.CorrectionLocationType.LASTTWOCOLUMNS) {
            this.checkAndAllocateSpace(2);
            KahanObject buffer = new KahanObject(this.value, this.extras[0]);
            buffer._sum = this.value;
            double n = this.extras[0];
            buffer._correction = this.extras[1];
            double mu2 = newWithCor.value;
            double n2 = newWithCor.getExtraByPostition(0);
            double toadd = (mu2 - buffer._sum) * n2 / (n += n2);
            buffer = (KahanObject)aggOp.increOp.fn.execute((Data)buffer, toadd);
            this.value = buffer._sum;
            this.extras[0] = n;
            this.extras[1] = buffer._correction;
        } else {
            throw new DMLRuntimeException("unrecognized correctionLocation: " + (Object)((Object)aggOp.correctionLocation));
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readDouble();
        int n = in.readInt();
        if (this.extras == null || this.extras.length < n) {
            this.extras = new double[n];
        }
        for (int i = 0; i < n; ++i) {
            this.extras[i] = in.readDouble();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.value);
        out.writeInt(this.extra_size);
        for (int i = 0; i < this.extra_size; ++i) {
            out.writeDouble(this.extras[i]);
        }
    }

    @Override
    public int compareTo(Object other) {
        if (!(other instanceof MatrixPackedCell)) {
            throw new RuntimeException("cannot compare MatrixPackedCell with " + other.getClass());
        }
        MatrixPackedCell that = (MatrixPackedCell)other;
        if (this.value != that.value) {
            return Double.compare(this.value, that.value);
        }
        if (this.extra_size != that.extra_size) {
            return this.extra_size - that.extra_size;
        }
        for (int i = 0; i < this.extra_size; ++i) {
            if (this.extras[i] == that.extras[i]) continue;
            return Double.compare(this.extras[i], that.extras[i]);
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        boolean ret;
        if (!(other instanceof MatrixPackedCell)) {
            throw new RuntimeException("cannot compare MatrixPackedCell with " + other.getClass());
        }
        MatrixPackedCell that = (MatrixPackedCell)other;
        boolean bl = ret = this.value == that.value && this.extra_size == that.extra_size;
        if (ret) {
            for (int i = 0; i < this.extra_size; ++i) {
                if (this.extras[i] == that.extras[i]) continue;
                return false;
            }
        }
        return ret;
    }

    @Override
    public int hashCode() {
        throw new RuntimeException("hashCode() should never be called on instances of this class.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\nextras: ");
        for (int i = 0; i < this.extra_size; ++i) {
            sb.append(this.extras[i]);
            sb.append(", ");
        }
        return sb.toString();
    }
}

