/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cpfile;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.IndexRange;
import org.apache.sysml.runtime.util.MapReduceTool;

public final class MatrixIndexingCPFileInstruction
extends IndexingCPInstruction {
    private MatrixIndexingCPFileInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(in, rl, ru, cl, cu, out, opcode, istr);
    }

    public static MatrixIndexingCPFileInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("rightIndex")) {
            if (parts.length == 7) {
                CPOperand in = new CPOperand(parts[1]);
                CPOperand rl = new CPOperand(parts[2]);
                CPOperand ru = new CPOperand(parts[3]);
                CPOperand cl = new CPOperand(parts[4]);
                CPOperand cu = new CPOperand(parts[5]);
                CPOperand out = new CPOperand(parts[6]);
                return new MatrixIndexingCPFileInstruction(in, rl, ru, cl, cu, out, opcode, str);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        if (parts[0].equalsIgnoreCase("leftIndex")) {
            throw new DMLRuntimeException("Invalid opcode while parsing a MatrixIndexingCPFileInstruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a MatrixIndexingCPFileInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String opcode = this.getOpcode();
        IndexRange ixrange = this.getIndexRange(ec).add(1);
        MatrixObject mo = ec.getMatrixObject(this.input1.getName());
        if (mo.isPartitioned() && opcode.equalsIgnoreCase("rightIndex")) {
            MetaDataFormat meta = (MetaDataFormat)mo.getMetaData();
            MatrixCharacteristics mc = meta.getMatrixCharacteristics();
            String pfname = mo.getPartitionFileName(ixrange, mc.getRowsPerBlock(), mc.getColsPerBlock());
            if (MapReduceTool.existsFileOnHDFS(pfname)) {
                MatrixObject mobj = new MatrixObject(mo.getValueType(), pfname);
                MatrixCharacteristics mcNew = null;
                switch (mo.getPartitionFormat()) {
                    case ROW_WISE: {
                        mcNew = new MatrixCharacteristics(1L, mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock());
                        break;
                    }
                    case ROW_BLOCK_WISE_N: {
                        mcNew = new MatrixCharacteristics(mo.getPartitionSize(), mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock());
                        break;
                    }
                    case COLUMN_WISE: {
                        mcNew = new MatrixCharacteristics(mc.getRows(), 1L, mc.getRowsPerBlock(), mc.getColsPerBlock());
                        break;
                    }
                    case COLUMN_BLOCK_WISE_N: {
                        mcNew = new MatrixCharacteristics(mc.getRows(), mo.getPartitionSize(), mc.getRowsPerBlock(), mc.getColsPerBlock());
                        break;
                    }
                    default: {
                        throw new DMLRuntimeException("Unsupported partition format for CP_FILE rightIndex: " + (Object)((Object)mo.getPartitionFormat()));
                    }
                }
                MetaDataFormat metaNew = new MetaDataFormat(mcNew, meta.getOutputInfo(), meta.getInputInfo());
                mobj.setMetaData(metaNew);
                mobj.enableCleanup(false);
                ec.setVariable(this.output.getName(), mobj);
            } else {
                MatrixBlock resultBlock = mo.readMatrixPartition(ixrange);
                ec.setMatrixOutput(this.output.getName(), resultBlock, this.getExtendedOpcode());
            }
        } else {
            throw new DMLRuntimeException("Invalid opcode or index predicate for MatrixIndexingCPFileInstruction: " + this.instString);
        }
    }
}

