/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.sslcert.crl;

import java.security.cert.X509CRL;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.utils.sslcert.cache.CacheController;
import org.apache.synapse.transport.utils.sslcert.cache.CacheManager;
import org.apache.synapse.transport.utils.sslcert.cache.ManageableCache;
import org.apache.synapse.transport.utils.sslcert.cache.ManageableCacheValue;
import org.apache.synapse.transport.utils.sslcert.crl.CRLVerifier;

public class CRLCache
implements ManageableCache {
    private static final Log log = LogFactory.getLog(CRLCache.class);
    private static final CRLCache cache = new CRLCache();
    private final Map<String, CRLCacheValue> hashMap = new ConcurrentHashMap<String, CRLCacheValue>();
    private Iterator<Map.Entry<String, CRLCacheValue>> iterator = this.hashMap.entrySet().iterator();
    private volatile CacheManager cacheManager;
    private final CRLVerifier crlVerifier = new CRLVerifier(null);

    private CRLCache() {
    }

    public static CRLCache getCache() {
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(int size, int delay) {
        if (this.cacheManager != null) return;
        Class<CRLCache> clazz = CRLCache.class;
        synchronized (CRLCache.class) {
            if (this.cacheManager != null) return;
            this.cacheManager = new CacheManager(cache, size, delay);
            CacheController mbean = new CacheController(cache, this.cacheManager);
            MBeanRegistrar.getInstance().registerMBean((Object)mbean, "CacheController", "CRLCacheController");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized ManageableCacheValue getNextCacheValue() {
        if (this.iterator.hasNext()) {
            return this.hashMap.get(this.iterator.next().getKey());
        }
        this.resetIterator();
        return null;
    }

    @Override
    public synchronized int getCacheSize() {
        return this.hashMap.size();
    }

    @Override
    public synchronized void resetIterator() {
        this.iterator = this.hashMap.entrySet().iterator();
    }

    private synchronized void replaceNewCacheValue(CRLCacheValue cacheValue) {
        if (cacheValue.isValid()) {
            return;
        }
        try {
            String crlUrl = cacheValue.crlUrl;
            X509CRL x509CRL = this.crlVerifier.downloadCRLFromWeb(crlUrl);
            this.setCacheValue(crlUrl, x509CRL);
        }
        catch (Exception e) {
            log.debug((Object)"Cant replace old CacheValue with new CacheValue. So remove", (Throwable)e);
            cacheValue.removeThisCacheValue();
        }
    }

    public synchronized X509CRL getCacheValue(String crlUrl) {
        CRLCacheValue cacheValue = this.hashMap.get(crlUrl);
        if (cacheValue != null) {
            if (!cacheValue.isValid()) {
                cacheValue.updateCacheWithNewValue();
                CRLCacheValue crlCacheValue = this.hashMap.get(crlUrl);
                return crlCacheValue != null ? crlCacheValue.getValue() : null;
            }
            return cacheValue.getValue();
        }
        return null;
    }

    public synchronized void setCacheValue(String crlUrl, X509CRL crl) {
        CRLCacheValue cacheValue = new CRLCacheValue(crlUrl, crl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Before set - HashMap size " + this.hashMap.size()));
        }
        this.hashMap.put(crlUrl, cacheValue);
        if (log.isDebugEnabled()) {
            log.debug((Object)("After set - HashMap size " + this.hashMap.size()));
        }
    }

    public synchronized void removeCacheValue(String crlUrl) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Before remove - HashMap size " + this.hashMap.size()));
        }
        this.hashMap.remove(crlUrl);
        if (log.isDebugEnabled()) {
            log.debug((Object)("After remove - HashMap size " + this.hashMap.size()));
        }
    }

    private class CRLCacheValue
    implements ManageableCacheValue {
        private String crlUrl;
        private X509CRL crl;
        private long timeStamp = System.currentTimeMillis();

        public CRLCacheValue(String crlUrl, X509CRL crl) {
            this.crlUrl = crlUrl;
            this.crl = crl;
        }

        public String getKey() {
            return this.crlUrl;
        }

        public X509CRL getValue() {
            this.timeStamp = System.currentTimeMillis();
            return this.crl;
        }

        @Override
        public boolean isValid() {
            Date today = new Date();
            Date nextUpdate = this.crl.getNextUpdate();
            return nextUpdate != null && nextUpdate.after(today);
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public void removeThisCacheValue() {
            CRLCache.this.removeCacheValue(this.crlUrl);
        }

        @Override
        public void updateCacheWithNewValue() {
            CRLCache.this.replaceNewCacheValue(this);
        }
    }
}

