/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jep;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class MethodCommand
extends PostfixMathCommand {
    private Method method;
    private boolean isStatic;

    public MethodCommand(Method method) {
        this.method = method;
        this.numberOfParameters = method.getParameterTypes().length;
        this.isStatic = Modifier.isStatic(method.getModifiers());
        if (!this.isStatic) {
            ++this.numberOfParameters;
        }
    }

    public void run(Stack s) throws ParseException {
        this.checkStack(s);
        Object thiz = this.isStatic ? null : s.pop();
        int numArgs = this.isStatic ? this.numberOfParameters : this.numberOfParameters - 1;
        Object[] args = new Object[numArgs];
        for (int i = 0; i < args.length; ++i) {
            args[i] = s.pop();
        }
        try {
            Object res = this.method.invoke(thiz, args);
            s.push(res);
        }
        catch (Exception exp) {
            throw new ParseException(exp.getMessage());
        }
    }
}

