/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.util.xpath.SynapseXPath;

public class HeaderMediator
extends AbstractMediator {
    public static final int ACTION_SET = 0;
    public static final int ACTION_REMOVE = 1;
    private QName qName = null;
    private String value = null;
    private int action = 0;
    private List<OMElement> embeddedXmlContent = new ArrayList<OMElement>();
    private SynapseXPath expression = null;
    private String scope = null;

    @Override
    public boolean mediate(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug("Start : Header mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace("Message : " + synCtx.getEnvelope());
            }
        }
        if ("transport".equals(this.scope)) {
            this.alterTransportHeader(synCtx);
        } else {
            this.alterSOAPOrKnownHeader(synCtx);
        }
        synLog.traceOrDebug("End : Header mediator");
        return true;
    }

    private void alterSOAPOrKnownHeader(MessageContext synCtx) {
        SynapseLog synLog = this.getLog(synCtx);
        if (this.action == 0) {
            String value;
            String string = value = this.getExpression() == null ? this.getValue() : this.expression.stringValueOf(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Setting header : " + this.qName + " to : " + value);
            }
            if (!this.isImplicit() && (this.qName.getNamespaceURI() == null || "".equals(this.qName.getNamespaceURI()))) {
                if ("To".equals(this.qName.getLocalPart())) {
                    synCtx.setTo(new EndpointReference(value));
                } else if ("From".equals(this.qName.getLocalPart())) {
                    synCtx.setFrom(new EndpointReference(value));
                } else if ("Action".equals(this.qName.getLocalPart())) {
                    synCtx.setWSAAction(value);
                } else if ("FaultTo".equals(this.qName.getLocalPart())) {
                    synCtx.setFaultTo(new EndpointReference(value));
                } else if ("ReplyTo".equals(this.qName.getLocalPart())) {
                    synCtx.setReplyTo(new EndpointReference(value));
                } else if ("RelatesTo".equals(this.qName.getLocalPart())) {
                    synCtx.setRelatesTo(new RelatesTo[]{new RelatesTo(value)});
                } else {
                    this.addCustomHeader(synCtx, value);
                }
            } else {
                this.addCustomHeader(synCtx, value);
            }
        } else {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Removing Header : " + this.qName);
            }
            if (this.qName.getNamespaceURI() == null || "".equals(this.qName.getNamespaceURI())) {
                if ("To".equals(this.qName.getLocalPart())) {
                    synCtx.setTo(null);
                } else if ("From".equals(this.qName.getLocalPart())) {
                    synCtx.setFrom(null);
                } else if ("Action".equals(this.qName.getLocalPart())) {
                    synCtx.setWSAAction(null);
                } else if ("FaultTo".equals(this.qName.getLocalPart())) {
                    synCtx.setFaultTo(null);
                } else if ("ReplyTo".equals(this.qName.getLocalPart())) {
                    synCtx.setReplyTo(null);
                } else if ("RelatesTo".equals(this.qName.getLocalPart())) {
                    synCtx.setRelatesTo(null);
                } else {
                    SOAPHeader header;
                    SOAPEnvelope envelope = synCtx.getEnvelope();
                    if (envelope != null && (header = envelope.getHeader()) != null) {
                        this.removeFromHeaderList(header.getHeaderBlocksWithNSURI(""));
                    }
                }
            } else {
                SOAPHeader header;
                SOAPEnvelope envelope = synCtx.getEnvelope();
                if (envelope != null && (header = envelope.getHeader()) != null) {
                    this.removeFromHeaderList(header.getHeaderBlocksWithNSURI(this.qName.getNamespaceURI()));
                }
            }
        }
    }

    private void alterTransportHeader(MessageContext synCtx) {
        String value;
        SynapseLog synLog = this.getLog(synCtx);
        String headerName = this.qName.getLocalPart();
        String string = value = this.getExpression() == null ? this.getValue() : this.expression.stringValueOf(synCtx);
        if (this.action == 0) {
            Axis2MessageContext axis2smc;
            org.apache.axis2.context.MessageContext axis2MessageCtx;
            Object headers;
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Setting Transport header : " + headerName + " to : " + value);
            }
            if ((headers = (axis2MessageCtx = (axis2smc = (Axis2MessageContext)synCtx).getAxis2MessageContext()).getProperty("TRANSPORT_HEADERS")) != null && headers instanceof Map) {
                Map headersMap = (Map)headers;
                headersMap.put(headerName, value);
            } else if (headers == null) {
                HashMap<String, String> headersMap = new HashMap<String, String>();
                headersMap.put(headerName, value);
                axis2MessageCtx.setProperty("TRANSPORT_HEADERS", headersMap);
            }
        } else {
            Axis2MessageContext axis2smc;
            org.apache.axis2.context.MessageContext axis2MessageCtx;
            Object headers;
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug("Removing Transport Header : " + this.qName);
            }
            if ((headers = (axis2MessageCtx = (axis2smc = (Axis2MessageContext)synCtx).getAxis2MessageContext()).getProperty("TRANSPORT_HEADERS")) != null && headers instanceof Map) {
                Map headersMap = (Map)headers;
                headersMap.remove(headerName);
            } else {
                synLog.traceOrDebug("No transport headers found");
            }
        }
    }

    private void addCustomHeader(MessageContext synCtx, String value) {
        SOAPEnvelope env = synCtx.getEnvelope();
        if (env == null) {
            return;
        }
        SOAPFactory fac = (SOAPFactory)env.getOMFactory();
        SOAPHeader header = env.getOrCreateHeader();
        if (!this.isImplicit()) {
            SOAPHeaderBlock hb = header.addHeaderBlock(this.qName.getLocalPart(), fac.createOMNamespace(this.qName.getNamespaceURI(), this.qName.getPrefix()));
            hb.setText(value);
        } else if (this.hasEmbeddedXml()) {
            for (OMElement e : this.embeddedXmlContent) {
                header.addChild((OMNode)e.cloneOMElement());
            }
        }
    }

    private void removeFromHeaderList(List headersList) {
        if (headersList == null || headersList.isEmpty()) {
            return;
        }
        for (Object o : headersList) {
            OMElement omElem;
            if (o instanceof SOAPHeaderBlock) {
                SOAPHeaderBlock header = (SOAPHeaderBlock)o;
                if (!header.getLocalName().equals(this.qName.getLocalPart())) continue;
                header.detach();
                continue;
            }
            if (!(o instanceof OMElement) || !(omElem = (OMElement)o).getLocalName().equals(this.qName.getLocalPart())) continue;
            omElem.detach();
        }
    }

    public List<OMElement> getEmbeddedXml() {
        return this.embeddedXmlContent;
    }

    public void addEmbeddedXml(OMElement element) {
        if (element != null && !this.embeddedXmlContent.contains(element)) {
            this.embeddedXmlContent.add(element);
        }
    }

    public boolean hasEmbeddedXml() {
        return !this.embeddedXmlContent.isEmpty();
    }

    public boolean isImplicit() {
        return this.getQName() == null;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public QName getQName() {
        return this.qName;
    }

    public void setQName(QName qName) {
        this.qName = qName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public boolean isContentAware() {
        return !"transport".equals(this.scope);
    }
}

