/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.jmx.JmxInformation;
import org.apache.synapse.commons.jmx.JmxSecretAuthenticator;
import org.apache.synapse.commons.util.RMIRegistryController;
import org.apache.synapse.securevault.PasswordManager;
import org.apache.synapse.securevault.secret.SecretInformation;

public class JmxAdapter {
    private static Log log = LogFactory.getLog(JmxAdapter.class);
    private static final int JNDI_AUTO_PORT_OFFSET = 1099;
    private JmxInformation jmxInformation;
    private JMXConnectorServer connectorServer;

    public JmxAdapter(JmxInformation jmxInformation) {
        this.jmxInformation = jmxInformation;
    }

    public void start() {
        this.initConfiguration();
        try {
            boolean registryCreated = false;
            int jndiPort = this.jmxInformation.getJndiPort();
            if (jndiPort == 0) {
                jndiPort = 1099;
                for (int retries = 0; !registryCreated && retries < 100; ++retries) {
                    try {
                        RMIRegistryController.getInstance().createLocalRegistry(jndiPort);
                        registryCreated = true;
                        continue;
                    }
                    catch (Exception ignored) {
                        log.warn((Object)("Trying alternate port " + ++jndiPort));
                    }
                }
                this.jmxInformation.setJndiPort(jndiPort);
            } else {
                RMIRegistryController.getInstance().createLocalRegistry(jndiPort);
                registryCreated = true;
            }
            if (registryCreated) {
                this.jmxInformation.updateJMXUrl();
                JMXServiceURL url = new JMXServiceURL(this.jmxInformation.getJmxUrl());
                Map<String, Object> env = this.createContextMap();
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
                try {
                    this.connectorServer.start();
                }
                catch (IOException ex) {
                    log.warn((Object)("Cannot start JMXConnectorServer on " + this.jmxInformation.getJmxUrl()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error while setting up remote JMX connector", (Throwable)ex);
        }
    }

    public void stop() {
        if (this.connectorServer != null) {
            log.info((Object)("JMXConnectorServer stopping on " + this.jmxInformation.getJmxUrl()));
            try {
                this.connectorServer.stop();
                RMIRegistryController.getInstance().removeLocalRegistry(this.jmxInformation.getJndiPort());
                this.jmxInformation = null;
            }
            catch (IOException ex) {
                log.error((Object)"Error while stopping remote JMX connector", (Throwable)ex);
            }
            this.connectorServer = null;
        }
    }

    private void initConfiguration() {
        String hostname;
        int jndiPort = this.jmxInformation.getJndiPort();
        if (jndiPort < 0 || 65535 < jndiPort) {
            throw new SynapseException("JNDI Port for Remote Registry not properly configured");
        }
        int rmiPort = this.jmxInformation.getRmiPort();
        if (rmiPort < 0 || 65535 < rmiPort) {
            rmiPort = 0;
            log.info((Object)"No or invalid value specified for JMX RMI port - using dynamic port");
        }
        if ((hostname = this.jmxInformation.getHostName()) == null || hostname.trim().length() == 0) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                this.jmxInformation.setHostName(address.getHostName());
            }
            catch (UnknownHostException ex) {
                throw new SynapseException("Hostname of loopback could not be determined", ex);
            }
        }
    }

    public boolean isRunning() {
        return this.connectorServer != null && this.connectorServer.isActive();
    }

    public JmxInformation getJmxInformation() {
        return this.jmxInformation;
    }

    public void setJmxInformation(JmxInformation jmxInformation) {
        this.jmxInformation = jmxInformation;
    }

    private Map<String, Object> createContextMap() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (this.jmxInformation.isAuthenticate()) {
            if (this.jmxInformation.getRemotePasswordFile() != null) {
                env.put("jmx.remote.x.password.file", this.jmxInformation.getRemotePasswordFile());
            } else {
                SecretInformation secretInformation = this.jmxInformation.getSecretInformation();
                PasswordManager pwManager = PasswordManager.getInstance();
                if (pwManager.isInitialized()) {
                    secretInformation.setGlobalSecretResolver(pwManager.getSecretResolver());
                }
                env.put("jmx.remote.authenticator", new JmxSecretAuthenticator(this.jmxInformation.getSecretInformation()));
            }
            if (this.jmxInformation.getRemoteAccessFile() != null) {
                env.put("jmx.remote.x.access.file", this.jmxInformation.getRemoteAccessFile());
            }
        }
        if (this.jmxInformation.isRemoteSSL()) {
            log.info((Object)"Activated SSL communication");
            env.put("jmx.remote.rmi.client.socket.factory", new SslRMIClientSocketFactory());
            env.put("jmx.remote.rmi.server.socket.factory", new SslRMIServerSocketFactory());
        }
        return env;
    }
}

