/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.experimental.mediators.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.experimental.mediators.seda.SEDAQueue;
import org.apache.synapse.experimental.mediators.seda.SEDAQueueProducerPolicy;

public class SEDAQueueProducer {
    private static final Log log = LogFactory.getLog(SEDAQueueProducer.class);
    private final SEDAQueueProducerPolicy queueProducerPolicy;
    private final SEDAQueue sedaQueue;
    private final BlockingQueue<MessageContext> queue;

    public SEDAQueueProducer(SEDAQueueProducerPolicy queueProducerPolicy, SEDAQueue sedaQueue) {
        this.queueProducerPolicy = queueProducerPolicy;
        this.sedaQueue = sedaQueue;
        this.queue = sedaQueue.getQueue();
    }

    public void produce(MessageContext messageContext) {
        String action = this.queueProducerPolicy.getAction();
        if ("add".equals(action)) {
            this.queue.add(messageContext);
        } else if ("offer".equals(action)) {
            long timeout = this.queueProducerPolicy.getTimeoutOnInsert();
            if (timeout < 0L) {
                if (!this.queue.offer(messageContext)) {
                    log.warn((Object)"Error while offering the message to the queue");
                }
            } else {
                try {
                    this.queue.offer(messageContext, timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.debug((Object)"Ignored InterruptedException when ocuured calling queue.offer");
                }
            }
        } else if ("put".equals(action)) {
            try {
                this.queue.put(messageContext);
            }
            catch (InterruptedException e) {
                log.debug((Object)"Ignored InterruptedException when ocuured calling queue.put");
            }
        }
    }
}

